/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;

public final class PhoenixDatabaseAdapter
implements DatabaseAdapter {
    public static final String NAME = "Phoenix";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "Generates Phoenix compliant SQL";
    }

    @Override
    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset) {
        return this.getSelectStatement(tableName, columnNames, whereClause, orderByClause, limit, offset, null);
    }

    @Override
    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset, String columnForPartitioning) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name cannot be null or empty");
        }
        StringBuilder query = new StringBuilder("SELECT ");
        if (StringUtils.isEmpty((CharSequence)columnNames) || columnNames.trim().equals("*")) {
            query.append("*");
        } else {
            query.append(columnNames);
        }
        query.append(" FROM ");
        query.append(tableName);
        if (!StringUtils.isEmpty((CharSequence)whereClause)) {
            query.append(" WHERE ");
            query.append(whereClause);
            if (!StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
                query.append(" AND ");
                query.append(columnForPartitioning);
                query.append(" >= ");
                query.append(offset != null ? offset : "0");
                if (limit != null) {
                    query.append(" AND ");
                    query.append(columnForPartitioning);
                    query.append(" < ");
                    query.append((offset == null ? 0L : offset) + limit);
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)orderByClause) && StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
            query.append(" ORDER BY ");
            query.append(orderByClause);
        }
        if (StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
            if (limit != null) {
                query.append(" LIMIT ");
                query.append(limit);
            }
            if (offset != null && offset > 0L) {
                query.append(" OFFSET ");
                query.append(offset);
            }
        }
        return query.toString();
    }
}

