/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.queryrecord;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.Pair;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.queryrecord.FlowFileEnumerator;
import org.apache.nifi.queryrecord.FlowFileTableScan;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;

public class FlowFileTable
extends AbstractTable
implements QueryableTable,
TranslatableTable {
    private final RecordReaderFactory recordReaderFactory;
    private final ComponentLog logger;
    private RecordSchema recordSchema;
    private RelDataType relDataType = null;
    private volatile ProcessSession session;
    private volatile FlowFile flowFile;
    private volatile int maxRecordsRead;
    private final Set<FlowFileEnumerator> enumerators = new HashSet<FlowFileEnumerator>();

    public FlowFileTable(ProcessSession session, FlowFile flowFile, RecordSchema schema, RecordReaderFactory recordReaderFactory, ComponentLog logger) {
        this.session = session;
        this.flowFile = flowFile;
        this.recordSchema = schema;
        this.recordReaderFactory = recordReaderFactory;
        this.logger = logger;
    }

    public void setFlowFile(ProcessSession session, FlowFile flowFile) {
        this.session = session;
        this.flowFile = flowFile;
        this.maxRecordsRead = 0;
    }

    public String toString() {
        return "FlowFileTable";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Set<FlowFileEnumerator> set = this.enumerators;
        synchronized (set) {
            for (FlowFileEnumerator enumerator : this.enumerators) {
                enumerator.close();
            }
        }
    }

    public Enumerable<Object> project(final int[] fields) {
        return new AbstractEnumerable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Enumerator<Object> enumerator() {
                FlowFileEnumerator flowFileEnumerator = new FlowFileEnumerator(FlowFileTable.this.session, FlowFileTable.this.flowFile, FlowFileTable.this.logger, FlowFileTable.this.recordReaderFactory, fields){

                    @Override
                    protected void onFinish() {
                        int recordCount = this.getRecordsRead();
                        if (recordCount > FlowFileTable.this.maxRecordsRead) {
                            FlowFileTable.this.maxRecordsRead = recordCount;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void close() {
                        Set set = FlowFileTable.this.enumerators;
                        synchronized (set) {
                            FlowFileTable.this.enumerators.remove(this);
                        }
                        super.close();
                    }
                };
                Set set = FlowFileTable.this.enumerators;
                synchronized (set) {
                    FlowFileTable.this.enumerators.add(flowFileEnumerator);
                }
                return flowFileEnumerator;
            }
        };
    }

    public int getRecordsRead() {
        return this.maxRecordsRead;
    }

    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
    }

    public Type getElementType() {
        return Object[].class;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        throw new UnsupportedOperationException();
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        int fieldCount = relOptTable.getRowType().getFieldCount();
        int[] fields = new int[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fields[i] = i;
        }
        return new FlowFileTableScan(context.getCluster(), relOptTable, this, fields);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.relDataType != null) {
            return this.relDataType;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        JavaTypeFactory javaTypeFactory = (JavaTypeFactory)typeFactory;
        for (RecordField field : this.recordSchema.getFields()) {
            names.add(field.getFieldName());
            RelDataType relDataType = this.getRelDataType(field.getDataType(), javaTypeFactory);
            types.add(javaTypeFactory.createTypeWithNullability(relDataType, field.isNullable()));
        }
        this.relDataType = typeFactory.createStructType(Pair.zip(names, types));
        return this.relDataType;
    }

    private RelDataType getRelDataType(DataType fieldType, JavaTypeFactory typeFactory) {
        switch (fieldType.getFieldType()) {
            case BOOLEAN: {
                return typeFactory.createJavaType(Boolean.TYPE);
            }
            case BYTE: {
                return typeFactory.createJavaType(Byte.TYPE);
            }
            case CHAR: {
                return typeFactory.createJavaType(Character.TYPE);
            }
            case DATE: {
                return typeFactory.createJavaType(Date.class);
            }
            case DOUBLE: {
                return typeFactory.createJavaType(Double.TYPE);
            }
            case FLOAT: {
                return typeFactory.createJavaType(Float.TYPE);
            }
            case INT: {
                return typeFactory.createJavaType(Integer.TYPE);
            }
            case SHORT: {
                return typeFactory.createJavaType(Short.TYPE);
            }
            case TIME: {
                return typeFactory.createJavaType(Time.class);
            }
            case TIMESTAMP: {
                return typeFactory.createJavaType(Timestamp.class);
            }
            case LONG: {
                return typeFactory.createJavaType(Long.TYPE);
            }
            case STRING: {
                return typeFactory.createJavaType(String.class);
            }
            case ARRAY: {
                ArrayDataType array = (ArrayDataType)fieldType;
                return typeFactory.createArrayType(this.getRelDataType(array.getElementType(), typeFactory), -1L);
            }
            case RECORD: {
                return typeFactory.createJavaType(Record.class);
            }
            case MAP: {
                return typeFactory.createJavaType(HashMap.class);
            }
            case BIGINT: {
                return typeFactory.createJavaType(BigInteger.class);
            }
            case DECIMAL: {
                return typeFactory.createJavaType(BigDecimal.class);
            }
            case CHOICE: {
                ChoiceDataType choiceDataType = (ChoiceDataType)fieldType;
                DataType widestDataType = (DataType)choiceDataType.getPossibleSubTypes().get(0);
                for (DataType possibleType : choiceDataType.getPossibleSubTypes()) {
                    if (possibleType == widestDataType) continue;
                    if (possibleType.getFieldType().isWiderThan(widestDataType.getFieldType())) {
                        widestDataType = possibleType;
                        continue;
                    }
                    if (widestDataType.getFieldType().isWiderThan(possibleType.getFieldType())) continue;
                    widestDataType = null;
                    break;
                }
                if (widestDataType != null) {
                    return this.getRelDataType(widestDataType, typeFactory);
                }
                boolean allNumeric = true;
                for (DataType possibleType : choiceDataType.getPossibleSubTypes()) {
                    if (this.isNumeric(possibleType)) continue;
                    allNumeric = false;
                    break;
                }
                if (allNumeric) {
                    return typeFactory.createJavaType(String.class);
                }
                return typeFactory.createJavaType(Object.class);
            }
        }
        throw new IllegalArgumentException("Unknown Record Field Type: " + fieldType);
    }

    private boolean isNumeric(DataType dataType) {
        switch (dataType.getFieldType()) {
            case BYTE: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case SHORT: 
            case LONG: 
            case BIGINT: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TEMPORARY_TABLE;
    }
}

