/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.annotation.notification.OnPrimaryNodeStateChange;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.http.HttpContextMap;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.HandleHttpResponse;
import org.apache.nifi.processors.standard.util.HTTPUtils;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.ssl.RestrictedSSLContextService;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.stream.io.StreamUtils;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"http", "https", "request", "listen", "ingress", "web service"})
@CapabilityDescription(value="Starts an HTTP Server and listens for HTTP Requests. For each request, creates a FlowFile and transfers to 'success'. This Processor is designed to be used in conjunction with the HandleHttpResponse Processor in order to create a Web Service. In case  of a multipart request, one FlowFile is generated for each part.")
@WritesAttributes(value={@WritesAttribute(attribute="http.context.identifier", description="An identifier that allows the HandleHttpRequest and HandleHttpResponse to coordinate which FlowFile belongs to which HTTP Request/Response."), @WritesAttribute(attribute="mime.type", description="The MIME Type of the data, according to the HTTP Header \"Content-Type\""), @WritesAttribute(attribute="http.servlet.path", description="The part of the request URL that is considered the Servlet Path"), @WritesAttribute(attribute="http.context.path", description="The part of the request URL that is considered to be the Context Path"), @WritesAttribute(attribute="http.method", description="The HTTP Method that was used for the request, such as GET or POST"), @WritesAttribute(attribute="http.local.name", description="IP address/hostname of the server"), @WritesAttribute(attribute="http.server.port", description="Listening port of the server"), @WritesAttribute(attribute="http.query.string", description="The query string portion of the Request URL"), @WritesAttribute(attribute="http.remote.host", description="The hostname of the requestor"), @WritesAttribute(attribute="http.remote.addr", description="The hostname:port combination of the requestor"), @WritesAttribute(attribute="http.remote.user", description="The username of the requestor"), @WritesAttribute(attribute="http.protocol", description="The protocol used to communicate"), @WritesAttribute(attribute="http.request.uri", description="The full Request URL"), @WritesAttribute(attribute="http.auth.type", description="The type of HTTP Authorization used"), @WritesAttribute(attribute="http.principal.name", description="The name of the authenticated user making the request"), @WritesAttribute(attribute="http.query.param.XXX", description="Each of query parameters in the request will be added as an attribute, prefixed with \"http.query.param.\""), @WritesAttribute(attribute="http.param.XXX", description="Form parameters in the request that are configured by \"Parameters to Attributes List\" will be added as an attribute, prefixed with \"http.param.\". Putting form parameters of large size is not recommended."), @WritesAttribute(attribute="http.subject.dn", description="The Distinguished Name of the requestor. This value will not be populated unless the Processor is configured to use an SSLContext Service"), @WritesAttribute(attribute="http.issuer.dn", description="The Distinguished Name of the entity that issued the Subject's certificate. This value will not be populated unless the Processor is configured to use an SSLContext Service"), @WritesAttribute(attribute="http.headers.XXX", description="Each of the HTTP Headers that is received in the request will be added as an attribute, prefixed with \"http.headers.\" For example, if the request contains an HTTP Header named \"x-my-header\", then the value will be added to an attribute named \"http.headers.x-my-header\""), @WritesAttribute(attribute="http.headers.multipart.XXX", description="Each of the HTTP Headers that is received in the multipart request will be added as an attribute, prefixed with \"http.headers.multipart.\" For example, if the multipart request contains an HTTP Header named \"content-disposition\", then the value will be added to an attribute named \"http.headers.multipart.content-disposition\""), @WritesAttribute(attribute="http.multipart.size", description="For requests with Content-Type \"multipart/form-data\", the part's content size is recorded into this attribute"), @WritesAttribute(attribute="http.multipart.content.type", description="For requests with Content-Type \"multipart/form-data\", the part's content type is recorded into this attribute"), @WritesAttribute(attribute="http.multipart.name", description="For requests with Content-Type \"multipart/form-data\", the part's name is recorded into this attribute"), @WritesAttribute(attribute="http.multipart.filename", description="For requests with Content-Type \"multipart/form-data\", when the part contains an uploaded file, the name of the file is recorded into this attribute. Files are stored temporarily at the default temporary-file directory specified in \"java.io.File\" Java Docs)"), @WritesAttribute(attribute="http.multipart.fragments.sequence.number", description="For requests with Content-Type \"multipart/form-data\", the part's index is recorded into this attribute. The index starts with 1."), @WritesAttribute(attribute="http.multipart.fragments.total.number", description="For requests with Content-Type \"multipart/form-data\", the count of all parts is recorded into this attribute.")})
@SeeAlso(value={HandleHttpResponse.class})
public class HandleHttpRequest
extends AbstractProcessor {
    private static final String MIME_TYPE__MULTIPART_FORM_DATA = "multipart/form-data";
    private static final Pattern URL_QUERY_PARAM_DELIMITER = Pattern.compile("&");
    public static final AllowableValue CLIENT_NONE = new AllowableValue("No Authentication", "No Authentication", "Processor will not authenticate clients. Anyone can communicate with this Processor anonymously");
    public static final AllowableValue CLIENT_WANT = new AllowableValue("Want Authentication", "Want Authentication", "Processor will try to verify the client but if unable to verify will allow the client to communicate anonymously");
    public static final AllowableValue CLIENT_NEED = new AllowableValue("Need Authentication", "Need Authentication", "Processor will reject communications from any client unless the client provides a certificate that is trusted by the TrustStorespecified in the SSL Context Service");
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Listening Port").description("The Port to listen on for incoming HTTP requests").required(true).addValidator(StandardValidators.createLongValidator((long)0L, (long)65535L, (boolean)true)).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("80").build();
    public static final PropertyDescriptor HOSTNAME = new PropertyDescriptor.Builder().name("Hostname").description("The Hostname to bind to. If not specified, will bind to all hosts").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor HTTP_CONTEXT_MAP = new PropertyDescriptor.Builder().name("HTTP Context Map").description("The HTTP Context Map Controller Service to use for caching the HTTP Request Information").required(true).identifiesControllerService(HttpContextMap.class).build();
    public static final PropertyDescriptor SSL_CONTEXT = new PropertyDescriptor.Builder().name("SSL Context Service").description("The SSL Context Service to use in order to secure the server. If specified, the server will accept only HTTPS requests; otherwise, the server will accept only HTTP requests").required(false).identifiesControllerService(RestrictedSSLContextService.class).build();
    public static final PropertyDescriptor URL_CHARACTER_SET = new PropertyDescriptor.Builder().name("Default URL Character Set").description("The character set to use for decoding URL parameters if the HTTP Request does not supply one").required(true).defaultValue("UTF-8").addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).build();
    public static final PropertyDescriptor PATH_REGEX = new PropertyDescriptor.Builder().name("Allowed Paths").description("A Regular Expression that specifies the valid HTTP Paths that are allowed in the incoming URL Requests. If this value is specified and the path of the HTTP Requests does not match this Regular Expression, the Processor will respond with a 404: NotFound").required(false).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor ALLOW_GET = new PropertyDescriptor.Builder().name("Allow GET").description("Allow HTTP GET Method").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor ALLOW_POST = new PropertyDescriptor.Builder().name("Allow POST").description("Allow HTTP POST Method").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor ALLOW_PUT = new PropertyDescriptor.Builder().name("Allow PUT").description("Allow HTTP PUT Method").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor ALLOW_DELETE = new PropertyDescriptor.Builder().name("Allow DELETE").description("Allow HTTP DELETE Method").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor ALLOW_HEAD = new PropertyDescriptor.Builder().name("Allow HEAD").description("Allow HTTP HEAD Method").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor ALLOW_OPTIONS = new PropertyDescriptor.Builder().name("Allow OPTIONS").description("Allow HTTP OPTIONS Method").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor ADDITIONAL_METHODS = new PropertyDescriptor.Builder().name("Additional HTTP Methods").description("A comma-separated list of non-standard HTTP Methods that should be allowed").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor PARAMETERS_TO_ATTRIBUTES = new PropertyDescriptor.Builder().name("parameters-to-attributes").displayName("Parameters to Attributes List").description("A comma-separated list of HTTP parameters or form data to output as attributes").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor CLIENT_AUTH = new PropertyDescriptor.Builder().name("Client Authentication").description("Specifies whether or not the Processor should authenticate clients. This value is ignored if the <SSL Context Service> Property is not specified or the SSL Context provided uses only a KeyStore and not a TrustStore.").required(true).allowableValues(new AllowableValue[]{CLIENT_NONE, CLIENT_WANT, CLIENT_NEED}).defaultValue(CLIENT_NONE.getValue()).build();
    public static final PropertyDescriptor CONTAINER_QUEUE_SIZE = new PropertyDescriptor.Builder().name("container-queue-size").displayName("Container Queue Size").description("The size of the queue for Http Request Containers").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("50").build();
    public static final PropertyDescriptor MULTIPART_REQUEST_MAX_SIZE = new PropertyDescriptor.Builder().name("multipart-request-max-size").displayName("Multipart Request Max Size").description("The max size of the request. Only applies for requests with Content-Type: multipart/form-data, and is used to prevent denial of service type of attacks, to prevent filling up the heap or disk space").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("1 MB").build();
    public static final PropertyDescriptor MULTIPART_READ_BUFFER_SIZE = new PropertyDescriptor.Builder().name("multipart-read-buffer-size").description("The threshold size, at which the contents of an incoming file would be written to disk. Only applies for requests with Content-Type: multipart/form-data. It is used to prevent denial of service type of attacks, to prevent filling up the heap or disk space.").displayName("Multipart Read Buffer Size").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("512 KB").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All content that is received is routed to the 'success' relationship").build();
    private static final List<PropertyDescriptor> propertyDescriptors;
    private volatile Server server;
    private volatile boolean ready;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private volatile BlockingQueue<HttpRequestContainer> containerQueue;
    private AtomicBoolean runOnPrimary = new AtomicBoolean(false);
    private AtomicReference<Set<String>> parameterToAttributesReference = new AtomicReference<Object>(null);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    @OnScheduled
    public void clearInit() {
        this.initialized.set(false);
    }

    synchronized void initializeServer(final ProcessContext context) throws Exception {
        String pathRegex;
        String additionalMethods;
        boolean want;
        boolean need;
        if (this.initialized.get()) {
            return;
        }
        this.runOnPrimary.set(context.getExecutionNode().equals((Object)ExecutionNode.PRIMARY));
        this.containerQueue = new LinkedBlockingQueue<HttpRequestContainer>(context.getProperty(CONTAINER_QUEUE_SIZE).asInteger());
        String host = context.getProperty(HOSTNAME).getValue();
        int port = context.getProperty(PORT).evaluateAttributeExpressions().asInteger();
        SSLContextService sslService = (SSLContextService)context.getProperty(SSL_CONTEXT).asControllerService(SSLContextService.class);
        HttpContextMap httpContextMap = (HttpContextMap)context.getProperty(HTTP_CONTEXT_MAP).asControllerService(HttpContextMap.class);
        long requestTimeout = httpContextMap.getRequestTimeout(TimeUnit.MILLISECONDS);
        String clientAuthValue = context.getProperty(CLIENT_AUTH).getValue();
        if (CLIENT_NEED.equals((Object)clientAuthValue)) {
            need = true;
            want = false;
        } else if (CLIENT_WANT.equals((Object)clientAuthValue)) {
            need = false;
            want = true;
        } else {
            need = false;
            want = false;
        }
        SslContextFactory sslFactory = sslService == null ? null : this.createSslFactory(sslService, need, want);
        Server server = new Server(port);
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        if (sslFactory == null) {
            ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
            if (StringUtils.isNotBlank((CharSequence)host)) {
                http.setHost(host);
            }
            http.setPort(port);
            http.setIdleTimeout(Math.max(http.getIdleTimeout(), requestTimeout));
            server.setConnectors(new Connector[]{http});
        } else {
            HttpConfiguration httpsConfiguration = new HttpConfiguration(httpConfiguration);
            httpsConfiguration.setSecureScheme("https");
            httpsConfiguration.setSecurePort(port);
            httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslFactory, "http/1.1"), new HttpConnectionFactory(httpsConfiguration)});
            if (StringUtils.isNotBlank((CharSequence)host)) {
                https.setHost(host);
            }
            https.setPort(port);
            https.setIdleTimeout(Math.max(https.getIdleTimeout(), requestTimeout));
            server.setConnectors(new Connector[]{https});
        }
        final HashSet<String> allowedMethods = new HashSet<String>();
        if (context.getProperty(ALLOW_GET).asBoolean().booleanValue()) {
            allowedMethods.add("GET");
        }
        if (context.getProperty(ALLOW_POST).asBoolean().booleanValue()) {
            allowedMethods.add("POST");
        }
        if (context.getProperty(ALLOW_PUT).asBoolean().booleanValue()) {
            allowedMethods.add("PUT");
        }
        if (context.getProperty(ALLOW_DELETE).asBoolean().booleanValue()) {
            allowedMethods.add("DELETE");
        }
        if (context.getProperty(ALLOW_HEAD).asBoolean().booleanValue()) {
            allowedMethods.add("HEAD");
        }
        if (context.getProperty(ALLOW_OPTIONS).asBoolean().booleanValue()) {
            allowedMethods.add("OPTIONS");
        }
        if ((additionalMethods = context.getProperty(ADDITIONAL_METHODS).getValue()) != null) {
            for (String additionalMethod : additionalMethods.split(",")) {
                String trimmed = additionalMethod.trim();
                if (trimmed.isEmpty()) continue;
                allowedMethods.add(trimmed.toUpperCase());
            }
        }
        HashSet<String> parametersToMakeAttributes = new HashSet<String>();
        String parametersToAttributesPropertyValue = context.getProperty(PARAMETERS_TO_ATTRIBUTES).getValue();
        if (parametersToAttributesPropertyValue != null) {
            for (String paremeterName : parametersToAttributesPropertyValue.split(",")) {
                String trimmed = paremeterName.trim();
                if (trimmed.isEmpty()) continue;
                parametersToMakeAttributes.add(trimmed);
            }
            this.parameterToAttributesReference.set(parametersToMakeAttributes);
        }
        final Pattern pathPattern = (pathRegex = context.getProperty(PATH_REGEX).getValue()) == null ? null : Pattern.compile(pathRegex);
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                String requestUri = request.getRequestURI();
                if (!allowedMethods.contains(request.getMethod().toUpperCase())) {
                    HandleHttpRequest.this.getLogger().info("Sending back METHOD_NOT_ALLOWED response to {}; method was {}; request URI was {}", new Object[]{request.getRemoteAddr(), request.getMethod(), requestUri});
                    response.sendError(405);
                    return;
                }
                if (pathPattern != null) {
                    URI uri;
                    try {
                        uri = new URI(requestUri);
                    }
                    catch (URISyntaxException e) {
                        throw new ServletException((Throwable)e);
                    }
                    if (!pathPattern.matcher(uri.getPath()).matches()) {
                        HandleHttpRequest.this.getLogger().info("Sending back NOT_FOUND response to {}; request was {} {}", new Object[]{request.getRemoteAddr(), request.getMethod(), requestUri});
                        response.sendError(404);
                        return;
                    }
                }
                if (context.getAvailableRelationships().isEmpty()) {
                    HandleHttpRequest.this.getLogger().warn("Request from {} cannot be processed, processor downstream queue is full; responding with SERVICE_UNAVAILABLE", new Object[]{request.getRemoteAddr()});
                    response.sendError(503, "Processor queue is full");
                    return;
                }
                if (!HandleHttpRequest.this.ready) {
                    HandleHttpRequest.this.getLogger().warn("Request from {} cannot be processed, processor is being shut down; responding with SERVICE_UNAVAILABLE", new Object[]{request.getRemoteAddr()});
                    response.sendError(503, "Processor is shutting down");
                    return;
                }
                AsyncContext async = baseRequest.startAsync();
                async.setTimeout(0L);
                boolean added = HandleHttpRequest.this.containerQueue.offer(new HttpRequestContainer(request, response, async));
                if (added) {
                    HandleHttpRequest.this.getLogger().debug("Added Http Request to queue for {} {} from {}", new Object[]{request.getMethod(), requestUri, request.getRemoteAddr()});
                } else {
                    HandleHttpRequest.this.getLogger().warn("Request from {} cannot be processed, container queue is full; responding with SERVICE_UNAVAILABLE", new Object[]{request.getRemoteAddr()});
                    response.sendError(503, "Container queue is full");
                    async.complete();
                }
            }
        });
        this.server = server;
        server.start();
        this.getLogger().info("Server started and listening on port " + this.getPort());
        this.initialized.set(true);
        this.ready = true;
    }

    protected int getPort() {
        for (Connector connector : this.server.getConnectors()) {
            if (!(connector instanceof ServerConnector)) continue;
            return ((ServerConnector)connector).getLocalPort();
        }
        throw new IllegalStateException("Server is not listening on any ports");
    }

    protected int getRequestQueueSize() {
        return this.containerQueue.size();
    }

    private SslContextFactory createSslFactory(SSLContextService sslContextService, boolean needClientAuth, boolean wantClientAuth) {
        SslContextFactory.Server sslFactory = new SslContextFactory.Server();
        sslFactory.setNeedClientAuth(needClientAuth);
        sslFactory.setWantClientAuth(wantClientAuth);
        SSLContext sslContext = sslContextService.createContext();
        sslFactory.setSslContext(sslContext);
        return sslFactory;
    }

    @OnUnscheduled
    public void shutdown() throws Exception {
        this.ready = false;
        if (this.server != null) {
            this.getLogger().debug("Shutting down server");
            this.rejectPendingRequests();
            this.server.stop();
            this.server.destroy();
            this.server.join();
            this.clearInit();
            this.getLogger().info("Shut down {}", new Object[]{this.server});
        }
    }

    void rejectPendingRequests() {
        HttpRequestContainer container;
        while ((container = this.getNextContainer()) != null) {
            try {
                this.getLogger().warn("Rejecting request from {} during cleanup after processor shutdown; responding with SERVICE_UNAVAILABLE", new Object[]{container.getRequest().getRemoteAddr()});
                HttpServletResponse response = container.getResponse();
                response.sendError(503, "Processor is shutting down");
                container.getContext().complete();
            }
            catch (IOException e) {
                this.getLogger().warn("Failed to send HTTP response to {} due to {}", new Object[]{container.getRequest().getRemoteAddr(), e});
            }
        }
    }

    private HttpRequestContainer getNextContainer() {
        HttpRequestContainer container;
        try {
            container = this.containerQueue.poll(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.getLogger().warn("Interrupted while polling for " + HttpRequestContainer.class.getSimpleName() + " during cleanup.");
            container = null;
        }
        return container;
    }

    @OnPrimaryNodeStateChange
    public void onPrimaryNodeChange(PrimaryNodeState newState) {
        if (this.runOnPrimary.get() && newState.equals((Object)PrimaryNodeState.PRIMARY_NODE_REVOKED)) {
            try {
                this.shutdown();
            }
            catch (Exception shutdownException) {
                this.getLogger().warn("Processor is configured to run only on Primary Node, but failed to shutdown HTTP server following revocation of primary node status due to {}", (Throwable)shutdownException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        block56: {
            try {
                if (!this.initialized.get()) {
                    this.initializeServer(context);
                }
            }
            catch (Exception e) {
                context.yield();
                try {
                    this.shutdown();
                    throw new ProcessException("Failed to initialize the server", (Throwable)e);
                }
                catch (Exception shutdownException) {
                    this.getLogger().debug("Failed to shutdown following a failed initialization: " + shutdownException);
                }
                throw new ProcessException("Failed to initialize the server", (Throwable)e);
            }
            try {
                container = this.containerQueue.poll(2L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                return;
            }
            if (container == null) {
                return;
            }
            start = System.nanoTime();
            request = container.getRequest();
            if (Strings.isNullOrEmpty((String)request.getContentType()) || !request.getContentType().contains("multipart/form-data")) break block56;
            requestMaxSize = context.getProperty(HandleHttpRequest.MULTIPART_REQUEST_MAX_SIZE).asDataSize(DataUnit.B).longValue();
            readBufferSize = context.getProperty(HandleHttpRequest.MULTIPART_READ_BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
            tempDir = System.getProperty("java.io.tmpdir");
            request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement(tempDir, requestMaxSize, requestMaxSize, readBufferSize));
            parts = null;
            try {
                parts = ImmutableList.copyOf((Collection)request.getParts());
                allPartsCount = parts.size();
                contextIdentifier = UUID.randomUUID().toString();
                i = 0;
lbl34:
                // 2 sources

                while (i < allPartsCount) {
                    part = (Part)parts.get(i);
                    flowFile = session.create();
                    try {
                        flowFileOut = session.write(flowFile);
                        var18_31 = null;
                        try {
                            StreamUtils.copy((InputStream)part.getInputStream(), (OutputStream)flowFileOut);
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var19_33) {
                            var18_31 = var19_33;
                            throw var19_33;
                        }
                        finally {
                            if (flowFileOut != null) {
                                if (var18_31 != null) {
                                    try {
                                        flowFileOut.close();
                                    }
                                    catch (Throwable var19_32) {
                                        var18_31.addSuppressed(var19_32);
                                    }
                                } else {
                                    flowFileOut.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        this.handleFlowContentStreamingError(session, container, request, (Optional<FlowFile>)Optional.of((Object)flowFile), e);
                        if (parts == null) return;
                        var18_31 = parts.iterator();
                        while (var18_31.hasNext() != false) {
                            part = (Part)var18_31.next();
                            try {
                                part.delete();
                            }
                            catch (Exception e) {
                                this.getLogger().error("Couldn't delete underlying storage for {}", new Object[]{part}, (Throwable)e);
                            }
                        }
                        return;
                    }
                }
                ** GOTO lbl96
            }
            catch (IOException | IllegalStateException | ServletException e) {
                block54: {
                    try {
                        this.handleFlowContentStreamingError(session, container, request, (Optional<FlowFile>)Optional.absent(), (Exception)e);
                        if (parts == null) return;
                        var13_21 = parts.iterator();
                    }
                    catch (Throwable var22_38) {
                        if (parts == null) throw var22_38;
                        var23_39 = parts.iterator();
                        while (var23_39.hasNext() != false) {
                            part = (Part)var23_39.next();
                            try {
                                part.delete();
                            }
                            catch (Exception e) {
                                this.getLogger().error("Couldn't delete underlying storage for {}", new Object[]{part}, (Throwable)e);
                            }
                        }
                        throw var22_38;
                    }
lbl-1000:
                    // 1 sources

                    {
                        flowFile = this.savePartAttributes(context, session, part, flowFile, i, allPartsCount);
                        flowFile = this.saveRequestAttributes(context, session, request, flowFile, contextIdentifier);
                        if (i == 0 && !(requestRegistrationSuccess = this.registerRequest(context, session, container, start, request, flowFile))) break block54;
                        this.forwardFlowFile(context, session, container, start, request, flowFile);
                        ++i;
                        ** GOTO lbl34
                    }
                }
                if (parts == null) return;
                allPartsCount = parts.iterator();
                while (allPartsCount.hasNext() != false) {
                    part = (Part)allPartsCount.next();
                    try {
                        part.delete();
                    }
                    catch (Exception e) {
                        this.getLogger().error("Couldn't delete underlying storage for {}", new Object[]{part}, (Throwable)e);
                    }
                }
                return;
                while (var13_21.hasNext() != false) {
                    part = (Part)var13_21.next();
                    try {
                        part.delete();
                    }
                    catch (Exception e) {
                        this.getLogger().error("Couldn't delete underlying storage for {}", new Object[]{part}, (Throwable)e);
                    }
                }
                return;
            }
        }
        flowFile = session.create();
        try {
            flowFileOut = session.write(flowFile);
            readBufferSize = null;
            try {
                StreamUtils.copy((InputStream)request.getInputStream(), (OutputStream)flowFileOut);
            }
            catch (Throwable var10_16) {
                readBufferSize = var10_16;
                throw var10_16;
            }
            finally {
                if (flowFileOut != null) {
                    if (readBufferSize != null) {
                        try {
                            flowFileOut.close();
                        }
                        catch (Throwable var10_15) {
                            readBufferSize.addSuppressed(var10_15);
                        }
                    } else {
                        flowFileOut.close();
                    }
                }
            }
        }
        catch (IOException e) {
            this.handleFlowContentStreamingError(session, container, request, (Optional<FlowFile>)Optional.of((Object)flowFile), e);
            return;
        }
        contextIdentifier = UUID.randomUUID().toString();
        flowFile = this.saveRequestAttributes(context, session, request, flowFile, contextIdentifier);
        requestRegistrationSuccess = this.registerRequest(context, session, container, start, request, flowFile);
        if (requestRegistrationSuccess == false) return;
        this.forwardFlowFile(context, session, container, start, request, flowFile);
    }

    private FlowFile savePartAttributes(ProcessContext context, ProcessSession session, Part part, FlowFile flowFile, int i, int allPartsCount) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (String headerName : part.getHeaderNames()) {
            String headerValue = part.getHeader(headerName);
            this.putAttribute(attributes, "http.headers.multipart." + headerName, headerValue);
        }
        this.putAttribute(attributes, "http.multipart.size", part.getSize());
        this.putAttribute(attributes, "http.multipart.content.type", part.getContentType());
        this.putAttribute(attributes, "http.multipart.name", part.getName());
        this.putAttribute(attributes, "http.multipart.filename", part.getSubmittedFileName());
        this.putAttribute(attributes, "http.multipart.fragments.sequence.number", i + 1);
        this.putAttribute(attributes, "http.multipart.fragments.total.number", allPartsCount);
        return session.putAllAttributes(flowFile, attributes);
    }

    private FlowFile saveRequestAttributes(ProcessContext context, ProcessSession session, HttpServletRequest request, FlowFile flowFile, String contextIdentifier) {
        String subjectDn;
        X509Certificate[] certs;
        String charset = request.getCharacterEncoding() == null ? context.getProperty(URL_CHARACTER_SET).getValue() : request.getCharacterEncoding();
        HashMap<String, String> attributes = new HashMap<String, String>();
        try {
            Cookie[] cookies;
            this.putAttribute(attributes, "http.context.identifier", contextIdentifier);
            this.putAttribute(attributes, "mime.type", request.getContentType());
            this.putAttribute(attributes, "http.servlet.path", request.getServletPath());
            this.putAttribute(attributes, "http.context.path", request.getContextPath());
            this.putAttribute(attributes, "http.method", request.getMethod());
            this.putAttribute(attributes, "http.local.addr", request.getLocalAddr());
            this.putAttribute(attributes, "http.local.name", request.getLocalName());
            String queryString = request.getQueryString();
            if (queryString != null) {
                this.putAttribute(attributes, "http.query.string", URLDecoder.decode(queryString, charset));
            }
            this.putAttribute(attributes, "http.remote.host", request.getRemoteHost());
            this.putAttribute(attributes, "http.remote.addr", request.getRemoteAddr());
            this.putAttribute(attributes, "http.remote.user", request.getRemoteUser());
            this.putAttribute(attributes, "http.protocol", request.getProtocol());
            this.putAttribute(attributes, "http.request.uri", request.getRequestURI());
            this.putAttribute(attributes, "http.request.url", request.getRequestURL().toString());
            this.putAttribute(attributes, "http.auth.type", request.getAuthType());
            this.putAttribute(attributes, "http.requested.session.id", request.getRequestedSessionId());
            DispatcherType dispatcherType = request.getDispatcherType();
            if (dispatcherType != null) {
                this.putAttribute(attributes, "http.dispatcher.type", dispatcherType.name());
            }
            this.putAttribute(attributes, "http.character.encoding", request.getCharacterEncoding());
            this.putAttribute(attributes, "http.locale", request.getLocale());
            this.putAttribute(attributes, "http.server.name", request.getServerName());
            this.putAttribute(attributes, "http.server.port", request.getServerPort());
            Set<String> parametersToAttributes = this.parameterToAttributesReference.get();
            if (parametersToAttributes != null && !parametersToAttributes.isEmpty()) {
                Enumeration paramEnumeration = request.getParameterNames();
                while (paramEnumeration.hasMoreElements()) {
                    String string = (String)paramEnumeration.nextElement();
                    if (!parametersToAttributes.contains(string)) continue;
                    attributes.put("http.param." + string, request.getParameter(string));
                }
            }
            if ((cookies = request.getCookies()) != null) {
                for (Cookie cookie : cookies) {
                    String name = cookie.getName();
                    String cookiePrefix = "http.cookie." + name + ".";
                    attributes.put(cookiePrefix + "value", cookie.getValue());
                    attributes.put(cookiePrefix + "domain", cookie.getDomain());
                    attributes.put(cookiePrefix + "path", cookie.getPath());
                    attributes.put(cookiePrefix + "max.age", String.valueOf(cookie.getMaxAge()));
                    attributes.put(cookiePrefix + "version", String.valueOf(cookie.getVersion()));
                    attributes.put(cookiePrefix + "secure", String.valueOf(cookie.getSecure()));
                }
            }
            if (queryString != null) {
                String[] stringArray;
                for (String keyValueString : stringArray = URL_QUERY_PARAM_DELIMITER.split(queryString)) {
                    int indexOf = keyValueString.indexOf("=");
                    if (indexOf < 0) {
                        attributes.put("http.query.param." + URLDecoder.decode(keyValueString, charset), "");
                        continue;
                    }
                    String key = keyValueString.substring(0, indexOf);
                    String value = indexOf == keyValueString.length() - 1 ? "" : keyValueString.substring(indexOf + 1);
                    attributes.put("http.query.param." + URLDecoder.decode(key, charset), URLDecoder.decode(value, charset));
                }
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new ProcessException("Invalid character encoding", (Throwable)uee);
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            this.putAttribute(attributes, "http.headers." + headerName, headerValue);
        }
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            this.putAttribute(attributes, "http.principal.name", principal.getName());
        }
        if ((certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate")) != null && certs.length > 0) {
            X509Certificate x509Certificate = certs[0];
            subjectDn = x509Certificate.getSubjectDN().getName();
            String issuerDn = x509Certificate.getIssuerDN().getName();
            this.putAttribute(attributes, "http.subject.dn", subjectDn);
            this.putAttribute(attributes, "http.issuer.dn", issuerDn);
        } else {
            subjectDn = null;
        }
        return session.putAllAttributes(flowFile, attributes);
    }

    private void forwardFlowFile(ProcessContext context, ProcessSession session, HttpRequestContainer container, long start, HttpServletRequest request, FlowFile flowFile) {
        long receiveMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        String subjectDn = flowFile.getAttribute("http.subject.dn");
        session.getProvenanceReporter().receive(flowFile, HTTPUtils.getURI(flowFile.getAttributes()), "Received from " + request.getRemoteAddr() + (subjectDn == null ? "" : " with DN=" + subjectDn), receiveMillis);
        session.transfer(flowFile, REL_SUCCESS);
        this.getLogger().info("Transferring {} to 'success'; received from {}", new Object[]{flowFile, request.getRemoteAddr()});
    }

    private boolean registerRequest(ProcessContext context, ProcessSession session, HttpRequestContainer container, long start, HttpServletRequest request, FlowFile flowFile) {
        String contextIdentifier;
        HttpContextMap contextMap = (HttpContextMap)context.getProperty(HTTP_CONTEXT_MAP).asControllerService(HttpContextMap.class);
        boolean registered = contextMap.register(contextIdentifier = flowFile.getAttribute("http.context.identifier"), request, container.getResponse(), container.getContext());
        if (registered) {
            return true;
        }
        this.getLogger().warn("Received request from {} but could not process it because too many requests are already outstanding; responding with SERVICE_UNAVAILABLE", new Object[]{request.getRemoteAddr()});
        try {
            container.getResponse().sendError(503, "HttpContextMap is full");
            container.getContext().complete();
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to respond with SERVICE_UNAVAILABLE message to {} due to {}", new Object[]{request.getRemoteAddr(), e});
        }
        session.remove(flowFile);
        return false;
    }

    protected void handleFlowContentStreamingError(ProcessSession session, HttpRequestContainer container, HttpServletRequest request, Optional<FlowFile> flowFile, Exception e) {
        this.getLogger().error("Failed to receive content from HTTP Request from {} due to {}", new Object[]{request.getRemoteAddr(), e});
        if (flowFile.isPresent()) {
            session.remove((FlowFile)flowFile.get());
        }
        try {
            HttpServletResponse response = container.getResponse();
            response.sendError(400);
            container.getContext().complete();
        }
        catch (IOException ioe) {
            this.getLogger().warn("Failed to send HTTP response to {} due to {}", new Object[]{request.getRemoteAddr(), ioe});
        }
    }

    private void putAttribute(Map<String, String> map, String key, Object value) {
        if (value == null) {
            return;
        }
        this.putAttribute(map, key, value.toString());
    }

    private void putAttribute(Map<String, String> map, String key, String value) {
        if (value == null) {
            return;
        }
        map.put(key, value);
    }

    static {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(PORT);
        descriptors.add(HOSTNAME);
        descriptors.add(SSL_CONTEXT);
        descriptors.add(HTTP_CONTEXT_MAP);
        descriptors.add(PATH_REGEX);
        descriptors.add(URL_CHARACTER_SET);
        descriptors.add(ALLOW_GET);
        descriptors.add(ALLOW_POST);
        descriptors.add(ALLOW_PUT);
        descriptors.add(ALLOW_DELETE);
        descriptors.add(ALLOW_HEAD);
        descriptors.add(ALLOW_OPTIONS);
        descriptors.add(ADDITIONAL_METHODS);
        descriptors.add(CLIENT_AUTH);
        descriptors.add(CONTAINER_QUEUE_SIZE);
        descriptors.add(MULTIPART_REQUEST_MAX_SIZE);
        descriptors.add(MULTIPART_READ_BUFFER_SIZE);
        descriptors.add(PARAMETERS_TO_ATTRIBUTES);
        propertyDescriptors = Collections.unmodifiableList(descriptors);
    }

    private static class HttpRequestContainer {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final AsyncContext context;

        public HttpRequestContainer(HttpServletRequest request, HttpServletResponse response, AsyncContext async) {
            this.request = request;
            this.response = response;
            this.context = async;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public AsyncContext getContext() {
            return this.context;
        }
    }
}

