/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.servlet.Servlet;
import javax.ws.rs.Path;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.notification.OnPrimaryNodeStateChange;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.servlets.ContentAcknowledgmentServlet;
import org.apache.nifi.processors.standard.servlets.HealthCheckServlet;
import org.apache.nifi.processors.standard.servlets.ListenHTTPServlet;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.security.util.ClientAuth;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.ssl.RestrictedSSLContextService;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.stream.io.LeakyBucketStreamThrottler;
import org.apache.nifi.stream.io.StreamThrottler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"ingest", "http", "https", "rest", "listen"})
@CapabilityDescription(value="Starts an HTTP Server and listens on a given base path to transform incoming requests into FlowFiles. The default URI of the Service will be http://{hostname}:{port}/contentListener. Only HEAD and POST requests are supported. GET, PUT, and DELETE will result in an error and the HTTP response status code 405. GET is supported on <service_URI>/healthcheck. If the service is available, it returns \"200 OK\" with the content \"OK\". The health check functionality can be configured to be accessible via a different port. For details see the documentation of the \"Listening Port for health check requests\" property.")
public class ListenHTTP
extends AbstractSessionFactoryProcessor {
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean runOnPrimary = new AtomicBoolean(false);
    public static final Relationship RELATIONSHIP_SUCCESS = new Relationship.Builder().name("success").description("Relationship for successfully received FlowFiles").build();
    public static final PropertyDescriptor BASE_PATH = new PropertyDescriptor.Builder().name("Base Path").description("Base path for incoming connections").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("contentListener").addValidator(StandardValidators.URI_VALIDATOR).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("(^[^/]+.*[^/]+$|^[^/]+$|^$)"))).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Listening Port").description("The Port to listen on for incoming connections").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor HEALTH_CHECK_PORT = new PropertyDescriptor.Builder().name("health-check-port").displayName("Listening Port for Health Check Requests").description("The port to listen on for incoming health check requests. If set, it must be different from the Listening Port. Configure this port if the processor is set to use two-way SSL and a load balancer that does not support client authentication for health check requests is used. Only /<base_path>/healthcheck service is available via this port and only GET and HEAD requests are supported. If the processor is set not to use SSL, SSL will not be used on this port, either. If the processor is set to use one-way SSL, one-way SSL will be used on this port. If the processor is set to use two-way SSL, one-way SSL will be used on this port (client authentication not required).").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor AUTHORIZED_DN_PATTERN = new PropertyDescriptor.Builder().name("Authorized DN Pattern").description("A Regular Expression to apply against the Distinguished Name of incoming connections. If the Pattern does not match the DN, the connection will be refused.").required(true).defaultValue(".*").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    public static final PropertyDescriptor MAX_UNCONFIRMED_TIME = new PropertyDescriptor.Builder().name("Max Unconfirmed Flowfile Time").description("The maximum amount of time to wait for a FlowFile to be confirmed before it is removed from the cache").required(true).defaultValue("60 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor MAX_DATA_RATE = new PropertyDescriptor.Builder().name("Max Data to Receive per Second").description("The maximum amount of data to receive per second; this allows the bandwidth to be throttled to a specified data rate; if not specified, the data rate is not throttled").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The Controller Service to use in order to obtain an SSL Context").required(false).identifiesControllerService(RestrictedSSLContextService.class).build();
    public static final PropertyDescriptor HEADERS_AS_ATTRIBUTES_REGEX = new PropertyDescriptor.Builder().name("HTTP Headers to receive as Attributes (Regex)").description("Specifies the Regular Expression that determines the names of HTTP Headers that should be passed along as FlowFile attributes").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).required(false).build();
    public static final PropertyDescriptor RETURN_CODE = new PropertyDescriptor.Builder().name("Return Code").description("The HTTP return code returned after every HTTP call").defaultValue(String.valueOf(200)).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor MULTIPART_REQUEST_MAX_SIZE = new PropertyDescriptor.Builder().name("multipart-request-max-size").displayName("Multipart Request Max Size").description("The max size of the request. Only applies for requests with Content-Type: multipart/form-data, and is used to prevent denial of service type of attacks, to prevent filling up the heap or disk space").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("1 MB").build();
    public static final PropertyDescriptor MULTIPART_READ_BUFFER_SIZE = new PropertyDescriptor.Builder().name("multipart-read-buffer-size").displayName("Multipart Read Buffer Size").description("The threshold size, at which the contents of an incoming file would be written to disk. Only applies for requests with Content-Type: multipart/form-data. It is used to prevent denial of service type of attacks, to prevent filling up the heap or disk space.").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("512 KB").build();
    public static final PropertyDescriptor CLIENT_AUTHENTICATION = new PropertyDescriptor.Builder().name("client-authentication").displayName("Client Authentication").description("Client Authentication policy for TLS connections. Required when SSL Context Service configured.").required(false).allowableValues(Arrays.stream(ClientAuthentication.values()).map(ClientAuthentication::getAllowableValue).collect(Collectors.toList()).toArray(new AllowableValue[0])).defaultValue(ClientAuthentication.AUTO.name()).dependsOn(SSL_CONTEXT_SERVICE, new AllowableValue[0]).build();
    public static final String CONTEXT_ATTRIBUTE_PROCESSOR = "processor";
    public static final String CONTEXT_ATTRIBUTE_LOGGER = "logger";
    public static final String CONTEXT_ATTRIBUTE_SESSION_FACTORY_HOLDER = "sessionFactoryHolder";
    public static final String CONTEXT_ATTRIBUTE_PROCESS_CONTEXT_HOLDER = "processContextHolder";
    public static final String CONTEXT_ATTRIBUTE_AUTHORITY_PATTERN = "authorityPattern";
    public static final String CONTEXT_ATTRIBUTE_HEADER_PATTERN = "headerPattern";
    public static final String CONTEXT_ATTRIBUTE_FLOWFILE_MAP = "flowFileMap";
    public static final String CONTEXT_ATTRIBUTE_STREAM_THROTTLER = "streamThrottler";
    public static final String CONTEXT_ATTRIBUTE_BASE_PATH = "basePath";
    public static final String CONTEXT_ATTRIBUTE_RETURN_CODE = "returnCode";
    public static final String CONTEXT_ATTRIBUTE_MULTIPART_REQUEST_MAX_SIZE = "multipartRequestMaxSize";
    public static final String CONTEXT_ATTRIBUTE_MULTIPART_READ_BUFFER_SIZE = "multipartReadBufferSize";
    public static final String CONTEXT_ATTRIBUTE_PORT = "port";
    private volatile Server server = null;
    private final ConcurrentMap<String, FlowFileEntryTimeWrapper> flowFileMap = new ConcurrentHashMap<String, FlowFileEntryTimeWrapper>();
    private final AtomicReference<ProcessSessionFactory> sessionFactoryReference = new AtomicReference();
    private final AtomicReference<StreamThrottler> throttlerRef = new AtomicReference();

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(1);
        this.validatePortsAreNotEqual(context, results);
        return results;
    }

    private void validatePortsAreNotEqual(ValidationContext context, Collection<ValidationResult> validationResults) {
        Integer port;
        Integer healthCheckPort = context.getProperty(HEALTH_CHECK_PORT).evaluateAttributeExpressions().asInteger();
        if (healthCheckPort != null && (port = context.getProperty(PORT).evaluateAttributeExpressions().asInteger()).equals(healthCheckPort)) {
            String explanation = String.format("'%s' and '%s' cannot have the same value.", PORT.getDisplayName(), HEALTH_CHECK_PORT.getDisplayName());
            validationResults.add(this.createValidationResult(HEALTH_CHECK_PORT.getDisplayName(), explanation));
        }
    }

    private ValidationResult createValidationResult(String subject, String explanation) {
        return new ValidationResult.Builder().subject(subject).valid(false).explanation(explanation).build();
    }

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(RELATIONSHIP_SUCCESS);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(BASE_PATH);
        descriptors.add(PORT);
        descriptors.add(HEALTH_CHECK_PORT);
        descriptors.add(MAX_DATA_RATE);
        descriptors.add(SSL_CONTEXT_SERVICE);
        descriptors.add(CLIENT_AUTHENTICATION);
        descriptors.add(AUTHORIZED_DN_PATTERN);
        descriptors.add(MAX_UNCONFIRMED_TIME);
        descriptors.add(HEADERS_AS_ATTRIBUTES_REGEX);
        descriptors.add(RETURN_CODE);
        descriptors.add(MULTIPART_REQUEST_MAX_SIZE);
        descriptors.add(MULTIPART_READ_BUFFER_SIZE);
        this.properties = Collections.unmodifiableList(descriptors);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    @OnStopped
    public void shutdownHttpServer() {
        Server toShutdown;
        StreamThrottler throttler = this.throttlerRef.getAndSet(null);
        if (throttler != null) {
            try {
                throttler.close();
            }
            catch (IOException e) {
                this.getLogger().error("Failed to close StreamThrottler", (Throwable)e);
            }
        }
        if ((toShutdown = this.server) == null) {
            return;
        }
        this.shutdownHttpServer(toShutdown);
    }

    private void shutdownHttpServer(Server toShutdown) {
        try {
            toShutdown.stop();
            toShutdown.destroy();
            this.clearInit();
        }
        catch (Exception ex) {
            this.getLogger().warn("unable to cleanly shutdown embedded server due to {}", new Object[]{ex});
            this.server = null;
        }
    }

    private synchronized void createHttpServerFromService(ProcessContext context) throws Exception {
        if (this.initialized.get()) {
            return;
        }
        this.runOnPrimary.set(context.getExecutionNode().equals((Object)ExecutionNode.PRIMARY));
        String basePath = context.getProperty(BASE_PATH).evaluateAttributeExpressions().getValue();
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        Double maxBytesPerSecond = context.getProperty(MAX_DATA_RATE).asDataSize(DataUnit.B);
        LeakyBucketStreamThrottler streamThrottler = maxBytesPerSecond == null ? null : new LeakyBucketStreamThrottler(maxBytesPerSecond.intValue());
        int returnCode = context.getProperty(RETURN_CODE).asInteger();
        long requestMaxSize = context.getProperty(MULTIPART_REQUEST_MAX_SIZE).asDataSize(DataUnit.B).longValue();
        int readBufferSize = context.getProperty(MULTIPART_READ_BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
        this.throttlerRef.set((StreamThrottler)streamThrottler);
        boolean sslRequired = sslContextService != null;
        PropertyValue clientAuthenticationProperty = context.getProperty(CLIENT_AUTHENTICATION);
        ClientAuthentication clientAuthentication = this.getClientAuthentication(sslContextService, clientAuthenticationProperty);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName(String.format("%s (%s) Web Server", ((Object)((Object)this)).getClass().getSimpleName(), this.getIdentifier()));
        Server server = new Server((ThreadPool)threadPool);
        int port = context.getProperty(PORT).evaluateAttributeExpressions().asInteger();
        ServerConnector connector = this.createServerConnector(server, port, sslContextService, sslRequired, clientAuthentication);
        server.addConnector((Connector)connector);
        Integer healthCheckPort = context.getProperty(HEALTH_CHECK_PORT).evaluateAttributeExpressions().asInteger();
        if (healthCheckPort != null) {
            ServerConnector healthCheckConnector = this.createServerConnector(server, healthCheckPort, sslContextService, sslRequired, ClientAuthentication.NONE);
            server.addConnector((Connector)healthCheckConnector);
        }
        ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)server, "/", true, sslRequired);
        for (Class<? extends Servlet> cls : this.getServerClasses()) {
            Path path = cls.getAnnotation(Path.class);
            if (basePath.isEmpty() && !path.value().isEmpty()) {
                contextHandler.addServlet(cls, path.value());
                continue;
            }
            contextHandler.addServlet(cls, "/" + basePath + path.value());
        }
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_PROCESSOR, (Object)this);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_LOGGER, (Object)this.getLogger());
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_SESSION_FACTORY_HOLDER, this.sessionFactoryReference);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_PROCESS_CONTEXT_HOLDER, (Object)context);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_FLOWFILE_MAP, this.flowFileMap);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_AUTHORITY_PATTERN, (Object)Pattern.compile(context.getProperty(AUTHORIZED_DN_PATTERN).getValue()));
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_STREAM_THROTTLER, (Object)streamThrottler);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_BASE_PATH, (Object)basePath);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_RETURN_CODE, (Object)returnCode);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_MULTIPART_REQUEST_MAX_SIZE, (Object)requestMaxSize);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_MULTIPART_READ_BUFFER_SIZE, (Object)readBufferSize);
        contextHandler.setAttribute(CONTEXT_ATTRIBUTE_PORT, (Object)port);
        if (context.getProperty(HEADERS_AS_ATTRIBUTES_REGEX).isSet()) {
            contextHandler.setAttribute(CONTEXT_ATTRIBUTE_HEADER_PATTERN, (Object)Pattern.compile(context.getProperty(HEADERS_AS_ATTRIBUTES_REGEX).getValue()));
        }
        try {
            server.start();
        }
        catch (Exception e) {
            this.shutdownHttpServer(server);
            throw e;
        }
        this.server = server;
        this.initialized.set(true);
    }

    private ClientAuthentication getClientAuthentication(SSLContextService sslContextService, PropertyValue clientAuthenticationProperty) {
        ClientAuthentication clientAuthentication = ClientAuthentication.NONE;
        if (clientAuthenticationProperty.isSet()) {
            boolean trustStoreConfigured;
            clientAuthentication = ClientAuthentication.valueOf(clientAuthenticationProperty.getValue());
            boolean bl = trustStoreConfigured = sslContextService != null && sslContextService.isTrustStoreConfigured();
            if (ClientAuthentication.AUTO.equals((Object)clientAuthentication) && trustStoreConfigured) {
                clientAuthentication = ClientAuthentication.REQUIRED;
                this.getLogger().debug("Client Authentication REQUIRED from SSLContextService Trust Store configuration");
            }
        }
        return clientAuthentication;
    }

    private ServerConnector createServerConnector(Server server, int port, SSLContextService sslContextService, boolean sslRequired, ClientAuthentication clientAuthentication) {
        ServerConnector connector;
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        if (sslRequired) {
            httpConfiguration.setSecureScheme("https");
            httpConfiguration.setSecurePort(port);
            httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslContextFactory contextFactory = this.createSslContextFactory(sslContextService, clientAuthentication);
            connector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(contextFactory, "http/1.1"), new HttpConnectionFactory(httpConfiguration)});
        } else {
            connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
        }
        connector.setPort(port);
        return connector;
    }

    private SslContextFactory createSslContextFactory(SSLContextService sslContextService, ClientAuthentication clientAuthentication) {
        SslContextFactory.Server contextFactory = new SslContextFactory.Server();
        SSLContext sslContext = sslContextService.createContext();
        contextFactory.setSslContext(sslContext);
        TlsConfiguration tlsConfiguration = sslContextService.createTlsConfiguration();
        contextFactory.setIncludeProtocols(tlsConfiguration.getEnabledProtocols());
        if (ClientAuthentication.REQUIRED.equals((Object)clientAuthentication)) {
            contextFactory.setNeedClientAuth(true);
        } else if (ClientAuthentication.WANT.equals((Object)clientAuthentication)) {
            contextFactory.setWantClientAuth(true);
        }
        return contextFactory;
    }

    @OnScheduled
    public void clearInit() {
        this.initialized.set(false);
    }

    protected Set<Class<? extends Servlet>> getServerClasses() {
        HashSet<Class<? extends Servlet>> s = new HashSet<Class<? extends Servlet>>();
        s.add(ListenHTTPServlet.class);
        s.add(ContentAcknowledgmentServlet.class);
        s.add(HealthCheckServlet.class);
        return s;
    }

    private Set<String> findOldFlowFileIds(ProcessContext ctx) {
        HashSet<String> old = new HashSet<String>();
        long expiryMillis = ctx.getProperty(MAX_UNCONFIRMED_TIME).asTimePeriod(TimeUnit.MILLISECONDS);
        long cutoffTime = System.currentTimeMillis() - expiryMillis;
        for (Map.Entry entry : this.flowFileMap.entrySet()) {
            FlowFileEntryTimeWrapper wrapper = (FlowFileEntryTimeWrapper)entry.getValue();
            if (wrapper == null || wrapper.getEntryTime() >= cutoffTime) continue;
            old.add((String)entry.getKey());
        }
        return old;
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        try {
            if (!this.initialized.get()) {
                this.createHttpServerFromService(context);
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to start http server during initialization: " + e);
            context.yield();
            throw new ProcessException("Failed to initialize the server", (Throwable)e);
        }
        this.sessionFactoryReference.compareAndSet(null, sessionFactory);
        for (String id : this.findOldFlowFileIds(context)) {
            FlowFileEntryTimeWrapper wrapper = (FlowFileEntryTimeWrapper)this.flowFileMap.remove(id);
            if (wrapper == null) continue;
            this.getLogger().warn("failed to received acknowledgment for HOLD with ID {} sent by {}; rolling back session", new Object[]{id, wrapper.getClientIP()});
            wrapper.session.rollback();
        }
        context.yield();
    }

    @OnPrimaryNodeStateChange
    public void onPrimaryNodeChange(PrimaryNodeState newState) {
        if (this.runOnPrimary.get() && newState.equals((Object)PrimaryNodeState.PRIMARY_NODE_REVOKED)) {
            try {
                this.shutdownHttpServer();
            }
            catch (Exception shutdownException) {
                this.getLogger().warn("Processor is configured to run only on Primary Node, but failed to shutdown HTTP server following revocation of primary node status due to {}", (Throwable)shutdownException);
            }
        }
    }

    public static class FlowFileEntryTimeWrapper {
        private final Set<FlowFile> flowFiles;
        private final long entryTime;
        private final ProcessSession session;
        private final String clientIP;

        public FlowFileEntryTimeWrapper(ProcessSession session, Set<FlowFile> flowFiles, long entryTime, String clientIP) {
            this.flowFiles = flowFiles;
            this.entryTime = entryTime;
            this.session = session;
            this.clientIP = clientIP;
        }

        public Set<FlowFile> getFlowFiles() {
            return this.flowFiles;
        }

        public long getEntryTime() {
            return this.entryTime;
        }

        public ProcessSession getSession() {
            return this.session;
        }

        public String getClientIP() {
            return this.clientIP;
        }
    }

    public static enum ClientAuthentication {
        AUTO("Inferred based on SSL Context Service properties. The presence of Trust Store properties implies REQUIRED, otherwise NONE is configured."),
        WANT(ClientAuth.WANT.getDescription()),
        REQUIRED(ClientAuth.REQUIRED.getDescription()),
        NONE(ClientAuth.NONE.getDescription());

        private final String description;

        private ClientAuthentication(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public AllowableValue getAllowableValue() {
            return new AllowableValue(this.name(), this.name(), this.description);
        }
    }
}

