/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.channels.SelectableChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.listen.ListenerProperties;
import org.apache.nifi.processor.util.listen.dispatcher.ByteBufferPool;
import org.apache.nifi.processor.util.listen.dispatcher.ByteBufferSource;
import org.apache.nifi.processor.util.listen.dispatcher.ChannelDispatcher;
import org.apache.nifi.processor.util.listen.dispatcher.DatagramChannelDispatcher;
import org.apache.nifi.processor.util.listen.dispatcher.SocketChannelDispatcher;
import org.apache.nifi.processor.util.listen.event.Event;
import org.apache.nifi.processor.util.listen.event.EventFactory;
import org.apache.nifi.processor.util.listen.handler.ChannelHandlerFactory;
import org.apache.nifi.processor.util.listen.handler.socket.SocketChannelHandlerFactory;
import org.apache.nifi.processor.util.listen.response.ChannelResponder;
import org.apache.nifi.processors.standard.AbstractSyslogProcessor;
import org.apache.nifi.processors.standard.ParseSyslog;
import org.apache.nifi.processors.standard.PutSyslog;
import org.apache.nifi.security.util.ClientAuth;
import org.apache.nifi.ssl.RestrictedSSLContextService;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.syslog.attributes.SyslogAttributes;
import org.apache.nifi.syslog.events.SyslogEvent;
import org.apache.nifi.syslog.parsers.SyslogParser;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"syslog", "listen", "udp", "tcp", "logs"})
@CapabilityDescription(value="Listens for Syslog messages being sent to a given port over TCP or UDP. Incoming messages are checked against regular expressions for RFC5424 and RFC3164 formatted messages. The format of each message is: (<PRIORITY>)(VERSION )(TIMESTAMP) (HOSTNAME) (BODY) where version is optional. The timestamp can be an RFC5424 timestamp with a format of \"yyyy-MM-dd'T'HH:mm:ss.SZ\" or \"yyyy-MM-dd'T'HH:mm:ss.S+hh:mm\", or it can be an RFC3164 timestamp with a format of \"MMM d HH:mm:ss\". If an incoming messages matches one of these patterns, the message will be parsed and the individual pieces will be placed in FlowFile attributes, with the original message in the content of the FlowFile. If an incoming message does not match one of these patterns it will not be parsed and the syslog.valid attribute will be set to false with the original message in the content of the FlowFile. Valid messages will be transferred on the success relationship, and invalid messages will be transferred on the invalid relationship.")
@WritesAttributes(value={@WritesAttribute(attribute="syslog.priority", description="The priority of the Syslog message."), @WritesAttribute(attribute="syslog.severity", description="The severity of the Syslog message derived from the priority."), @WritesAttribute(attribute="syslog.facility", description="The facility of the Syslog message derived from the priority."), @WritesAttribute(attribute="syslog.version", description="The optional version from the Syslog message."), @WritesAttribute(attribute="syslog.timestamp", description="The timestamp of the Syslog message."), @WritesAttribute(attribute="syslog.hostname", description="The hostname or IP address of the Syslog message."), @WritesAttribute(attribute="syslog.sender", description="The hostname of the Syslog server that sent the message."), @WritesAttribute(attribute="syslog.body", description="The body of the Syslog message, everything after the hostname."), @WritesAttribute(attribute="syslog.valid", description="An indicator of whether this message matched the expected formats. If this value is false, the other attributes will be empty and only the original message will be available in the content."), @WritesAttribute(attribute="syslog.protocol", description="The protocol over which the Syslog message was received."), @WritesAttribute(attribute="syslog.port", description="The port over which the Syslog message was received."), @WritesAttribute(attribute="mime.type", description="The mime.type of the FlowFile which will be text/plain for Syslog messages.")})
@SeeAlso(value={PutSyslog.class, ParseSyslog.class})
public class ListenSyslog
extends AbstractSyslogProcessor {
    public static final PropertyDescriptor MAX_MESSAGE_QUEUE_SIZE = new PropertyDescriptor.Builder().name("Max Size of Message Queue").displayName("Max Size of Message Queue").description("The maximum size of the internal queue used to buffer messages being transferred from the underlying channel to the processor. Setting this value higher allows more messages to be buffered in memory during surges of incoming messages, but increases the total memory used by the processor.").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("10000").required(true).build();
    public static final PropertyDescriptor RECV_BUFFER_SIZE = new PropertyDescriptor.Builder().name("Receive Buffer Size").displayName("Receive Buffer Size").description("The size of each buffer used to receive Syslog messages. Adjust this value appropriately based on the expected size of the incoming Syslog messages. When UDP is selected each buffer will hold one Syslog message. When TCP is selected messages are read from an incoming connection until the buffer is full, or the connection is closed. ").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("65507 B").required(true).build();
    public static final PropertyDescriptor MAX_SOCKET_BUFFER_SIZE = new PropertyDescriptor.Builder().name("Max Size of Socket Buffer").displayName("Max Size of Socket Buffer").description("The maximum size of the socket buffer that should be used. This is a suggestion to the Operating System to indicate how big the socket buffer should be. If this value is set too low, the buffer may fill up before the data can be read, and incoming data will be dropped.").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("1 MB").required(true).build();
    public static final PropertyDescriptor MAX_CONNECTIONS = new PropertyDescriptor.Builder().name("Max Number of TCP Connections").displayName("Max Number of TCP Connections").description("The maximum number of concurrent connections to accept Syslog messages in TCP mode.").addValidator(StandardValidators.createLongValidator((long)1L, (long)65535L, (boolean)true)).defaultValue("2").required(true).build();
    public static final PropertyDescriptor MAX_BATCH_SIZE = new PropertyDescriptor.Builder().name("Max Batch Size").displayName("Max Batch Size").description("The maximum number of Syslog events to add to a single FlowFile. If multiple events are available, they will be concatenated along with the <Message Delimiter> up to this configured maximum number of messages").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).expressionLanguageSupported(false).defaultValue("1").required(true).build();
    public static final PropertyDescriptor MESSAGE_DELIMITER = new PropertyDescriptor.Builder().name("Message Delimiter").displayName("Message Delimiter").description("Specifies the delimiter to place between Syslog messages when multiple messages are bundled together (see <Max Batch Size> property).").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("\\n").required(true).build();
    public static final PropertyDescriptor PARSE_MESSAGES = new PropertyDescriptor.Builder().name("Parse Messages").displayName("Parse Messages").description("Indicates if the processor should parse the Syslog messages. If set to false, each outgoing FlowFile will only contain the sender, protocol, and port, and no additional attributes.").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").displayName("SSL Context Service").description("The Controller Service to use in order to obtain an SSL Context. If this property is set, syslog messages will be received over a secure connection.").required(false).identifiesControllerService(RestrictedSSLContextService.class).build();
    public static final PropertyDescriptor CLIENT_AUTH = new PropertyDescriptor.Builder().name("Client Auth").displayName("Client Auth").description("The client authentication policy to use for the SSL Context. Only used if an SSL Context Service is provided.").required(false).allowableValues((Enum[])ClientAuth.values()).defaultValue(ClientAuth.REQUIRED.name()).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Syslog messages that match one of the expected formats will be sent out this relationship as a FlowFile per message.").build();
    public static final Relationship REL_INVALID = new Relationship.Builder().name("invalid").description("Syslog messages that do not match one of the expected formats will be sent out this relationship as a FlowFile per message.").build();
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> descriptors;
    private volatile ChannelDispatcher channelDispatcher;
    private volatile SyslogParser parser;
    private volatile ByteBufferSource byteBufferSource;
    private volatile BlockingQueue<RawSyslogEvent> syslogEvents;
    private final BlockingQueue<RawSyslogEvent> errorEvents = new LinkedBlockingQueue<RawSyslogEvent>();
    private volatile byte[] messageDemarcatorBytes;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(PROTOCOL);
        descriptors.add(PORT);
        descriptors.add(ListenerProperties.NETWORK_INTF_NAME);
        descriptors.add(SSL_CONTEXT_SERVICE);
        descriptors.add(CLIENT_AUTH);
        descriptors.add(RECV_BUFFER_SIZE);
        descriptors.add(MAX_MESSAGE_QUEUE_SIZE);
        descriptors.add(MAX_SOCKET_BUFFER_SIZE);
        descriptors.add(MAX_CONNECTIONS);
        descriptors.add(MAX_BATCH_SIZE);
        descriptors.add(MESSAGE_DELIMITER);
        descriptors.add(PARSE_MESSAGES);
        descriptors.add(CHARSET);
        this.descriptors = Collections.unmodifiableList(descriptors);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_INVALID);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (PROTOCOL.equals((Object)descriptor)) {
            if (this.syslogEvents != null) {
                this.syslogEvents.clear();
            }
            if (this.errorEvents != null) {
                this.errorEvents.clear();
            }
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (validationContext.getProperty(MAX_BATCH_SIZE).asInteger() > 1 && validationContext.getProperty(PARSE_MESSAGES).asBoolean().booleanValue()) {
            results.add(new ValidationResult.Builder().subject("Parse Messages").input("true").valid(false).explanation("Cannot set Parse Messages to 'true' if Batch Size is greater than 1").build());
        }
        String protocol = validationContext.getProperty(PROTOCOL).getValue();
        SSLContextService sslContextService = (SSLContextService)validationContext.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        if (UDP_VALUE.getValue().equals(protocol) && sslContextService != null) {
            results.add(new ValidationResult.Builder().explanation("SSL can not be used with UDP").valid(false).subject("SSL Context").build());
        }
        String clientAuth = validationContext.getProperty(CLIENT_AUTH).getValue();
        if (sslContextService != null && StringUtils.isBlank((CharSequence)clientAuth)) {
            results.add(new ValidationResult.Builder().explanation("Client Auth must be provided when using TLS/SSL").valid(false).subject("Client Auth").build());
        }
        return results;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        int port = context.getProperty(PORT).evaluateAttributeExpressions().asInteger();
        int bufferSize = context.getProperty(RECV_BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
        int maxChannelBufferSize = context.getProperty(MAX_SOCKET_BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
        int maxMessageQueueSize = context.getProperty(MAX_MESSAGE_QUEUE_SIZE).asInteger();
        String protocol = context.getProperty(PROTOCOL).getValue();
        String nicIPAddressStr = context.getProperty(ListenerProperties.NETWORK_INTF_NAME).evaluateAttributeExpressions().getValue();
        String charSet = context.getProperty(CHARSET).evaluateAttributeExpressions().getValue();
        String msgDemarcator = context.getProperty(MESSAGE_DELIMITER).getValue().replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t");
        this.messageDemarcatorBytes = msgDemarcator.getBytes(Charset.forName(charSet));
        int maxConnections = UDP_VALUE.getValue().equals(protocol) ? 1 : context.getProperty(MAX_CONNECTIONS).asLong().intValue();
        this.byteBufferSource = new ByteBufferPool(maxConnections, bufferSize);
        this.parser = new SyslogParser(Charset.forName(charSet));
        this.syslogEvents = new LinkedBlockingQueue<RawSyslogEvent>(maxMessageQueueSize);
        InetAddress nicIPAddress = null;
        if (!StringUtils.isEmpty((CharSequence)nicIPAddressStr)) {
            NetworkInterface netIF = NetworkInterface.getByName(nicIPAddressStr);
            nicIPAddress = netIF.getInetAddresses().nextElement();
        }
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        this.channelDispatcher = this.createChannelReader(context, protocol, this.byteBufferSource, this.syslogEvents, maxConnections, sslContextService, Charset.forName(charSet));
        this.channelDispatcher.open(nicIPAddress, port, maxChannelBufferSize);
        Thread readerThread = new Thread((Runnable)this.channelDispatcher);
        readerThread.setName("ListenSyslog [" + this.getIdentifier() + "]");
        readerThread.setDaemon(true);
        readerThread.start();
    }

    protected SyslogParser getParser() {
        return this.parser;
    }

    protected ChannelDispatcher createChannelReader(ProcessContext context, String protocol, ByteBufferSource byteBufferSource, BlockingQueue<RawSyslogEvent> events, int maxConnections, SSLContextService sslContextService, Charset charset) throws IOException {
        RawSyslogEventFactory eventFactory = new RawSyslogEventFactory();
        if (UDP_VALUE.getValue().equals(protocol)) {
            return new DatagramChannelDispatcher((EventFactory)eventFactory, byteBufferSource, events, this.getLogger());
        }
        SSLContext sslContext = null;
        ClientAuth clientAuth = null;
        if (sslContextService != null) {
            String clientAuthValue = context.getProperty(CLIENT_AUTH).getValue();
            sslContext = sslContextService.createContext();
            clientAuth = ClientAuth.valueOf((String)clientAuthValue);
        }
        SocketChannelHandlerFactory handlerFactory = new SocketChannelHandlerFactory();
        return new SocketChannelDispatcher((EventFactory)eventFactory, (ChannelHandlerFactory)handlerFactory, byteBufferSource, events, this.getLogger(), maxConnections, sslContext, clientAuth, charset);
    }

    protected int getPort() {
        return this.channelDispatcher == null ? 0 : this.channelDispatcher.getPort();
    }

    @OnUnscheduled
    public void onUnscheduled() {
        if (this.channelDispatcher != null) {
            this.channelDispatcher.close();
        }
    }

    protected RawSyslogEvent getMessage(boolean longPoll, boolean pollErrorQueue, ProcessSession session) {
        RawSyslogEvent rawSyslogEvent = null;
        if (pollErrorQueue) {
            rawSyslogEvent = (RawSyslogEvent)this.errorEvents.poll();
        }
        if (rawSyslogEvent == null) {
            try {
                rawSyslogEvent = longPoll ? this.syslogEvents.poll(20L, TimeUnit.MILLISECONDS) : (RawSyslogEvent)this.syslogEvents.poll();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        if (rawSyslogEvent != null) {
            session.adjustCounter("Messages Received", 1L, false);
        }
        return rawSyslogEvent;
    }

    protected int getErrorQueueSize() {
        return this.errorEvents.size();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile;
        String sender;
        RawSyslogEvent rawSyslogEvent = this.getMessage(true, true, session);
        if (rawSyslogEvent == null) {
            return;
        }
        int maxBatchSize = context.getProperty(MAX_BATCH_SIZE).asInteger();
        String port = context.getProperty(PORT).evaluateAttributeExpressions().getValue();
        String protocol = context.getProperty(PROTOCOL).getValue();
        HashMap<String, String> defaultAttributes = new HashMap<String, String>(4);
        defaultAttributes.put(SyslogAttributes.SYSLOG_PROTOCOL.key(), protocol);
        defaultAttributes.put(SyslogAttributes.SYSLOG_PORT.key(), port);
        defaultAttributes.put(CoreAttributes.MIME_TYPE.key(), "text/plain");
        int numAttributes = SyslogAttributes.values().length + 2;
        boolean shouldParse = context.getProperty(PARSE_MESSAGES).asBoolean();
        HashMap<String, FlowFile> flowFilePerSender = new HashMap<String, FlowFile>();
        SyslogParser parser = this.getParser();
        for (int i = 0; i < maxBatchSize; ++i) {
            SyslogEvent event = null;
            if (i > 0 && (rawSyslogEvent = this.getMessage(true, false, session)) == null) break;
            sender = rawSyslogEvent.getSender();
            flowFile = flowFilePerSender.computeIfAbsent(sender, k -> session.create());
            if (shouldParse) {
                boolean valid = true;
                try {
                    event = parser.parseEvent(rawSyslogEvent.getData(), sender);
                }
                catch (ProcessException pe) {
                    this.getLogger().warn("Failed to parse Syslog event; routing to invalid");
                    valid = false;
                }
                if (!valid || event == null || !event.isValid()) {
                    FlowFile invalidFlowFile = session.create();
                    invalidFlowFile = session.putAllAttributes(invalidFlowFile, defaultAttributes);
                    if (sender != null) {
                        invalidFlowFile = session.putAttribute(invalidFlowFile, SyslogAttributes.SYSLOG_SENDER.key(), sender);
                    }
                    try {
                        final byte[] rawBytes = rawSyslogEvent.getData();
                        invalidFlowFile = session.write(invalidFlowFile, new OutputStreamCallback(){

                            public void process(OutputStream out) throws IOException {
                                out.write(rawBytes);
                            }
                        });
                    }
                    catch (Exception e) {
                        this.getLogger().error("Failed to write contents of Syslog message to FlowFile due to {}; will re-queue message and try again", (Throwable)e);
                        this.errorEvents.offer(rawSyslogEvent);
                        session.remove(invalidFlowFile);
                        break;
                    }
                    session.transfer(invalidFlowFile, REL_INVALID);
                    break;
                }
                this.getLogger().trace(event.getFullMessage());
                HashMap<String, String> attributes = new HashMap<String, String>(numAttributes);
                attributes.put(SyslogAttributes.SYSLOG_PRIORITY.key(), event.getPriority());
                attributes.put(SyslogAttributes.SYSLOG_SEVERITY.key(), event.getSeverity());
                attributes.put(SyslogAttributes.SYSLOG_FACILITY.key(), event.getFacility());
                attributes.put(SyslogAttributes.SYSLOG_VERSION.key(), event.getVersion());
                attributes.put(SyslogAttributes.SYSLOG_TIMESTAMP.key(), event.getTimeStamp());
                attributes.put(SyslogAttributes.SYSLOG_HOSTNAME.key(), event.getHostName());
                attributes.put(SyslogAttributes.SYSLOG_BODY.key(), event.getMsgBody());
                attributes.put(SyslogAttributes.SYSLOG_VALID.key(), String.valueOf(event.isValid()));
                flowFile = session.putAllAttributes(flowFile, attributes);
            }
            final boolean writeDemarcator = i > 0;
            try {
                final byte[] rawMessage = event == null ? rawSyslogEvent.getData() : event.getRawMessage();
                flowFile = session.append(flowFile, new OutputStreamCallback(){

                    public void process(OutputStream out) throws IOException {
                        if (writeDemarcator) {
                            out.write(ListenSyslog.this.messageDemarcatorBytes);
                        }
                        out.write(rawMessage);
                    }
                });
            }
            catch (Exception e) {
                this.getLogger().error("Failed to write contents of Syslog message to FlowFile due to {}; will re-queue message and try again", (Throwable)e);
                this.errorEvents.offer(rawSyslogEvent);
                break;
            }
            flowFilePerSender.put(sender, flowFile);
        }
        for (Map.Entry entry : flowFilePerSender.entrySet()) {
            sender = (String)entry.getKey();
            flowFile = (FlowFile)entry.getValue();
            if (flowFile.getSize() == 0L) {
                session.remove(flowFile);
                this.getLogger().debug("No data written to FlowFile from Sender {}; removing FlowFile", new Object[]{sender});
                continue;
            }
            HashMap<String, String> newAttributes = new HashMap<String, String>(defaultAttributes.size() + 1);
            newAttributes.putAll(defaultAttributes);
            newAttributes.put(SyslogAttributes.SYSLOG_SENDER.key(), sender);
            flowFile = session.putAllAttributes(flowFile, newAttributes);
            this.getLogger().debug("Transferring {} to success", new Object[]{flowFile});
            session.transfer(flowFile, REL_SUCCESS);
            session.adjustCounter("FlowFiles Transferred to Success", 1L, false);
            String senderHost = sender.startsWith("/") && sender.length() > 1 ? sender.substring(1) : sender;
            String transitUri = protocol.toLowerCase() + "://" + senderHost + ":" + port;
            session.getProvenanceReporter().receive(flowFile, transitUri);
        }
    }

    private static class RawSyslogEventFactory
    implements EventFactory<RawSyslogEvent> {
        private RawSyslogEventFactory() {
        }

        public RawSyslogEvent create(byte[] data, Map<String, String> metadata, ChannelResponder responder) {
            String sender = null;
            if (metadata != null && metadata.containsKey("sender")) {
                sender = metadata.get("sender");
            }
            return new RawSyslogEvent(data, sender);
        }
    }

    static class RawSyslogEvent<C extends SelectableChannel>
    implements Event<C> {
        final byte[] rawMessage;
        final String sender;

        public RawSyslogEvent(byte[] rawMessage, String sender) {
            this.rawMessage = rawMessage;
            this.sender = sender;
        }

        public byte[] getData() {
            return this.rawMessage;
        }

        public String getSender() {
            return this.sender;
        }

        public ChannelResponder getResponder() {
            return null;
        }
    }
}

