/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.processors.standard.db.impl.GenericDatabaseAdapter;
import org.apache.nifi.util.StringUtils;

public class PostgreSQLDatabaseAdapter
extends GenericDatabaseAdapter {
    @Override
    public String getName() {
        return "PostgreSQL";
    }

    @Override
    public String getDescription() {
        return "Generates PostgreSQL compatible SQL";
    }

    @Override
    public boolean supportsUpsert() {
        return true;
    }

    @Override
    public boolean supportsInsertIgnore() {
        return true;
    }

    @Override
    public String getUpsertStatement(String table, List<String> columnNames, Collection<String> uniqueKeyColumnNames) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)table) ? 1 : 0) != 0, (Object)"Table name cannot be null or blank");
        Preconditions.checkArgument((columnNames != null && !columnNames.isEmpty() ? 1 : 0) != 0, (Object)"Column names cannot be null or empty");
        Preconditions.checkArgument((uniqueKeyColumnNames != null && !uniqueKeyColumnNames.isEmpty() ? 1 : 0) != 0, (Object)"Key column names cannot be null or empty");
        String columns = columnNames.stream().collect(Collectors.joining(", "));
        String parameterizedInsertValues = columnNames.stream().map(__ -> "?").collect(Collectors.joining(", "));
        String updateValues = columnNames.stream().map(columnName -> "EXCLUDED." + columnName).collect(Collectors.joining(", "));
        String conflictClause = "(" + uniqueKeyColumnNames.stream().collect(Collectors.joining(", ")) + ")";
        StringBuilder statementStringBuilder = new StringBuilder("INSERT INTO ").append(table).append("(").append(columns).append(")").append(" VALUES ").append("(").append(parameterizedInsertValues).append(")").append(" ON CONFLICT ").append(conflictClause).append(" DO UPDATE SET ").append("(").append(columns).append(")").append(" = ").append("(").append(updateValues).append(")");
        return statementStringBuilder.toString();
    }

    @Override
    public String getInsertIgnoreStatement(String table, List<String> columnNames, Collection<String> uniqueKeyColumnNames) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)table) ? 1 : 0) != 0, (Object)"Table name cannot be null or blank");
        Preconditions.checkArgument((columnNames != null && !columnNames.isEmpty() ? 1 : 0) != 0, (Object)"Column names cannot be null or empty");
        Preconditions.checkArgument((uniqueKeyColumnNames != null && !uniqueKeyColumnNames.isEmpty() ? 1 : 0) != 0, (Object)"Key column names cannot be null or empty");
        String columns = columnNames.stream().collect(Collectors.joining(", "));
        String parameterizedInsertValues = columnNames.stream().map(__ -> "?").collect(Collectors.joining(", "));
        String conflictClause = "(" + uniqueKeyColumnNames.stream().collect(Collectors.joining(", ")) + ")";
        StringBuilder statementStringBuilder = new StringBuilder("INSERT INTO ").append(table).append("(").append(columns).append(")").append(" VALUES ").append("(").append(parameterizedInsertValues).append(")").append(" ON CONFLICT ").append(conflictClause).append(" DO NOTHING");
        return statementStringBuilder.toString();
    }
}

