/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.LookupService;
import org.apache.nifi.lookup.StringLookupService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.Tuple;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"xml", "xslt", "transform"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Applies the provided XSLT file to the flowfile XML payload. A new FlowFile is created with transformed content and is routed to the 'success' relationship. If the XSL transform fails, the original FlowFile is routed to the 'failure' relationship")
@DynamicProperty(name="An XSLT transform parameter name", value="An XSLT transform parameter value", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="These XSLT parameters are passed to the transformer")
public class TransformXml
extends AbstractProcessor {
    public static final PropertyDescriptor XSLT_FILE_NAME = new PropertyDescriptor.Builder().name("XSLT file name").description("Provides the name (including full path) of the XSLT file to apply to the flowfile XML content.One of the 'XSLT file name' and 'XSLT Lookup' properties must be defined.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).build();
    public static final PropertyDescriptor XSLT_CONTROLLER = new PropertyDescriptor.Builder().name("xslt-controller").displayName("XSLT Lookup").description("Controller lookup used to store XSLT definitions. One of the 'XSLT file name' and 'XSLT Lookup' properties must be defined. WARNING: note that the lookup controller service should not be used to store large XSLT files.").required(false).identifiesControllerService(StringLookupService.class).build();
    public static final PropertyDescriptor XSLT_CONTROLLER_KEY = new PropertyDescriptor.Builder().name("xslt-controller-key").displayName("XSLT Lookup key").description("Key used to retrieve the XSLT definition from the XSLT lookup controller. This property must be set when using the XSLT controller property.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).build();
    public static final PropertyDescriptor INDENT_OUTPUT = new PropertyDescriptor.Builder().name("indent-output").displayName("Indent").description("Whether or not to indent the output.").required(true).defaultValue("true").allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor SECURE_PROCESSING = new PropertyDescriptor.Builder().name("secure-processing").displayName("Secure processing").description("Whether or not to mitigate various XML-related attacks like XXE (XML External Entity) attacks.").required(true).defaultValue("true").allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor CACHE_SIZE = new PropertyDescriptor.Builder().name("cache-size").displayName("Cache size").description("Maximum number of stylesheets to cache. Zero disables the cache.").required(true).defaultValue("10").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor CACHE_TTL_AFTER_LAST_ACCESS = new PropertyDescriptor.Builder().name("cache-ttl-after-last-access").displayName("Cache TTL after last access").description("The cache TTL (time-to-live) or how long to keep stylesheets in the cache after last access.").required(true).defaultValue("60 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The FlowFile with transformed content will be routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If a FlowFile fails processing for any reason (for example, the FlowFile is not valid XML), it will be routed to this relationship").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;
    private LoadingCache<String, Templates> cache;
    private static AtomicReference<LookupService<String>> lookupService = new AtomicReference<Object>(null);

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(XSLT_FILE_NAME);
        properties.add(XSLT_CONTROLLER);
        properties.add(XSLT_CONTROLLER_KEY);
        properties.add(INDENT_OUTPUT);
        properties.add(SECURE_PROCESSING);
        properties.add(CACHE_SIZE);
        properties.add(CACHE_TTL_AFTER_LAST_ACCESS);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        LookupService lookupService;
        Set requiredKeys;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        PropertyValue filename = validationContext.getProperty(XSLT_FILE_NAME);
        PropertyValue controller = validationContext.getProperty(XSLT_CONTROLLER);
        PropertyValue key = validationContext.getProperty(XSLT_CONTROLLER_KEY);
        if (filename.isSet() && controller.isSet() || !filename.isSet() && !controller.isSet()) {
            results.add(new ValidationResult.Builder().valid(false).subject(((Object)((Object)this)).getClass().getSimpleName()).explanation("Exactly one of the \"XSLT file name\" and \"XSLT controller\" properties must be defined.").build());
        }
        if (controller.isSet() && !key.isSet()) {
            results.add(new ValidationResult.Builder().valid(false).subject(XSLT_CONTROLLER_KEY.getDisplayName()).explanation("If using \"XSLT controller\", the XSLT controller key property must be defined.").build());
        }
        if (controller.isSet() && ((requiredKeys = (lookupService = (LookupService)validationContext.getProperty(XSLT_CONTROLLER).asControllerService(StringLookupService.class)).getRequiredKeys()) == null || requiredKeys.size() != 1)) {
            results.add(new ValidationResult.Builder().valid(false).subject(XSLT_CONTROLLER.getDisplayName()).explanation("This processor requires a key-value lookup service supporting exactly one required key, was: " + (requiredKeys == null ? "null" : String.valueOf(requiredKeys.size()))).build());
        }
        return results;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).required(false).dynamic(true).build();
    }

    private Templates newTemplates(ProcessContext context, String path) throws TransformerConfigurationException, LookupFailureException {
        Boolean secureProcessing = context.getProperty(SECURE_PROCESSING).asBoolean();
        TransformerFactory factory = TransformerFactory.newInstance();
        boolean isFilename = context.getProperty(XSLT_FILE_NAME).isSet();
        if (secureProcessing.booleanValue()) {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://saxon.sf.net/feature/parserFeature?uri=http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://saxon.sf.net/feature/parserFeature?uri=http://xml.org/sax/features/external-general-entities", false);
        }
        if (isFilename) {
            return factory.newTemplates(new StreamSource(path));
        }
        String coordinateKey = (String)lookupService.get().getRequiredKeys().iterator().next();
        Optional attributeValue = lookupService.get().lookup(Collections.singletonMap(coordinateKey, path));
        if (attributeValue.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)attributeValue.get()))) {
            return factory.newTemplates(new StreamSource(new ByteArrayInputStream(((String)attributeValue.get()).getBytes(StandardCharsets.UTF_8))));
        }
        throw new TransformerConfigurationException("No XSLT definition is associated to " + path + " in the lookup controller service.");
    }

    @OnScheduled
    public void onScheduled(final ProcessContext context) {
        ComponentLog logger = this.getLogger();
        Integer cacheSize = context.getProperty(CACHE_SIZE).asInteger();
        Long cacheTTL = context.getProperty(CACHE_TTL_AFTER_LAST_ACCESS).asTimePeriod(TimeUnit.SECONDS);
        if (cacheSize > 0) {
            CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize((long)cacheSize.intValue());
            if (cacheTTL > 0L) {
                cacheBuilder = cacheBuilder.expireAfterAccess(cacheTTL.longValue(), TimeUnit.SECONDS);
            }
            this.cache = cacheBuilder.build((CacheLoader)new CacheLoader<String, Templates>(){

                public Templates load(String path) throws TransformerConfigurationException, LookupFailureException {
                    return TransformXml.this.newTemplates(context, path);
                }
            });
        } else {
            this.cache = null;
            logger.info("Stylesheet cache disabled because cache size is set to 0");
        }
    }

    public void onTrigger(final ProcessContext context, ProcessSession session) {
        final FlowFile original = session.get();
        if (original == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        StopWatch stopWatch = new StopWatch(true);
        final String path = context.getProperty(XSLT_FILE_NAME).isSet() ? context.getProperty(XSLT_FILE_NAME).evaluateAttributeExpressions(original).getValue() : context.getProperty(XSLT_CONTROLLER_KEY).evaluateAttributeExpressions(original).getValue();
        final Boolean indentOutput = context.getProperty(INDENT_OUTPUT).asBoolean();
        lookupService.set((LookupService<String>)context.getProperty(XSLT_CONTROLLER).asControllerService(LookupService.class));
        try {
            FlowFile transformed = session.write(original, new StreamCallback(){

                public void process(InputStream rawIn, OutputStream out) throws IOException {
                    try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                        Templates templates = TransformXml.this.cache != null ? (Templates)TransformXml.this.cache.get((Object)path) : TransformXml.this.newTemplates(context, path);
                        Transformer transformer = templates.newTransformer();
                        transformer.setOutputProperty("indent", indentOutput != false ? "yes" : "no");
                        for (Map.Entry entry : context.getProperties().entrySet()) {
                            if (!((PropertyDescriptor)entry.getKey()).isDynamic()) continue;
                            String value = context.newPropertyValue((String)entry.getValue()).evaluateAttributeExpressions(original).getValue();
                            transformer.setParameter(((PropertyDescriptor)entry.getKey()).getName(), value);
                        }
                        StreamSource source = new StreamSource(in);
                        StreamResult result = new StreamResult(out);
                        transformer.transform(source, result);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            });
            session.transfer(transformed, REL_SUCCESS);
            session.getProvenanceReporter().modifyContent(transformed, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            logger.info("Transformed {}", new Object[]{original});
        }
        catch (ProcessException e) {
            logger.error("Unable to transform {} due to {}", new Object[]{original, e});
            session.transfer(original, REL_FAILURE);
        }
    }

    private static final class XsltValidator
    implements Validator {
        private volatile Tuple<String, ValidationResult> cachedResult;

        private XsltValidator() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext validationContext) {
            Tuple<String, ValidationResult> lastResult = this.cachedResult;
            if (lastResult != null && ((String)lastResult.getKey()).equals(input)) {
                return (ValidationResult)lastResult.getValue();
            }
            String error = null;
            File stylesheet = new File(input);
            TransformerFactoryImpl tFactory = new TransformerFactoryImpl();
            StreamSource styleSource = new StreamSource(stylesheet);
            try {
                tFactory.newTransformer(styleSource);
            }
            catch (Exception e) {
                error = e.toString();
            }
            this.cachedResult = new Tuple((Object)input, (Object)new ValidationResult.Builder().input(input).subject(subject).valid(error == null).explanation(error).build());
            return (ValidationResult)this.cachedResult.getValue();
        }
    }
}

