/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.frame;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.nio.charset.Charset;
import java.util.concurrent.BlockingQueue;
import org.apache.nifi.processors.standard.relp.event.RELPMessage;
import org.apache.nifi.processors.standard.relp.frame.RELPEncoder;
import org.apache.nifi.processors.standard.relp.response.RELPChannelResponse;
import org.apache.nifi.processors.standard.relp.response.RELPResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class RELPMessageChannelHandler
extends SimpleChannelInboundHandler<RELPMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RELPMessageChannelHandler.class);
    private final BlockingQueue<RELPMessage> events;
    private final RELPEncoder encoder;

    public RELPMessageChannelHandler(BlockingQueue<RELPMessage> events, Charset charset) {
        this.events = events;
        this.encoder = new RELPEncoder(charset);
    }

    protected void channelRead0(ChannelHandlerContext ctx, RELPMessage msg) {
        LOGGER.debug("RELP Message Received Length [{}] Remote Address [{}] ", (Object)msg.getMessage().length, (Object)msg.getSender());
        if (this.events.offer(msg)) {
            LOGGER.debug("Event Queued: RELP Message Sender [{}] Transaction Number [{}]", (Object)msg.getSender(), (Object)msg.getTxnr());
            ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new RELPChannelResponse(this.encoder, RELPResponse.ok(msg.getTxnr())).toByteArray()));
        } else {
            LOGGER.debug("Event Queue Full: Failed RELP Message Sender [{}] Transaction Number [{}]", (Object)msg.getSender(), (Object)msg.getTxnr());
            ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new RELPChannelResponse(this.encoder, RELPResponse.serverFullError(msg.getTxnr())).toByteArray()));
        }
    }
}

