/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.handler;

import io.netty.channel.ChannelHandler;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import org.apache.nifi.event.transport.configuration.TransportProtocol;
import org.apache.nifi.event.transport.netty.NettyEventServerFactory;
import org.apache.nifi.event.transport.netty.channel.LogExceptionChannelHandler;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.standard.relp.event.RELPMessage;
import org.apache.nifi.processors.standard.relp.frame.RELPFrameDecoder;
import org.apache.nifi.processors.standard.relp.frame.RELPMessageChannelHandler;

public class RELPMessageServerFactory
extends NettyEventServerFactory {
    public RELPMessageServerFactory(ComponentLog log, InetAddress address, int port, Charset charset, BlockingQueue<RELPMessage> events) {
        super(address, port, TransportProtocol.TCP);
        LogExceptionChannelHandler logExceptionChannelHandler = new LogExceptionChannelHandler(log);
        RELPMessageChannelHandler relpChannelHandler = new RELPMessageChannelHandler(events, charset);
        this.setHandlerSupplier(() -> Arrays.asList(new ChannelHandler[]{logExceptionChannelHandler, new RELPFrameDecoder(log, charset), relpChannelHandler}));
    }
}

