/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.Socket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import net.schmizz.keepalive.KeepAlive;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.connection.ConnectionImpl;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyFormat;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.keyprovider.KeyProviderUtil;
import net.schmizz.sshj.userauth.method.AuthKeyboardInteractive;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPassword;
import net.schmizz.sshj.userauth.method.AuthPublickey;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.method.PasswordResponseProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import net.schmizz.sshj.xfer.FilePermission;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.util.FTPTransfer;
import org.apache.nifi.processors.standard.util.FileInfo;
import org.apache.nifi.processors.standard.util.FileTransfer;
import org.apache.nifi.processors.standard.util.PermissionDeniedException;
import org.apache.nifi.processors.standard.util.SFTPFlowFileSourceFile;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.stream.io.StreamUtils;

public class SFTPTransfer
implements FileTransfer {
    private static final int KEEP_ALIVE_INTERVAL_SECONDS = 5;
    private static final Set<String> DEFAULT_KEY_ALGORITHM_NAMES;
    private static final Set<String> DEFAULT_CIPHER_NAMES;
    private static final Set<String> DEFAULT_MESSAGE_AUTHENTICATION_CODE_NAMES;
    private static final Set<String> DEFAULT_KEY_EXCHANGE_ALGORITHM_NAMES;
    public static final PropertyDescriptor PRIVATE_KEY_PATH;
    public static final PropertyDescriptor PRIVATE_KEY_PASSPHRASE;
    public static final PropertyDescriptor HOST_KEY_FILE;
    public static final PropertyDescriptor STRICT_HOST_KEY_CHECKING;
    public static final PropertyDescriptor PORT;
    public static final PropertyDescriptor USE_KEEPALIVE_ON_TIMEOUT;
    public static final PropertyDescriptor KEY_ALGORITHMS_ALLOWED;
    public static final PropertyDescriptor CIPHERS_ALLOWED;
    public static final PropertyDescriptor MESSAGE_AUTHENTICATION_CODES_ALLOWED;
    public static final PropertyDescriptor KEY_EXCHANGE_ALGORITHMS_ALLOWED;
    public static final PropertyDescriptor DISABLE_DIRECTORY_LISTING;
    private static final ProxySpec[] PROXY_SPECS;
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE;
    private final ComponentLog logger;
    private final PropertyContext ctx;
    private SSHClient sshClient;
    private SFTPClient sftpClient;
    private volatile boolean closed = false;
    private String homeDir;
    private final boolean disableDirectoryListing;
    private static final KeepAliveProvider NO_OP_KEEP_ALIVE;
    private static final KeepAliveProvider DEFAULT_KEEP_ALIVE_PROVIDER;

    private static String convertFactorySetToString(Set<String> factorySetNames) {
        return factorySetNames.stream().sorted().collect(Collectors.joining(", "));
    }

    public SFTPTransfer(PropertyContext propertyContext, ComponentLog logger) {
        this.ctx = propertyContext;
        this.logger = logger;
        PropertyValue disableListing = propertyContext.getProperty(DISABLE_DIRECTORY_LISTING);
        this.disableDirectoryListing = disableListing == null ? false : Boolean.TRUE.equals(disableListing.asBoolean());
    }

    public static void validateProxySpec(ValidationContext context, Collection<ValidationResult> results) {
        ProxyConfiguration.validateProxySpec((ValidationContext)context, results, (ProxySpec[])PROXY_SPECS);
    }

    @Override
    public String getProtocolName() {
        return "sftp";
    }

    @Override
    public List<FileInfo> getListing(boolean applyFilters) throws IOException {
        Integer configuredValue;
        String path = this.ctx.getProperty(FileTransfer.REMOTE_PATH).evaluateAttributeExpressions().getValue();
        boolean depth = false;
        PropertyValue batchSizeValue = this.ctx.getProperty(FileTransfer.REMOTE_POLL_BATCH_SIZE);
        int maxResults = batchSizeValue == null ? Integer.MAX_VALUE : ((configuredValue = batchSizeValue.asInteger()) == null ? Integer.MAX_VALUE : configuredValue);
        ArrayList<FileInfo> listing = new ArrayList<FileInfo>(1000);
        this.getListing(path, 0, maxResults, listing, applyFilters);
        return listing;
    }

    protected void getListing(String path, int depth, int maxResults, List<FileInfo> listing, boolean applyFilters) throws IOException {
        if (maxResults < 1 || listing.size() >= maxResults) {
            return;
        }
        if (depth >= 100) {
            this.logger.warn(this + " had to stop recursively searching directories at a recursive depth of " + depth + " to avoid memory issues");
            return;
        }
        boolean ignoreDottedFiles = this.ctx.getProperty(FileTransfer.IGNORE_DOTTED_FILES).asBoolean();
        boolean recurse = this.ctx.getProperty(FileTransfer.RECURSIVE_SEARCH).asBoolean();
        boolean symlink = this.ctx.getProperty(FileTransfer.FOLLOW_SYMLINK).asBoolean();
        String fileFilterRegex = this.ctx.getProperty(FileTransfer.FILE_FILTER_REGEX).getValue();
        Pattern pattern = fileFilterRegex == null ? null : Pattern.compile(fileFilterRegex);
        String pathFilterRegex = this.ctx.getProperty(FileTransfer.PATH_FILTER_REGEX).getValue();
        Pattern pathPattern = !recurse || pathFilterRegex == null ? null : Pattern.compile(pathFilterRegex);
        String remotePath = this.ctx.getProperty(FileTransfer.REMOTE_PATH).evaluateAttributeExpressions().getValue();
        boolean pathFilterMatches = true;
        if (pathPattern != null) {
            Path reldir;
            Path path2 = reldir = path == null ? Paths.get(".", new String[0]) : Paths.get(path, new String[0]);
            if (remotePath != null) {
                reldir = Paths.get(remotePath, new String[0]).relativize(reldir);
            }
            if (reldir != null && !reldir.toString().isEmpty() && !pathPattern.matcher(reldir.toString().replace("\\", "/")).matches()) {
                pathFilterMatches = false;
            }
        }
        SFTPClient sftpClient = this.getSFTPClient(null);
        boolean isPathMatch = pathFilterMatches;
        ArrayList subDirs = new ArrayList();
        try {
            RemoteResourceFilter filter = entry -> {
                String entryFilename = entry.getName();
                if (entryFilename.equals(".") || entryFilename.equals("..")) {
                    return false;
                }
                if (ignoreDottedFiles && entryFilename.startsWith(".")) {
                    return false;
                }
                if (recurse && entry.isDirectory() || symlink && entry.getAttributes().getType() == FileMode.Type.SYMLINK) {
                    subDirs.add(entry);
                    return false;
                }
                if (listing.size() >= maxResults) {
                    return false;
                }
                if (!(entry.isDirectory() || entry.getAttributes().getType() == FileMode.Type.SYMLINK || applyFilters && !isPathMatch || pattern != null && applyFilters && !pattern.matcher(entryFilename).matches())) {
                    listing.add(this.newFileInfo(entry, path));
                }
                return false;
            };
            if (path == null || path.trim().isEmpty()) {
                sftpClient.ls(".", filter);
            } else {
                sftpClient.ls(path, filter);
            }
        }
        catch (SFTPException e) {
            String pathDesc = path == null ? "current directory" : path;
            switch (e.getStatusCode()) {
                case NO_SUCH_FILE: {
                    throw new FileNotFoundException("Could not perform listing on " + pathDesc + " because could not find the file on the remote server");
                }
                case PERMISSION_DENIED: {
                    throw new PermissionDeniedException("Could not perform listing on " + pathDesc + " due to insufficient permissions");
                }
            }
            throw new IOException(String.format("Failed to obtain file listing for %s due to unexpected SSH_FXP_STATUS (%d)", pathDesc, e.getStatusCode().getCode()), e);
        }
        for (RemoteResourceInfo entry2 : subDirs) {
            String entryFilename = entry2.getName();
            File newFullPath = new File(path, entryFilename);
            String newFullForwardPath = newFullPath.getPath().replace("\\", "/");
            try {
                this.getListing(newFullForwardPath, depth + 1, maxResults, listing, applyFilters);
            }
            catch (IOException e) {
                this.logger.error("Unable to get listing from " + newFullForwardPath + "; skipping", (Throwable)e);
            }
        }
    }

    private FileInfo newFileInfo(RemoteResourceInfo entry, String path) {
        if (entry == null) {
            return null;
        }
        File newFullPath = new File(path, entry.getName());
        String newFullForwardPath = newFullPath.getPath().replace("\\", "/");
        StringBuilder permsBuilder = new StringBuilder();
        Set permissions = entry.getAttributes().getPermissions();
        this.appendPermission(permsBuilder, permissions, FilePermission.USR_R, "r");
        this.appendPermission(permsBuilder, permissions, FilePermission.USR_W, "w");
        this.appendPermission(permsBuilder, permissions, FilePermission.USR_X, "x");
        this.appendPermission(permsBuilder, permissions, FilePermission.GRP_R, "r");
        this.appendPermission(permsBuilder, permissions, FilePermission.GRP_W, "w");
        this.appendPermission(permsBuilder, permissions, FilePermission.GRP_X, "x");
        this.appendPermission(permsBuilder, permissions, FilePermission.OTH_R, "r");
        this.appendPermission(permsBuilder, permissions, FilePermission.OTH_W, "w");
        this.appendPermission(permsBuilder, permissions, FilePermission.OTH_X, "x");
        FileInfo.Builder builder = new FileInfo.Builder().filename(entry.getName()).fullPathFileName(newFullForwardPath).directory(entry.isDirectory()).size(entry.getAttributes().getSize()).lastModifiedTime(entry.getAttributes().getMtime() * 1000L).permissions(permsBuilder.toString()).owner(Integer.toString(entry.getAttributes().getUID())).group(Integer.toString(entry.getAttributes().getGID()));
        return builder.build();
    }

    private void appendPermission(StringBuilder builder, Set<FilePermission> permissions, FilePermission filePermission, String permString) {
        if (permissions.contains(filePermission)) {
            builder.append(permString);
        } else {
            builder.append("-");
        }
    }

    @Override
    public FlowFile getRemoteFile(String remoteFileName, FlowFile origFlowFile, ProcessSession session) throws ProcessException, IOException {
        SFTPClient sftpClient = this.getSFTPClient(origFlowFile);
        RemoteFile rf = null;
        RemoteFile.ReadAheadRemoteFileInputStream rfis = null;
        try {
            FlowFile resultFlowFile;
            RemoteFile remoteFile = rf = sftpClient.open(remoteFileName);
            remoteFile.getClass();
            RemoteFile.ReadAheadRemoteFileInputStream in = rfis = new RemoteFile.ReadAheadRemoteFileInputStream(remoteFile, 16);
            FlowFile flowFile = resultFlowFile = session.write(origFlowFile, new OutputStreamCallback((InputStream)in){
                final /* synthetic */ InputStream val$in;
                {
                    this.val$in = inputStream;
                }

                public void process(OutputStream out) throws IOException {
                    StreamUtils.copy((InputStream)this.val$in, (OutputStream)out);
                }
            });
            return flowFile;
        }
        catch (SFTPException e) {
            switch (e.getStatusCode()) {
                case NO_SUCH_FILE: {
                    throw new FileNotFoundException("Could not find file " + remoteFileName + " on remote SFTP Server");
                }
                case PERMISSION_DENIED: {
                    throw new PermissionDeniedException("Insufficient permissions to read file " + remoteFileName + " from remote SFTP Server", e);
                }
            }
            throw new IOException("Failed to obtain file content for " + remoteFileName, e);
        }
        finally {
            if (rf != null) {
                try {
                    rf.close();
                }
                catch (IOException iOException) {}
            }
            if (rfis != null) {
                try {
                    rfis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void deleteFile(FlowFile flowFile, String path, String remoteFileName) throws IOException {
        SFTPClient sftpClient = this.getSFTPClient(flowFile);
        String fullPath = path == null ? remoteFileName : (path.endsWith("/") ? path + remoteFileName : path + "/" + remoteFileName);
        try {
            sftpClient.rm(fullPath);
        }
        catch (SFTPException e) {
            switch (e.getStatusCode()) {
                case NO_SUCH_FILE: {
                    throw new FileNotFoundException("Could not find file " + remoteFileName + " to remove from remote SFTP Server");
                }
                case PERMISSION_DENIED: {
                    throw new PermissionDeniedException("Insufficient permissions to delete file " + remoteFileName + " from remote SFTP Server", e);
                }
            }
            throw new IOException("Failed to delete remote file " + fullPath, e);
        }
    }

    @Override
    public void deleteDirectory(FlowFile flowFile, String remoteDirectoryName) throws IOException {
        SFTPClient sftpClient = this.getSFTPClient(flowFile);
        try {
            sftpClient.rmdir(remoteDirectoryName);
        }
        catch (SFTPException e) {
            throw new IOException("Failed to delete remote directory " + remoteDirectoryName, e);
        }
    }

    @Override
    public void ensureDirectoryExists(FlowFile flowFile, File directoryName) throws IOException {
        String remoteDirectory;
        SFTPClient sftpClient;
        block10: {
            sftpClient = this.getSFTPClient(flowFile);
            remoteDirectory = directoryName.getAbsolutePath().replace("\\", "/").replaceAll("^.\\:", "");
            if (this.disableDirectoryListing) {
                try {
                    sftpClient.mkdir(remoteDirectory);
                    return;
                }
                catch (SFTPException e) {
                    if (e.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) {
                        this.logger.debug(String.format("Could not create %s due to 'No such file'. Will try to create the parent dir.", remoteDirectory));
                        break block10;
                    }
                    if (e.getStatusCode() == Response.StatusCode.FAILURE) {
                        this.logger.debug("Could not blindly create remote directory due to " + this.getMessage(e), (Throwable)e);
                        return;
                    }
                    throw new IOException("Could not blindly create remote directory due to " + e.getMessage(), e);
                }
            }
            try {
                sftpClient.stat(remoteDirectory);
                return;
            }
            catch (SFTPException e) {
                if (e.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) break block10;
                throw new IOException("Failed to determine if remote directory exists at " + remoteDirectory + " due to " + this.getMessage(e), e);
            }
        }
        if (directoryName.getParent() != null && !directoryName.getParentFile().equals(new File(File.separator))) {
            this.ensureDirectoryExists(flowFile, directoryName.getParentFile());
        }
        this.logger.debug("Remote Directory {} does not exist; creating it", new Object[]{remoteDirectory});
        try {
            sftpClient.mkdir(remoteDirectory);
            this.logger.debug("Created {}", new Object[]{remoteDirectory});
        }
        catch (SFTPException e) {
            throw new IOException("Failed to create remote directory " + remoteDirectory + " due to " + this.getMessage(e), e);
        }
    }

    private String getMessage(SFTPException e) {
        if (e.getStatusCode() != null) {
            return e.getStatusCode().getCode() + ": " + e.getMessage();
        }
        return e.getMessage();
    }

    protected KeepAliveProvider getKeepAliveProvider() {
        boolean useKeepAliveOnTimeout = this.ctx.getProperty(USE_KEEPALIVE_ON_TIMEOUT).asBoolean();
        return useKeepAliveOnTimeout ? DEFAULT_KEEP_ALIVE_PROVIDER : NO_OP_KEEP_ALIVE;
    }

    protected SFTPClient getSFTPClient(FlowFile flowFile) throws IOException {
        String hostKeyVal;
        boolean strictHostKeyChecking;
        Proxy proxy;
        if (this.sftpClient != null) {
            String propertiesHost;
            String clientHost = this.sshClient.getRemoteHostname();
            if (clientHost.equals(propertiesHost = this.ctx.getProperty(HOSTNAME).evaluateAttributeExpressions(flowFile).getValue())) {
                return this.sftpClient;
            }
            this.close();
        }
        DefaultConfig sshClientConfig = new DefaultConfig();
        sshClientConfig.setKeepAliveProvider(this.getKeepAliveProvider());
        this.updateConfigAlgorithms((Config)sshClientConfig);
        SSHClient sshClient = new SSHClient((Config)sshClientConfig);
        ProxyConfiguration proxyConfig = ProxyConfiguration.getConfiguration((PropertyContext)this.ctx, FTPTransfer.createComponentProxyConfigSupplier(this.ctx));
        switch (proxyConfig.getProxyType()) {
            case HTTP: 
            case SOCKS: {
                proxy = proxyConfig.createProxy();
                break;
            }
            default: {
                proxy = null;
            }
        }
        if (proxy != null) {
            sshClient.setSocketFactory(new SocketFactory(){

                @Override
                public Socket createSocket() {
                    return new Socket(proxy);
                }

                @Override
                public Socket createSocket(String s, int i) {
                    return new Socket(proxy);
                }

                @Override
                public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) {
                    return new Socket(proxy);
                }

                @Override
                public Socket createSocket(InetAddress inetAddress, int i) {
                    return new Socket(proxy);
                }

                @Override
                public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) {
                    return new Socket(proxy);
                }
            });
        }
        if (!(strictHostKeyChecking = this.ctx.getProperty(STRICT_HOST_KEY_CHECKING).asBoolean().booleanValue())) {
            sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        }
        if ((hostKeyVal = this.ctx.getProperty(HOST_KEY_FILE).getValue()) != null) {
            sshClient.loadKnownHosts(new File(hostKeyVal));
        } else if (strictHostKeyChecking) {
            sshClient.loadKnownHosts();
        }
        PropertyValue compressionValue = this.ctx.getProperty(FileTransfer.USE_COMPRESSION);
        if (compressionValue != null && "true".equalsIgnoreCase(compressionValue.getValue())) {
            sshClient.useCompression();
        }
        int connectionTimeoutMillis = this.ctx.getProperty(FileTransfer.CONNECTION_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        sshClient.setTimeout(connectionTimeoutMillis);
        String hostname = this.ctx.getProperty(HOSTNAME).evaluateAttributeExpressions(flowFile).getValue();
        int port = this.ctx.getProperty(PORT).evaluateAttributeExpressions(flowFile).asInteger();
        sshClient.connect(hostname, port);
        List<AuthMethod> authMethods = this.getAuthMethods(sshClient, flowFile);
        String username = this.ctx.getProperty(USERNAME).evaluateAttributeExpressions(flowFile).getValue();
        sshClient.auth(username, authMethods);
        this.sshClient = sshClient;
        this.sftpClient = sshClient.newSFTPClient();
        this.closed = false;
        int dataTimeout = this.ctx.getProperty(FileTransfer.DATA_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        this.sftpClient.getSFTPEngine().setTimeoutMs(dataTimeout);
        try {
            this.homeDir = this.sftpClient.canonicalize("");
        }
        catch (IOException e) {
            this.homeDir = "";
            this.logger.debug("Failed to retrieve {} home directory due to {}", new Object[]{username, e.getMessage()});
        }
        return this.sftpClient;
    }

    void updateConfigAlgorithms(Config config) {
        if (this.ctx.getProperty(CIPHERS_ALLOWED).isSet()) {
            Set allowedCiphers = Arrays.stream(this.ctx.getProperty(CIPHERS_ALLOWED).evaluateAttributeExpressions().getValue().split(",")).map(String::trim).collect(Collectors.toSet());
            config.setCipherFactories(config.getCipherFactories().stream().filter(cipherNamed -> allowedCiphers.contains(cipherNamed.getName())).collect(Collectors.toList()));
        }
        if (this.ctx.getProperty(KEY_ALGORITHMS_ALLOWED).isSet()) {
            Set allowedKeyAlgorithms = Arrays.stream(this.ctx.getProperty(KEY_ALGORITHMS_ALLOWED).evaluateAttributeExpressions().getValue().split(",")).map(String::trim).collect(Collectors.toSet());
            config.setKeyAlgorithms(config.getKeyAlgorithms().stream().filter(keyAlgorithmNamed -> allowedKeyAlgorithms.contains(keyAlgorithmNamed.getName())).collect(Collectors.toList()));
        }
        if (this.ctx.getProperty(KEY_EXCHANGE_ALGORITHMS_ALLOWED).isSet()) {
            Set allowedKeyExchangeAlgorithms = Arrays.stream(this.ctx.getProperty(KEY_EXCHANGE_ALGORITHMS_ALLOWED).evaluateAttributeExpressions().getValue().split(",")).map(String::trim).collect(Collectors.toSet());
            config.setKeyExchangeFactories(config.getKeyExchangeFactories().stream().filter(keyExchangeNamed -> allowedKeyExchangeAlgorithms.contains(keyExchangeNamed.getName())).collect(Collectors.toList()));
        }
        if (this.ctx.getProperty(MESSAGE_AUTHENTICATION_CODES_ALLOWED).isSet()) {
            Set allowedMessageAuthenticationCodes = Arrays.stream(this.ctx.getProperty(MESSAGE_AUTHENTICATION_CODES_ALLOWED).evaluateAttributeExpressions().getValue().split(",")).map(String::trim).collect(Collectors.toSet());
            config.setMACFactories(config.getMACFactories().stream().filter(macNamed -> allowedMessageAuthenticationCodes.contains(macNamed.getName())).collect(Collectors.toList()));
        }
    }

    @Override
    public String getHomeDirectory(FlowFile flowFile) throws IOException {
        this.getSFTPClient(flowFile);
        return this.homeDir;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (null != this.sftpClient) {
                this.sftpClient.close();
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to close SFTPClient due to {}", new Object[]{ex.toString()}, (Throwable)ex);
        }
        this.sftpClient = null;
        try {
            if (null != this.sshClient) {
                this.sshClient.disconnect();
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to close SSHClient due to {}", new Object[]{ex.toString()}, (Throwable)ex);
        }
        this.sshClient = null;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public FileInfo getRemoteFileInfo(FlowFile flowFile, String path, String filename) throws IOException {
        List remoteResources;
        SFTPClient sftpClient = this.getSFTPClient(flowFile);
        try {
            remoteResources = sftpClient.ls(path);
        }
        catch (SFTPException e) {
            if (e.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) {
                return null;
            }
            throw new IOException("Failed to obtain file listing for " + path, e);
        }
        RemoteResourceInfo matchingEntry = null;
        for (RemoteResourceInfo entry : remoteResources) {
            if (!entry.getName().equalsIgnoreCase(filename)) continue;
            matchingEntry = entry;
            break;
        }
        if (matchingEntry != null && matchingEntry.isDirectory()) {
            return null;
        }
        return this.newFileInfo(matchingEntry, path);
    }

    @Override
    public String put(FlowFile flowFile, String path, String filename, InputStream content) throws IOException {
        String group;
        String owner;
        int perms;
        SFTPClient sftpClient = this.getSFTPClient(flowFile);
        String fullPath = path == null ? filename : (path.endsWith("/") ? path + filename : path + "/" + filename);
        String tempFilename = this.ctx.getProperty(TEMP_FILENAME).evaluateAttributeExpressions(flowFile).getValue();
        if (tempFilename == null) {
            boolean dotRename = this.ctx.getProperty(DOT_RENAME).asBoolean();
            String string = tempFilename = dotRename ? "." + filename : filename;
        }
        String tempPath = path == null ? tempFilename : (path.endsWith("/") ? path + tempFilename : path + "/" + tempFilename);
        String permissions = this.ctx.getProperty(PERMISSIONS).evaluateAttributeExpressions(flowFile).getValue();
        if (permissions == null || permissions.trim().isEmpty()) {
            sftpClient.getFileTransfer().setPreserveAttributes(false);
            perms = 0;
        } else {
            sftpClient.getFileTransfer().setPreserveAttributes(true);
            perms = this.numberPermissions(permissions);
        }
        try {
            SFTPFlowFileSourceFile sourceFile = new SFTPFlowFileSourceFile(filename, content, perms);
            sftpClient.put((LocalSourceFile)sourceFile, tempPath);
        }
        catch (SFTPException e) {
            throw new IOException("Unable to put content to " + fullPath + " due to " + this.getMessage(e), e);
        }
        String lastModifiedTime = this.ctx.getProperty(LAST_MODIFIED_TIME).evaluateAttributeExpressions(flowFile).getValue();
        if (lastModifiedTime != null && !lastModifiedTime.trim().isEmpty()) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
                Date fileModifyTime = formatter.parse(lastModifiedTime);
                int time = (int)(fileModifyTime.getTime() / 1000L);
                FileAttributes tempAttributes = sftpClient.stat(tempPath);
                FileAttributes modifiedAttributes = new FileAttributes.Builder().withAtimeMtime(tempAttributes.getAtime(), (long)time).build();
                sftpClient.setattr(tempPath, modifiedAttributes);
            }
            catch (Exception e) {
                this.logger.error("Failed to set lastModifiedTime on {} to {} due to {}", new Object[]{tempPath, lastModifiedTime, e});
            }
        }
        if ((owner = this.ctx.getProperty(REMOTE_OWNER).evaluateAttributeExpressions(flowFile).getValue()) != null && !owner.trim().isEmpty()) {
            try {
                sftpClient.chown(tempPath, Integer.parseInt(owner));
            }
            catch (Exception e) {
                this.logger.error("Failed to set owner on {} to {} due to {}", new Object[]{tempPath, owner, e});
            }
        }
        if ((group = this.ctx.getProperty(REMOTE_GROUP).evaluateAttributeExpressions(flowFile).getValue()) != null && !group.trim().isEmpty()) {
            try {
                sftpClient.chgrp(tempPath, Integer.parseInt(group));
            }
            catch (Exception e) {
                this.logger.error("Failed to set group on {} to {} due to {}", new Object[]{tempPath, group, e});
            }
        }
        if (!filename.equals(tempFilename)) {
            try {
                sftpClient.rename(tempPath, fullPath);
            }
            catch (SFTPException e) {
                try {
                    sftpClient.rm(tempPath);
                    throw new IOException("Failed to rename dot-file to " + fullPath + " due to " + this.getMessage(e), e);
                }
                catch (SFTPException e1) {
                    throw new IOException("Failed to rename dot-file to " + fullPath + " and failed to delete it when attempting to clean up", e1);
                }
            }
        }
        return fullPath;
    }

    @Override
    public void rename(FlowFile flowFile, String source, String target) throws IOException {
        SFTPClient sftpClient = this.getSFTPClient(flowFile);
        try {
            sftpClient.rename(source, target);
        }
        catch (SFTPException e) {
            switch (e.getStatusCode()) {
                case NO_SUCH_FILE: {
                    throw new FileNotFoundException("No such file or directory");
                }
                case PERMISSION_DENIED: {
                    throw new PermissionDeniedException("Could not rename remote file " + source + " to " + target + " due to insufficient permissions");
                }
            }
            throw new IOException(e);
        }
    }

    protected int numberPermissions(String perms) {
        int number = -1;
        Pattern rwxPattern = Pattern.compile("^[rwx-]{9}$");
        Pattern numPattern = Pattern.compile("\\d+");
        if (rwxPattern.matcher(perms).matches()) {
            number = 0;
            if (perms.charAt(0) == 'r') {
                number |= 0x100;
            }
            if (perms.charAt(1) == 'w') {
                number |= 0x80;
            }
            if (perms.charAt(2) == 'x') {
                number |= 0x40;
            }
            if (perms.charAt(3) == 'r') {
                number |= 0x20;
            }
            if (perms.charAt(4) == 'w') {
                number |= 0x10;
            }
            if (perms.charAt(5) == 'x') {
                number |= 8;
            }
            if (perms.charAt(6) == 'r') {
                number |= 4;
            }
            if (perms.charAt(7) == 'w') {
                number |= 2;
            }
            if (perms.charAt(8) == 'x') {
                number |= 1;
            }
        } else if (numPattern.matcher(perms).matches()) {
            try {
                number = Integer.parseInt(perms, 8);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return number;
    }

    protected List<AuthMethod> getAuthMethods(SSHClient client, FlowFile flowFile) {
        String password;
        ArrayList<AuthMethod> authMethods = new ArrayList<AuthMethod>();
        String privateKeyPath = this.ctx.getProperty(PRIVATE_KEY_PATH).evaluateAttributeExpressions(flowFile).getValue();
        if (privateKeyPath != null) {
            String privateKeyPassphrase = this.ctx.getProperty(PRIVATE_KEY_PASSPHRASE).evaluateAttributeExpressions(flowFile).getValue();
            KeyProvider keyProvider = this.getKeyProvider(client, privateKeyPath, privateKeyPassphrase);
            AuthPublickey authPublicKey = new AuthPublickey(keyProvider);
            authMethods.add((AuthMethod)authPublicKey);
        }
        if ((password = this.ctx.getProperty(FileTransfer.PASSWORD).evaluateAttributeExpressions(flowFile).getValue()) != null) {
            AuthPassword authPassword = new AuthPassword(this.getPasswordFinder(password));
            authMethods.add((AuthMethod)authPassword);
            PasswordResponseProvider passwordProvider = new PasswordResponseProvider(this.getPasswordFinder(password));
            AuthKeyboardInteractive authKeyboardInteractive = new AuthKeyboardInteractive((ChallengeResponseProvider)passwordProvider);
            authMethods.add((AuthMethod)authKeyboardInteractive);
        }
        if (this.logger.isDebugEnabled()) {
            List methods = authMethods.stream().map(AuthMethod::getName).collect(Collectors.toList());
            this.logger.debug("Authentication Methods Configured {}", new Object[]{methods});
        }
        return authMethods;
    }

    private KeyProvider getKeyProvider(SSHClient client, String privateKeyLocation, String privateKeyPassphrase) {
        KeyFormat keyFormat = this.getKeyFormat(privateKeyLocation);
        this.logger.debug("Loading Private Key File [{}] Format [{}]", new Object[]{privateKeyLocation, keyFormat});
        try {
            return privateKeyPassphrase == null ? client.loadKeys(privateKeyLocation) : client.loadKeys(privateKeyLocation, privateKeyPassphrase);
        }
        catch (IOException e) {
            throw new ProcessException(String.format("Loading Private Key File [%s] Format [%s] Failed", privateKeyLocation, keyFormat), (Throwable)e);
        }
    }

    private KeyFormat getKeyFormat(String privateKeyLocation) {
        try {
            File privateKeyFile = new File(privateKeyLocation);
            return KeyProviderUtil.detectKeyFileFormat((File)privateKeyFile);
        }
        catch (IOException e) {
            throw new ProcessException(String.format("Reading Private Key File [%s] Format Failed", privateKeyLocation), (Throwable)e);
        }
    }

    private PasswordFinder getPasswordFinder(String password) {
        return PasswordUtils.createOneOff((char[])password.toCharArray());
    }

    static {
        DefaultConfig defaultConfig = new DefaultConfig();
        DEFAULT_KEY_ALGORITHM_NAMES = Collections.unmodifiableSet(defaultConfig.getKeyAlgorithms().stream().map(Factory.Named::getName).collect(Collectors.toSet()));
        DEFAULT_CIPHER_NAMES = Collections.unmodifiableSet(defaultConfig.getCipherFactories().stream().map(Factory.Named::getName).collect(Collectors.toSet()));
        DEFAULT_MESSAGE_AUTHENTICATION_CODE_NAMES = Collections.unmodifiableSet(defaultConfig.getMACFactories().stream().map(Factory.Named::getName).collect(Collectors.toSet()));
        DEFAULT_KEY_EXCHANGE_ALGORITHM_NAMES = Collections.unmodifiableSet(defaultConfig.getKeyExchangeFactories().stream().map(Factory.Named::getName).collect(Collectors.toSet()));
        PRIVATE_KEY_PATH = new PropertyDescriptor.Builder().name("Private Key Path").description("The fully qualified path to the Private Key file").required(false).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        PRIVATE_KEY_PASSPHRASE = new PropertyDescriptor.Builder().name("Private Key Passphrase").description("Password for the private key").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).sensitive(true).build();
        HOST_KEY_FILE = new PropertyDescriptor.Builder().name("Host Key File").description("If supplied, the given file will be used as the Host Key; otherwise, if 'Strict Host Key Checking' property is applied (set to true) then uses the 'known_hosts' and 'known_hosts2' files from ~/.ssh directory else no host key file will be used").identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).required(false).build();
        STRICT_HOST_KEY_CHECKING = new PropertyDescriptor.Builder().name("Strict Host Key Checking").description("Indicates whether or not strict enforcement of hosts keys should be applied").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
        PORT = new PropertyDescriptor.Builder().name("Port").description("The port that the remote system is listening on for file transfers").addValidator(StandardValidators.PORT_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).defaultValue("22").build();
        USE_KEEPALIVE_ON_TIMEOUT = new PropertyDescriptor.Builder().name("Send Keep Alive On Timeout").description("Send a Keep Alive message every 5 seconds up to 5 times for an overall timeout of 25 seconds.").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
        KEY_ALGORITHMS_ALLOWED = new PropertyDescriptor.Builder().name("Key Algorithms Allowed").displayName("Key Algorithms Allowed").description("A comma-separated list of Key Algorithms allowed for SFTP connections. Leave unset to allow all. Available options are: " + SFTPTransfer.convertFactorySetToString(DEFAULT_KEY_ALGORITHM_NAMES)).required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
        CIPHERS_ALLOWED = new PropertyDescriptor.Builder().name("Ciphers Allowed").displayName("Ciphers Allowed").description("A comma-separated list of Ciphers allowed for SFTP connections. Leave unset to allow all. Available options are: " + SFTPTransfer.convertFactorySetToString(DEFAULT_CIPHER_NAMES)).required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
        MESSAGE_AUTHENTICATION_CODES_ALLOWED = new PropertyDescriptor.Builder().name("Message Authentication Codes Allowed").displayName("Message Authentication Codes Allowed").description("A comma-separated list of Message Authentication Codes allowed for SFTP connections. Leave unset to allow all. Available options are: " + SFTPTransfer.convertFactorySetToString(DEFAULT_MESSAGE_AUTHENTICATION_CODE_NAMES)).required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
        KEY_EXCHANGE_ALGORITHMS_ALLOWED = new PropertyDescriptor.Builder().name("Key Exchange Algorithms Allowed").displayName("Key Exchange Algorithms Allowed").description("A comma-separated list of Key Exchange Algorithms allowed for SFTP connections. Leave unset to allow all. Available options are: " + SFTPTransfer.convertFactorySetToString(DEFAULT_KEY_EXCHANGE_ALGORITHM_NAMES)).required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
        DISABLE_DIRECTORY_LISTING = new PropertyDescriptor.Builder().name("Disable Directory Listing").description("If set to 'true', directory listing is not performed prior to create missing directories. By default, this processor executes a directory listing command to see target directory existence before creating missing directories. However, there are situations that you might need to disable the directory listing such as the following. Directory listing might fail with some permission setups (e.g. chmod 100) on a directory. Also, if any other SFTP client created the directory after this processor performed a listing and before a directory creation request by this processor is finished, then an error is returned because the directory already exists.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
        PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP_AUTH, ProxySpec.SOCKS_AUTH};
        PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)true, (ProxySpec[])PROXY_SPECS);
        NO_OP_KEEP_ALIVE = new KeepAliveProvider(){

            public KeepAlive provide(ConnectionImpl connection) {
                return new KeepAlive(connection, "no-op-keep-alive"){

                    protected void doKeepAlive() {
                    }
                };
            }
        };
        DEFAULT_KEEP_ALIVE_PROVIDER = new KeepAliveProvider(){

            public KeepAlive provide(ConnectionImpl connection) {
                KeepAlive keepAlive = KeepAliveProvider.KEEP_ALIVE.provide(connection);
                keepAlive.setKeepAliveInterval(5);
                return keepAlive;
            }
        };
    }
}

