/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ssh;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.Objects;
import javax.net.SocketFactory;

public class ProxySocketFactory
extends SocketFactory {
    private final Proxy proxy;

    public ProxySocketFactory(Proxy proxy) {
        this.proxy = Objects.requireNonNull(proxy, "Proxy required");
    }

    @Override
    public Socket createSocket() {
        return new Socket(this.proxy);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        return this.createSocket(socketAddress);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        InetSocketAddress bindSocketAddress = new InetSocketAddress(localHost, localPort);
        return this.createSocket(socketAddress, bindSocketAddress);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        return this.createSocket(socketAddress);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        InetSocketAddress bindSocketAddress = new InetSocketAddress(localAddress, localPort);
        return this.createSocket(socketAddress, bindSocketAddress);
    }

    private Socket createSocket(InetSocketAddress socketAddress, InetSocketAddress bindSocketAddress) throws IOException {
        Socket socket = this.createSocket();
        socket.bind(bindSocketAddress);
        socket.connect(socketAddress);
        return socket;
    }

    private Socket createSocket(InetSocketAddress socketAddress) throws IOException {
        Socket socket = this.createSocket();
        socket.connect(socketAddress);
        return socket;
    }
}

