/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ssh;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import net.schmizz.keepalive.KeepAlive;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyFormat;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.keyprovider.KeyProviderUtil;
import net.schmizz.sshj.userauth.method.AuthKeyboardInteractive;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPassword;
import net.schmizz.sshj.userauth.method.AuthPublickey;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.method.PasswordResponseProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.standard.ssh.ClientAuthenticationException;
import org.apache.nifi.processors.standard.ssh.ClientConfigurationException;
import org.apache.nifi.processors.standard.ssh.ClientConnectException;
import org.apache.nifi.processors.standard.ssh.ProxySocketFactory;
import org.apache.nifi.processors.standard.ssh.SSHClientProvider;
import org.apache.nifi.processors.standard.ssh.SSHConfigProvider;
import org.apache.nifi.processors.standard.ssh.StandardSSHConfigProvider;
import org.apache.nifi.processors.standard.util.FTPTransfer;
import org.apache.nifi.processors.standard.util.SFTPTransfer;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.util.StringUtils;

public class StandardSSHClientProvider
implements SSHClientProvider {
    private static final SSHConfigProvider SSH_CONFIG_PROVIDER = new StandardSSHConfigProvider();
    private static final List<Proxy.Type> SUPPORTED_PROXY_TYPES = Arrays.asList(Proxy.Type.HTTP, Proxy.Type.SOCKS);
    private static final String ADDRESS_FORMAT = "%s:%d";

    @Override
    public SSHClient getClient(PropertyContext context, Map<String, String> attributes) {
        Objects.requireNonNull(context, "Property Context required");
        Objects.requireNonNull(attributes, "Attributes required");
        String hostname = context.getProperty(SFTPTransfer.HOSTNAME).evaluateAttributeExpressions(attributes).getValue();
        int port = context.getProperty(SFTPTransfer.PORT).evaluateAttributeExpressions(attributes).asInteger();
        String address = String.format(ADDRESS_FORMAT, hostname, port);
        String username = context.getProperty(SFTPTransfer.USERNAME).evaluateAttributeExpressions(attributes).getValue();
        List<AuthMethod> authMethods = this.getPasswordAuthMethods(context, attributes);
        Config config = SSH_CONFIG_PROVIDER.getConfig(address, context);
        SSHClient client = new SSHClient(config);
        try {
            this.setClientProperties(client, context);
        }
        catch (Exception e) {
            this.closeClient(client);
            throw new ClientConfigurationException(String.format("SSH Client configuration failed [%s]", address), e);
        }
        try {
            client.connect(hostname, port);
        }
        catch (Exception e) {
            this.closeClient(client);
            throw new ClientConnectException(String.format("SSH Client connection failed [%s]", address), e);
        }
        try {
            List<AuthMethod> publicKeyAuthMethods = this.getPublicKeyAuthMethods(client, context, attributes);
            authMethods.addAll(publicKeyAuthMethods);
            client.auth(username, authMethods);
        }
        catch (Exception e) {
            this.closeClient(client);
            throw new ClientAuthenticationException(String.format("SSH Client authentication failed [%s]", address), e);
        }
        return client;
    }

    private void closeClient(SSHClient client) {
        try {
            client.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("SSH Client close failed", e);
        }
        finally {
            Connection connection = client.getConnection();
            KeepAlive keepAlive = connection.getKeepAlive();
            keepAlive.interrupt();
        }
    }

    private void setClientProperties(SSHClient client, PropertyContext context) {
        ProxyConfiguration proxyConfiguration;
        Proxy.Type proxyType;
        int connectionTimeout = context.getProperty(SFTPTransfer.CONNECTION_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        client.setConnectTimeout(connectionTimeout);
        int dataTimeout = context.getProperty(SFTPTransfer.DATA_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        client.setTimeout(dataTimeout);
        boolean strictHostKeyChecking = context.getProperty(SFTPTransfer.STRICT_HOST_KEY_CHECKING).asBoolean();
        String hostKeyFilePath = context.getProperty(SFTPTransfer.HOST_KEY_FILE).getValue();
        if (StringUtils.isNotBlank((String)hostKeyFilePath)) {
            File knownHosts = new File(hostKeyFilePath);
            try {
                client.loadKnownHosts(knownHosts);
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Loading Known Hosts [%s] Failed", hostKeyFilePath), e);
            }
        } else if (strictHostKeyChecking) {
            try {
                client.loadKnownHosts();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Loading Known Hosts Failed", e);
            }
        } else {
            client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        }
        boolean compressionEnabled = context.getProperty(SFTPTransfer.USE_COMPRESSION).asBoolean();
        if (compressionEnabled) {
            try {
                client.useCompression();
            }
            catch (TransportException e) {
                throw new UncheckedIOException("Enabling Compression Failed", (IOException)((Object)e));
            }
        }
        if (SUPPORTED_PROXY_TYPES.contains((Object)(proxyType = (proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)context, FTPTransfer.createComponentProxyConfigSupplier(context))).getProxyType()))) {
            Proxy proxy = proxyConfiguration.createProxy();
            ProxySocketFactory socketFactory = new ProxySocketFactory(proxy);
            client.setSocketFactory((SocketFactory)socketFactory);
        }
    }

    private List<AuthMethod> getPasswordAuthMethods(PropertyContext context, Map<String, String> attributes) {
        ArrayList<AuthMethod> passwordAuthMethods = new ArrayList<AuthMethod>();
        String password = context.getProperty(SFTPTransfer.PASSWORD).evaluateAttributeExpressions(attributes).getValue();
        if (password != null) {
            AuthPassword authPassword = new AuthPassword(this.getPasswordFinder(password));
            passwordAuthMethods.add((AuthMethod)authPassword);
            PasswordResponseProvider passwordProvider = new PasswordResponseProvider(this.getPasswordFinder(password));
            AuthKeyboardInteractive authKeyboardInteractive = new AuthKeyboardInteractive((ChallengeResponseProvider)passwordProvider);
            passwordAuthMethods.add((AuthMethod)authKeyboardInteractive);
        }
        return passwordAuthMethods;
    }

    private List<AuthMethod> getPublicKeyAuthMethods(SSHClient client, PropertyContext context, Map<String, String> attributes) {
        ArrayList<AuthMethod> publicKeyAuthMethods = new ArrayList<AuthMethod>();
        String privateKeyPath = context.getProperty(SFTPTransfer.PRIVATE_KEY_PATH).evaluateAttributeExpressions(attributes).getValue();
        if (privateKeyPath != null) {
            String privateKeyPassphrase = context.getProperty(SFTPTransfer.PRIVATE_KEY_PASSPHRASE).evaluateAttributeExpressions(attributes).getValue();
            KeyProvider keyProvider = this.getKeyProvider(client, privateKeyPath, privateKeyPassphrase);
            AuthPublickey authPublicKey = new AuthPublickey(keyProvider);
            publicKeyAuthMethods.add((AuthMethod)authPublicKey);
        }
        return publicKeyAuthMethods;
    }

    private KeyProvider getKeyProvider(SSHClient client, String privateKeyLocation, String privateKeyPassphrase) {
        KeyFormat keyFormat = this.getKeyFormat(privateKeyLocation);
        try {
            return privateKeyPassphrase == null ? client.loadKeys(privateKeyLocation) : client.loadKeys(privateKeyLocation, privateKeyPassphrase);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Loading Private Key File [%s] Format [%s] Failed", privateKeyLocation, keyFormat), e);
        }
    }

    private KeyFormat getKeyFormat(String privateKeyLocation) {
        try {
            File privateKeyFile = new File(privateKeyLocation);
            return KeyProviderUtil.detectKeyFileFormat((File)privateKeyFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Reading Private Key File [%s] Format Failed", privateKeyLocation), e);
        }
    }

    private PasswordFinder getPasswordFinder(String password) {
        return PasswordUtils.createOneOff((char[])password.toCharArray());
    }
}

