/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ssh;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.sftp.PacketType;
import net.schmizz.sshj.sftp.RenameFlags;
import net.schmizz.sshj.sftp.Request;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;

public class PatchedSFTPEngine
extends SFTPEngine {
    public PatchedSFTPEngine(SessionFactory sessionFactory) throws SSHException {
        super(sessionFactory);
    }

    public void rename(String oldPath, String newPath, Set<RenameFlags> flags) throws IOException {
        if (this.operativeVersion < 1) {
            throw new SFTPException("RENAME is not supported in SFTPv" + this.operativeVersion);
        }
        Charset remoteCharset = this.sub.getRemoteCharset();
        Request request = (Request)((Request)this.newRequest(PacketType.RENAME).putString(oldPath, remoteCharset)).putString(newPath, remoteCharset);
        if (this.operativeVersion >= 5) {
            long renameFlagMask = 0L;
            for (RenameFlags flag : flags) {
                renameFlagMask |= flag.longValue();
            }
            request.putUInt32(renameFlagMask);
        }
        ((Response)this.request(request).retrieve((long)this.getTimeoutMs(), TimeUnit.MILLISECONDS)).ensureStatusPacketIsOK();
    }
}

