/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.nifi.processors.standard.EncryptContent;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.KeyDerivationFunction;
import org.apache.nifi.security.util.crypto.CipherUtility;
import org.apache.nifi.stream.io.ByteCountingInputStream;
import org.apache.nifi.stream.io.ByteCountingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEncryptor
implements EncryptContent.Encryptor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEncryptor.class);
    private static final String MODIFIABLE_CHECK_KEY = "__NiFi_EncryptContent_Check__";
    protected transient Map<String, String> flowfileAttributes = new HashMap<String, String>();

    @Override
    public void updateAttributes(Map<String, String> attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Cannot update null flowfile attributes");
        }
        try {
            attributes.put(MODIFIABLE_CHECK_KEY, "");
            attributes.remove(MODIFIABLE_CHECK_KEY);
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException("The provided attributes map must be modifiable");
        }
        attributes.putAll(this.flowfileAttributes);
        if (logger.isDebugEnabled()) {
            logger.debug("Added {} encryption metadata attributes to flowfile", (Object)this.flowfileAttributes.size());
        }
    }

    static Map<String, String> writeAttributes(EncryptionMethod encryptionMethod, KeyDerivationFunction kdf, byte[] iv, ByteCountingInputStream bcis, ByteCountingOutputStream bcos, boolean encryptMode) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("encryptcontent.action", encryptMode ? "encrypted" : "decrypted");
        attributes.put("encryptcontent.algorithm", encryptionMethod.name());
        attributes.put("encryptcontent.kdf", kdf.name());
        attributes.put("encryptcontent.timestamp", CipherUtility.getTimestampString());
        attributes.put("encryptcontent.iv", iv != null ? Hex.encodeHexString((byte[])iv) : "N/A");
        attributes.put("encryptcontent.iv_length", iv != null ? String.valueOf(iv.length) : "0");
        if (encryptMode) {
            attributes.put("encryptcontent.plaintext_length", String.valueOf(bcis.getBytesRead()));
            attributes.put("encryptcontent.cipher_text_length", String.valueOf(bcos.getBytesWritten()));
        } else {
            attributes.put("encryptcontent.plaintext_length", String.valueOf(bcos.getBytesWritten()));
            attributes.put("encryptcontent.cipher_text_length", String.valueOf(bcis.getBytesRead()));
        }
        if (logger.isDebugEnabled()) {
            ArrayList sortedKeys = new ArrayList(attributes.keySet());
            Collections.sort(sortedKeys);
            for (String k : sortedKeys) {
                logger.debug("Added encryption metadata attribute: {} -> {}", (Object)k, attributes.get(k));
            }
        }
        return attributes;
    }
}

