/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.nifi.processor.util.list.ListableEntity;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class FileInfo
implements Comparable<FileInfo>,
Serializable,
ListableEntity {
    private static final long serialVersionUID = 1L;
    private static final RecordSchema SCHEMA;
    private static final String FILENAME = "filename";
    private static final String PATH = "path";
    private static final String DIRECTORY = "directory";
    private static final String SIZE = "size";
    private static final String LAST_MODIFIED = "lastModified";
    private static final String PERMISSIONS = "permissions";
    private static final String OWNER = "owner";
    private static final String GROUP = "group";
    private static final char[] PERMISSION_MODIFIER_CHARS;
    private final boolean directory;
    private final long size;
    private final long lastModifiedTime;
    private final String fileName;
    private final String fullPathFileName;
    private final String permissions;
    private final String owner;
    private final String group;

    public String getFileName() {
        return this.fileName;
    }

    public String getFullPathFileName() {
        return this.fullPathFileName;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public Record toRecord() {
        HashMap<String, Object> values = new HashMap<String, Object>(8);
        values.put(FILENAME, this.getFileName());
        values.put(PATH, new File(this.getFullPathFileName()).getParent());
        values.put(DIRECTORY, this.isDirectory());
        values.put(SIZE, this.getSize());
        values.put(LAST_MODIFIED, this.getLastModifiedTime());
        values.put(PERMISSIONS, this.getPermissions());
        values.put(OWNER, this.getOwner());
        values.put(GROUP, this.getGroup());
        return new MapRecord(SCHEMA, values);
    }

    public static RecordSchema getRecordSchema() {
        return SCHEMA;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fullPathFileName == null ? 0 : this.fullPathFileName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileInfo other = (FileInfo)obj;
        return !(this.fullPathFileName == null ? other.fullPathFileName != null : !this.fullPathFileName.equals(other.fullPathFileName));
    }

    @Override
    public int compareTo(FileInfo o) {
        return this.fullPathFileName.compareTo(o.fullPathFileName);
    }

    protected FileInfo(Builder builder) {
        this.directory = builder.directory;
        this.size = builder.size;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.fileName = builder.fileName;
        this.fullPathFileName = builder.fullPathFileName;
        this.permissions = builder.permissions;
        this.owner = builder.owner;
        this.group = builder.group;
    }

    public static String permissionToString(int fileModeOctal) {
        StringBuilder sb = new StringBuilder();
        for (char p : PERMISSION_MODIFIER_CHARS) {
            sb.append((fileModeOctal & 1) == 1 ? p : (char)'-');
            fileModeOctal >>= 1;
        }
        return sb.reverse().toString();
    }

    public String getName() {
        return this.getFileName();
    }

    public String getIdentifier() {
        String fullPathName = this.getFullPathFileName();
        return fullPathName == null ? this.getName() : fullPathName;
    }

    public long getTimestamp() {
        return this.getLastModifiedTime();
    }

    static {
        PERMISSION_MODIFIER_CHARS = "xwrxwrxwr".toCharArray();
        ArrayList<RecordField> recordFields = new ArrayList<RecordField>();
        recordFields.add(new RecordField(FILENAME, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(PATH, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(DIRECTORY, RecordFieldType.BOOLEAN.getDataType(), false));
        recordFields.add(new RecordField(SIZE, RecordFieldType.LONG.getDataType(), false));
        recordFields.add(new RecordField(LAST_MODIFIED, RecordFieldType.TIMESTAMP.getDataType(), false));
        recordFields.add(new RecordField(PERMISSIONS, RecordFieldType.STRING.getDataType()));
        recordFields.add(new RecordField(OWNER, RecordFieldType.STRING.getDataType()));
        recordFields.add(new RecordField(GROUP, RecordFieldType.STRING.getDataType()));
        SCHEMA = new SimpleRecordSchema(recordFields);
    }

    public static final class Builder {
        private boolean directory;
        private long size;
        private long lastModifiedTime;
        private String fileName;
        private String fullPathFileName;
        private String permissions;
        private String owner;
        private String group;

        public FileInfo build() {
            return new FileInfo(this);
        }

        public Builder directory(boolean directory) {
            this.directory = directory;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder lastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public Builder filename(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder fullPathFileName(String pathFileName) {
            this.fullPathFileName = pathFileName;
            return this;
        }

        public Builder permissions(String permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }
    }
}

