/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;

public class ValidatingBase64InputStream
extends FilterInputStream {
    public ValidatingBase64InputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read(byte[] b, int offset, int len) throws IOException {
        int numRead = super.read(b, offset, len);
        if (numRead > 0) {
            byte[] copy = b;
            if (numRead < b.length) {
                copy = Arrays.copyOf(b, numRead);
            }
            if (!Base64.isBase64((byte[])copy)) {
                throw new IOException("Data is not base64 encoded.");
            }
        }
        return numRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int numRead = super.read(b);
        if (numRead > 0) {
            byte[] copy = b;
            if (numRead < b.length) {
                copy = Arrays.copyOf(b, numRead);
            }
            if (!Base64.isBase64((byte[])copy)) {
                throw new IOException("Data is not base64 encoded.");
            }
        }
        return numRead;
    }

    @Override
    public int read() throws IOException {
        int data = super.read();
        if (!Base64.isBase64((byte)((byte)data))) {
            throw new IOException("Data is not base64 encoded.");
        }
        return super.read();
    }
}

