/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.burgstaller.okhttp.AuthenticationCacheInterceptor;
import com.burgstaller.okhttp.CachingAuthenticatorDecorator;
import com.burgstaller.okhttp.digest.Credentials;
import com.burgstaller.okhttp.digest.DigestAuthenticator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Cache;
import okhttp3.ConnectionPool;
import okhttp3.CookieJar;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.JavaNetCookieJar;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.deprecation.log.DeprecationLogger;
import org.apache.nifi.deprecation.log.DeprecationLoggerFactory;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.http.ContentEncodingStrategy;
import org.apache.nifi.processors.standard.http.CookieStrategy;
import org.apache.nifi.processors.standard.http.FlowFileNamingStrategy;
import org.apache.nifi.processors.standard.http.HttpHeader;
import org.apache.nifi.processors.standard.http.HttpMethod;
import org.apache.nifi.processors.standard.util.ProxyAuthenticator;
import org.apache.nifi.processors.standard.util.SoftLimitBoundedByteArrayOutputStream;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.stream.io.StreamUtils;

@SupportsSensitiveDynamicProperties
@SupportsBatching
@Tags(value={"http", "https", "rest", "client"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@CapabilityDescription(value="An HTTP client processor which can interact with a configurable HTTP Endpoint. The destination URL and HTTP Method are configurable. FlowFile attributes are converted to HTTP headers and the FlowFile contents are included as the body of the request (if the HTTP Method is PUT, POST or PATCH).")
@WritesAttributes(value={@WritesAttribute(attribute="invokehttp.status.code", description="The status code that is returned"), @WritesAttribute(attribute="invokehttp.status.message", description="The status message that is returned"), @WritesAttribute(attribute="invokehttp.response.body", description="In the instance where the status code received is not a success (2xx) then the response body will be put to the 'invokehttp.response.body' attribute of the request FlowFile."), @WritesAttribute(attribute="invokehttp.request.url", description="The original request URL"), @WritesAttribute(attribute="invokehttp.request.duration", description="Duration (in milliseconds) of the HTTP call to the external endpoint"), @WritesAttribute(attribute="invokehttp.response.url", description="The URL that was ultimately requested after any redirects were followed"), @WritesAttribute(attribute="invokehttp.tx.id", description="The transaction ID that is returned after reading the response"), @WritesAttribute(attribute="invokehttp.remote.dn", description="The DN of the remote server"), @WritesAttribute(attribute="invokehttp.java.exception.class", description="The Java exception class raised when the processor fails"), @WritesAttribute(attribute="invokehttp.java.exception.message", description="The Java exception message raised when the processor fails"), @WritesAttribute(attribute="user-defined", description="If the 'Put Response Body In Attribute' property is set then whatever it is set to will become the attribute key and the value would be the body of the HTTP response.")})
@DynamicProperties(value={@DynamicProperty(name="Header Name", value="Attribute Expression Language", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Send request header with a key matching the Dynamic Property Key and a value created by evaluating the Attribute Expression Language set in the value of the Dynamic Property."), @DynamicProperty(name="post:form:<NAME>", value="Attribute Expression Language", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="When the HTTP Method is POST, dynamic properties with the property name in the form of post:form:<NAME>, where the <NAME> will be the form data name, will be used to fill out the multipart form parts.  If send message body is false, the flowfile will not be sent, but any other form data will be.")})
public class InvokeHTTP
extends AbstractProcessor {
    public static final String STATUS_CODE = "invokehttp.status.code";
    public static final String STATUS_MESSAGE = "invokehttp.status.message";
    public static final String RESPONSE_BODY = "invokehttp.response.body";
    public static final String REQUEST_URL = "invokehttp.request.url";
    public static final String REQUEST_DURATION = "invokehttp.request.duration";
    public static final String RESPONSE_URL = "invokehttp.response.url";
    public static final String TRANSACTION_ID = "invokehttp.tx.id";
    public static final String REMOTE_DN = "invokehttp.remote.dn";
    public static final String EXCEPTION_CLASS = "invokehttp.java.exception.class";
    public static final String EXCEPTION_MESSAGE = "invokehttp.java.exception.message";
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    protected static final String FORM_DATA_NAME_BASE = "post:form";
    private static final Pattern FORM_DATA_NAME_PARAMETER_PATTERN = Pattern.compile("post:form:(?<formDataName>.*)$");
    private static final String FORM_DATA_NAME_GROUP = "formDataName";
    private static final Set<String> IGNORED_REQUEST_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("invokehttp.status.code", "invokehttp.status.message", "invokehttp.response.body", "invokehttp.request.url", "invokehttp.response.url", "invokehttp.tx.id", "invokehttp.remote.dn", "invokehttp.java.exception.class", "invokehttp.java.exception.message", CoreAttributes.UUID.key(), CoreAttributes.FILENAME.key(), CoreAttributes.PATH.key())));
    public static final PropertyDescriptor HTTP_METHOD = new PropertyDescriptor.Builder().name("HTTP Method").description("HTTP request method (GET, POST, PUT, PATCH, DELETE, HEAD, OPTIONS). Arbitrary methods are also supported. Methods other than POST, PUT and PATCH will be sent without a message body.").required(true).defaultValue(HttpMethod.GET.name()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).build();
    public static final PropertyDescriptor HTTP_URL = new PropertyDescriptor.Builder().name("Remote URL").displayName("HTTP URL").description("HTTP remote URL including a scheme of http or https, as well as a hostname or IP address with optional port and path elements.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor HTTP2_DISABLED = new PropertyDescriptor.Builder().name("disable-http2").displayName("HTTP/2 Disabled").description("Disable negotiation of HTTP/2 protocol. HTTP/2 requires TLS. HTTP/1.1 protocol supported is required when HTTP/2 is disabled.").required(true).defaultValue("False").allowableValues(new String[]{"True", "False"}).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("SSL Context Service provides trusted certificates and client certificates for TLS communication.").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor SOCKET_CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("Connection Timeout").displayName("Socket Connect Timeout").description("Maximum time to wait for initial socket connection to the HTTP URL.").required(true).defaultValue("5 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor SOCKET_READ_TIMEOUT = new PropertyDescriptor.Builder().name("Read Timeout").displayName("Socket Read Timeout").description("Maximum time to wait for receiving responses from a socket connection to the HTTP URL.").required(true).defaultValue("15 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor SOCKET_IDLE_TIMEOUT = new PropertyDescriptor.Builder().name("idle-timeout").displayName("Socket Idle Timeout").description("Maximum time to wait before closing idle connections to the HTTP URL.").required(true).defaultValue("5 mins").addValidator(StandardValidators.createTimePeriodValidator((long)1L, (TimeUnit)TimeUnit.MILLISECONDS, (long)Integer.MAX_VALUE, (TimeUnit)TimeUnit.SECONDS)).build();
    public static final PropertyDescriptor SOCKET_IDLE_CONNECTIONS = new PropertyDescriptor.Builder().name("max-idle-connections").displayName("Socket Idle Connections").description("Maximum number of idle connections to the HTTP URL.").required(true).defaultValue("5").addValidator(StandardValidators.INTEGER_VALIDATOR).build();
    @Deprecated
    public static final PropertyDescriptor PROXY_HOST = new PropertyDescriptor.Builder().name("Proxy Host").description("Proxy Host and dependent properties are deprecated in favor of Proxy Configuration Service. Proxy Host can be configured using an IP address or DNS address.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    @Deprecated
    public static final PropertyDescriptor PROXY_PORT = new PropertyDescriptor.Builder().name("Proxy Port").description("Proxy Port and dependent properties are deprecated in favor of Proxy Configuration Service. Port number for the configured Proxy Host address.").required(false).addValidator(StandardValidators.PORT_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dependsOn(PROXY_HOST, new AllowableValue[0]).build();
    @Deprecated
    public static final PropertyDescriptor PROXY_TYPE = new PropertyDescriptor.Builder().name("Proxy Type").displayName("Proxy Type").description("Proxy Type and dependent properties are deprecated in favor of Proxy Configuration Service. Proxy protocol type is not used").defaultValue("http").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).dependsOn(PROXY_HOST, new AllowableValue[0]).build();
    @Deprecated
    public static final PropertyDescriptor PROXY_USERNAME = new PropertyDescriptor.Builder().name("invokehttp-proxy-user").displayName("Proxy Username").description("Proxy Username and dependent properties are deprecated in favor of Proxy Configuration Service. Username to set when authenticating with a Proxy server.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dependsOn(PROXY_HOST, new AllowableValue[0]).build();
    @Deprecated
    public static final PropertyDescriptor PROXY_PASSWORD = new PropertyDescriptor.Builder().name("invokehttp-proxy-password").displayName("Proxy Password").description("Proxy Password and dependent properties are deprecated in favor of Proxy Configuration Service. Password to set when authenticating with a Proxy server.").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dependsOn(PROXY_HOST, new AllowableValue[0]).build();
    public static final PropertyDescriptor REQUEST_OAUTH2_ACCESS_TOKEN_PROVIDER = new PropertyDescriptor.Builder().name("oauth2-access-token-provider").displayName("Request OAuth2 Access Token Provider").description("Enables managed retrieval of OAuth2 Bearer Token applied to HTTP requests using the Authorization Header.").identifiesControllerService(OAuth2AccessTokenProvider.class).required(false).build();
    public static final PropertyDescriptor REQUEST_USERNAME = new PropertyDescriptor.Builder().name("Basic Authentication Username").displayName("Request Username").description("The username provided for authentication of HTTP requests. Encoded using Base64 for HTTP Basic Authentication as described in RFC 7617.").required(false).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("^[\\x20-\\x39\\x3b-\\x7e\\x80-\\xff]+$"))).build();
    public static final PropertyDescriptor REQUEST_PASSWORD = new PropertyDescriptor.Builder().name("Basic Authentication Password").displayName("Request Password").description("The password provided for authentication of HTTP requests. Encoded using Base64 for HTTP Basic Authentication as described in RFC 7617.").required(false).sensitive(true).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("^[\\x20-\\x7e\\x80-\\xff]+$"))).build();
    public static final PropertyDescriptor REQUEST_DIGEST_AUTHENTICATION_ENABLED = new PropertyDescriptor.Builder().name("Digest Authentication").displayName("Request Digest Authentication Enabled").description("Enable Digest Authentication on HTTP requests with Username and Password credentials as described in RFC 7616.").required(false).defaultValue("false").allowableValues(new String[]{"true", "false"}).dependsOn(REQUEST_USERNAME, new AllowableValue[0]).build();
    public static final PropertyDescriptor REQUEST_FAILURE_PENALIZATION_ENABLED = new PropertyDescriptor.Builder().name("Penalize on \"No Retry\"").displayName("Request Failure Penalization Enabled").description("Enable penalization of request FlowFiles when receiving HTTP response with a status code between 400 and 499.").required(false).defaultValue(Boolean.FALSE.toString()).allowableValues(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).build();
    public static final PropertyDescriptor REQUEST_BODY_ENABLED = new PropertyDescriptor.Builder().name("send-message-body").displayName("Request Body Enabled").description("Enable sending HTTP request body for PATCH, POST, or PUT methods.").defaultValue(Boolean.TRUE.toString()).allowableValues(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).required(false).dependsOn(HTTP_METHOD, HttpMethod.PATCH.name(), new String[]{HttpMethod.POST.name(), HttpMethod.PUT.name()}).build();
    public static final PropertyDescriptor REQUEST_FORM_DATA_NAME = new PropertyDescriptor.Builder().name("form-body-form-name").displayName("Request Multipart Form-Data Name").description("Enable sending HTTP request body formatted using multipart/form-data and using the form name configured.").required(false).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(REQUEST_BODY_ENABLED, Boolean.TRUE.toString(), new String[0]).build();
    public static final PropertyDescriptor REQUEST_FORM_DATA_FILENAME_ENABLED = new PropertyDescriptor.Builder().name("set-form-filename").displayName("Request Multipart Form-Data Filename Enabled").description("Enable sending the FlowFile filename attribute as the filename parameter in the Content-Disposition Header for multipart/form-data HTTP requests.").required(false).defaultValue(Boolean.TRUE.toString()).allowableValues(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).dependsOn(REQUEST_FORM_DATA_NAME, new AllowableValue[0]).build();
    public static final PropertyDescriptor REQUEST_CHUNKED_TRANSFER_ENCODING_ENABLED = new PropertyDescriptor.Builder().name("Use Chunked Encoding").displayName("Request Chunked Transfer-Encoding Enabled").description("Enable sending HTTP requests with the Transfer-Encoding Header set to chunked, and disable sending the Content-Length Header. Transfer-Encoding applies to the body in HTTP/1.1 requests as described in RFC 7230 Section 3.3.1").required(true).defaultValue(Boolean.FALSE.toString()).allowableValues(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).dependsOn(HTTP_METHOD, HttpMethod.PATCH.name(), new String[]{HttpMethod.POST.name(), HttpMethod.PUT.name()}).build();
    public static final PropertyDescriptor REQUEST_CONTENT_ENCODING = new PropertyDescriptor.Builder().name("Content-Encoding").displayName("Request Content-Encoding").description("HTTP Content-Encoding applied to request body during transmission. The receiving server must support the selected encoding to avoid request failures.").required(true).defaultValue(ContentEncodingStrategy.DISABLED.getValue()).allowableValues(ContentEncodingStrategy.class).dependsOn(HTTP_METHOD, HttpMethod.PATCH.name(), new String[]{HttpMethod.POST.name(), HttpMethod.PUT.name()}).build();
    public static final PropertyDescriptor REQUEST_CONTENT_TYPE = new PropertyDescriptor.Builder().name("Content-Type").displayName("Request Content-Type").description("HTTP Content-Type Header applied to when sending an HTTP request body for PATCH, POST, or PUT methods. " + String.format("The Content-Type defaults to %s when not configured.", "application/octet-stream")).required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("${" + CoreAttributes.MIME_TYPE.key() + "}").addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).dependsOn(HTTP_METHOD, HttpMethod.PATCH.name(), new String[]{HttpMethod.POST.name(), HttpMethod.PUT.name()}).build();
    public static final PropertyDescriptor REQUEST_DATE_HEADER_ENABLED = new PropertyDescriptor.Builder().name("Include Date Header").displayName("Request Date Header Enabled").description("Enable sending HTTP Date Header on HTTP requests as described in RFC 7231 Section 7.1.1.2.").required(true).defaultValue("True").allowableValues(new String[]{"True", "False"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor REQUEST_HEADER_ATTRIBUTES_PATTERN = new PropertyDescriptor.Builder().name("Attributes to Send").displayName("Request Header Attributes Pattern").description("Regular expression that defines which attributes to send as HTTP headers in the request. If not defined, no attributes are sent as headers. Dynamic properties will be sent as headers. The dynamic property name will be the header key and the dynamic property value will be interpreted as expression language will be the header value.").required(false).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    public static final PropertyDescriptor REQUEST_USER_AGENT = new PropertyDescriptor.Builder().name("Useragent").displayName("Request User-Agent").description("HTTP User-Agent Header applied to requests. RFC 7231 Section 5.5.3 describes recommend formatting.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor RESPONSE_BODY_ATTRIBUTE_NAME = new PropertyDescriptor.Builder().name("Put Response Body In Attribute").displayName("Response Body Attribute Name").description("FlowFile attribute name used to write an HTTP response body for FlowFiles transferred to the Original relationship.").addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor RESPONSE_BODY_ATTRIBUTE_SIZE = new PropertyDescriptor.Builder().name("Max Length To Put In Attribute").displayName("Response Body Attribute Size").description("Maximum size in bytes applied when writing an HTTP response body to a FlowFile attribute. Attributes exceeding the maximum will be truncated.").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("256").dependsOn(RESPONSE_BODY_ATTRIBUTE_NAME, new AllowableValue[0]).build();
    public static final PropertyDescriptor RESPONSE_BODY_IGNORED = new PropertyDescriptor.Builder().name("ignore-response-content").displayName("Response Body Ignored").description("Disable writing HTTP response FlowFiles to Response relationship").required(true).defaultValue(Boolean.FALSE.toString()).allowableValues(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).build();
    public static final PropertyDescriptor RESPONSE_CACHE_ENABLED = new PropertyDescriptor.Builder().name("use-etag").displayName("Response Cache Enabled").description("Enable HTTP response caching described in RFC 7234. Caching responses considers ETag and other headers.").required(true).defaultValue(Boolean.FALSE.toString()).allowableValues(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).build();
    public static final PropertyDescriptor RESPONSE_CACHE_SIZE = new PropertyDescriptor.Builder().name("etag-max-cache-size").displayName("Response Cache Size").description("Maximum size of HTTP response cache in bytes. Caching responses considers ETag and other headers.").required(true).defaultValue("10MB").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).dependsOn(RESPONSE_CACHE_ENABLED, Boolean.TRUE.toString(), new String[0]).build();
    public static final PropertyDescriptor RESPONSE_COOKIE_STRATEGY = new PropertyDescriptor.Builder().name("cookie-strategy").description("Strategy for accepting and persisting HTTP cookies. Accepting cookies enables persistence across multiple requests.").displayName("Response Cookie Strategy").required(true).defaultValue(CookieStrategy.DISABLED.name()).allowableValues((Enum[])CookieStrategy.values()).build();
    public static final PropertyDescriptor RESPONSE_GENERATION_REQUIRED = new PropertyDescriptor.Builder().name("Always Output Response").displayName("Response Generation Required").description("Enable generation and transfer of a FlowFile to the Response relationship regardless of HTTP response received.").required(false).defaultValue(Boolean.FALSE.toString()).allowableValues(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).build();
    public static final PropertyDescriptor RESPONSE_FLOW_FILE_NAMING_STRATEGY = new PropertyDescriptor.Builder().name("flow-file-naming-strategy").description("Determines the strategy used for setting the filename attribute of FlowFiles transferred to the Response relationship.").displayName("Response FlowFile Naming Strategy").required(true).defaultValue(FlowFileNamingStrategy.RANDOM.name()).allowableValues((AllowableValue[])Arrays.stream(FlowFileNamingStrategy.values()).map(strategy -> new AllowableValue(strategy.name(), strategy.name(), strategy.getDescription())).toArray(AllowableValue[]::new)).build();
    public static final PropertyDescriptor RESPONSE_HEADER_REQUEST_ATTRIBUTES_ENABLED = new PropertyDescriptor.Builder().name("Add Response Headers to Request").displayName("Response Header Request Attributes Enabled").description("Enable adding HTTP response headers as attributes to FlowFiles transferred to the Original relationship.").required(false).defaultValue(Boolean.FALSE.toString()).allowableValues(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).build();
    public static final PropertyDescriptor RESPONSE_REDIRECTS_ENABLED = new PropertyDescriptor.Builder().name("Follow Redirects").displayName("Response Redirects Enabled").description("Enable following HTTP redirects sent with HTTP 300 series responses as described in RFC 7231 Section 6.4.").required(true).defaultValue("True").allowableValues(new String[]{"True", "False"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    private static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP_AUTH, ProxySpec.SOCKS};
    private static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)true, (ProxySpec[])PROXY_SPECS);
    public static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(HTTP_METHOD, HTTP_URL, HTTP2_DISABLED, SSL_CONTEXT_SERVICE, SOCKET_CONNECT_TIMEOUT, SOCKET_READ_TIMEOUT, SOCKET_IDLE_TIMEOUT, SOCKET_IDLE_CONNECTIONS, PROXY_CONFIGURATION_SERVICE, PROXY_HOST, PROXY_PORT, PROXY_TYPE, PROXY_USERNAME, PROXY_PASSWORD, REQUEST_OAUTH2_ACCESS_TOKEN_PROVIDER, REQUEST_USERNAME, REQUEST_PASSWORD, REQUEST_DIGEST_AUTHENTICATION_ENABLED, REQUEST_FAILURE_PENALIZATION_ENABLED, REQUEST_BODY_ENABLED, REQUEST_FORM_DATA_NAME, REQUEST_FORM_DATA_FILENAME_ENABLED, REQUEST_CHUNKED_TRANSFER_ENCODING_ENABLED, REQUEST_CONTENT_ENCODING, REQUEST_CONTENT_TYPE, REQUEST_DATE_HEADER_ENABLED, REQUEST_HEADER_ATTRIBUTES_PATTERN, REQUEST_USER_AGENT, RESPONSE_BODY_ATTRIBUTE_NAME, RESPONSE_BODY_ATTRIBUTE_SIZE, RESPONSE_BODY_IGNORED, RESPONSE_CACHE_ENABLED, RESPONSE_CACHE_SIZE, RESPONSE_COOKIE_STRATEGY, RESPONSE_GENERATION_REQUIRED, RESPONSE_FLOW_FILE_NAMING_STRATEGY, RESPONSE_HEADER_REQUEST_ATTRIBUTES_ENABLED, RESPONSE_REDIRECTS_ENABLED));
    public static final Relationship ORIGINAL = new Relationship.Builder().name("Original").description("Request FlowFiles transferred when receiving HTTP responses with a status code between 200 and 299.").build();
    public static final Relationship RESPONSE = new Relationship.Builder().name("Response").description("Response FlowFiles transferred when receiving HTTP responses with a status code between 200 and 299.").build();
    public static final Relationship RETRY = new Relationship.Builder().name("Retry").description("Request FlowFiles transferred when receiving HTTP responses with a status code between 500 and 599.").build();
    public static final Relationship NO_RETRY = new Relationship.Builder().name("No Retry").description("Request FlowFiles transferred when receiving HTTP responses with a status code between 400 an 499.").build();
    public static final Relationship FAILURE = new Relationship.Builder().name("Failure").description("Request FlowFiles transferred when receiving socket communication errors.").build();
    public static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(ORIGINAL, RESPONSE, RETRY, NO_RETRY, FAILURE)));
    private static final DateTimeFormatter RFC_2616_DATE_TIME = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    private static final String MULTIPLE_HEADER_DELIMITER = ", ";
    private static final DeprecationLogger deprecationLogger = DeprecationLoggerFactory.getLogger(InvokeHTTP.class);
    private volatile Set<String> dynamicPropertyNames = new HashSet<String>();
    private volatile Pattern requestHeaderAttributesPattern = null;
    private volatile boolean chunkedTransferEncoding = false;
    private volatile Optional<OAuth2AccessTokenProvider> oauth2AccessTokenProviderOptional;
    private final AtomicReference<OkHttpClient> okHttpClientAtomicReference = new AtomicReference();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        if (propertyDescriptorName.startsWith(FORM_DATA_NAME_BASE)) {
            Matcher matcher = FORM_DATA_NAME_PARAMETER_PATTERN.matcher(propertyDescriptorName);
            if (matcher.matches()) {
                return new PropertyDescriptor.Builder().required(false).name(propertyDescriptorName).description("Form Data " + matcher.group(FORM_DATA_NAME_GROUP)).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
            }
            return null;
        }
        return new PropertyDescriptor.Builder().required(false).name(propertyDescriptorName).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.isDynamic()) {
            HashSet<String> newDynamicPropertyNames = new HashSet<String>(this.dynamicPropertyNames);
            if (newValue == null) {
                newDynamicPropertyNames.remove(descriptor.getName());
            } else if (oldValue == null) {
                newDynamicPropertyNames.add(descriptor.getName());
            }
            this.dynamicPropertyNames = Collections.unmodifiableSet(newDynamicPropertyNames);
        } else if (REQUEST_HEADER_ATTRIBUTES_PATTERN.getName().equalsIgnoreCase(descriptor.getName())) {
            if (newValue == null || newValue.isEmpty()) {
                this.requestHeaderAttributesPattern = null;
            } else {
                String trimmedValue = StringUtils.trimToEmpty((String)newValue);
                this.requestHeaderAttributesPattern = Pattern.compile(trimmedValue);
            }
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        String explanation;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(3);
        boolean proxyHostSet = validationContext.getProperty(PROXY_HOST).isSet();
        if (proxyHostSet) {
            deprecationLogger.warn("{}[id={}] [{}] Property should be replaced with [{}] Property", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.getIdentifier(), PROXY_HOST.getDisplayName(), PROXY_CONFIGURATION_SERVICE.getDisplayName()});
        }
        boolean proxyPortSet = validationContext.getProperty(PROXY_PORT).isSet();
        if (proxyHostSet && !proxyPortSet || !proxyHostSet && proxyPortSet) {
            results.add(new ValidationResult.Builder().subject("Proxy Host and Port").valid(false).explanation("If Proxy Host or Proxy Port is set, both must be set").build());
        }
        boolean proxyUserSet = validationContext.getProperty(PROXY_USERNAME).isSet();
        boolean proxyPwdSet = validationContext.getProperty(PROXY_PASSWORD).isSet();
        if (proxyUserSet && !proxyPwdSet || !proxyUserSet && proxyPwdSet) {
            results.add(new ValidationResult.Builder().subject("Proxy User and Password").valid(false).explanation("If Proxy Username or Proxy Password is set, both must be set").build());
        }
        if (proxyUserSet && !proxyHostSet) {
            results.add(new ValidationResult.Builder().subject("Proxy").valid(false).explanation("If Proxy username is set, proxy host must be set").build());
        }
        ProxyConfiguration.validateProxySpec((ValidationContext)validationContext, results, (ProxySpec[])PROXY_SPECS);
        boolean hasFormData = false;
        for (PropertyDescriptor descriptor : validationContext.getProperties().keySet()) {
            Matcher matcher = FORM_DATA_NAME_PARAMETER_PATTERN.matcher(descriptor.getName());
            if (!matcher.matches()) continue;
            hasFormData = true;
            break;
        }
        boolean requestBodyEnabled = validationContext.getProperty(REQUEST_BODY_ENABLED).asBoolean();
        boolean contentNameSet = validationContext.getProperty(REQUEST_FORM_DATA_NAME).isSet();
        if (hasFormData && requestBodyEnabled && !contentNameSet) {
            explanation = String.format("[%s] is required when Form Data properties are configured and [%s] is enabled", REQUEST_FORM_DATA_NAME.getDisplayName(), REQUEST_BODY_ENABLED.getDisplayName());
            results.add(new ValidationResult.Builder().subject(REQUEST_FORM_DATA_NAME.getDisplayName()).valid(false).explanation(explanation).build());
        }
        if (!requestBodyEnabled && contentNameSet) {
            explanation = String.format("[%s] must be [true] when Form Data properties are configured and [%s] is configured", REQUEST_BODY_ENABLED.getDisplayName(), REQUEST_FORM_DATA_NAME.getDisplayName());
            results.add(new ValidationResult.Builder().subject(REQUEST_FORM_DATA_NAME.getDisplayName()).valid(false).explanation(explanation).build());
        }
        boolean usingUserNamePasswordAuthorization = validationContext.getProperty(REQUEST_USERNAME).isSet() || validationContext.getProperty(REQUEST_PASSWORD).isSet();
        boolean usingOAuth2Authorization = validationContext.getProperty(REQUEST_OAUTH2_ACCESS_TOKEN_PROVIDER).isSet();
        if (usingUserNamePasswordAuthorization && usingOAuth2Authorization) {
            results.add(new ValidationResult.Builder().subject("Authorization properties").valid(false).explanation("OAuth2 Authorization cannot be configured together with Username and Password properties").build());
        }
        return results;
    }

    @OnScheduled
    public void setUpClient(ProcessContext context) throws TlsException, IOException {
        boolean cachingEnabled;
        this.okHttpClientAtomicReference.set(null);
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient().newBuilder();
        ProxyConfiguration proxyConfig = ProxyConfiguration.getConfiguration((PropertyContext)context, () -> {
            ProxyConfiguration componentProxyConfig = new ProxyConfiguration();
            String proxyHost = context.getProperty(PROXY_HOST).evaluateAttributeExpressions().getValue();
            Integer proxyPort = context.getProperty(PROXY_PORT).evaluateAttributeExpressions().asInteger();
            if (proxyHost != null && proxyPort != null) {
                componentProxyConfig.setProxyType(Proxy.Type.HTTP);
                componentProxyConfig.setProxyServerHost(proxyHost);
                componentProxyConfig.setProxyServerPort(proxyPort);
                String proxyUsername = StringUtils.trimToEmpty((String)context.getProperty(PROXY_USERNAME).evaluateAttributeExpressions().getValue());
                String proxyPassword = context.getProperty(PROXY_PASSWORD).evaluateAttributeExpressions().getValue();
                componentProxyConfig.setProxyUserName(proxyUsername);
                componentProxyConfig.setProxyUserPassword(proxyPassword);
            }
            return componentProxyConfig;
        });
        Proxy proxy = proxyConfig.createProxy();
        if (!Proxy.Type.DIRECT.equals((Object)proxy.type())) {
            okHttpClientBuilder.proxy(proxy);
            if (proxyConfig.hasCredential()) {
                ProxyAuthenticator proxyAuthenticator = new ProxyAuthenticator(proxyConfig.getProxyUserName(), proxyConfig.getProxyUserPassword());
                okHttpClientBuilder.proxyAuthenticator((Authenticator)proxyAuthenticator);
            }
        }
        if (cachingEnabled = context.getProperty(RESPONSE_CACHE_ENABLED).asBoolean().booleanValue()) {
            int maxCacheSizeBytes = context.getProperty(RESPONSE_CACHE_SIZE).asDataSize(DataUnit.B).intValue();
            okHttpClientBuilder.cache(new Cache(InvokeHTTP.getResponseCacheDirectory(), (long)maxCacheSizeBytes));
        }
        if (context.getProperty(HTTP2_DISABLED).asBoolean().booleanValue()) {
            okHttpClientBuilder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
        }
        okHttpClientBuilder.followRedirects(context.getProperty(RESPONSE_REDIRECTS_ENABLED).asBoolean().booleanValue());
        okHttpClientBuilder.connectTimeout((long)context.getProperty(SOCKET_CONNECT_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue(), TimeUnit.MILLISECONDS);
        okHttpClientBuilder.readTimeout((long)context.getProperty(SOCKET_READ_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue(), TimeUnit.MILLISECONDS);
        okHttpClientBuilder.connectionPool(new ConnectionPool(context.getProperty(SOCKET_IDLE_CONNECTIONS).asInteger().intValue(), (long)context.getProperty(SOCKET_IDLE_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue(), TimeUnit.MILLISECONDS));
        SSLContextService sslService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        if (sslService != null) {
            SSLContext sslContext = sslService.createContext();
            SSLSocketFactory socketFactory = sslContext.getSocketFactory();
            TlsConfiguration tlsConfiguration = sslService.createTlsConfiguration();
            X509TrustManager trustManager = Objects.requireNonNull(SslContextFactory.getX509TrustManager((TlsConfiguration)tlsConfiguration), "Trust Manager not found");
            okHttpClientBuilder.sslSocketFactory(socketFactory, trustManager);
        }
        CookieStrategy cookieStrategy = CookieStrategy.valueOf(context.getProperty(RESPONSE_COOKIE_STRATEGY).getValue());
        switch (cookieStrategy) {
            case DISABLED: {
                break;
            }
            case ACCEPT_ALL: {
                CookieManager cookieManager = new CookieManager();
                cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
                okHttpClientBuilder.cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager));
            }
        }
        this.setAuthenticator(okHttpClientBuilder, context);
        this.chunkedTransferEncoding = context.getProperty(REQUEST_CHUNKED_TRANSFER_ENCODING_ENABLED).asBoolean();
        this.okHttpClientAtomicReference.set(okHttpClientBuilder.build());
    }

    @OnScheduled
    public void initOauth2AccessTokenProvider(ProcessContext context) {
        if (context.getProperty(REQUEST_OAUTH2_ACCESS_TOKEN_PROVIDER).isSet()) {
            OAuth2AccessTokenProvider oauth2AccessTokenProvider = (OAuth2AccessTokenProvider)context.getProperty(REQUEST_OAUTH2_ACCESS_TOKEN_PROVIDER).asControllerService(OAuth2AccessTokenProvider.class);
            oauth2AccessTokenProvider.getAccessDetails();
            this.oauth2AccessTokenProviderOptional = Optional.of(oauth2AccessTokenProvider);
        } else {
            this.oauth2AccessTokenProviderOptional = Optional.empty();
        }
    }

    private void setAuthenticator(OkHttpClient.Builder okHttpClientBuilder, ProcessContext context) {
        String authUser = StringUtils.trimToEmpty((String)context.getProperty(REQUEST_USERNAME).getValue());
        if (!authUser.isEmpty() && "true".equalsIgnoreCase(context.getProperty(REQUEST_DIGEST_AUTHENTICATION_ENABLED).getValue())) {
            String authPass = StringUtils.trimToEmpty((String)context.getProperty(REQUEST_PASSWORD).getValue());
            ConcurrentHashMap authCache = new ConcurrentHashMap();
            Credentials credentials = new Credentials(authUser, authPass);
            DigestAuthenticator digestAuthenticator = new DigestAuthenticator(credentials);
            okHttpClientBuilder.interceptors().add(new AuthenticationCacheInterceptor(authCache));
            okHttpClientBuilder.authenticator((Authenticator)new CachingAuthenticatorDecorator((Authenticator)digestAuthenticator, authCache));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        block42: {
            OkHttpClient okHttpClient = this.okHttpClientAtomicReference.get();
            FlowFile requestFlowFile = session.get();
            boolean putToAttribute = context.getProperty(RESPONSE_BODY_ATTRIBUTE_NAME).isSet();
            if (requestFlowFile == null) {
                if (context.hasNonLoopConnection()) {
                    return;
                }
                String method = this.getRequestMethod((PropertyContext)context, null);
                Optional<HttpMethod> requestMethodFound = this.findRequestMethod(method);
                HttpMethod requestMethod = requestMethodFound.orElse(HttpMethod.GET);
                if (requestMethod.isRequestBodySupported()) {
                    return;
                }
                if (putToAttribute) {
                    requestFlowFile = session.create();
                }
            }
            int maxAttributeSize = context.getProperty(RESPONSE_BODY_ATTRIBUTE_SIZE).asInteger();
            ComponentLog logger = this.getLogger();
            UUID txId = UUID.randomUUID();
            FlowFile responseFlowFile = null;
            try {
                String urlProperty = StringUtils.trimToEmpty((String)context.getProperty(HTTP_URL).evaluateAttributeExpressions(requestFlowFile).getValue());
                URL url = new URL(urlProperty);
                Request httpRequest = this.configureRequest(context, session, requestFlowFile, url);
                this.logRequest(logger, httpRequest);
                if (httpRequest.body() != null) {
                    session.getProvenanceReporter().send(requestFlowFile, url.toExternalForm(), true);
                }
                long startNanos = System.nanoTime();
                try (Response responseHttp = okHttpClient.newCall(httpRequest).execute();){
                    this.logResponse(logger, url, responseHttp);
                    int statusCode = responseHttp.code();
                    String statusMessage = responseHttp.message();
                    HashMap<String, String> statusAttributes = new HashMap<String, String>();
                    statusAttributes.put(STATUS_CODE, String.valueOf(statusCode));
                    statusAttributes.put(STATUS_MESSAGE, statusMessage);
                    statusAttributes.put(REQUEST_URL, url.toExternalForm());
                    statusAttributes.put(REQUEST_DURATION, Long.toString(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos)));
                    statusAttributes.put(RESPONSE_URL, responseHttp.request().url().toString());
                    statusAttributes.put(TRANSACTION_ID, txId.toString());
                    if (requestFlowFile != null) {
                        requestFlowFile = session.putAllAttributes(requestFlowFile, statusAttributes);
                    }
                    if (context.getProperty(RESPONSE_HEADER_REQUEST_ATTRIBUTES_ENABLED).asBoolean().booleanValue() && requestFlowFile != null) {
                        requestFlowFile = session.putAllAttributes(requestFlowFile, this.convertAttributesFromHeaders(responseHttp));
                    }
                    boolean outputBodyToRequestAttribute = (!this.isSuccess(statusCode) || putToAttribute) && requestFlowFile != null;
                    boolean outputBodyToResponseContent = this.isSuccess(statusCode) && !putToAttribute || context.getProperty(RESPONSE_GENERATION_REQUIRED).asBoolean() != false;
                    ResponseBody responseBody = responseHttp.body();
                    boolean bodyExists = responseBody != null && context.getProperty(RESPONSE_BODY_IGNORED).asBoolean() == false;
                    InputStream responseBodyStream = null;
                    OutputStream outputStreamToRequestAttribute = null;
                    TeeInputStream teeInputStream = null;
                    try {
                        InputStream inputStream = responseBodyStream = bodyExists ? responseBody.byteStream() : null;
                        if (responseBodyStream != null && outputBodyToRequestAttribute && outputBodyToResponseContent) {
                            outputStreamToRequestAttribute = new SoftLimitBoundedByteArrayOutputStream(maxAttributeSize);
                            teeInputStream = new TeeInputStream(responseBodyStream, outputStreamToRequestAttribute);
                        }
                        if (outputBodyToResponseContent) {
                            String fileName;
                            responseFlowFile = requestFlowFile != null ? session.create(requestFlowFile) : session.create();
                            responseFlowFile = session.putAllAttributes(responseFlowFile, statusAttributes);
                            responseFlowFile = session.putAllAttributes(responseFlowFile, this.convertAttributesFromHeaders(responseHttp));
                            if (FlowFileNamingStrategy.URL_PATH.equals((Object)this.getFlowFileNamingStrategy(context)) && HttpMethod.GET.name().equals(httpRequest.method()) && (fileName = this.getFileNameFromUrl(url)) != null) {
                                responseFlowFile = session.putAttribute(responseFlowFile, CoreAttributes.FILENAME.key(), fileName);
                            }
                            if (bodyExists) {
                                MediaType contentType = responseBody.contentType();
                                if (contentType != null) {
                                    responseFlowFile = session.putAttribute(responseFlowFile, CoreAttributes.MIME_TYPE.key(), contentType.toString());
                                }
                                responseFlowFile = teeInputStream != null ? session.importFrom((InputStream)teeInputStream, responseFlowFile) : session.importFrom(responseBodyStream, responseFlowFile);
                                long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                                if (requestFlowFile != null) {
                                    session.getProvenanceReporter().fetch(responseFlowFile, url.toExternalForm(), millis);
                                } else {
                                    session.getProvenanceReporter().receive(responseFlowFile, url.toExternalForm(), millis);
                                }
                            }
                        }
                        if (outputBodyToRequestAttribute && bodyExists) {
                            int size;
                            byte[] outputBuffer;
                            String attributeKey = context.getProperty(RESPONSE_BODY_ATTRIBUTE_NAME).evaluateAttributeExpressions(requestFlowFile).getValue();
                            if (attributeKey == null) {
                                attributeKey = RESPONSE_BODY;
                            }
                            if (outputStreamToRequestAttribute != null) {
                                outputBuffer = ((SoftLimitBoundedByteArrayOutputStream)outputStreamToRequestAttribute).getBuffer();
                                size = ((SoftLimitBoundedByteArrayOutputStream)outputStreamToRequestAttribute).size();
                            } else {
                                outputBuffer = new byte[maxAttributeSize];
                                size = StreamUtils.fillBuffer((InputStream)responseBodyStream, (byte[])outputBuffer, (boolean)false);
                            }
                            String bodyString = new String(outputBuffer, 0, size, this.getCharsetFromMediaType(responseBody.contentType()));
                            requestFlowFile = session.putAttribute(requestFlowFile, attributeKey, bodyString);
                            long processingDuration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                            String eventDetails = String.format("Response Body Attribute Added [%s] Processing Duration [%d ms]", attributeKey, processingDuration);
                            session.getProvenanceReporter().modifyAttributes(requestFlowFile, eventDetails);
                        }
                    }
                    finally {
                        if (outputStreamToRequestAttribute != null) {
                            outputStreamToRequestAttribute.close();
                        }
                        if (teeInputStream != null) {
                            teeInputStream.close();
                        } else if (responseBodyStream != null) {
                            responseBodyStream.close();
                        }
                    }
                    this.route(requestFlowFile, responseFlowFile, session, context, statusCode);
                }
            }
            catch (Exception e) {
                if (requestFlowFile == null) {
                    logger.error("Request Processing failed", (Throwable)e);
                    context.yield();
                } else {
                    logger.error("Request Processing failed: {}", new Object[]{requestFlowFile, e});
                    requestFlowFile = session.penalize(requestFlowFile);
                    requestFlowFile = session.putAttribute(requestFlowFile, EXCEPTION_CLASS, e.getClass().getName());
                    requestFlowFile = session.putAttribute(requestFlowFile, EXCEPTION_MESSAGE, e.getMessage());
                    session.transfer(requestFlowFile, FAILURE);
                }
                if (responseFlowFile == null) break block42;
                session.remove(responseFlowFile);
            }
        }
    }

    private Request configureRequest(ProcessContext context, ProcessSession session, FlowFile requestFlowFile, URL url) {
        HttpMethod httpMethod;
        String method;
        Optional<HttpMethod> httpMethodFound;
        String contentEncoding;
        ContentEncodingStrategy contentEncodingStrategy;
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        String authUser = StringUtils.trimToEmpty((String)context.getProperty(REQUEST_USERNAME).getValue());
        if ("false".equalsIgnoreCase(context.getProperty(REQUEST_DIGEST_AUTHENTICATION_ENABLED).getValue())) {
            if (!authUser.isEmpty()) {
                String authPass = StringUtils.trimToEmpty((String)context.getProperty(REQUEST_PASSWORD).getValue());
                String credential = okhttp3.Credentials.basic((String)authUser, (String)authPass);
                requestBuilder.header(HttpHeader.AUTHORIZATION.getHeader(), credential);
            } else {
                this.oauth2AccessTokenProviderOptional.ifPresent(oauth2AccessTokenProvider -> requestBuilder.addHeader(HttpHeader.AUTHORIZATION.getHeader(), "Bearer " + oauth2AccessTokenProvider.getAccessDetails().getAccessToken()));
            }
        }
        if (ContentEncodingStrategy.GZIP == (contentEncodingStrategy = ContentEncodingStrategy.valueOf(contentEncoding = context.getProperty(REQUEST_CONTENT_ENCODING).getValue()))) {
            requestBuilder.addHeader(HttpHeader.CONTENT_ENCODING.getHeader(), ContentEncodingStrategy.GZIP.getValue().toLowerCase());
        }
        RequestBody requestBody = (httpMethodFound = this.findRequestMethod(method = this.getRequestMethod((PropertyContext)context, requestFlowFile))).isPresent() ? ((httpMethod = httpMethodFound.get()).isRequestBodySupported() ? this.getRequestBodyToSend(session, context, requestFlowFile, contentEncodingStrategy) : null) : null;
        requestBuilder.method(method, requestBody);
        this.setHeaderProperties(context, requestBuilder, requestFlowFile);
        return requestBuilder.build();
    }

    private RequestBody getRequestBodyToSend(final ProcessSession session, ProcessContext context, final FlowFile requestFlowFile, final ContentEncodingStrategy contentEncodingStrategy) {
        boolean requestBodyEnabled = context.getProperty(REQUEST_BODY_ENABLED).asBoolean();
        String evalContentType = context.getProperty(REQUEST_CONTENT_TYPE).evaluateAttributeExpressions(requestFlowFile).getValue();
        final String contentType = StringUtils.isBlank((CharSequence)evalContentType) ? DEFAULT_CONTENT_TYPE : evalContentType;
        String formDataName = context.getProperty(REQUEST_FORM_DATA_NAME).evaluateAttributeExpressions(requestFlowFile).getValue();
        HashMap propertyDescriptors = new HashMap();
        for (Map.Entry entry : context.getProperties().entrySet()) {
            Matcher matcher = FORM_DATA_NAME_PARAMETER_PATTERN.matcher(((PropertyDescriptor)entry.getKey()).getName());
            if (!matcher.matches()) continue;
            propertyDescriptors.put(matcher.group(FORM_DATA_NAME_GROUP), entry.getKey());
        }
        final boolean contentLengthUnknown = this.chunkedTransferEncoding || ContentEncodingStrategy.GZIP == contentEncodingStrategy;
        RequestBody requestBody = new RequestBody(){

            @Nullable
            public MediaType contentType() {
                return MediaType.parse((String)contentType);
            }

            public void writeTo(BufferedSink sink) throws IOException {
                BufferedSink outputSink = ContentEncodingStrategy.GZIP == contentEncodingStrategy ? Okio.buffer((Sink)new GzipSink((Sink)sink)) : sink;
                session.read(requestFlowFile, inputStream -> {
                    Source source = Okio.source((InputStream)inputStream);
                    outputSink.writeAll(source);
                });
                if (ContentEncodingStrategy.GZIP == contentEncodingStrategy) {
                    outputSink.close();
                }
            }

            public long contentLength() {
                return contentLengthUnknown ? -1L : requestFlowFile.getSize();
            }
        };
        if (propertyDescriptors.size() > 0 || StringUtils.isNotEmpty((CharSequence)formDataName)) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            boolean useFileName = context.getProperty(REQUEST_FORM_DATA_FILENAME_ENABLED).asBoolean();
            String contentFileName = null;
            if (useFileName) {
                contentFileName = requestFlowFile.getAttribute(CoreAttributes.FILENAME.key());
            }
            for (Map.Entry entry : propertyDescriptors.entrySet()) {
                String propValue = context.getProperty(((PropertyDescriptor)entry.getValue()).getName()).evaluateAttributeExpressions(requestFlowFile).getValue();
                builder.addFormDataPart((String)entry.getKey(), propValue);
            }
            if (requestBodyEnabled) {
                builder.addFormDataPart(formDataName, contentFileName, requestBody);
            }
            return builder.build();
        }
        if (requestBodyEnabled) {
            return requestBody;
        }
        return RequestBody.create((byte[])new byte[0], null);
    }

    private void setHeaderProperties(ProcessContext context, Request.Builder requestBuilder, FlowFile requestFlowFile) {
        String userAgent = StringUtils.trimToEmpty((String)context.getProperty(REQUEST_USER_AGENT).evaluateAttributeExpressions(requestFlowFile).getValue());
        requestBuilder.addHeader(HttpHeader.USER_AGENT.getHeader(), userAgent);
        if (context.getProperty(REQUEST_DATE_HEADER_ENABLED).asBoolean().booleanValue()) {
            ZonedDateTime universalCoordinatedTimeNow = ZonedDateTime.now(ZoneOffset.UTC);
            requestBuilder.addHeader(HttpHeader.DATE.getHeader(), RFC_2616_DATE_TIME.format(universalCoordinatedTimeNow));
        }
        for (String headerKey : this.dynamicPropertyNames) {
            String headerValue = context.getProperty(headerKey).evaluateAttributeExpressions(requestFlowFile).getValue();
            if (FORM_DATA_NAME_PARAMETER_PATTERN.matcher(headerKey).matches()) continue;
            requestBuilder.addHeader(headerKey, headerValue);
        }
        if (this.requestHeaderAttributesPattern != null && requestFlowFile != null) {
            Map attributes = requestFlowFile.getAttributes();
            Matcher m = this.requestHeaderAttributesPattern.matcher("");
            for (Map.Entry entry : attributes.entrySet()) {
                String headerKey = StringUtils.trimToEmpty((String)((String)entry.getKey()));
                if (IGNORED_REQUEST_ATTRIBUTES.contains(headerKey)) continue;
                m.reset(headerKey);
                if (!m.matches()) continue;
                String headerVal = StringUtils.trimToEmpty((String)((String)entry.getValue()));
                requestBuilder.addHeader(headerKey, headerVal);
            }
        }
    }

    private void route(FlowFile request, FlowFile response, ProcessSession session, ProcessContext context, int statusCode) {
        if (!this.isSuccess(statusCode) && request == null) {
            context.yield();
        }
        boolean responseSent = false;
        if (context.getProperty(RESPONSE_GENERATION_REQUIRED).asBoolean().booleanValue()) {
            session.transfer(response, RESPONSE);
            responseSent = true;
        }
        if (this.isSuccess(statusCode)) {
            if (request != null) {
                session.transfer(request, ORIGINAL);
            }
            if (response != null && !responseSent) {
                session.transfer(response, RESPONSE);
            }
        } else if (statusCode / 100 == 5) {
            if (request != null) {
                request = session.penalize(request);
                session.transfer(request, RETRY);
            }
        } else if (request != null) {
            if (context.getProperty(REQUEST_FAILURE_PENALIZATION_ENABLED).asBoolean().booleanValue()) {
                request = session.penalize(request);
            }
            session.transfer(request, NO_RETRY);
        }
    }

    private boolean isSuccess(int statusCode) {
        return statusCode / 100 == 2;
    }

    private void logRequest(ComponentLog logger, Request request) {
        if (logger.isDebugEnabled()) {
            logger.debug("\nRequest to remote service:\n\t{}\n{}", new Object[]{request.url().url().toExternalForm(), this.getLogString(request.headers().toMultimap())});
        }
    }

    private void logResponse(ComponentLog logger, URL url, Response response) {
        if (logger.isDebugEnabled()) {
            logger.debug("\nResponse from remote service:\n\t{}\n{}", new Object[]{url.toExternalForm(), this.getLogString(response.headers().toMultimap())});
        }
    }

    private String getLogString(Map<String, List<String>> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            List<String> list = entry.getValue();
            if (list.isEmpty()) continue;
            sb.append("\t");
            sb.append(entry.getKey());
            sb.append(": ");
            if (list.size() == 1) {
                sb.append(list.get(0));
            } else {
                sb.append(list);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private Map<String, String> convertAttributesFromHeaders(Response responseHttp) {
        Principal principal;
        HashMap<String, String> attributes = new HashMap<String, String>();
        Headers headers = responseHttp.headers();
        headers.names().forEach(key -> {
            List values = headers.values(key);
            if (!values.isEmpty()) {
                String value = StringUtils.join((Iterable)values, (String)MULTIPLE_HEADER_DELIMITER);
                attributes.put((String)key, value);
            }
        });
        Handshake handshake = responseHttp.handshake();
        if (handshake != null && (principal = handshake.peerPrincipal()) != null) {
            attributes.put(REMOTE_DN, principal.getName());
        }
        return attributes;
    }

    private Charset getCharsetFromMediaType(MediaType contentType) {
        return contentType != null ? contentType.charset(StandardCharsets.UTF_8) : StandardCharsets.UTF_8;
    }

    private static File getResponseCacheDirectory() throws IOException {
        return Files.createTempDirectory(InvokeHTTP.class.getSimpleName(), new FileAttribute[0]).toFile();
    }

    private FlowFileNamingStrategy getFlowFileNamingStrategy(ProcessContext context) {
        String strategy = context.getProperty(RESPONSE_FLOW_FILE_NAMING_STRATEGY).getValue();
        return FlowFileNamingStrategy.valueOf(strategy);
    }

    private String getFileNameFromUrl(URL url) {
        String fileName = null;
        String path = StringUtils.removeEnd((String)url.getPath(), (String)"/");
        if (!StringUtils.isEmpty((CharSequence)path)) {
            fileName = path.substring(path.lastIndexOf(47) + 1);
        }
        return fileName;
    }

    private Optional<HttpMethod> findRequestMethod(String method) {
        return Arrays.stream(HttpMethod.values()).filter(httpMethod -> httpMethod.name().equals(method)).findFirst();
    }

    private String getRequestMethod(PropertyContext context, FlowFile flowFile) {
        String method = context.getProperty(HTTP_METHOD).evaluateAttributeExpressions(flowFile).getValue().toUpperCase();
        return StringUtils.trimToEmpty((String)method);
    }
}

