/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.util.StringUtils;

public abstract class AbstractDatabaseFetchProcessor
extends AbstractSessionFactoryProcessor {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Successfully created FlowFile from SQL query result set.").build();
    protected Set<Relationship> relationships;
    public static final PropertyDescriptor DBCP_SERVICE = new PropertyDescriptor.Builder().name("Database Connection Pooling Service").description("The Controller Service that is used to obtain a connection to the database.").required(true).identifiesControllerService(DBCPService.class).build();
    public static final PropertyDescriptor TABLE_NAME = new PropertyDescriptor.Builder().name("Table Name").description("The name of the database table to be queried.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor COLUMN_NAMES = new PropertyDescriptor.Builder().name("Columns to Return").description("A comma-separated list of column names to be used in the query. If your database requires special treatment of the names (quoting, e.g.), each name should include such treatment. If no column names are supplied, all columns in the specified table will be returned. NOTE: It is important to use consistent column names for a given table for incremental fetch to work properly.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor MAX_VALUE_COLUMN_NAMES = new PropertyDescriptor.Builder().name("Maximum-value Columns").description("A comma-separated list of column names. The processor will keep track of the maximum value for each column that has been returned since the processor started running. Using multiple columns implies an order to the column list, and each column's values are expected to increase more slowly than the previous columns' values. Thus, using multiple columns implies a hierarchical structure of columns, which is usually used for partitioning tables. This processor can be used to retrieve only those rows that have been added/updated since the last retrieval. Note that some JDBC types such as bit/boolean are not conducive to maintaining maximum value, so columns of these types should not be listed in this property, and will result in error(s) during processing. If no columns are provided, all rows from the table will be considered, which could have a performance impact. NOTE: It is important to use consistent max-value column names for a given table for incremental fetch to work properly.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor QUERY_TIMEOUT = new PropertyDescriptor.Builder().name("Max Wait Time").description("The maximum amount of time allowed for a running SQL select query , zero means there is no limit. Max time less than 1 second will be equal to zero.").defaultValue("0 seconds").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor NORMALIZE_NAMES_FOR_AVRO = new PropertyDescriptor.Builder().name("dbf-normalize").displayName("Normalize Table/Column Names").description("Whether to change non-Avro-compatible characters in column names to Avro-compatible characters. For example, colons and periods will be changed to underscores in order to build a valid Avro record.").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    protected List<PropertyDescriptor> propDescriptors;
    protected static final String NAMESPACE_DELIMITER = "@!@";
    public static final PropertyDescriptor DB_TYPE;
    protected static final Map<String, DatabaseAdapter> dbAdapters;
    protected final Map<String, Integer> columnTypeMap = new HashMap<String, Integer>();
    protected volatile boolean isDynamicTableName = false;
    protected volatile boolean isDynamicMaxValues = false;
    private static SimpleDateFormat TIME_TYPE_FORMAT;

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        this.isDynamicTableName = validationContext.isExpressionLanguagePresent(validationContext.getProperty(TABLE_NAME).getValue());
        this.isDynamicMaxValues = validationContext.isExpressionLanguagePresent(validationContext.getProperty(MAX_VALUE_COLUMN_NAMES).getValue());
        return super.customValidate(validationContext);
    }

    public void setup(ProcessContext context) {
        block29: {
            String maxValueColumnNames = context.getProperty(MAX_VALUE_COLUMN_NAMES).evaluateAttributeExpressions().getValue();
            if (StringUtils.isEmpty((String)maxValueColumnNames)) {
                return;
            }
            DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
            String tableName = context.getProperty(TABLE_NAME).evaluateAttributeExpressions().getValue();
            DatabaseAdapter dbAdapter = dbAdapters.get(context.getProperty(DB_TYPE).getValue());
            try (Connection con = dbcpService.getConnection();
                 Statement st = con.createStatement();){
                String query = dbAdapter.getSelectStatement(tableName, maxValueColumnNames, "1 = 0", null, null, null);
                ResultSet resultSet = st.executeQuery(query);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int numCols = resultSetMetaData.getColumnCount();
                if (numCols > 0) {
                    this.columnTypeMap.clear();
                    for (int i = 1; i <= numCols; ++i) {
                        String colName = resultSetMetaData.getColumnName(i).toLowerCase();
                        String colKey = AbstractDatabaseFetchProcessor.getStateKey(tableName, colName);
                        int colType = resultSetMetaData.getColumnType(i);
                        this.columnTypeMap.putIfAbsent(colKey, colType);
                    }
                    break block29;
                }
                throw new ProcessException("No columns found in table from those specified: " + maxValueColumnNames);
            }
            catch (SQLException e) {
                throw new ProcessException("Unable to communicate with database in order to determine column types", (Throwable)e);
            }
        }
    }

    protected static String getMaxValueFromRow(ResultSet resultSet, int columnIndex, Integer type, String maxValueString, String databaseType) throws ParseException, IOException, SQLException {
        if (type == null || resultSet.getObject(columnIndex) == null) {
            return null;
        }
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String colStringValue = resultSet.getString(columnIndex);
                if (maxValueString != null && colStringValue.compareTo(maxValueString) <= 0) break;
                return colStringValue;
            }
            case -6: 
            case 4: 
            case 5: {
                Integer colIntValue = resultSet.getInt(columnIndex);
                Integer maxIntValue = null;
                if (maxValueString != null) {
                    maxIntValue = Integer.valueOf(maxValueString);
                }
                if (maxIntValue != null && colIntValue <= maxIntValue) break;
                return colIntValue.toString();
            }
            case -5: {
                Long colLongValue = resultSet.getLong(columnIndex);
                Long maxLongValue = null;
                if (maxValueString != null) {
                    maxLongValue = Long.valueOf(maxValueString);
                }
                if (maxLongValue != null && colLongValue <= maxLongValue) break;
                return colLongValue.toString();
            }
            case 6: 
            case 7: 
            case 8: {
                Double colDoubleValue = resultSet.getDouble(columnIndex);
                Double maxDoubleValue = null;
                if (maxValueString != null) {
                    maxDoubleValue = Double.valueOf(maxValueString);
                }
                if (maxDoubleValue != null && !(colDoubleValue > maxDoubleValue)) break;
                return colDoubleValue.toString();
            }
            case 2: 
            case 3: {
                BigDecimal colBigDecimalValue = resultSet.getBigDecimal(columnIndex);
                BigDecimal maxBigDecimalValue = null;
                if (maxValueString != null) {
                    DecimalFormat df = new DecimalFormat();
                    df.setParseBigDecimal(true);
                    maxBigDecimalValue = (BigDecimal)df.parse(maxValueString);
                }
                if (maxBigDecimalValue != null && colBigDecimalValue.compareTo(maxBigDecimalValue) <= 0) break;
                return colBigDecimalValue.toString();
            }
            case 91: {
                Date rawColDateValue = resultSet.getDate(columnIndex);
                Date colDateValue = new Date(rawColDateValue.getTime());
                Date maxDateValue = null;
                if (maxValueString != null) {
                    maxDateValue = Date.valueOf(maxValueString);
                }
                if (maxDateValue != null && !colDateValue.after(maxDateValue)) break;
                return colDateValue.toString();
            }
            case 92: {
                java.util.Date colTimeValue = new java.util.Date(resultSet.getTimestamp(columnIndex).getTime());
                java.util.Date maxTimeValue = null;
                if (maxValueString != null) {
                    try {
                        maxTimeValue = TIME_TYPE_FORMAT.parse(maxValueString);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (maxTimeValue != null && !colTimeValue.after(maxTimeValue)) break;
                return TIME_TYPE_FORMAT.format(colTimeValue);
            }
            case 93: {
                Timestamp colTimestampValue = resultSet.getTimestamp(columnIndex);
                Timestamp maxTimestampValue = null;
                if (maxValueString != null) {
                    try {
                        maxTimestampValue = Timestamp.valueOf(maxValueString);
                    }
                    catch (IllegalArgumentException iae) {
                        maxTimestampValue = new Timestamp(Date.valueOf(maxValueString).getTime());
                    }
                }
                if (maxTimestampValue != null && !colTimestampValue.after(maxTimestampValue)) break;
                return colTimestampValue.toString();
            }
            default: {
                throw new IOException("Type for column " + columnIndex + " is not valid for maintaining maximum value");
            }
        }
        return null;
    }

    protected static String getLiteralByType(int type, String value, String databaseType) {
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: {
                return "'" + value + "'";
            }
            case 93: {
                if ("Oracle".equals(databaseType)) {
                    if (value.matches("\\d{4}-\\d{2}-\\d{2}")) {
                        return "date '" + value + "'";
                    }
                    return "timestamp '" + value + "'";
                }
                return "'" + value + "'";
            }
        }
        return value;
    }

    protected static String getStateKey(String prefix, String columnName) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix.toLowerCase());
            sb.append(NAMESPACE_DELIMITER);
        }
        if (columnName != null) {
            sb.append(columnName.toLowerCase());
        }
        return sb.toString();
    }

    static {
        dbAdapters = new HashMap<String, DatabaseAdapter>();
        TIME_TYPE_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
        ArrayList dbAdapterValues = new ArrayList();
        ServiceLoader<DatabaseAdapter> dbAdapterLoader = ServiceLoader.load(DatabaseAdapter.class);
        dbAdapterLoader.forEach(it -> {
            dbAdapters.put(it.getName(), (DatabaseAdapter)it);
            dbAdapterValues.add(new AllowableValue(it.getName(), it.getName(), it.getDescription()));
        });
        DB_TYPE = new PropertyDescriptor.Builder().name("db-fetch-db-type").displayName("Database Type").description("The type/flavor of database, used for generating database-specific code. In many cases the Generic type should suffice, but some databases (such as Oracle) require custom SQL clauses. ").allowableValues(dbAdapterValues.toArray(new AllowableValue[dbAdapterValues.size()])).defaultValue("Generic").required(true).build();
    }
}

