/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.Closeable;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.list.AbstractListProcessor;
import org.apache.nifi.processors.standard.util.FileInfo;
import org.apache.nifi.processors.standard.util.FileTransfer;

public abstract class ListFileTransfer
extends AbstractListProcessor<FileInfo> {
    public static final PropertyDescriptor HOSTNAME = new PropertyDescriptor.Builder().name("Hostname").description("The fully qualified hostname or IP address of the remote system").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).expressionLanguageSupported(true).build();
    static final PropertyDescriptor UNDEFAULTED_PORT = new PropertyDescriptor.Builder().name("Port").description("The port to connect to on the remote host to fetch the data from").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).required(true).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("Username").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).required(true).build();
    public static final PropertyDescriptor REMOTE_PATH = new PropertyDescriptor.Builder().name("Remote Path").description("The path on the remote system from which to pull or push files").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).defaultValue(".").build();

    protected Map<String, String> createAttributes(FileInfo fileInfo, ProcessContext context) {
        int index;
        HashMap<String, String> attributes = new HashMap<String, String>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        attributes.put(this.getProtocolName() + ".remote.host", context.getProperty(HOSTNAME).evaluateAttributeExpressions().getValue());
        attributes.put(this.getProtocolName() + ".remote.port", context.getProperty(UNDEFAULTED_PORT).evaluateAttributeExpressions().getValue());
        attributes.put(this.getProtocolName() + ".listing.user", context.getProperty(USERNAME).evaluateAttributeExpressions().getValue());
        attributes.put("file.lastModifiedTime", formatter.format(new Date(fileInfo.getLastModifiedTime())));
        attributes.put("file.permissions", fileInfo.getPermissions());
        attributes.put("file.owner", fileInfo.getOwner());
        attributes.put("file.group", fileInfo.getGroup());
        attributes.put(CoreAttributes.FILENAME.key(), fileInfo.getFileName());
        String fullPath = fileInfo.getFullPathFileName();
        if (fullPath != null && (index = fullPath.lastIndexOf("/")) > -1) {
            String path = fullPath.substring(0, index);
            attributes.put(CoreAttributes.PATH.key(), path);
        }
        return attributes;
    }

    protected String getPath(ProcessContext context) {
        return context.getProperty(REMOTE_PATH).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<FileInfo> performListing(ProcessContext context, Long minTimestamp) throws IOException {
        List<FileInfo> listing;
        FileTransfer transfer = this.getFileTransfer(context);
        try {
            listing = transfer.getListing();
        }
        finally {
            IOUtils.closeQuietly((Closeable)transfer);
        }
        if (minTimestamp == null) {
            return listing;
        }
        Iterator<FileInfo> itr = listing.iterator();
        while (itr.hasNext()) {
            FileInfo next = itr.next();
            if (next.getLastModifiedTime() >= minTimestamp) continue;
            itr.remove();
        }
        return listing;
    }

    protected boolean isListingResetNecessary(PropertyDescriptor property) {
        return HOSTNAME.equals((Object)property) || REMOTE_PATH.equals((Object)property);
    }

    protected abstract FileTransfer getFileTransfer(ProcessContext var1);

    protected abstract String getProtocolName();
}

