/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.crypto.CipherUtility;
import org.apache.nifi.security.util.crypto.PBECipherProvider;
import org.slf4j.Logger;

public abstract class RandomIVPBECipherProvider
implements PBECipherProvider {
    static final byte[] SALT_DELIMITER = "NiFiSALT".getBytes(StandardCharsets.UTF_8);
    static final int MAX_SALT_LIMIT = 128;
    static final byte[] IV_DELIMITER = "NiFiIV".getBytes(StandardCharsets.UTF_8);
    static final int MAX_IV_LIMIT = 16;

    abstract Cipher getCipher(EncryptionMethod var1, String var2, byte[] var3, byte[] var4, int var5, boolean var6) throws Exception;

    abstract Logger getLogger();

    @Override
    public byte[] readSalt(InputStream in) throws IOException, ProcessException {
        return CipherUtility.readBytesFromInputStream((InputStream)in, (String)"salt", (int)128, (byte[])SALT_DELIMITER);
    }

    @Override
    public void writeSalt(byte[] salt, OutputStream out) throws IOException {
        CipherUtility.writeBytesToOutputStream((OutputStream)out, (byte[])salt, (String)"salt", (byte[])SALT_DELIMITER);
    }

    public byte[] readIV(InputStream in) throws IOException, ProcessException {
        return CipherUtility.readBytesFromInputStream((InputStream)in, (String)"IV", (int)16, (byte[])IV_DELIMITER);
    }

    public void writeIV(byte[] iv, OutputStream out) throws IOException {
        CipherUtility.writeBytesToOutputStream((OutputStream)out, (byte[])iv, (String)"IV", (byte[])IV_DELIMITER);
    }
}

