/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.event.transport.configuration.TransportProtocol;
import org.apache.nifi.event.transport.netty.ByteArrayNettyEventSenderFactory;
import org.apache.nifi.event.transport.netty.NettyEventSenderFactory;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.put.AbstractPutEventProcessor;
import org.apache.nifi.processors.standard.ListenUDP;
import org.apache.nifi.processors.standard.PutTCP;
import org.apache.nifi.util.StopWatch;

@CapabilityDescription(value="The PutUDP processor receives a FlowFile and packages the FlowFile content into a single UDP datagram packet which is then transmitted to the configured UDP server. The user must ensure that the FlowFile content being fed to this processor is not larger than the maximum size for the underlying UDP transport. The maximum transport size will vary based on the platform setup but is generally just under 64KB. FlowFiles will be marked as failed if their content is larger than the maximum transport size.")
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@SeeAlso(value={ListenUDP.class, PutTCP.class})
@Tags(value={"remote", "egress", "put", "udp"})
@SupportsBatching
public class PutUDP
extends AbstractPutEventProcessor<byte[]> {
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        ProcessSession session = sessionFactory.createSession();
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        StopWatch stopWatch = new StopWatch(true);
        try {
            byte[] content = this.readContent(session, flowFile);
            this.eventSender.sendEvent((Object)content);
            session.getProvenanceReporter().send(flowFile, this.transitUri, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            session.transfer(flowFile, REL_SUCCESS);
            session.commitAsync();
        }
        catch (Exception e) {
            this.getLogger().error("Send Failed {}", new Object[]{flowFile, e});
            session.transfer(session.penalize(flowFile), REL_FAILURE);
            session.commitAsync();
            context.yield();
        }
    }

    protected String getProtocol(ProcessContext context) {
        return UDP_VALUE.getValue();
    }

    protected NettyEventSenderFactory<byte[]> getNettyEventSenderFactory(String hostname, int port, String protocol) {
        return new ByteArrayNettyEventSenderFactory(this.getLogger(), hostname, port, TransportProtocol.UDP);
    }

    private byte[] readContent(ProcessSession session, FlowFile flowFile) throws IOException {
        try (InputStream inputStream = session.read(flowFile);){
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
    }
}

