/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"JSON", "schema", "validation"})
@WritesAttributes(value={@WritesAttribute(attribute="json.validation.errors", description="If the flow file is routed to the invalid relationship , this attribute will contain the error message resulting from the validation failure.")})
@CapabilityDescription(value="Validates the contents of FlowFiles against a configurable JSON Schema. See json-schema.org for specification standards.")
@SystemResourceConsideration(resource=SystemResource.MEMORY, description="Validating JSON requires reading FlowFile content into memory")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.REFERENCE_REMOTE_RESOURCES, explanation="Schema configuration can reference resources over HTTP")})
public class ValidateJson
extends AbstractProcessor {
    public static final String ERROR_ATTRIBUTE_KEY = "json.validation.errors";
    public static final PropertyDescriptor SCHEMA_CONTENT = new PropertyDescriptor.Builder().name("JSON Schema").displayName("JSON Schema").description("The content of a JSON Schema").required(true).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[]{ResourceType.URL, ResourceType.TEXT}).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor SCHEMA_VERSION = new PropertyDescriptor.Builder().name("Schema Version").displayName("Schema Version").description("The JSON schema specification").required(true).allowableValues(SchemaVersion.class).defaultValue(SchemaVersion.DRAFT_2020_12.getValue()).build();
    public static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(SCHEMA_CONTENT, SCHEMA_VERSION));
    public static final Relationship REL_VALID = new Relationship.Builder().name("valid").description("FlowFiles that are successfully validated against the schema are routed to this relationship").build();
    public static final Relationship REL_INVALID = new Relationship.Builder().name("invalid").description("FlowFiles that are not valid according to the specified schema are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that cannot be read as JSON are routed to this relationship").build();
    public static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_VALID, REL_INVALID, REL_FAILURE)));
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private JsonSchema schema;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        try (InputStream inputStream = context.getProperty(SCHEMA_CONTENT).asResource().read();){
            SchemaVersion schemaVersion = SchemaVersion.valueOf(context.getProperty(SCHEMA_VERSION).getValue());
            JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)schemaVersion.getVersionFlag());
            this.schema = factory.getSchema(inputStream);
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try (InputStream in = session.read(flowFile);){
            JsonNode node = MAPPER.readTree(in);
            Set errors = this.schema.validate(node);
            if (errors.isEmpty()) {
                this.getLogger().debug("JSON {} valid", new Object[]{flowFile});
                session.getProvenanceReporter().route(flowFile, REL_VALID);
                session.transfer(flowFile, REL_VALID);
            } else {
                String validationMessages = errors.toString();
                flowFile = session.putAttribute(flowFile, ERROR_ATTRIBUTE_KEY, validationMessages);
                this.getLogger().warn("JSON {} invalid: Validation Errors {}", new Object[]{flowFile, validationMessages});
                session.getProvenanceReporter().route(flowFile, REL_INVALID);
                session.transfer(flowFile, REL_INVALID);
            }
        }
        catch (Exception e) {
            this.getLogger().error("JSON processing failed {}", new Object[]{flowFile, e});
            session.getProvenanceReporter().route(flowFile, REL_FAILURE);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    static {
        MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }

    public static enum SchemaVersion implements DescribedValue
    {
        DRAFT_4("Draft Version 4", "Draft 4", SpecVersion.VersionFlag.V4),
        DRAFT_6("Draft Version 6", "Draft 6", SpecVersion.VersionFlag.V6),
        DRAFT_7("Draft Version 7", "Draft 7", SpecVersion.VersionFlag.V7),
        DRAFT_2019_09("Draft Version 2019-09", "Draft 2019-09", SpecVersion.VersionFlag.V201909),
        DRAFT_2020_12("Draft Version 2020-12", "Draft 2020-12", SpecVersion.VersionFlag.V202012);

        private final String description;
        private final String displayName;
        private final SpecVersion.VersionFlag versionFlag;

        private SchemaVersion(String description, String displayName, SpecVersion.VersionFlag versionFlag) {
            this.description = description;
            this.displayName = displayName;
            this.versionFlag = versionFlag;
        }

        public String getValue() {
            return this.name();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }

        public SpecVersion.VersionFlag getVersionFlag() {
            return this.versionFlag;
        }
    }
}

