/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.http;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.processors.standard.http.CertificateAttribute;
import org.apache.nifi.processors.standard.http.CertificateAttributesProvider;

public class HandleHttpRequestCertificateAttributesProvider
implements CertificateAttributesProvider {
    protected static final String REQUEST_CERTIFICATES_ATTRIBUTE_NAME = "javax.servlet.request.X509Certificate";
    private static final String SAN_NAME_TYPE_FORMAT = "%s.%d.nameType";
    private static final String SAN_NAME_FORMAT = "%s.%d.name";
    private static final Map<String, String> GENERAL_NAME_TYPES = new LinkedHashMap<String, String>();

    @Override
    public Map<String, String> getCertificateAttributes(HttpServletRequest request) {
        Map<String, String> attributes;
        Objects.requireNonNull(request, "HTTP Servlet Request required");
        Object requestCertificates = request.getAttribute(REQUEST_CERTIFICATES_ATTRIBUTE_NAME);
        if (requestCertificates instanceof X509Certificate[]) {
            X509Certificate[] certificates = (X509Certificate[])requestCertificates;
            if (certificates.length == 0) {
                attributes = Collections.emptyMap();
            } else {
                X509Certificate clientCertificate = certificates[0];
                attributes = this.getCertificateAttributes(clientCertificate);
            }
        } else {
            attributes = Collections.emptyMap();
        }
        return attributes;
    }

    private Map<String, String> getCertificateAttributes(X509Certificate certificate) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        String subjectPrincipal = certificate.getSubjectX500Principal().getName();
        String issuerPrincipal = certificate.getIssuerX500Principal().getName();
        attributes.put(CertificateAttribute.HTTP_SUBJECT_DN.getName(), subjectPrincipal);
        attributes.put(CertificateAttribute.HTTP_ISSUER_DN.getName(), issuerPrincipal);
        try {
            Collection<List<?>> subjectAlternativeNames = certificate.getSubjectAlternativeNames();
            if (subjectAlternativeNames != null) {
                Map<String, String> subjectAlternativeNameAttributes = this.getSubjectAlternativeNameAttributes(subjectAlternativeNames);
                attributes.putAll(subjectAlternativeNameAttributes);
            }
        }
        catch (CertificateParsingException e) {
            attributes.put(CertificateAttribute.HTTP_CERTIFICATE_PARSING_EXCEPTION.getName(), e.getMessage());
        }
        return attributes;
    }

    private Map<String, String> getSubjectAlternativeNameAttributes(Collection<List<?>> subjectAlternativeNames) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        int subjectAlternativeNameIndex = 0;
        for (List<?> subjectAlternativeTypeName : subjectAlternativeNames) {
            String nameTypeAttributeKey = String.format(SAN_NAME_TYPE_FORMAT, CertificateAttribute.HTTP_CERTIFICATE_SANS.getName(), subjectAlternativeNameIndex);
            String nameType = subjectAlternativeTypeName.get(0).toString();
            String generalNameType = GENERAL_NAME_TYPES.getOrDefault(nameType, nameType);
            attributes.put(nameTypeAttributeKey, generalNameType);
            String nameAttributeKey = String.format(SAN_NAME_FORMAT, CertificateAttribute.HTTP_CERTIFICATE_SANS.getName(), subjectAlternativeNameIndex);
            Object name = subjectAlternativeTypeName.get(1);
            String serializedName = this.getSerializedName(name);
            attributes.put(nameAttributeKey, serializedName);
            ++subjectAlternativeNameIndex;
        }
        return attributes;
    }

    private String getSerializedName(Object name) {
        String serializedName;
        if (name instanceof byte[]) {
            byte[] encodedName = (byte[])name;
            serializedName = Base64.getEncoder().encodeToString(encodedName);
        } else {
            serializedName = name.toString();
        }
        return serializedName;
    }

    static {
        GENERAL_NAME_TYPES.put("0", "otherName");
        GENERAL_NAME_TYPES.put("1", "rfc822Name");
        GENERAL_NAME_TYPES.put("2", "dNSName");
        GENERAL_NAME_TYPES.put("3", "x400Address");
        GENERAL_NAME_TYPES.put("4", "directoryName");
        GENERAL_NAME_TYPES.put("5", "ediPartyName");
        GENERAL_NAME_TYPES.put("6", "uniformResourceIdentifier");
        GENERAL_NAME_TYPES.put("7", "iPAddress");
        GENERAL_NAME_TYPES.put("8", "registeredID");
    }
}

