/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.pattern.DiscontinuedException;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.processors.standard.db.TableNotFoundException;
import org.apache.nifi.processors.standard.db.TableSchema;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.util.StringUtils;

@Tags(value={"metadata", "jdbc", "database", "table", "update", "alter"})
@CapabilityDescription(value="This processor uses a JDBC connection and incoming records to generate any database table changes needed to support the incoming records. It expects a 'flat' record layout, meaning none of the top-level record fields has nested fields that are intended to become columns themselves.")
@WritesAttributes(value={@WritesAttribute(attribute="output.table", description="This attribute is written on the flow files routed to the 'success' and 'failure' relationships, and contains the target table name."), @WritesAttribute(attribute="output.path", description="This attribute is written on the flow files routed to the 'success' and 'failure' relationships, and contains the path on the file system to the table (or partition location if the table is partitioned)."), @WritesAttribute(attribute="mime.type", description="Sets the mime.type attribute to the MIME Type specified by the Record Writer, only if a Record Writer is specified and Update Field Names is 'true'."), @WritesAttribute(attribute="record.count", description="Sets the number of records in the FlowFile, only if a Record Writer is specified and Update Field Names is 'true'.")})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
public class UpdateDatabaseTable
extends AbstractProcessor {
    static final AllowableValue CREATE_IF_NOT_EXISTS = new AllowableValue("Create If Not Exists", "Create If Not Exists", "Create a table with the given schema if it does not already exist");
    static final AllowableValue FAIL_IF_NOT_EXISTS = new AllowableValue("Fail If Not Exists", "Fail If Not Exists", "If the target does not already exist, log an error and route the flowfile to failure");
    static final String ATTR_OUTPUT_TABLE = "output.table";
    static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("record-reader").displayName("Record Reader").description("The service for reading incoming flow files. The reader is only used to determine the schema of the records, the actual records will not be processed.").identifiesControllerService(RecordReaderFactory.class).required(true).build();
    static final PropertyDescriptor DBCP_SERVICE = new PropertyDescriptor.Builder().name("updatedatabasetable-dbcp-service").displayName("Database Connection Pooling Service").description("The Controller Service that is used to obtain connection(s) to the database").required(true).identifiesControllerService(DBCPService.class).build();
    static final PropertyDescriptor CATALOG_NAME = new PropertyDescriptor.Builder().name("updatedatabasetable-catalog-name").displayName("Catalog Name").description("The name of the catalog that the statement should update. This may not apply for the database that you are updating. In this case, leave the field empty. Note that if the property is set and the database is case-sensitive, the catalog name must match the database's catalog name exactly.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor SCHEMA_NAME = new PropertyDescriptor.Builder().name("updatedatabasetable-schema-name").displayName("Schema Name").description("The name of the database schema that the table belongs to. This may not apply for the database that you are updating. In this case, leave the field empty. Note that if the property is set and the database is case-sensitive, the schema name must match the database's schema name exactly.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor TABLE_NAME = new PropertyDescriptor.Builder().name("updatedatabasetable-table-name").displayName("Table Name").description("The name of the database table to update. If the table does not exist, then it will either be created or an error thrown, depending on the value of the Create Table property.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor CREATE_TABLE = new PropertyDescriptor.Builder().name("updatedatabasetable-create-table").displayName("Create Table Strategy").description("Specifies how to process the target table when it does not exist (create it, fail, e.g.).").required(true).addValidator(Validator.VALID).allowableValues(new AllowableValue[]{CREATE_IF_NOT_EXISTS, FAIL_IF_NOT_EXISTS}).defaultValue(FAIL_IF_NOT_EXISTS.getValue()).build();
    static final PropertyDescriptor PRIMARY_KEY_FIELDS = new PropertyDescriptor.Builder().name("updatedatabasetable-primary-keys").displayName("Primary Key Fields").description("A comma-separated list of record field names that uniquely identifies a row in the database. This property is only used if the specified table needs to be created, in which case the Primary Key Fields will be used to specify the primary keys of the newly-created table. IMPORTANT: Primary Key Fields must match the record field names exactly unless 'Quote Column Identifiers' is false and the database allows for case-insensitive column names. In practice it is best to specify Primary Key Fields that exactly match the record field names, and those will become the column names in the created table.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(CREATE_TABLE, new AllowableValue[]{CREATE_IF_NOT_EXISTS}).build();
    static final PropertyDescriptor TRANSLATE_FIELD_NAMES = new PropertyDescriptor.Builder().name("updatedatabasetable-translate-field-names").displayName("Translate Field Names").description("If true, the Processor will attempt to translate field names into the corresponding column names for the table specified, for the purposes of determining whether the field name exists as a column in the target table. NOTE: If the target table does not exist and is to be created, this property is ignored and the field names will be used as-is. If false, the field names must match the column names exactly, or the column may not be found and instead an error my be reported that the column already exists.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    static final PropertyDescriptor UPDATE_FIELD_NAMES = new PropertyDescriptor.Builder().name("updatedatabasetable-update-field-names").displayName("Update Field Names").description("This property indicates whether to update the output schema such that the field names are set to the exact column names from the specified table. This should be used if the incoming record field names may not match the table's column names in terms of upper- and lower-case. For example, this property should be set to true if the output FlowFile is destined for Oracle e.g., which expects the field names to match the column names exactly. NOTE: The value of the 'Translate Field Names' property is ignored when updating field names; instead they are updated to match the column name as returned by the database.").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    static final PropertyDescriptor RECORD_WRITER_FACTORY = new PropertyDescriptor.Builder().name("updatedatabasetable-record-writer").displayName("Record Writer").description("Specifies the Controller Service to use for writing results to a FlowFile. The Record Writer should use Inherit Schema to emulate the inferred schema behavior, i.e. an explicit schema need not be defined in the writer, and will be supplied by the same logic used to infer the schema from the column types. If Create Table Strategy is set 'Create If Not Exists', the Record Writer's output format must match the Record Reader's format in order for the data to be placed in the created table location. Note that this property is only used if 'Update Field Names' is set to true and the field names do not all match the column names exactly. If no update is needed for any field names (or 'Update Field Names' is false), the Record Writer is not used and instead the input FlowFile is routed to success or failure without modification.").identifiesControllerService(RecordSetWriterFactory.class).dependsOn(UPDATE_FIELD_NAMES, "true", new String[0]).required(true).build();
    static final PropertyDescriptor QUOTE_COLUMN_IDENTIFIERS = new PropertyDescriptor.Builder().name("updatedatabasetable-quoted-column-identifiers").displayName("Quote Column Identifiers").description("Enabling this option will cause all column names to be quoted, allowing you to use reserved words as column names in your tables and/or forcing the record field names to match the column names exactly.").allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor QUOTE_TABLE_IDENTIFIER = new PropertyDescriptor.Builder().name("updatedatabasetable-quoted-table-identifiers").displayName("Quote Table Identifiers").description("Enabling this option will cause the table name to be quoted to support the use of special characters in the table name and/or forcing the value of the Table Name property to match the target table name exactly.").allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor QUERY_TIMEOUT = new PropertyDescriptor.Builder().name("updatedatabasetable-query-timeout").displayName("Query Timeout").description("Sets the number of seconds the driver will wait for a query to execute. A value of 0 means no timeout. NOTE: Non-zero values may not be supported by the driver.").defaultValue("0").required(true).addValidator(StandardValidators.INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor DB_TYPE;
    public static final Relationship REL_SUCCESS;
    public static final Relationship REL_FAILURE;
    protected static final Map<String, DatabaseAdapter> dbAdapters;
    private static final List<PropertyDescriptor> propertyDescriptors;
    protected static Set<Relationship> relationships;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        boolean recordWriterFactorySet = validationContext.getProperty(RECORD_WRITER_FACTORY).isSet();
        boolean updateFieldNames = validationContext.getProperty(UPDATE_FIELD_NAMES).asBoolean();
        if (!recordWriterFactorySet && updateFieldNames) {
            validationResults.add(new ValidationResult.Builder().subject(RECORD_WRITER_FACTORY.getDisplayName()).explanation("Record Writer must be set if 'Update Field Names' is true").valid(false).build());
        }
        DatabaseAdapter databaseAdapter = dbAdapters.get(validationContext.getProperty(DB_TYPE).getValue());
        boolean createIfNotExists = CREATE_IF_NOT_EXISTS.getValue().equals(validationContext.getProperty(CREATE_TABLE).getValue());
        if (createIfNotExists && !databaseAdapter.supportsCreateTableIfNotExists()) {
            validationResults.add(new ValidationResult.Builder().subject(CREATE_TABLE.getDisplayName()).explanation("The specified Database Type does not support Create If Not Exists").valid(false).build());
        }
        return validationResults;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        RecordReaderFactory recordReaderFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
        RecordSetWriterFactory recordWriterFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER_FACTORY).asControllerService(RecordSetWriterFactory.class);
        String catalogName = context.getProperty(CATALOG_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String schemaName = context.getProperty(SCHEMA_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String tableName = context.getProperty(TABLE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String primaryKeyFields = context.getProperty(PRIMARY_KEY_FIELDS).evaluateAttributeExpressions(flowFile).getValue();
        ComponentLog log = this.getLogger();
        try {
            RecordReader reader;
            try (InputStream in2 = session.read(flowFile);){
                try {
                    reader = recordReaderFactory.createRecordReader(flowFile, in2, this.getLogger());
                }
                catch (Exception e) {
                    throw new ProcessException("Unable to create RecordReader", (Throwable)e);
                }
            }
            catch (ProcessException rrfe) {
                log.error("Failed to create {} for {} - routing to failure", new Object[]{RecordReader.class.getSimpleName(), flowFile, rrfe});
                Throwable c = rrfe.getCause();
                if (c != null) {
                    session.putAttribute(flowFile, "record.error.message", c.getLocalizedMessage() != null ? c.getLocalizedMessage() : c.getClass().getCanonicalName() + " Thrown");
                } else {
                    session.putAttribute(flowFile, "record.error.message", ((Object)((Object)rrfe)).getClass().getCanonicalName() + " Thrown");
                }
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            RecordSchema recordSchema = reader.getSchema();
            boolean createIfNotExists = context.getProperty(CREATE_TABLE).getValue().equals(CREATE_IF_NOT_EXISTS.getValue());
            boolean updateFieldNames = context.getProperty(UPDATE_FIELD_NAMES).asBoolean();
            boolean translateFieldNames = context.getProperty(TRANSLATE_FIELD_NAMES).asBoolean();
            if (recordWriterFactory == null && updateFieldNames) {
                throw new ProcessException("Record Writer must be set if 'Update Field Names' is true");
            }
            DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
            DatabaseAdapter databaseAdapter = dbAdapters.get(context.getProperty(DB_TYPE).getValue());
            try (Connection connection = dbcpService.getConnection();){
                HashSet<String> primaryKeyColumnNames;
                boolean quoteTableName = context.getProperty(QUOTE_TABLE_IDENTIFIER).asBoolean();
                boolean quoteColumnNames = context.getProperty(QUOTE_COLUMN_IDENTIFIERS).asBoolean();
                HashMap<String, String> attributes = new HashMap<String, String>(flowFile.getAttributes());
                if (createIfNotExists && primaryKeyFields != null) {
                    primaryKeyColumnNames = new HashSet<String>();
                    Arrays.stream(primaryKeyFields.split(",")).filter(path -> path != null && !path.trim().isEmpty()).map(String::trim).forEach(primaryKeyColumnNames::add);
                } else {
                    primaryKeyColumnNames = null;
                }
                OutputMetadataHolder outputMetadataHolder = this.checkAndUpdateTableSchema(connection, databaseAdapter, recordSchema, catalogName, schemaName, tableName, createIfNotExists, translateFieldNames, updateFieldNames, primaryKeyColumnNames, quoteTableName, quoteColumnNames);
                if (outputMetadataHolder != null) {
                    try {
                        FlowFile inputFlowFile = flowFile;
                        flowFile = session.write(flowFile, (in, out) -> {
                            RecordSetWriter recordSetWriter;
                            RecordReader recordReader;
                            try {
                                recordReader = recordReaderFactory.createRecordReader(inputFlowFile, in, this.getLogger());
                                recordSetWriter = recordWriterFactory.createWriter(this.getLogger(), outputMetadataHolder.getOutputSchema(), out, attributes);
                            }
                            catch (Exception e) {
                                if (e instanceof IOException) {
                                    throw (IOException)e;
                                }
                                throw new IOException("Unable to create RecordReader", e);
                            }
                            WriteResult writeResult = this.updateRecords(recordSchema, outputMetadataHolder, recordReader, recordSetWriter);
                            recordSetWriter.flush();
                            recordSetWriter.close();
                            attributes.put("record.count", String.valueOf(writeResult.getRecordCount()));
                            attributes.put(CoreAttributes.MIME_TYPE.key(), recordSetWriter.getMimeType());
                            attributes.putAll(writeResult.getAttributes());
                        });
                    }
                    catch (Exception e) {
                        this.getLogger().error("Failed to process {}; will route to failure", new Object[]{flowFile, e});
                        Throwable c = e.getCause();
                        if (c != null) {
                            session.putAttribute(flowFile, "record.error.message", c.getLocalizedMessage() != null ? c.getLocalizedMessage() : c.getClass().getCanonicalName() + " Thrown");
                        } else {
                            session.putAttribute(flowFile, "record.error.message", e.getClass().getCanonicalName() + " Thrown");
                        }
                        session.transfer(flowFile, REL_FAILURE);
                        if (connection != null) {
                            if (var19_30 != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable) {
                                    var19_30.addSuppressed(throwable);
                                }
                            } else {
                                connection.close();
                            }
                        }
                        return;
                    }
                }
                attributes.put(ATTR_OUTPUT_TABLE, tableName);
                flowFile = session.putAllAttributes(flowFile, attributes);
                session.getProvenanceReporter().invokeRemoteProcess(flowFile, this.getJdbcUrl(connection));
                session.transfer(flowFile, REL_SUCCESS);
            }
        }
        catch (IOException | SQLException e) {
            flowFile = session.putAttribute(flowFile, ATTR_OUTPUT_TABLE, tableName);
            log.error("Exception while processing {} - routing to failure", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
        }
        catch (DiscontinuedException e) {
            this.getLogger().warn("Discontinued processing for {} due to {}", new Object[]{flowFile, e, e});
            session.transfer(flowFile, Relationship.SELF);
        }
        catch (Throwable t) {
            throw t instanceof ProcessException ? (ProcessException)t : new ProcessException(t);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized OutputMetadataHolder checkAndUpdateTableSchema(Connection conn, DatabaseAdapter databaseAdapter, RecordSchema schema, String catalogName, String schemaName, String tableName, boolean createIfNotExists, boolean translateFieldNames, boolean updateFieldNames, Set<String> primaryKeyColumnNames, boolean quoteTableName, boolean quoteColumnNames) throws IOException {
        try (Statement s = conn.createStatement();){
            void var20_31;
            TableSchema tableSchema = null;
            try {
                tableSchema = TableSchema.from(conn, catalogName, schemaName, tableName, translateFieldNames, null, this.getLogger());
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            ArrayList<ColumnDescription> columns = new ArrayList<ColumnDescription>();
            boolean tableCreated = false;
            if (tableSchema == null) {
                if (!createIfNotExists) throw new IOException("The table " + tableName + " could not be found in the database and the processor is configured not to create it.");
                for (RecordField recordField : schema.getFields()) {
                    String string = recordField.getFieldName();
                    boolean required = recordField.getDefaultValue() != null;
                    columns.add(new ColumnDescription(string, DataTypeUtils.getSQLTypeValue((DataType)recordField.getDataType()), required, null, recordField.isNullable()));
                    this.getLogger().debug("Adding column " + string + " to table " + tableName);
                }
                tableSchema = new TableSchema(catalogName, schemaName, tableName, columns, translateFieldNames, primaryKeyColumnNames, databaseAdapter.getColumnQuoteString());
                String createTableSql = databaseAdapter.getCreateTableStatement(tableSchema, quoteTableName, quoteColumnNames);
                if (StringUtils.isNotEmpty((String)createTableSql)) {
                    this.getLogger().info("Executing DDL: " + createTableSql);
                    s.execute(createTableSql);
                }
                tableCreated = true;
            }
            ArrayList<String> dbColumns = new ArrayList<String>();
            for (ColumnDescription columnDescription : tableSchema.getColumnsAsList()) {
                dbColumns.add(ColumnDescription.normalizeColumnName(columnDescription.getColumnName(), translateFieldNames));
            }
            ArrayList<ColumnDescription> columnsToAdd = new ArrayList<ColumnDescription>();
            if (!tableCreated) {
                List<String> list;
                for (RecordField recordField : schema.getFields()) {
                    String recordFieldName = recordField.getFieldName();
                    String normalizedFieldName = ColumnDescription.normalizeColumnName(recordFieldName, translateFieldNames);
                    if (dbColumns.contains(normalizedFieldName)) continue;
                    ColumnDescription columnToAdd = new ColumnDescription(recordFieldName, DataTypeUtils.getSQLTypeValue((DataType)recordField.getDataType()), recordField.getDefaultValue() != null, null, recordField.isNullable());
                    columnsToAdd.add(columnToAdd);
                    dbColumns.add(recordFieldName);
                    this.getLogger().debug("Adding column " + recordFieldName + " to table " + tableName);
                }
                if (!columnsToAdd.isEmpty() && (list = databaseAdapter.getAlterTableStatements(tableName, columnsToAdd, quoteTableName, quoteColumnNames)) != null && !list.isEmpty()) {
                    for (String alterTableSql : list) {
                        if (StringUtils.isEmpty((String)alterTableSql)) continue;
                        this.getLogger().info("Executing DDL: " + alterTableSql);
                        s.execute(alterTableSql);
                    }
                }
            }
            if (updateFieldNames) {
                List inputRecordFields = schema.getFields();
                ArrayList<RecordField> outputRecordFields = new ArrayList<RecordField>();
                HashMap<String, String> fieldMap = new HashMap<String, String>();
                boolean needsUpdating = false;
                for (RecordField inputRecordField : inputRecordFields) {
                    String inputRecordFieldName = inputRecordField.getFieldName();
                    boolean found = false;
                    for (String columnName : dbColumns) {
                        if (!inputRecordFieldName.equalsIgnoreCase(columnName)) continue;
                        if (!inputRecordFieldName.equals(columnName)) {
                            needsUpdating = true;
                        }
                        fieldMap.put(inputRecordFieldName, columnName);
                        outputRecordFields.add(new RecordField(columnName, inputRecordField.getDataType(), inputRecordField.getDefaultValue(), inputRecordField.isNullable()));
                        found = true;
                        break;
                    }
                    if (found) continue;
                    fieldMap.put(inputRecordFieldName, inputRecordFieldName);
                }
                OutputMetadataHolder outputMetadataHolder = needsUpdating ? new OutputMetadataHolder((RecordSchema)new SimpleRecordSchema(outputRecordFields), fieldMap) : null;
            } else {
                Object var20_30 = null;
            }
            void var21_36 = var20_31;
            return var21_36;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private synchronized WriteResult updateRecords(RecordSchema inputRecordSchema, OutputMetadataHolder outputMetadataHolder, RecordReader reader, RecordSetWriter writer) throws IOException {
        try {
            Record inputRecord;
            writer.beginRecordSet();
            while ((inputRecord = reader.nextRecord()) != null) {
                List inputRecordFields = inputRecordSchema.getFields();
                HashMap<String, Object> outputRecordFields = new HashMap<String, Object>(inputRecordFields.size());
                for (Map.Entry<String, String> mapping : outputMetadataHolder.getFieldMap().entrySet()) {
                    outputRecordFields.put(mapping.getValue(), inputRecord.getValue(mapping.getKey()));
                }
                MapRecord outputRecord = new MapRecord(outputMetadataHolder.getOutputSchema(), outputRecordFields);
                writer.write((Record)outputRecord);
            }
            return writer.finishRecordSet();
        }
        catch (MalformedRecordException mre) {
            throw new IOException("Error reading records: " + mre.getMessage(), mre);
        }
    }

    private String getJdbcUrl(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData != null) {
                return databaseMetaData.getURL();
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Could not determine JDBC URL based on the Driver Connection.", (Throwable)e);
        }
        return "DBCPService";
    }

    static {
        REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile containing records routed to this relationship after the record has been successfully transmitted to the database.").build();
        REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile containing records routed to this relationship if the record could not be transmitted to the database.").build();
        dbAdapters = new HashMap<String, DatabaseAdapter>();
        ArrayList dbAdapterValues = new ArrayList();
        ServiceLoader<DatabaseAdapter> dbAdapterLoader = ServiceLoader.load(DatabaseAdapter.class);
        dbAdapterLoader.forEach(databaseAdapter -> {
            dbAdapters.put(databaseAdapter.getName(), (DatabaseAdapter)databaseAdapter);
            dbAdapterValues.add(new AllowableValue(databaseAdapter.getName(), databaseAdapter.getName(), databaseAdapter.getDescription()));
        });
        DB_TYPE = new PropertyDescriptor.Builder().name("db-type").displayName("Database Type").description("The type/flavor of database, used for generating database-specific code. In many cases the Generic type should suffice, but some databases (such as Oracle) require custom SQL clauses.").allowableValues(dbAdapterValues.toArray(new AllowableValue[0])).defaultValue("Generic").required(false).build();
        HashSet<Relationship> r = new HashSet<Relationship>();
        r.add(REL_SUCCESS);
        r.add(REL_FAILURE);
        relationships = Collections.unmodifiableSet(r);
        ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        pds.add(RECORD_READER);
        pds.add(DBCP_SERVICE);
        pds.add(DB_TYPE);
        pds.add(CATALOG_NAME);
        pds.add(SCHEMA_NAME);
        pds.add(TABLE_NAME);
        pds.add(CREATE_TABLE);
        pds.add(PRIMARY_KEY_FIELDS);
        pds.add(TRANSLATE_FIELD_NAMES);
        pds.add(UPDATE_FIELD_NAMES);
        pds.add(RECORD_WRITER_FACTORY);
        pds.add(QUOTE_TABLE_IDENTIFIER);
        pds.add(QUOTE_COLUMN_IDENTIFIERS);
        pds.add(QUERY_TIMEOUT);
        propertyDescriptors = Collections.unmodifiableList(pds);
    }

    private static class OutputMetadataHolder {
        private final RecordSchema outputSchema;
        private final Map<String, String> fieldMap;

        public OutputMetadataHolder(RecordSchema outputSchema, Map<String, String> fieldMap) {
            this.outputSchema = outputSchema;
            this.fieldMap = fieldMap;
        }

        public RecordSchema getOutputSchema() {
            return this.outputSchema;
        }

        public Map<String, String> getFieldMap() {
            return this.fieldMap;
        }
    }
}

