/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;

public class GenericDatabaseAdapter
implements DatabaseAdapter {
    @Override
    public String getName() {
        return "Generic";
    }

    @Override
    public String getDescription() {
        return "Generates ANSI SQL";
    }

    @Override
    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name cannot be null or empty");
        }
        StringBuilder query = new StringBuilder("SELECT ");
        if (StringUtils.isEmpty((CharSequence)columnNames) || columnNames.trim().equals("*")) {
            query.append("*");
        } else {
            query.append(columnNames);
        }
        query.append(" FROM ");
        query.append(tableName);
        if (!StringUtils.isEmpty((CharSequence)whereClause)) {
            query.append(" WHERE ");
            query.append(whereClause);
        }
        if (!StringUtils.isEmpty((CharSequence)orderByClause)) {
            query.append(" ORDER BY ");
            query.append(orderByClause);
        }
        if (limit != null) {
            query.append(" LIMIT ");
            query.append(limit);
        }
        if (offset != null && offset > 0L) {
            query.append(" OFFSET ");
            query.append(offset);
        }
        return query.toString();
    }
}

