/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.syslog;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.processors.standard.syslog.SyslogEvent;

public class SyslogParser {
    public static final String SYSLOG_MSG_RFC5424_0 = "(?:\\<(\\d{1,3})\\>)(?:(\\d)?\\s?)(?:(\\d{4}[-]\\d{2}[-]\\d{2}[T]\\d{2}[:]\\d{2}[:]\\d{2}(?:\\.\\d{1,6})?(?:[+-]\\d{2}[:]\\d{2}|Z)?)|-)\\s(?:([\\w][\\w\\d\\.@\\-]*)|-)\\s(.*)$";
    public static final String SYSLOG_MSG_RFC3164_0 = "(?:\\<(\\d{1,3})\\>)(?:(\\d)?\\s?)([A-Z][a-z][a-z]\\s{1,2}\\d{1,2}\\s\\d{2}[:]\\d{2}[:]\\d{2})\\s([\\w][\\w\\d(\\.|\\:)@-]*)\\s(.*)$";
    public static final Collection<Pattern> MESSAGE_PATTERNS;
    public static final int SYSLOG_PRIORITY_POS = 1;
    public static final int SYSLOG_VERSION_POS = 2;
    public static final int SYSLOG_TIMESTAMP_POS = 3;
    public static final int SYSLOG_HOSTNAME_POS = 4;
    public static final int SYSLOG_BODY_POS = 5;
    private Charset charset;

    public SyslogParser() {
        this(StandardCharsets.UTF_8);
    }

    public SyslogParser(Charset charset) {
        this.charset = charset;
    }

    public SyslogEvent parseEvent(ByteBuffer buffer) {
        return this.parseEvent(buffer, null);
    }

    public SyslogEvent parseEvent(ByteBuffer buffer, String sender) {
        if (buffer == null) {
            return null;
        }
        if (buffer.position() != 0) {
            buffer.flip();
        }
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes, 0, buffer.limit());
        return this.parseEvent(bytes, sender);
    }

    public SyslogEvent parseEvent(byte[] bytes, String sender) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        int length = bytes.length;
        if (bytes[length - 1] == 10) {
            --length;
        }
        String message = new String(bytes, 0, length, this.charset);
        SyslogEvent.Builder builder = new SyslogEvent.Builder().valid(false).fullMessage(message).rawMessage(bytes).sender(sender);
        for (Pattern pattern : MESSAGE_PATTERNS) {
            Matcher matcher = pattern.matcher(message);
            if (!matcher.matches()) continue;
            MatchResult res = matcher.toMatchResult();
            for (int grp = 1; grp <= res.groupCount(); ++grp) {
                String value = res.group(grp);
                if (grp == 3) {
                    builder.timestamp(value);
                    continue;
                }
                if (grp == 4) {
                    builder.hostname(value);
                    continue;
                }
                if (grp == 1) {
                    int pri = Integer.parseInt(value);
                    int sev = pri % 8;
                    int facility = pri / 8;
                    builder.priority(value);
                    builder.severity(String.valueOf(sev));
                    builder.facility(String.valueOf(facility));
                    continue;
                }
                if (grp == 2) {
                    builder.version(value);
                    continue;
                }
                if (grp != 5) continue;
                builder.msgBody(value);
            }
            builder.valid(true);
            break;
        }
        return builder.build();
    }

    public String getCharsetName() {
        return this.charset == null ? StandardCharsets.UTF_8.name() : this.charset.name();
    }

    static {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        patterns.add(Pattern.compile(SYSLOG_MSG_RFC5424_0));
        patterns.add(Pattern.compile(SYSLOG_MSG_RFC3164_0));
        MESSAGE_PATTERNS = Collections.unmodifiableList(patterns);
    }
}

