/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.function.Function;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.util.StandardValidators;

public class JdbcCommon {
    private static final int MAX_DIGITS_IN_BIGINT = 19;
    private static final int MAX_DIGITS_IN_INT = 9;
    private static final int DEFAULT_PRECISION_VALUE = 10;
    private static final int DEFAULT_SCALE_VALUE = 0;
    public static final String MIME_TYPE_AVRO_BINARY = "application/avro-binary";
    public static final PropertyDescriptor NORMALIZE_NAMES_FOR_AVRO = new PropertyDescriptor.Builder().name("dbf-normalize").displayName("Normalize Table/Column Names").description("Whether to change non-Avro-compatible characters in column names to Avro-compatible characters. For example, colons and periods will be changed to underscores in order to build a valid Avro record.").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final PropertyDescriptor USE_AVRO_LOGICAL_TYPES = new PropertyDescriptor.Builder().name("dbf-user-logical-types").displayName("Use Avro Logical Types").description("Whether to use Avro Logical Types for DECIMAL/NUMBER, DATE, TIME and TIMESTAMP columns. If disabled, written as string. If enabled, Logical types are used and written as its underlying type, specifically, DECIMAL/NUMBER as logical 'decimal': written as bytes with additional precision and scale meta data, DATE as logical 'date-millis': written as int denoting days since Unix epoch (1970-01-01), TIME as logical 'time-millis': written as int denoting milliseconds since Unix epoch, and TIMESTAMP as logical 'timestamp-millis': written as long denoting milliseconds since Unix epoch. If a reader of written Avro records also knows these logical types, then these values can be deserialized with more context depending on reader implementation.").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final PropertyDescriptor DEFAULT_PRECISION = new PropertyDescriptor.Builder().name("dbf-default-precision").displayName("Default Decimal Precision").description("When a DECIMAL/NUMBER value is written as a 'decimal' Avro logical type, a specific 'precision' denoting number of available digits is required. Generally, precision is defined by column data type definition or database engines default. However undefined precision (0) can be returned from some database engines. 'Default Decimal Precision' is used when writing those undefined precision numbers.").defaultValue(String.valueOf(10)).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).expressionLanguageSupported(true).required(true).build();
    public static final PropertyDescriptor DEFAULT_SCALE = new PropertyDescriptor.Builder().name("dbf-default-scale").displayName("Default Decimal Scale").description("When a DECIMAL/NUMBER value is written as a 'decimal' Avro logical type, a specific 'scale' denoting number of available decimal digits is required. Generally, scale is defined by column data type definition or database engines default. However when undefined precision (0) is returned, scale can also be uncertain with some database engines. 'Default Decimal Scale' is used when writing those undefined numbers. If a value has more decimals than specified scale, then the value will be rounded-up, e.g. 1.53 becomes 2 with scale 0, and 1.5 with scale 1.").defaultValue(String.valueOf(0)).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(true).required(true).build();

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, boolean convertNames) throws SQLException, IOException {
        return JdbcCommon.convertToAvroStream(rs, outStream, null, null, convertNames);
    }

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, String recordName, boolean convertNames) throws SQLException, IOException {
        return JdbcCommon.convertToAvroStream(rs, outStream, recordName, null, convertNames);
    }

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, String recordName, ResultSetRowCallback callback, boolean convertNames) throws IOException, SQLException {
        return JdbcCommon.convertToAvroStream(rs, outStream, recordName, callback, 0, convertNames);
    }

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, String recordName, ResultSetRowCallback callback, int maxRows, boolean convertNames) throws SQLException, IOException {
        AvroConversionOptions options = AvroConversionOptions.builder().recordName(recordName).maxRows(maxRows).convertNames(convertNames).useLogicalTypes(false).build();
        return JdbcCommon.convertToAvroStream(rs, outStream, options, callback);
    }

    public static void createEmptyAvroStream(OutputStream outStream) throws IOException {
        SchemaBuilder.FieldAssembler builder = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"NiFi_ExecuteSQL_Record").namespace("any.data")).fields();
        Schema schema = (Schema)builder.endRecord();
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.create(schema, outStream);
        }
    }

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, AvroConversionOptions options, ResultSetRowCallback callback) throws SQLException, IOException {
        Schema schema = JdbcCommon.createSchema(rs, options);
        GenericData.Record rec = new GenericData.Record(schema);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.create(schema, outStream);
            ResultSetMetaData meta = rs.getMetaData();
            int nrOfColumns = meta.getColumnCount();
            long nrOfRows = 0L;
            while (rs.next()) {
                if (callback != null) {
                    callback.processRow(rs);
                }
                for (int i = 1; i <= nrOfColumns; ++i) {
                    int c;
                    int index;
                    InputStream is;
                    Object[] buffer;
                    int javaSqlType = meta.getColumnType(i);
                    Schema fieldSchema = ((Schema.Field)schema.getFields().get(i - 1)).schema();
                    if (javaSqlType == 2005) {
                        Clob clob = rs.getClob(i);
                        if (clob != null) {
                            long numChars = clob.length();
                            buffer = new char[(int)numChars];
                            is = clob.getAsciiStream();
                            index = 0;
                            c = is.read();
                            while (c > 0) {
                                buffer[index++] = (char)c;
                                c = is.read();
                            }
                            rec.put(i - 1, (Object)new String((char[])buffer));
                            clob.free();
                            continue;
                        }
                        rec.put(i - 1, null);
                        continue;
                    }
                    if (javaSqlType == 2011) {
                        NClob nClob = rs.getNClob(i);
                        if (nClob != null) {
                            Reader characterStream = nClob.getCharacterStream();
                            long numChars = (int)nClob.length();
                            CharBuffer buffer2 = CharBuffer.allocate((int)numChars);
                            characterStream.read(buffer2);
                            buffer2.flip();
                            rec.put(i - 1, (Object)buffer2.toString());
                            nClob.free();
                            continue;
                        }
                        rec.put(i - 1, null);
                        continue;
                    }
                    if (javaSqlType == 2004) {
                        Blob blob = rs.getBlob(i);
                        if (blob != null) {
                            long numChars = blob.length();
                            buffer = new byte[(int)numChars];
                            is = blob.getBinaryStream();
                            index = 0;
                            c = is.read();
                            while (c > 0) {
                                buffer[index++] = (char)c;
                                c = is.read();
                            }
                            ByteBuffer bb = ByteBuffer.wrap((byte[])buffer);
                            rec.put(i - 1, (Object)bb);
                            blob.free();
                            continue;
                        }
                        rec.put(i - 1, null);
                        continue;
                    }
                    Object value = rs.getObject(i);
                    if (value == null) {
                        rec.put(i - 1, null);
                        continue;
                    }
                    if (javaSqlType == -2 || javaSqlType == -3 || javaSqlType == -4 || javaSqlType == 2003) {
                        byte[] bytes = rs.getBytes(i);
                        ByteBuffer bb = ByteBuffer.wrap(bytes);
                        rec.put(i - 1, (Object)bb);
                        continue;
                    }
                    if (value instanceof Byte) {
                        rec.put(i - 1, (Object)((Byte)value).intValue());
                        continue;
                    }
                    if (value instanceof Short) {
                        rec.put(i - 1, (Object)((Short)value).intValue());
                        continue;
                    }
                    if (value instanceof BigDecimal) {
                        if (options.useLogicalTypes) {
                            rec.put(i - 1, AvroTypeUtil.convertToAvroObject((Object)value, (Schema)fieldSchema));
                            continue;
                        }
                        rec.put(i - 1, (Object)value.toString());
                        continue;
                    }
                    if (value instanceof BigInteger) {
                        if (javaSqlType == -5) {
                            int precision = meta.getPrecision(i);
                            if (precision < 0 || precision > 19) {
                                rec.put(i - 1, (Object)value.toString());
                                continue;
                            }
                            try {
                                rec.put(i - 1, (Object)((BigInteger)value).longValueExact());
                            }
                            catch (ArithmeticException ae) {
                                rec.put(i - 1, (Object)value.toString());
                            }
                            continue;
                        }
                        rec.put(i - 1, (Object)value.toString());
                        continue;
                    }
                    if (value instanceof Number || value instanceof Boolean) {
                        if (javaSqlType == -5) {
                            int precision = meta.getPrecision(i);
                            if (precision < 0 || precision > 19) {
                                rec.put(i - 1, (Object)value.toString());
                                continue;
                            }
                            rec.put(i - 1, value);
                            continue;
                        }
                        rec.put(i - 1, value);
                        continue;
                    }
                    if (value instanceof Date) {
                        if (options.useLogicalTypes) {
                            rec.put(i - 1, AvroTypeUtil.convertToAvroObject((Object)value, (Schema)fieldSchema));
                            continue;
                        }
                        rec.put(i - 1, (Object)value.toString());
                        continue;
                    }
                    rec.put(i - 1, (Object)value.toString());
                }
                dataFileWriter.append((Object)rec);
                if (options.maxRows <= 0 || ++nrOfRows != (long)options.maxRows) continue;
            }
            long l = nrOfRows;
            return l;
        }
    }

    public static Schema createSchema(ResultSet rs) throws SQLException {
        return JdbcCommon.createSchema(rs, null, false);
    }

    public static Schema createSchema(ResultSet rs, String recordName, boolean convertNames) throws SQLException {
        AvroConversionOptions options = AvroConversionOptions.builder().recordName(recordName).convertNames(convertNames).build();
        return JdbcCommon.createSchema(rs, options);
    }

    private static void addNullableField(SchemaBuilder.FieldAssembler<Schema> builder, String columnName, Function<SchemaBuilder.BaseTypeBuilder<SchemaBuilder.UnionAccumulator<SchemaBuilder.NullDefault<Schema>>>, SchemaBuilder.UnionAccumulator<SchemaBuilder.NullDefault<Schema>>> func) {
        SchemaBuilder.BaseTypeBuilder and = ((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and();
        ((SchemaBuilder.NullDefault)func.apply((SchemaBuilder.BaseTypeBuilder<SchemaBuilder.UnionAccumulator<SchemaBuilder.NullDefault<Schema>>>)and).endUnion()).noDefault();
    }

    public static Schema createSchema(ResultSet rs, AvroConversionOptions options) throws SQLException {
        String tableNameFromMeta;
        String tableName;
        ResultSetMetaData meta = rs.getMetaData();
        int nrOfColumns = meta.getColumnCount();
        String string = tableName = StringUtils.isEmpty((CharSequence)options.recordName) ? "NiFi_ExecuteSQL_Record" : options.recordName;
        if (nrOfColumns > 0 && !StringUtils.isBlank((CharSequence)(tableNameFromMeta = meta.getTableName(1)))) {
            tableName = tableNameFromMeta;
        }
        if (options.convertNames) {
            tableName = JdbcCommon.normalizeNameForAvro(tableName);
        }
        SchemaBuilder.FieldAssembler builder = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)tableName).namespace("any.data")).fields();
        block15: for (int i = 1; i <= nrOfColumns; ++i) {
            String nameOrLabel = StringUtils.isNotEmpty((CharSequence)meta.getColumnLabel(i)) ? meta.getColumnLabel(i) : meta.getColumnName(i);
            String columnName = options.convertNames ? JdbcCommon.normalizeNameForAvro(nameOrLabel) : nameOrLabel;
            switch (meta.getColumnType(i)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block15;
                }
                case -7: 
                case 16: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().booleanType()).endUnion()).noDefault();
                    continue block15;
                }
                case 4: {
                    if (meta.isSigned(i) || meta.getPrecision(i) > 0 && meta.getPrecision(i) < 9) {
                        ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().intType()).endUnion()).noDefault();
                        continue block15;
                    }
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().longType()).endUnion()).noDefault();
                    continue block15;
                }
                case -6: 
                case 5: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().intType()).endUnion()).noDefault();
                    continue block15;
                }
                case -5: {
                    int precision = meta.getPrecision(i);
                    if (precision < 0 || precision > 19) {
                        ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                        continue block15;
                    }
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().longType()).endUnion()).noDefault();
                    continue block15;
                }
                case -8: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block15;
                }
                case 6: 
                case 7: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().floatType()).endUnion()).noDefault();
                    continue block15;
                }
                case 8: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().doubleType()).endUnion()).noDefault();
                    continue block15;
                }
                case 2: 
                case 3: {
                    if (options.useLogicalTypes) {
                        int decimalScale;
                        int decimalPrecision;
                        if (meta.getPrecision(i) > 0) {
                            decimalPrecision = meta.getPrecision(i);
                            decimalScale = meta.getScale(i);
                        } else {
                            decimalPrecision = options.defaultPrecision;
                            decimalScale = meta.getScale(i) > 0 ? meta.getScale(i) : options.defaultScale;
                        }
                        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalPrecision, (int)decimalScale);
                        JdbcCommon.addNullableField((SchemaBuilder.FieldAssembler<Schema>)builder, columnName, u -> (SchemaBuilder.UnionAccumulator)u.type(decimal.addToSchema((Schema)SchemaBuilder.builder().bytesType())));
                        continue block15;
                    }
                    JdbcCommon.addNullableField((SchemaBuilder.FieldAssembler<Schema>)builder, columnName, u -> (SchemaBuilder.UnionAccumulator)u.stringType());
                    continue block15;
                }
                case 91: {
                    JdbcCommon.addNullableField((SchemaBuilder.FieldAssembler<Schema>)builder, columnName, u -> options.useLogicalTypes ? (SchemaBuilder.UnionAccumulator)u.type(LogicalTypes.date().addToSchema((Schema)SchemaBuilder.builder().intType())) : (SchemaBuilder.UnionAccumulator)u.stringType());
                    continue block15;
                }
                case 92: {
                    JdbcCommon.addNullableField((SchemaBuilder.FieldAssembler<Schema>)builder, columnName, u -> options.useLogicalTypes ? (SchemaBuilder.UnionAccumulator)u.type(LogicalTypes.timeMillis().addToSchema((Schema)SchemaBuilder.builder().intType())) : (SchemaBuilder.UnionAccumulator)u.stringType());
                    continue block15;
                }
                case 93: {
                    JdbcCommon.addNullableField((SchemaBuilder.FieldAssembler<Schema>)builder, columnName, u -> options.useLogicalTypes ? (SchemaBuilder.UnionAccumulator)u.type(LogicalTypes.timestampMillis().addToSchema((Schema)SchemaBuilder.builder().longType())) : (SchemaBuilder.UnionAccumulator)u.stringType());
                    continue block15;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2003: 
                case 2004: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().bytesType()).endUnion()).noDefault();
                    continue block15;
                }
                default: {
                    throw new IllegalArgumentException("createSchema: Unknown SQL type " + meta.getColumnType(i) + " / " + meta.getColumnTypeName(i) + " (table: " + tableName + ", column: " + columnName + ") cannot be converted to Avro type");
                }
            }
        }
        return (Schema)builder.endRecord();
    }

    public static String normalizeNameForAvro(String inputName) {
        String normalizedName = inputName.replaceAll("[^A-Za-z0-9_]", "_");
        if (Character.isDigit(normalizedName.charAt(0))) {
            normalizedName = "_" + normalizedName;
        }
        return normalizedName;
    }

    public static interface ResultSetRowCallback {
        public void processRow(ResultSet var1) throws IOException;
    }

    public static class AvroConversionOptions {
        private final String recordName;
        private final int maxRows;
        private final boolean convertNames;
        private final boolean useLogicalTypes;
        private final int defaultPrecision;
        private final int defaultScale;

        private AvroConversionOptions(String recordName, int maxRows, boolean convertNames, boolean useLogicalTypes, int defaultPrecision, int defaultScale) {
            this.recordName = recordName;
            this.maxRows = maxRows;
            this.convertNames = convertNames;
            this.useLogicalTypes = useLogicalTypes;
            this.defaultPrecision = defaultPrecision;
            this.defaultScale = defaultScale;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String recordName;
            private int maxRows = 0;
            private boolean convertNames = false;
            private boolean useLogicalTypes = false;
            private int defaultPrecision = 10;
            private int defaultScale = 0;

            public Builder recordName(String recordName) {
                this.recordName = recordName;
                return this;
            }

            public Builder maxRows(int maxRows) {
                this.maxRows = maxRows;
                return this;
            }

            public Builder convertNames(boolean convertNames) {
                this.convertNames = convertNames;
                return this;
            }

            public Builder useLogicalTypes(boolean useLogicalTypes) {
                this.useLogicalTypes = useLogicalTypes;
                return this;
            }

            public Builder defaultPrecision(int defaultPrecision) {
                this.defaultPrecision = defaultPrecision;
                return this;
            }

            public Builder defaultScale(int defaultScale) {
                this.defaultScale = defaultScale;
                return this;
            }

            public AvroConversionOptions build() {
                return new AvroConversionOptions(this.recordName, this.maxRows, this.convertNames, this.useLogicalTypes, this.defaultPrecision, this.defaultScale);
            }
        }
    }
}

