/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.queryrecord;

import java.io.InputStream;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.record.Record;

public class FlowFileEnumerator<InternalType>
implements Enumerator<Object> {
    private final ProcessSession session;
    private final FlowFile flowFile;
    private final ComponentLog logger;
    private final RecordReaderFactory recordParserFactory;
    private final int[] fields;
    private InputStream rawIn;
    private Object currentRow;
    private RecordReader recordParser;
    private int recordsRead = 0;

    public FlowFileEnumerator(ProcessSession session, FlowFile flowFile, ComponentLog logger, RecordReaderFactory parserFactory, int[] fields) {
        this.session = session;
        this.flowFile = flowFile;
        this.recordParserFactory = parserFactory;
        this.logger = logger;
        this.fields = fields;
        this.reset();
    }

    public Object current() {
        return this.currentRow;
    }

    public boolean moveNext() {
        this.currentRow = null;
        if (this.currentRow == null) {
            try {
                this.currentRow = this.filterColumns(this.recordParser.nextRecord());
            }
            catch (Exception e) {
                throw new ProcessException("Failed to read next record in stream for " + this.flowFile, (Throwable)e);
            }
        }
        if (this.currentRow == null) {
            this.close();
            try {
                this.onFinish();
            }
            catch (Exception e) {
                this.logger.error("Failed to perform tasks when enumerator was finished", (Throwable)e);
            }
            return false;
        }
        ++this.recordsRead;
        return true;
    }

    protected int getRecordsRead() {
        return this.recordsRead;
    }

    protected void onFinish() {
    }

    private Object filterColumns(Record record) {
        if (record == null) {
            return null;
        }
        Object[] row = record.getValues();
        if (this.fields == null || row == null) {
            return row;
        }
        if (this.fields.length == 1) {
            int desiredCellIndex = this.fields[0];
            return row[desiredCellIndex];
        }
        Object[] filtered = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            int indexToKeep = this.fields[i];
            filtered[i] = row[indexToKeep];
        }
        return filtered;
    }

    public void reset() {
        if (this.rawIn != null) {
            try {
                this.rawIn.close();
            }
            catch (Exception e) {
                this.logger.warn("Could not close FlowFile's input due to " + e, (Throwable)e);
            }
        }
        this.rawIn = this.session.read(this.flowFile);
        try {
            this.recordParser = this.recordParserFactory.createRecordReader(this.flowFile, this.rawIn, this.logger);
        }
        catch (Exception e) {
            throw new ProcessException("Failed to reset stream", (Throwable)e);
        }
    }

    public void close() {
        if (this.recordParser != null) {
            try {
                this.recordParser.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close decorated source for " + this.flowFile, (Throwable)e);
            }
        }
        try {
            this.rawIn.close();
        }
        catch (Exception e) {
            this.logger.warn("Failed to close InputStream for " + this.flowFile, (Throwable)e);
        }
    }
}

