/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.util.FileTransfer;
import org.apache.nifi.util.Tuple;

public abstract class FetchFileTransfer
extends AbstractProcessor {
    static final AllowableValue COMPLETION_NONE = new AllowableValue("None", "None", "Leave the file as-is");
    static final AllowableValue COMPLETION_MOVE = new AllowableValue("Move File", "Move File", "Move the file to the directory specified by the <Move Destination Directory> property");
    static final AllowableValue COMPLETION_DELETE = new AllowableValue("Delete File", "Delete File", "Deletes the original file from the remote system");
    static final PropertyDescriptor HOSTNAME = new PropertyDescriptor.Builder().name("Hostname").description("The fully-qualified hostname or IP address of the host to fetch the data from").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).required(true).build();
    static final PropertyDescriptor UNDEFAULTED_PORT = new PropertyDescriptor.Builder().name("Port").description("The port to connect to on the remote host to fetch the data from").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).required(true).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("Username").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).required(true).build();
    public static final PropertyDescriptor REMOTE_FILENAME = new PropertyDescriptor.Builder().name("Remote File").description("The fully qualified filename on the remote system").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    static final PropertyDescriptor COMPLETION_STRATEGY = new PropertyDescriptor.Builder().name("Completion Strategy").description("Specifies what to do with the original file on the server once it has been pulled into NiFi. If the Completion Strategy fails, a warning will be logged but the data will still be transferred.").expressionLanguageSupported(false).allowableValues(new AllowableValue[]{COMPLETION_NONE, COMPLETION_MOVE, COMPLETION_DELETE}).defaultValue(COMPLETION_NONE.getValue()).required(true).build();
    static final PropertyDescriptor MOVE_DESTINATION_DIR = new PropertyDescriptor.Builder().name("Move Destination Directory").description("The directory on the remote server to the move the original file to once it has been ingested into NiFi. This property is ignored unless the Completion Strategy is set to \"Move File\". The specified directory must already exist onthe remote system, or the rename will fail.").expressionLanguageSupported(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that are received are routed to success").build();
    static final Relationship REL_COMMS_FAILURE = new Relationship.Builder().name("comms.failure").description("Any FlowFile that could not be fetched from the remote server due to a communications failure will be transferred to this Relationship.").build();
    static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not.found").description("Any FlowFile for which we receive a 'Not Found' message from the remote server will be transferred to this Relationship.").build();
    static final Relationship REL_PERMISSION_DENIED = new Relationship.Builder().name("permission.denied").description("Any FlowFile that could not be fetched from the remote server due to insufficient permissions will be transferred to this Relationship.").build();
    private final Map<Tuple<String, Integer>, BlockingQueue<FileTransferIdleWrapper>> fileTransferMap = new HashMap<Tuple<String, Integer>, BlockingQueue<FileTransferIdleWrapper>>();
    private final long IDLE_CONNECTION_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private volatile long lastClearTime = System.currentTimeMillis();

    public Set<Relationship> getRelationships() {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_NOT_FOUND);
        relationships.add(REL_PERMISSION_DENIED);
        relationships.add(REL_COMMS_FAILURE);
        return relationships;
    }

    private void closeConnections(boolean closeNonIdleConnections) {
        for (Map.Entry<Tuple<String, Integer>, BlockingQueue<FileTransferIdleWrapper>> entry : this.fileTransferMap.entrySet()) {
            FileTransferIdleWrapper wrapper;
            BlockingQueue<FileTransferIdleWrapper> wrapperQueue = entry.getValue();
            ArrayList<FileTransferIdleWrapper> putBack = new ArrayList<FileTransferIdleWrapper>();
            while ((wrapper = (FileTransferIdleWrapper)wrapperQueue.poll()) != null) {
                long lastUsed = wrapper.getLastUsed();
                long nanosSinceLastUse = System.nanoTime() - lastUsed;
                if (!closeNonIdleConnections && TimeUnit.NANOSECONDS.toMillis(nanosSinceLastUse) < this.IDLE_CONNECTION_MILLIS) {
                    putBack.add(wrapper);
                    continue;
                }
                try {
                    wrapper.getFileTransfer().close();
                }
                catch (IOException ioe) {
                    this.getLogger().warn("Failed to close Idle Connection due to {}", new Object[]{ioe}, (Throwable)ioe);
                }
            }
            for (FileTransferIdleWrapper toPutBack : putBack) {
                wrapperQueue.offer(toPutBack);
            }
        }
    }

    @OnStopped
    public void cleanup() {
        this.closeConnections(true);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(HOSTNAME);
        properties.add(UNDEFAULTED_PORT);
        properties.add(REMOTE_FILENAME);
        properties.add(COMPLETION_STRATEGY);
        properties.add(MOVE_DESTINATION_DIR);
        return properties;
    }

    /*
     * Exception decompiling
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract FileTransfer createFileTransfer(ProcessContext var1);

    private static class FileTransferIdleWrapper {
        private final FileTransfer fileTransfer;
        private final long lastUsed;

        public FileTransferIdleWrapper(FileTransfer fileTransfer, long lastUsed) {
            this.fileTransfer = fileTransfer;
            this.lastUsed = lastUsed;
        }

        public FileTransfer getFileTransfer() {
            return this.fileTransfer;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }
    }
}

