/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.eclipse.jetty.util.StringUtil;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"attributes", "logging"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
public class LogAttribute
extends AbstractProcessor {
    public static final PropertyDescriptor LOG_LEVEL = new PropertyDescriptor.Builder().name("Log Level").required(true).description("The Log Level to use when logging the Attributes").allowableValues((Enum[])DebugLevels.values()).defaultValue("info").build();
    public static final PropertyDescriptor ATTRIBUTES_TO_LOG_CSV = new PropertyDescriptor.Builder().name("Attributes to Log").required(false).description("A comma-separated list of Attributes to Log. If not specified, all attributes will be logged unless `Attributes to Log by Regular Expression` is modified. There's an AND relationship between the two properties.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor ATTRIBUTES_TO_LOG_REGEX = new PropertyDescriptor.Builder().name("attributes-to-log-regex").displayName("Attributes to Log by Regular Expression").required(false).defaultValue(".*").description("A regular expression indicating the Attributes to Log. If not specified, all attributes will be logged unless `Attributes to Log` is modified. There's an AND relationship between the two properties.").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    public static final PropertyDescriptor ATTRIBUTES_TO_IGNORE_CSV = new PropertyDescriptor.Builder().name("Attributes to Ignore").description("A comma-separated list of Attributes to ignore. If not specified, no attributes will be ignored unless `Attributes to Ignore by Regular Expression` is modified. There's an OR relationship between the two properties.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor ATTRIBUTES_TO_IGNORE_REGEX = new PropertyDescriptor.Builder().name("attributes-to-ignore-regex").displayName("Attributes to Ignore by Regular Expression").required(false).description("A regular expression indicating the Attributes to Ignore. If not specified, no attributes will be ignored unless `Attributes to Ignore` is modified. There's an OR relationship between the two properties.").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    public static final PropertyDescriptor LOG_PAYLOAD = new PropertyDescriptor.Builder().name("Log Payload").required(true).description("If true, the FlowFile's payload will be logged, in addition to its attributes; otherwise, just the Attributes will be logged.").defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor LOG_PREFIX = new PropertyDescriptor.Builder().name("Log prefix").required(false).description("Log prefix appended to the log lines. It helps to distinguish the output of multiple LogAttribute processors.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("character-set").displayName("Character Set").description("The name of the CharacterSet to use").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue(Charset.defaultCharset().name()).required(true).build();
    public static final String FIFTY_DASHES = "--------------------------------------------------";
    public static final long ONE_MB = 0x100000L;
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> supportedDescriptors;
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles are routed to this relationship").build();

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> procRels = new HashSet<Relationship>();
        procRels.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(procRels);
        ArrayList<PropertyDescriptor> supDescriptors = new ArrayList<PropertyDescriptor>();
        supDescriptors.add(LOG_LEVEL);
        supDescriptors.add(LOG_PAYLOAD);
        supDescriptors.add(ATTRIBUTES_TO_LOG_CSV);
        supDescriptors.add(ATTRIBUTES_TO_LOG_REGEX);
        supDescriptors.add(ATTRIBUTES_TO_IGNORE_CSV);
        supDescriptors.add(ATTRIBUTES_TO_IGNORE_REGEX);
        supDescriptors.add(LOG_PREFIX);
        supDescriptors.add(CHARSET);
        this.supportedDescriptors = Collections.unmodifiableList(supDescriptors);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.supportedDescriptors;
    }

    protected String processFlowFile(ComponentLog logger, DebugLevels logLevel, FlowFile flowFile, ProcessSession session, ProcessContext context) {
        String dashedLine;
        Set<String> attributeKeys = this.getAttributesToLog(flowFile.getAttributes().keySet(), context);
        ComponentLog LOG = this.getLogger();
        String logPrefix = context.getProperty(LOG_PREFIX).evaluateAttributeExpressions(flowFile).getValue();
        Charset charset = Charset.forName(context.getProperty(CHARSET).evaluateAttributeExpressions(flowFile).getValue());
        if (StringUtil.isBlank((String)logPrefix)) {
            dashedLine = StringUtils.repeat((char)'-', (int)50);
        } else {
            logPrefix = StringUtils.abbreviate((String)logPrefix, (int)40);
            logPrefix = StringUtils.center((String)logPrefix, (int)40, (char)'-');
            dashedLine = StringUtils.repeat((char)'-', (int)5) + logPrefix + StringUtils.repeat((char)'-', (int)5);
        }
        StringBuilder message = new StringBuilder();
        message.append("logging for flow file ").append(flowFile);
        message.append("\n");
        message.append(dashedLine);
        message.append("\nStandard FlowFile Attributes");
        message.append(String.format("\nKey: '%1$s'\n\tValue: '%2$s'", "entryDate", new Date(flowFile.getEntryDate())));
        message.append(String.format("\nKey: '%1$s'\n\tValue: '%2$s'", "lineageStartDate", new Date(flowFile.getLineageStartDate())));
        message.append(String.format("\nKey: '%1$s'\n\tValue: '%2$s'", "fileSize", flowFile.getSize()));
        message.append("\nFlowFile Attribute Map Content");
        for (String key : attributeKeys) {
            message.append(String.format("\nKey: '%1$s'\n\tValue: '%2$s'", key, flowFile.getAttribute(key)));
        }
        message.append("\n");
        message.append(dashedLine);
        boolean logPayload = context.getProperty(LOG_PAYLOAD).asBoolean();
        if (logPayload) {
            message.append("\n");
            if (flowFile.getSize() < 0x100000L) {
                FlowFilePayloadCallback callback = new FlowFilePayloadCallback(charset);
                session.read(flowFile, (InputStreamCallback)callback);
                message.append(callback.getContents());
            } else {
                message.append("\n Not including payload since it is larger than one mb.");
            }
        }
        String outputMessage = message.toString().trim();
        switch (logLevel) {
            case info: {
                LOG.info(outputMessage);
                break;
            }
            case debug: {
                LOG.debug(outputMessage);
                break;
            }
            case warn: {
                LOG.warn(outputMessage);
                break;
            }
            case trace: {
                LOG.trace(outputMessage);
                break;
            }
            case error: {
                LOG.error(outputMessage);
                break;
            }
            default: {
                LOG.debug(outputMessage);
            }
        }
        return outputMessage;
    }

    private Set<String> getAttributesToLog(Set<String> flowFileAttrKeys, ProcessContext context) {
        String attrsToLogValue = context.getProperty(ATTRIBUTES_TO_LOG_CSV).getValue();
        String attrsToRemoveValue = context.getProperty(ATTRIBUTES_TO_IGNORE_CSV).getValue();
        HashSet attrsToLog = StringUtils.isBlank((CharSequence)attrsToLogValue) ? Sets.newHashSet(flowFileAttrKeys) : Sets.newHashSet((Object[])attrsToLogValue.split("\\s*,\\s*"));
        HashSet attrsToRemove = StringUtils.isBlank((CharSequence)attrsToRemoveValue) ? Sets.newHashSet() : Sets.newHashSet((Object[])attrsToRemoveValue.split("\\s*,\\s*"));
        Pattern attrsToLogRegex = Pattern.compile(context.getProperty(ATTRIBUTES_TO_LOG_REGEX).getValue());
        String attrsToRemoveRegexValue = context.getProperty(ATTRIBUTES_TO_IGNORE_REGEX).getValue();
        Pattern attrsToRemoveRegex = attrsToRemoveRegexValue == null ? null : Pattern.compile(context.getProperty(ATTRIBUTES_TO_IGNORE_REGEX).getValue());
        return flowFileAttrKeys.stream().filter(candidate -> !(!attrsToLog.isEmpty() && !attrsToLog.contains(candidate) || !attrsToLogRegex.matcher((CharSequence)candidate).matches() || !attrsToRemove.isEmpty() && attrsToRemove.contains(candidate) || attrsToRemoveRegex != null && attrsToRemoveRegex.matcher((CharSequence)candidate).matches())).collect(Collectors.toCollection(TreeSet::new));
    }

    private void transferChunk(ProcessSession session) {
        List flowFiles = session.get(50);
        if (!flowFiles.isEmpty()) {
            session.transfer((Collection)flowFiles, REL_SUCCESS);
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        DebugLevels logLevel;
        String logLevelValue = context.getProperty(LOG_LEVEL).getValue().toLowerCase();
        try {
            logLevel = DebugLevels.valueOf(logLevelValue);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        ComponentLog LOG = this.getLogger();
        boolean isLogLevelEnabled = false;
        switch (logLevel) {
            case trace: {
                isLogLevelEnabled = LOG.isTraceEnabled();
                break;
            }
            case debug: {
                isLogLevelEnabled = LOG.isDebugEnabled();
                break;
            }
            case info: {
                isLogLevelEnabled = LOG.isInfoEnabled();
                break;
            }
            case warn: {
                isLogLevelEnabled = LOG.isWarnEnabled();
                break;
            }
            case error: {
                isLogLevelEnabled = LOG.isErrorEnabled();
            }
        }
        if (!isLogLevelEnabled) {
            this.transferChunk(session);
            return;
        }
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        this.processFlowFile(LOG, logLevel, flowFile, session, context);
        session.transfer(flowFile, REL_SUCCESS);
    }

    protected static class FlowFilePayloadCallback
    implements InputStreamCallback {
        private String contents = "";
        private Charset charset;

        public FlowFilePayloadCallback(Charset charset) {
            this.charset = charset;
        }

        public void process(InputStream in) throws IOException {
            this.contents = IOUtils.toString((InputStream)in, (Charset)this.charset);
        }

        public String getContents() {
            return this.contents;
        }
    }

    public static enum DebugLevels {
        trace,
        debug,
        info,
        warn,
        error;

    }
}

