/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.util.FTPTransfer;
import org.apache.nifi.processors.standard.util.FileInfo;
import org.apache.nifi.processors.standard.util.FileTransfer;
import org.apache.nifi.processors.standard.util.PermissionDeniedException;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.slf4j.LoggerFactory;

public class SFTPTransfer
implements FileTransfer {
    public static final PropertyDescriptor PRIVATE_KEY_PATH = new PropertyDescriptor.Builder().name("Private Key Path").description("The fully qualified path to the Private Key file").required(false).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor PRIVATE_KEY_PASSPHRASE = new PropertyDescriptor.Builder().name("Private Key Passphrase").description("Password for the private key").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).sensitive(true).build();
    public static final PropertyDescriptor HOST_KEY_FILE = new PropertyDescriptor.Builder().name("Host Key File").description("If supplied, the given file will be used as the Host Key; otherwise, no use host key file will be used").addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).required(false).build();
    public static final PropertyDescriptor STRICT_HOST_KEY_CHECKING = new PropertyDescriptor.Builder().name("Strict Host Key Checking").description("Indicates whether or not strict enforcement of hosts keys should be applied").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Port").description("The port that the remote system is listening on for file transfers").addValidator(StandardValidators.PORT_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).defaultValue("22").build();
    public static final PropertyDescriptor USE_KEEPALIVE_ON_TIMEOUT = new PropertyDescriptor.Builder().name("Send Keep Alive On Timeout").description("Indicates whether or not to send a single Keep Alive message when SSH socket times out").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    public static final PropertyDescriptor DISABLE_DIRECTORY_LISTING = new PropertyDescriptor.Builder().name("Disable Directory Listing").description("If set to 'true', directory listing is not performed prior to create missing directories. By default, this processor executes a directory listing command to see target directory existence before creating missing directories. However, there are situations that you might need to disable the directory listing such as the following. Directory listing might fail with some permission setups (e.g. chmod 100) on a directory. Also, if any other SFTP client created the directory after this processor performed a listing and before a directory creation request by this processor is finished, then an error is returned because the directory already exists.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    private static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP_AUTH, ProxySpec.SOCKS_AUTH};
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)true, (ProxySpec[])PROXY_SPECS);
    private final ComponentLog logger;
    private final ProcessContext ctx;
    private Session session;
    private ChannelSftp sftp;
    private boolean closed = false;
    private String homeDir;
    private final boolean disableDirectoryListing;

    public SFTPTransfer(ProcessContext processContext, ComponentLog logger) {
        this.ctx = processContext;
        this.logger = logger;
        PropertyValue disableListing = processContext.getProperty(DISABLE_DIRECTORY_LISTING);
        this.disableDirectoryListing = disableListing == null ? false : Boolean.TRUE.equals(disableListing.asBoolean());
    }

    public static void validateProxySpec(ValidationContext context, Collection<ValidationResult> results) {
        ProxyConfiguration.validateProxySpec((ValidationContext)context, results, (ProxySpec[])PROXY_SPECS);
    }

    @Override
    public String getProtocolName() {
        return "sftp";
    }

    @Override
    public List<FileInfo> getListing() throws IOException {
        Integer configuredValue;
        String path = this.ctx.getProperty(FileTransfer.REMOTE_PATH).evaluateAttributeExpressions().getValue();
        boolean depth = false;
        PropertyValue batchSizeValue = this.ctx.getProperty(FileTransfer.REMOTE_POLL_BATCH_SIZE);
        int maxResults = batchSizeValue == null ? Integer.MAX_VALUE : ((configuredValue = batchSizeValue.asInteger()) == null ? Integer.MAX_VALUE : configuredValue);
        ArrayList<FileInfo> listing = new ArrayList<FileInfo>(1000);
        this.getListing(path, 0, maxResults, listing);
        return listing;
    }

    private void getListing(final String path, int depth, final int maxResults, final List<FileInfo> listing) throws IOException {
        if (maxResults < 1 || listing.size() >= maxResults) {
            return;
        }
        if (depth >= 100) {
            this.logger.warn(this + " had to stop recursively searching directories at a recursive depth of " + depth + " to avoid memory issues");
            return;
        }
        final boolean ignoreDottedFiles = this.ctx.getProperty(FileTransfer.IGNORE_DOTTED_FILES).asBoolean();
        final boolean recurse = this.ctx.getProperty(FileTransfer.RECURSIVE_SEARCH).asBoolean();
        String fileFilterRegex = this.ctx.getProperty(FileTransfer.FILE_FILTER_REGEX).getValue();
        final Pattern pattern = fileFilterRegex == null ? null : Pattern.compile(fileFilterRegex);
        String pathFilterRegex = this.ctx.getProperty(FileTransfer.PATH_FILTER_REGEX).getValue();
        Pattern pathPattern = !recurse || pathFilterRegex == null ? null : Pattern.compile(pathFilterRegex);
        String remotePath = this.ctx.getProperty(FileTransfer.REMOTE_PATH).evaluateAttributeExpressions().getValue();
        boolean pathFilterMatches = true;
        if (pathPattern != null) {
            Path reldir;
            Path path2 = reldir = path == null ? Paths.get(".", new String[0]) : Paths.get(path, new String[0]);
            if (remotePath != null) {
                reldir = Paths.get(remotePath, new String[0]).relativize(reldir);
            }
            if (reldir != null && !reldir.toString().isEmpty() && !pathPattern.matcher(reldir.toString().replace("\\", "/")).matches()) {
                pathFilterMatches = false;
            }
        }
        ChannelSftp sftp = this.getChannel(null);
        final boolean isPathMatch = pathFilterMatches;
        final ArrayList subDirs = new ArrayList();
        try {
            ChannelSftp.LsEntrySelector filter = new ChannelSftp.LsEntrySelector(){

                public int select(ChannelSftp.LsEntry entry) {
                    String entryFilename = entry.getFilename();
                    if (entryFilename.equals(".") || entryFilename.equals("..")) {
                        return 0;
                    }
                    if (ignoreDottedFiles && entryFilename.startsWith(".")) {
                        return 0;
                    }
                    if (recurse && entry.getAttrs().isDir()) {
                        subDirs.add(entry);
                        return 0;
                    }
                    if (!entry.getAttrs().isDir() && !entry.getAttrs().isLink() && isPathMatch && (pattern == null || pattern.matcher(entryFilename).matches())) {
                        listing.add(SFTPTransfer.this.newFileInfo(entry, path));
                    }
                    if (listing.size() >= maxResults) {
                        return 1;
                    }
                    return 0;
                }
            };
            if (path == null || path.trim().isEmpty()) {
                sftp.ls(".", filter);
            } else {
                sftp.ls(path, filter);
            }
        }
        catch (SftpException e) {
            String pathDesc = path == null ? "current directory" : path;
            switch (e.id) {
                case 2: {
                    throw new FileNotFoundException("Could not perform listing on " + pathDesc + " because could not find the file on the remote server");
                }
                case 3: {
                    throw new PermissionDeniedException("Could not perform listing on " + pathDesc + " due to insufficient permissions");
                }
            }
            throw new IOException("Failed to obtain file listing for " + pathDesc, e);
        }
        for (ChannelSftp.LsEntry entry : subDirs) {
            String entryFilename = entry.getFilename();
            File newFullPath = new File(path, entryFilename);
            String newFullForwardPath = newFullPath.getPath().replace("\\", "/");
            try {
                this.getListing(newFullForwardPath, depth + 1, maxResults, listing);
            }
            catch (IOException e) {
                this.logger.error("Unable to get listing from " + newFullForwardPath + "; skipping this subdirectory", (Throwable)e);
            }
        }
    }

    private FileInfo newFileInfo(ChannelSftp.LsEntry entry, String path) {
        if (entry == null) {
            return null;
        }
        File newFullPath = new File(path, entry.getFilename());
        String newFullForwardPath = newFullPath.getPath().replace("\\", "/");
        String perms = entry.getAttrs().getPermissionsString();
        if (perms.length() > 9) {
            perms = perms.substring(perms.length() - 9);
        }
        FileInfo.Builder builder = new FileInfo.Builder().filename(entry.getFilename()).fullPathFileName(newFullForwardPath).directory(entry.getAttrs().isDir()).size(entry.getAttrs().getSize()).lastModifiedTime((long)entry.getAttrs().getMTime() * 1000L).permissions(perms).owner(Integer.toString(entry.getAttrs().getUId())).group(Integer.toString(entry.getAttrs().getGId()));
        return builder.build();
    }

    @Override
    public InputStream getInputStream(String remoteFileName) throws IOException {
        return this.getInputStream(remoteFileName, null);
    }

    @Override
    public InputStream getInputStream(String remoteFileName, FlowFile flowFile) throws IOException {
        ChannelSftp sftp = this.getChannel(flowFile);
        try {
            return sftp.get(remoteFileName);
        }
        catch (SftpException e) {
            switch (e.id) {
                case 2: {
                    throw new FileNotFoundException("Could not find file " + remoteFileName + " on remote SFTP Server");
                }
                case 3: {
                    throw new PermissionDeniedException("Insufficient permissions to read file " + remoteFileName + " from remote SFTP Server", e);
                }
            }
            throw new IOException("Failed to obtain file content for " + remoteFileName, e);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public boolean flush(FlowFile flowFile) throws IOException {
        return true;
    }

    @Override
    public void deleteFile(FlowFile flowFile, String path, String remoteFileName) throws IOException {
        String fullPath = path == null ? remoteFileName : (path.endsWith("/") ? path + remoteFileName : path + "/" + remoteFileName);
        try {
            this.sftp.rm(fullPath);
        }
        catch (SftpException e) {
            switch (e.id) {
                case 2: {
                    throw new FileNotFoundException("Could not find file " + remoteFileName + " to remove from remote SFTP Server");
                }
                case 3: {
                    throw new PermissionDeniedException("Insufficient permissions to delete file " + remoteFileName + " from remote SFTP Server", e);
                }
            }
            throw new IOException("Failed to delete remote file " + fullPath, e);
        }
    }

    @Override
    public void deleteDirectory(FlowFile flowFile, String remoteDirectoryName) throws IOException {
        try {
            this.sftp.rm(remoteDirectoryName);
        }
        catch (SftpException e) {
            throw new IOException("Failed to delete remote directory " + remoteDirectoryName, e);
        }
    }

    @Override
    public void ensureDirectoryExists(FlowFile flowFile, File directoryName) throws IOException {
        String remoteDirectory;
        ChannelSftp channel;
        block10: {
            channel = this.getChannel(flowFile);
            remoteDirectory = directoryName.getAbsolutePath().replace("\\", "/").replaceAll("^.\\:", "");
            if (this.disableDirectoryListing) {
                try {
                    channel.mkdir(remoteDirectory);
                    return;
                }
                catch (SftpException e) {
                    if (e.id == 2) {
                        this.logger.debug(String.format("Could not create %s due to 'No such file'. Will try to create the parent dir.", remoteDirectory));
                        break block10;
                    }
                    if (e.id == 4) {
                        this.logger.debug("Could not blindly create remote directory due to " + e.getMessage(), (Throwable)e);
                        return;
                    }
                    throw new IOException("Could not blindly create remote directory due to " + e.getMessage(), e);
                }
            }
            try {
                channel.stat(remoteDirectory);
                return;
            }
            catch (SftpException e) {
                if (e.id == 2) break block10;
                throw new IOException("Failed to determine if remote directory exists at " + remoteDirectory + " due to " + (Object)((Object)e), e);
            }
        }
        if (directoryName.getParent() != null && !directoryName.getParentFile().equals(new File(File.separator))) {
            this.ensureDirectoryExists(flowFile, directoryName.getParentFile());
        }
        this.logger.debug("Remote Directory {} does not exist; creating it", new Object[]{remoteDirectory});
        try {
            channel.mkdir(remoteDirectory);
            this.logger.debug("Created {}", new Object[]{remoteDirectory});
        }
        catch (SftpException e) {
            throw new IOException("Failed to create remote directory " + remoteDirectory + " due to " + (Object)((Object)e), e);
        }
    }

    protected ChannelSftp getChannel(FlowFile flowFile) throws IOException {
        if (this.sftp != null) {
            String desthost;
            String sessionhost = this.session.getHost();
            if (sessionhost.equals(desthost = this.ctx.getProperty(HOSTNAME).evaluateAttributeExpressions(flowFile).getValue())) {
                return this.sftp;
            }
            this.close();
        }
        JSch jsch = new JSch();
        try {
            String password;
            String username = this.ctx.getProperty(USERNAME).evaluateAttributeExpressions(flowFile).getValue();
            Session session = jsch.getSession(username, this.ctx.getProperty(HOSTNAME).evaluateAttributeExpressions(flowFile).getValue(), this.ctx.getProperty(PORT).evaluateAttributeExpressions(flowFile).asInteger().intValue());
            ProxyConfiguration proxyConfig = ProxyConfiguration.getConfiguration((PropertyContext)this.ctx, FTPTransfer.createComponentProxyConfigSupplier((PropertyContext)this.ctx));
            switch (proxyConfig.getProxyType()) {
                case HTTP: {
                    ProxyHTTP proxyHTTP = new ProxyHTTP(proxyConfig.getProxyServerHost(), proxyConfig.getProxyServerPort().intValue());
                    if (proxyConfig.hasCredential()) {
                        proxyHTTP.setUserPasswd(proxyConfig.getProxyUserName(), proxyConfig.getProxyUserPassword());
                    }
                    session.setProxy((Proxy)proxyHTTP);
                    break;
                }
                case SOCKS: {
                    ProxySOCKS5 proxySOCKS5 = new ProxySOCKS5(proxyConfig.getProxyServerHost(), proxyConfig.getProxyServerPort().intValue());
                    if (proxyConfig.hasCredential()) {
                        proxySOCKS5.setUserPasswd(proxyConfig.getProxyUserName(), proxyConfig.getProxyUserPassword());
                    }
                    session.setProxy((Proxy)proxySOCKS5);
                }
            }
            String hostKeyVal = this.ctx.getProperty(HOST_KEY_FILE).getValue();
            if (hostKeyVal != null) {
                jsch.setKnownHosts(hostKeyVal);
            }
            Properties properties = new Properties();
            properties.setProperty("StrictHostKeyChecking", this.ctx.getProperty(STRICT_HOST_KEY_CHECKING).asBoolean() != false ? "yes" : "no");
            properties.setProperty("PreferredAuthentications", "publickey,password,keyboard-interactive");
            PropertyValue compressionValue = this.ctx.getProperty(FileTransfer.USE_COMPRESSION);
            if (compressionValue != null && "true".equalsIgnoreCase(compressionValue.getValue())) {
                properties.setProperty("compression.s2c", "zlib@openssh.com,zlib,none");
                properties.setProperty("compression.c2s", "zlib@openssh.com,zlib,none");
            } else {
                properties.setProperty("compression.s2c", "none");
                properties.setProperty("compression.c2s", "none");
            }
            session.setConfig(properties);
            String privateKeyFile = this.ctx.getProperty(PRIVATE_KEY_PATH).evaluateAttributeExpressions(flowFile).getValue();
            if (privateKeyFile != null) {
                jsch.addIdentity(privateKeyFile, this.ctx.getProperty(PRIVATE_KEY_PASSPHRASE).evaluateAttributeExpressions(flowFile).getValue());
            }
            if ((password = this.ctx.getProperty(FileTransfer.PASSWORD).evaluateAttributeExpressions(flowFile).getValue()) != null) {
                session.setPassword(password);
            }
            int connectionTimeoutMillis = this.ctx.getProperty(FileTransfer.CONNECTION_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
            session.setTimeout(connectionTimeoutMillis);
            session.connect();
            this.session = session;
            this.closed = false;
            this.sftp = (ChannelSftp)session.openChannel("sftp");
            this.sftp.connect(connectionTimeoutMillis);
            session.setTimeout(this.ctx.getProperty(FileTransfer.DATA_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
            if (!this.ctx.getProperty(USE_KEEPALIVE_ON_TIMEOUT).asBoolean().booleanValue()) {
                session.setServerAliveCountMax(0);
            }
            try {
                this.homeDir = this.sftp.getHome();
            }
            catch (SftpException e) {
                this.logger.debug("Failed to retrieve {} home directory due to {}", new Object[]{username, e.getMessage()});
            }
            return this.sftp;
        }
        catch (JSchException e) {
            throw new IOException("Failed to obtain connection to remote host due to " + e.toString(), e);
        }
    }

    @Override
    public String getHomeDirectory(FlowFile flowFile) throws IOException {
        this.getChannel(flowFile);
        return this.homeDir;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (null != this.sftp) {
                this.sftp.exit();
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to close ChannelSftp due to {}", new Object[]{ex.toString()}, (Throwable)ex);
        }
        this.sftp = null;
        try {
            if (null != this.session) {
                this.session.disconnect();
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to close session due to {}", new Object[]{ex.toString()}, (Throwable)ex);
        }
        this.session = null;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public FileInfo getRemoteFileInfo(FlowFile flowFile, String path, String filename) throws IOException {
        Vector vector;
        String fullPath;
        ChannelSftp sftp = this.getChannel(flowFile);
        if (path == null) {
            fullPath = filename;
            int slashpos = filename.lastIndexOf(47);
            if (slashpos >= 0 && !filename.endsWith("/")) {
                filename = filename.substring(slashpos + 1);
            }
        } else {
            fullPath = path + "/" + filename;
        }
        try {
            vector = sftp.ls(fullPath);
        }
        catch (SftpException e) {
            if (e.id == 2) {
                return null;
            }
            throw new IOException("Failed to obtain file listing for " + fullPath, e);
        }
        ChannelSftp.LsEntry matchingEntry = null;
        for (ChannelSftp.LsEntry entry : vector) {
            if (!entry.getFilename().equalsIgnoreCase(filename)) continue;
            matchingEntry = entry;
            break;
        }
        return this.newFileInfo(matchingEntry, path);
    }

    @Override
    public String put(FlowFile flowFile, String path, String filename, InputStream content) throws IOException {
        String group;
        String owner;
        String permissions;
        ChannelSftp sftp = this.getChannel(flowFile);
        String fullPath = path == null ? filename : (path.endsWith("/") ? path + filename : path + "/" + filename);
        String tempFilename = this.ctx.getProperty(TEMP_FILENAME).evaluateAttributeExpressions(flowFile).getValue();
        if (tempFilename == null) {
            boolean dotRename = this.ctx.getProperty(DOT_RENAME).asBoolean();
            String string = tempFilename = dotRename ? "." + filename : filename;
        }
        String tempPath = path == null ? tempFilename : (path.endsWith("/") ? path + tempFilename : path + "/" + tempFilename);
        try {
            sftp.put(content, tempPath);
        }
        catch (SftpException e) {
            throw new IOException("Unable to put content to " + fullPath + " due to " + (Object)((Object)e), e);
        }
        String lastModifiedTime = this.ctx.getProperty(LAST_MODIFIED_TIME).evaluateAttributeExpressions(flowFile).getValue();
        if (lastModifiedTime != null && !lastModifiedTime.trim().isEmpty()) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
                Date fileModifyTime = formatter.parse(lastModifiedTime);
                int time = (int)(fileModifyTime.getTime() / 1000L);
                sftp.setMtime(tempPath, time);
            }
            catch (Exception e) {
                this.logger.error("Failed to set lastModifiedTime on {} to {} due to {}", new Object[]{tempPath, lastModifiedTime, e});
            }
        }
        if ((permissions = this.ctx.getProperty(PERMISSIONS).evaluateAttributeExpressions(flowFile).getValue()) != null && !permissions.trim().isEmpty()) {
            try {
                int perms = this.numberPermissions(permissions);
                if (perms >= 0) {
                    sftp.chmod(perms, tempPath);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to set permission on {} to {} due to {}", new Object[]{tempPath, permissions, e});
            }
        }
        if ((owner = this.ctx.getProperty(REMOTE_OWNER).evaluateAttributeExpressions(flowFile).getValue()) != null && !owner.trim().isEmpty()) {
            try {
                sftp.chown(Integer.parseInt(owner), tempPath);
            }
            catch (Exception e) {
                this.logger.error("Failed to set owner on {} to {} due to {}", new Object[]{tempPath, owner, e});
            }
        }
        if ((group = this.ctx.getProperty(REMOTE_GROUP).evaluateAttributeExpressions(flowFile).getValue()) != null && !group.trim().isEmpty()) {
            try {
                sftp.chgrp(Integer.parseInt(group), tempPath);
            }
            catch (Exception e) {
                this.logger.error("Failed to set group on {} to {} due to {}", new Object[]{tempPath, group, e});
            }
        }
        if (!filename.equals(tempFilename)) {
            try {
                sftp.rename(tempPath, fullPath);
            }
            catch (SftpException e) {
                try {
                    sftp.rm(tempPath);
                    throw new IOException("Failed to rename dot-file to " + fullPath + " due to " + (Object)((Object)e), e);
                }
                catch (SftpException e1) {
                    throw new IOException("Failed to rename dot-file to " + fullPath + " and failed to delete it when attempting to clean up", e1);
                }
            }
        }
        return fullPath;
    }

    @Override
    public void rename(FlowFile flowFile, String source, String target) throws IOException {
        ChannelSftp sftp = this.getChannel(flowFile);
        try {
            sftp.rename(source, target);
        }
        catch (SftpException e) {
            switch (e.id) {
                case 2: {
                    throw new FileNotFoundException("No such file or directory");
                }
                case 3: {
                    throw new PermissionDeniedException("Could not rename remote file " + source + " to " + target + " due to insufficient permissions");
                }
            }
            throw new IOException(e);
        }
    }

    protected int numberPermissions(String perms) {
        int number = -1;
        Pattern rwxPattern = Pattern.compile("^[rwx-]{9}$");
        Pattern numPattern = Pattern.compile("\\d+");
        if (rwxPattern.matcher(perms).matches()) {
            number = 0;
            if (perms.charAt(0) == 'r') {
                number |= 0x100;
            }
            if (perms.charAt(1) == 'w') {
                number |= 0x80;
            }
            if (perms.charAt(2) == 'x') {
                number |= 0x40;
            }
            if (perms.charAt(3) == 'r') {
                number |= 0x20;
            }
            if (perms.charAt(4) == 'w') {
                number |= 0x10;
            }
            if (perms.charAt(5) == 'x') {
                number |= 8;
            }
            if (perms.charAt(6) == 'r') {
                number |= 4;
            }
            if (perms.charAt(7) == 'w') {
                number |= 2;
            }
            if (perms.charAt(8) == 'x') {
                number |= 1;
            }
        } else if (numPattern.matcher(perms).matches()) {
            try {
                number = Integer.parseInt(perms, 8);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return number;
    }

    static {
        JSch.setLogger((Logger)new Logger(){

            public boolean isEnabled(int level) {
                return true;
            }

            public void log(int level, String message) {
                LoggerFactory.getLogger(SFTPTransfer.class).debug("SFTP Log: {}", (Object)message);
            }
        });
    }
}

