/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.sql;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.avro.Schema;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.AbstractQueryDatabaseTable;
import org.apache.nifi.processors.standard.sql.SqlWriter;
import org.apache.nifi.processors.standard.util.JdbcCommon;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.serialization.record.ResultSetRecordSet;

public class RecordSqlWriter
implements SqlWriter {
    private final RecordSetWriterFactory recordSetWriterFactory;
    private final AtomicReference<WriteResult> writeResultRef;
    private final JdbcCommon.AvroConversionOptions options;
    private final int maxRowsPerFlowFile;
    private final Map<String, String> originalAttributes;
    private ResultSetRecordSet fullRecordSet;
    private RecordSchema writeSchema;
    private String mimeType;

    public RecordSqlWriter(RecordSetWriterFactory recordSetWriterFactory, JdbcCommon.AvroConversionOptions options, int maxRowsPerFlowFile, Map<String, String> originalAttributes) {
        this.recordSetWriterFactory = recordSetWriterFactory;
        this.writeResultRef = new AtomicReference();
        this.maxRowsPerFlowFile = maxRowsPerFlowFile;
        this.options = options;
        this.originalAttributes = originalAttributes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long writeResultSet(ResultSet resultSet, OutputStream outputStream, ComponentLog logger, AbstractQueryDatabaseTable.MaxValueResultSetRowCollector callback) throws Exception {
        ResultSetRecordSet recordSet;
        try {
            if (this.fullRecordSet == null) {
                Schema avroSchema = JdbcCommon.createSchema(resultSet, this.options);
                RecordSchema recordAvroSchema = AvroTypeUtil.createSchema((Schema)avroSchema);
                this.fullRecordSet = new ResultSetRecordSetWithCallback(resultSet, recordAvroSchema, callback);
                this.writeSchema = this.recordSetWriterFactory.getSchema(this.originalAttributes, this.fullRecordSet.getSchema());
            }
            recordSet = this.maxRowsPerFlowFile > 0 ? this.fullRecordSet.limit(this.maxRowsPerFlowFile) : this.fullRecordSet;
        }
        catch (IOException | SQLException | SchemaNotFoundException e) {
            throw new ProcessException(e);
        }
        try (RecordSetWriter resultSetWriter = this.recordSetWriterFactory.createWriter(logger, this.writeSchema, outputStream);){
            this.writeResultRef.set(resultSetWriter.write((RecordSet)recordSet));
            if (this.mimeType == null) {
                this.mimeType = resultSetWriter.getMimeType();
            }
            long l = this.writeResultRef.get().getRecordCount();
            return l;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Map<String, String> getAttributesToAdd() {
        HashMap<String, String> attributesToAdd = new HashMap<String, String>();
        attributesToAdd.put(CoreAttributes.MIME_TYPE.key(), this.mimeType);
        WriteResult result = this.writeResultRef.get();
        if (result != null) {
            if (result.getAttributes() != null) {
                attributesToAdd.putAll(result.getAttributes());
            }
            attributesToAdd.put("record.count", String.valueOf(result.getRecordCount()));
        }
        return attributesToAdd;
    }

    @Override
    public void updateCounters(ProcessSession session) {
        WriteResult result = this.writeResultRef.get();
        if (result != null) {
            session.adjustCounter("Records Written", (long)result.getRecordCount(), false);
        }
    }

    @Override
    public void writeEmptyResultSet(OutputStream outputStream, ComponentLog logger) throws IOException {
        try (RecordSetWriter resultSetWriter = this.recordSetWriterFactory.createWriter(logger, this.writeSchema, outputStream);){
            this.mimeType = resultSetWriter.getMimeType();
            resultSetWriter.beginRecordSet();
            resultSetWriter.finishRecordSet();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    private static class ResultSetRecordSetWithCallback
    extends ResultSetRecordSet {
        private final AbstractQueryDatabaseTable.MaxValueResultSetRowCollector callback;

        ResultSetRecordSetWithCallback(ResultSet rs, RecordSchema readerSchema, AbstractQueryDatabaseTable.MaxValueResultSetRowCollector callback) throws SQLException {
            super(rs, readerSchema);
            this.callback = callback;
        }

        public Record next() throws IOException {
            try {
                if (this.hasMoreRows()) {
                    ResultSet rs = this.getResultSet();
                    Record record = this.createRecord(rs);
                    if (this.callback != null) {
                        this.callback.processRow(rs);
                    }
                    this.setMoreRows(rs.next());
                    return record;
                }
                return null;
            }
            catch (SQLException e) {
                throw new IOException("Could not obtain next record from ResultSet", e);
            }
        }
    }
}

