/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.standard.EncryptContent;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.KeyDerivationFunction;
import org.apache.nifi.security.util.crypto.CipherProviderFactory;
import org.apache.nifi.security.util.crypto.CipherUtility;
import org.apache.nifi.security.util.crypto.KeyedCipherProvider;

public class KeyedEncryptor
implements EncryptContent.Encryptor {
    private EncryptionMethod encryptionMethod;
    private SecretKey key;
    private byte[] iv;
    private static final int DEFAULT_MAX_ALLOWED_KEY_LENGTH = 128;
    private static boolean isUnlimitedStrengthCryptographyEnabled;

    public KeyedEncryptor(EncryptionMethod encryptionMethod, SecretKey key) {
        this(encryptionMethod, key == null ? new byte[]{} : key.getEncoded(), new byte[0]);
    }

    public KeyedEncryptor(EncryptionMethod encryptionMethod, SecretKey key, byte[] iv) {
        this(encryptionMethod, key == null ? new byte[]{} : key.getEncoded(), iv);
    }

    public KeyedEncryptor(EncryptionMethod encryptionMethod, byte[] keyBytes) {
        this(encryptionMethod, keyBytes, new byte[0]);
    }

    public KeyedEncryptor(EncryptionMethod encryptionMethod, byte[] keyBytes, byte[] iv) {
        try {
            if (encryptionMethod == null) {
                throw new IllegalArgumentException("Cannot instantiate a keyed encryptor with null encryption method");
            }
            if (!encryptionMethod.isKeyedCipher()) {
                throw new IllegalArgumentException("Cannot instantiate a keyed encryptor with encryption method " + encryptionMethod.name());
            }
            this.encryptionMethod = encryptionMethod;
            if (keyBytes == null || keyBytes.length == 0) {
                throw new IllegalArgumentException("Cannot instantiate a keyed encryptor with empty key");
            }
            if (!CipherUtility.isValidKeyLengthForAlgorithm((int)(keyBytes.length * 8), (String)encryptionMethod.getAlgorithm())) {
                throw new IllegalArgumentException("Cannot instantiate a keyed encryptor with key of length " + keyBytes.length);
            }
            String cipherName = CipherUtility.parseCipherFromAlgorithm((String)encryptionMethod.getAlgorithm());
            this.key = new SecretKeySpec(keyBytes, cipherName);
            this.iv = iv;
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public static int getMaxAllowedKeyLength(String algorithm) {
        if (StringUtils.isEmpty((CharSequence)algorithm)) {
            return 128;
        }
        String parsedCipher = CipherUtility.parseCipherFromAlgorithm((String)algorithm);
        try {
            return Cipher.getMaxAllowedKeyLength(parsedCipher);
        }
        catch (NoSuchAlgorithmException e) {
            return 128;
        }
    }

    public static boolean supportsUnlimitedStrength() {
        return isUnlimitedStrengthCryptographyEnabled;
    }

    @Override
    public StreamCallback getEncryptionCallback() throws ProcessException {
        return new EncryptCallback();
    }

    @Override
    public StreamCallback getDecryptionCallback() throws ProcessException {
        return new DecryptCallback();
    }

    static /* synthetic */ byte[] access$002(KeyedEncryptor x0, byte[] x1) {
        x0.iv = x1;
        return x1;
    }

    static {
        try {
            isUnlimitedStrengthCryptographyEnabled = Cipher.getMaxAllowedKeyLength("AES") > 128;
        }
        catch (NoSuchAlgorithmException e) {
            isUnlimitedStrengthCryptographyEnabled = false;
        }
    }

    private class EncryptCallback
    implements StreamCallback {
        public void process(InputStream in, OutputStream out) throws IOException {
            KeyedCipherProvider cipherProvider = (KeyedCipherProvider)CipherProviderFactory.getCipherProvider((KeyDerivationFunction)KeyDerivationFunction.NONE);
            try {
                Cipher cipher = cipherProvider.getCipher(KeyedEncryptor.this.encryptionMethod, KeyedEncryptor.this.key, KeyedEncryptor.this.iv, true);
                cipherProvider.writeIV(cipher.getIV(), out);
                CipherUtility.processStreams((Cipher)cipher, (InputStream)in, (OutputStream)out);
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
        }
    }

    private class DecryptCallback
    implements StreamCallback {
        public void process(InputStream in, OutputStream out) throws IOException {
            KeyedCipherProvider cipherProvider = (KeyedCipherProvider)CipherProviderFactory.getCipherProvider((KeyDerivationFunction)KeyDerivationFunction.NONE);
            try {
                if (KeyedEncryptor.this.iv.length == 0) {
                    KeyedEncryptor.access$002(KeyedEncryptor.this, cipherProvider.readIV(in));
                }
                Cipher cipher = cipherProvider.getCipher(KeyedEncryptor.this.encryptionMethod, KeyedEncryptor.this.key, KeyedEncryptor.this.iv, false);
                CipherUtility.processStreams((Cipher)cipher, (InputStream)in, (OutputStream)out);
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
        }
    }
}

