/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.standard.EncryptContent;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.KeyDerivationFunction;
import org.apache.nifi.security.util.crypto.CipherProviderFactory;
import org.apache.nifi.security.util.crypto.CipherUtility;
import org.apache.nifi.security.util.crypto.NiFiLegacyCipherProvider;
import org.apache.nifi.security.util.crypto.PBECipherProvider;
import org.apache.nifi.security.util.crypto.RandomIVPBECipherProvider;

public class PasswordBasedEncryptor
implements EncryptContent.Encryptor {
    private EncryptionMethod encryptionMethod;
    private PBEKeySpec password;
    private KeyDerivationFunction kdf;
    private static final int DEFAULT_MAX_ALLOWED_KEY_LENGTH = 128;
    private static final int MINIMUM_SAFE_PASSWORD_LENGTH = 10;
    private static boolean isUnlimitedStrengthCryptographyEnabled;

    public PasswordBasedEncryptor(EncryptionMethod encryptionMethod, char[] password, KeyDerivationFunction kdf) {
        try {
            if (encryptionMethod == null) {
                throw new IllegalArgumentException("Cannot initialize password-based encryptor with null encryption method");
            }
            this.encryptionMethod = encryptionMethod;
            if (kdf == null || kdf.equals((Object)KeyDerivationFunction.NONE)) {
                throw new IllegalArgumentException("Cannot initialize password-based encryptor with null KDF");
            }
            this.kdf = kdf;
            if (password == null || password.length == 0) {
                throw new IllegalArgumentException("Cannot initialize password-based encryptor with empty password");
            }
            this.password = new PBEKeySpec(password);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public static int getMaxAllowedKeyLength(String algorithm) {
        if (StringUtils.isEmpty((CharSequence)algorithm)) {
            return 128;
        }
        String parsedCipher = CipherUtility.parseCipherFromAlgorithm((String)algorithm);
        try {
            return Cipher.getMaxAllowedKeyLength(parsedCipher);
        }
        catch (NoSuchAlgorithmException e) {
            return 128;
        }
    }

    public static int getMinimumSafePasswordLength() {
        return 10;
    }

    public static boolean supportsUnlimitedStrength() {
        return isUnlimitedStrengthCryptographyEnabled;
    }

    @Override
    public StreamCallback getEncryptionCallback() throws ProcessException {
        return new EncryptCallback();
    }

    @Override
    public StreamCallback getDecryptionCallback() throws ProcessException {
        return new DecryptCallback();
    }

    static {
        try {
            isUnlimitedStrengthCryptographyEnabled = Cipher.getMaxAllowedKeyLength("AES") > 128;
        }
        catch (NoSuchAlgorithmException e) {
            isUnlimitedStrengthCryptographyEnabled = false;
        }
    }

    private class EncryptCallback
    implements StreamCallback {
        public void process(InputStream in, OutputStream out) throws IOException {
            PBECipherProvider cipherProvider = (PBECipherProvider)CipherProviderFactory.getCipherProvider((KeyDerivationFunction)PasswordBasedEncryptor.this.kdf);
            byte[] salt = cipherProvider instanceof NiFiLegacyCipherProvider ? ((NiFiLegacyCipherProvider)cipherProvider).generateSalt(PasswordBasedEncryptor.this.encryptionMethod) : cipherProvider.generateSalt();
            cipherProvider.writeSalt(salt, out);
            int keyLength = CipherUtility.parseKeyLengthFromAlgorithm((String)PasswordBasedEncryptor.this.encryptionMethod.getAlgorithm());
            try {
                Cipher cipher = cipherProvider.getCipher(PasswordBasedEncryptor.this.encryptionMethod, new String(PasswordBasedEncryptor.this.password.getPassword()), salt, keyLength, true);
                if (cipherProvider instanceof RandomIVPBECipherProvider) {
                    ((RandomIVPBECipherProvider)cipherProvider).writeIV(cipher.getIV(), out);
                }
                CipherUtility.processStreams((Cipher)cipher, (InputStream)in, (OutputStream)out);
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
        }
    }

    private class DecryptCallback
    implements StreamCallback {
        public void process(InputStream in, OutputStream out) throws IOException {
            byte[] salt;
            PBECipherProvider cipherProvider = (PBECipherProvider)CipherProviderFactory.getCipherProvider((KeyDerivationFunction)PasswordBasedEncryptor.this.kdf);
            try {
                salt = cipherProvider instanceof NiFiLegacyCipherProvider ? ((NiFiLegacyCipherProvider)cipherProvider).readSalt(PasswordBasedEncryptor.this.encryptionMethod, in) : cipherProvider.readSalt(in);
            }
            catch (EOFException e) {
                throw new ProcessException("Cannot decrypt because file size is smaller than salt size", (Throwable)e);
            }
            int keyLength = CipherUtility.parseKeyLengthFromAlgorithm((String)PasswordBasedEncryptor.this.encryptionMethod.getAlgorithm());
            try {
                Cipher cipher;
                if (cipherProvider instanceof RandomIVPBECipherProvider) {
                    RandomIVPBECipherProvider rivpcp = (RandomIVPBECipherProvider)cipherProvider;
                    byte[] iv = rivpcp.readIV(in);
                    cipher = rivpcp.getCipher(PasswordBasedEncryptor.this.encryptionMethod, new String(PasswordBasedEncryptor.this.password.getPassword()), salt, iv, keyLength, false);
                } else {
                    cipher = cipherProvider.getCipher(PasswordBasedEncryptor.this.encryptionMethod, new String(PasswordBasedEncryptor.this.password.getPassword()), salt, keyLength, false);
                }
                CipherUtility.processStreams((Cipher)cipher, (InputStream)in, (OutputStream)out);
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
        }
    }
}

