/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lzma.sdk.lzma.Decoder;
import lzma.streams.LzmaInputStream;
import lzma.streams.LzmaOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.stream.io.GZIPOutputStream;
import org.apache.nifi.util.StopWatch;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;
import org.xerial.snappy.SnappyFramedInputStream;
import org.xerial.snappy.SnappyFramedOutputStream;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

@EventDriven
@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"content", "compress", "decompress", "gzip", "bzip2", "lzma", "xz-lzma2", "snappy", "snappy framed"})
@CapabilityDescription(value="Compresses or decompresses the contents of FlowFiles using a user-specified compression algorithm and updates the mime.type attribute as appropriate")
@ReadsAttribute(attribute="mime.type", description="If the Compression Format is set to use mime.type attribute, this attribute is used to determine the compression type. Otherwise, this attribute is ignored.")
@WritesAttribute(attribute="mime.type", description="If the Mode property is set to compress, the appropriate MIME Type is set. If the Mode property is set to decompress and the file is successfully decompressed, this attribute is removed, as the MIME Type is no longer known.")
@SystemResourceConsideration(resource=SystemResource.CPU)
public class CompressContent
extends AbstractProcessor {
    public static final String COMPRESSION_FORMAT_ATTRIBUTE = "use mime.type attribute";
    public static final String COMPRESSION_FORMAT_GZIP = "gzip";
    public static final String COMPRESSION_FORMAT_BZIP2 = "bzip2";
    public static final String COMPRESSION_FORMAT_XZ_LZMA2 = "xz-lzma2";
    public static final String COMPRESSION_FORMAT_LZMA = "lzma";
    public static final String COMPRESSION_FORMAT_SNAPPY = "snappy";
    public static final String COMPRESSION_FORMAT_SNAPPY_FRAMED = "snappy framed";
    public static final String MODE_COMPRESS = "compress";
    public static final String MODE_DECOMPRESS = "decompress";
    public static final PropertyDescriptor COMPRESSION_FORMAT = new PropertyDescriptor.Builder().name("Compression Format").description("The compression format to use. Valid values are: GZIP, BZIP2, XZ-LZMA2, LZMA, Snappy, and Snappy Framed").allowableValues(new String[]{"use mime.type attribute", "gzip", "bzip2", "xz-lzma2", "lzma", "snappy", "snappy framed"}).defaultValue("use mime.type attribute").required(true).build();
    public static final PropertyDescriptor COMPRESSION_LEVEL = new PropertyDescriptor.Builder().name("Compression Level").description("The compression level to use; this is valid only when using GZIP compression. A lower value results in faster processing but less compression; a value of 0 indicates no compression but simply archiving").defaultValue("1").required(true).allowableValues(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}).build();
    public static final PropertyDescriptor MODE = new PropertyDescriptor.Builder().name("Mode").description("Indicates whether the processor should compress content or decompress content. Must be either 'compress' or 'decompress'").allowableValues(new String[]{"compress", "decompress"}).defaultValue("compress").required(true).build();
    public static final PropertyDescriptor UPDATE_FILENAME = new PropertyDescriptor.Builder().name("Update Filename").description("If true, will remove the filename extension when decompressing data (only if the extension indicates the appropriate compression format) and add the appropriate extension when compressing data").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles will be transferred to the success relationship after successfully being compressed or decompressed").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles will be transferred to the failure relationship if they fail to compress/decompress").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;
    private Map<String, String> compressionFormatMimeTypeMap;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(MODE);
        properties.add(COMPRESSION_FORMAT);
        properties.add(COMPRESSION_LEVEL);
        properties.add(UPDATE_FILENAME);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
        HashMap<String, String> mimeTypeMap = new HashMap<String, String>();
        mimeTypeMap.put("application/gzip", COMPRESSION_FORMAT_GZIP);
        mimeTypeMap.put("application/x-gzip", COMPRESSION_FORMAT_GZIP);
        mimeTypeMap.put("application/bzip2", COMPRESSION_FORMAT_BZIP2);
        mimeTypeMap.put("application/x-bzip2", COMPRESSION_FORMAT_BZIP2);
        mimeTypeMap.put("application/x-lzma", COMPRESSION_FORMAT_LZMA);
        mimeTypeMap.put("application/x-snappy", COMPRESSION_FORMAT_SNAPPY);
        mimeTypeMap.put("application/x-snappy-framed", COMPRESSION_FORMAT_SNAPPY_FRAMED);
        this.compressionFormatMimeTypeMap = Collections.unmodifiableMap(mimeTypeMap);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public void onTrigger(final ProcessContext context, ProcessSession session) {
        String fileExtension;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        long sizeBeforeCompression = flowFile.getSize();
        final String compressionMode = context.getProperty(MODE).getValue();
        String compressionFormatValue = context.getProperty(COMPRESSION_FORMAT).getValue();
        if (compressionFormatValue.equals(COMPRESSION_FORMAT_ATTRIBUTE)) {
            String mimeType = flowFile.getAttribute(CoreAttributes.MIME_TYPE.key());
            if (mimeType == null) {
                logger.error("No {} attribute exists for {}; routing to failure", new Object[]{CoreAttributes.MIME_TYPE.key(), flowFile});
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            compressionFormatValue = this.compressionFormatMimeTypeMap.get(mimeType);
            if (compressionFormatValue == null) {
                logger.info("Mime Type of {} is '{}', which does not indicate a supported Compression Format; routing to success without decompressing", new Object[]{flowFile, mimeType});
                session.transfer(flowFile, REL_SUCCESS);
                return;
            }
        }
        final String compressionFormat = compressionFormatValue;
        final AtomicReference<Object> mimeTypeRef = new AtomicReference<Object>(null);
        StopWatch stopWatch = new StopWatch(true);
        switch (compressionFormat.toLowerCase()) {
            case "gzip": {
                fileExtension = ".gz";
                break;
            }
            case "lzma": {
                fileExtension = ".lzma";
                break;
            }
            case "xz-lzma2": {
                fileExtension = ".xz";
                break;
            }
            case "bzip2": {
                fileExtension = ".bz2";
                break;
            }
            case "snappy": {
                fileExtension = ".snappy";
                break;
            }
            case "snappy framed": {
                fileExtension = ".sz";
                break;
            }
            default: {
                fileExtension = "";
            }
        }
        try {
            flowFile = session.write(flowFile, new StreamCallback(){

                public void process(InputStream rawIn, OutputStream rawOut) throws IOException {
                    BufferedOutputStream compressionOut;
                    BufferedInputStream compressionIn;
                    BufferedOutputStream bufferedOut = new BufferedOutputStream(rawOut, 65536);
                    BufferedInputStream bufferedIn = new BufferedInputStream(rawIn, 65536);
                    try {
                        if (CompressContent.MODE_COMPRESS.equalsIgnoreCase(compressionMode)) {
                            compressionIn = bufferedIn;
                            switch (compressionFormat.toLowerCase()) {
                                case "gzip": {
                                    int compressionLevel = context.getProperty(COMPRESSION_LEVEL).asInteger();
                                    compressionOut = new GZIPOutputStream((OutputStream)bufferedOut, compressionLevel);
                                    mimeTypeRef.set("application/gzip");
                                    break;
                                }
                                case "lzma": {
                                    compressionOut = new LzmaOutputStream.Builder((OutputStream)bufferedOut).build();
                                    mimeTypeRef.set("application/x-lzma");
                                    break;
                                }
                                case "xz-lzma2": {
                                    compressionOut = new XZOutputStream((OutputStream)bufferedOut, (FilterOptions)new LZMA2Options());
                                    mimeTypeRef.set("application/x-xz");
                                    break;
                                }
                                case "snappy": {
                                    compressionOut = new SnappyOutputStream((OutputStream)bufferedOut);
                                    mimeTypeRef.set("application/x-snappy");
                                    break;
                                }
                                case "snappy framed": {
                                    compressionOut = new SnappyFramedOutputStream((OutputStream)bufferedOut);
                                    mimeTypeRef.set("application/x-snappy-framed");
                                    break;
                                }
                                default: {
                                    mimeTypeRef.set("application/x-bzip2");
                                    compressionOut = new CompressorStreamFactory().createCompressorOutputStream(compressionFormat.toLowerCase(), (OutputStream)bufferedOut);
                                    break;
                                }
                            }
                        } else {
                            compressionOut = bufferedOut;
                            switch (compressionFormat.toLowerCase()) {
                                case "lzma": {
                                    compressionIn = new LzmaInputStream((InputStream)bufferedIn, new Decoder());
                                    break;
                                }
                                case "xz-lzma2": {
                                    compressionIn = new XZInputStream((InputStream)bufferedIn);
                                    break;
                                }
                                case "bzip2": {
                                    compressionIn = new BZip2CompressorInputStream((InputStream)bufferedIn, true);
                                    break;
                                }
                                case "gzip": {
                                    compressionIn = new GzipCompressorInputStream((InputStream)bufferedIn, true);
                                    break;
                                }
                                case "snappy": {
                                    compressionIn = new SnappyInputStream((InputStream)bufferedIn);
                                    break;
                                }
                                case "snappy framed": {
                                    compressionIn = new SnappyFramedInputStream((InputStream)bufferedIn);
                                    break;
                                }
                                default: {
                                    compressionIn = new CompressorStreamFactory().createCompressorInputStream(compressionFormat.toLowerCase(), (InputStream)bufferedIn);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        CompressContent.this.closeQuietly(bufferedOut);
                        throw new IOException(e);
                    }
                    try (BufferedInputStream in = compressionIn;
                         BufferedOutputStream out = compressionOut;){
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = ((InputStream)in).read(buffer)) > 0) {
                            ((OutputStream)out).write(buffer, 0, len);
                        }
                        ((OutputStream)out).flush();
                    }
                }
            });
            stopWatch.stop();
            long sizeAfterCompression = flowFile.getSize();
            if (MODE_DECOMPRESS.equalsIgnoreCase(compressionMode)) {
                String filename;
                flowFile = session.removeAttribute(flowFile, CoreAttributes.MIME_TYPE.key());
                if (context.getProperty(UPDATE_FILENAME).asBoolean().booleanValue() && (filename = flowFile.getAttribute(CoreAttributes.FILENAME.key())).toLowerCase().endsWith(fileExtension)) {
                    flowFile = session.putAttribute(flowFile, CoreAttributes.FILENAME.key(), filename.substring(0, filename.length() - fileExtension.length()));
                }
            } else {
                flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), (String)mimeTypeRef.get());
                if (context.getProperty(UPDATE_FILENAME).asBoolean().booleanValue()) {
                    String filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
                    flowFile = session.putAttribute(flowFile, CoreAttributes.FILENAME.key(), filename + fileExtension);
                }
            }
            logger.info("Successfully {}ed {} using {} compression format; size changed from {} to {} bytes", new Object[]{compressionMode.toLowerCase(), flowFile, compressionFormat, sizeBeforeCompression, sizeAfterCompression});
            session.getProvenanceReporter().modifyContent(flowFile, stopWatch.getDuration(TimeUnit.MILLISECONDS));
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (ProcessException e) {
            logger.error("Unable to {} {} using {} compression format due to {}; routing to failure", new Object[]{compressionMode.toLowerCase(), flowFile, compressionFormat, e});
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

