/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.standard.AbstractRecordProcessor;
import org.apache.nifi.processors.standard.ConvertRecord;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.RecordPathResult;
import org.apache.nifi.record.path.util.RecordPathCache;
import org.apache.nifi.record.path.validation.RecordPathPropertyNameValidator;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

@EventDriven
@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"update", "record", "generic", "schema", "json", "csv", "avro", "log", "logs", "freeform", "text"})
@CapabilityDescription(value="Updates the contents of a FlowFile that contains Record-oriented data (i.e., data that can be read via a RecordReader and written by a RecordWriter). This Processor requires that at least one user-defined Property be added. The name of the Property should indicate a RecordPath that determines the field that should be updated. The value of the Property is either a replacement value (optionally making use of the Expression Language) or is itself a RecordPath that extracts a value from the Record. Whether the Property value is determined to be a RecordPath or a literal value depends on the configuration of the <Replacement Value Strategy> Property.")
@SeeAlso(value={ConvertRecord.class})
public class UpdateRecord
extends AbstractRecordProcessor {
    private static final String FIELD_NAME = "field.name";
    private static final String FIELD_VALUE = "field.value";
    private static final String FIELD_TYPE = "field.type";
    private volatile RecordPathCache recordPathCache;
    private volatile List<String> recordPaths;
    static final AllowableValue LITERAL_VALUES = new AllowableValue("literal-value", "Literal Value", "The value entered for a Property (after Expression Language has been evaluated) is the desired value to update the Record Fields with. Expression Language may reference variables 'field.name', 'field.type', and 'field.value' to access information about the field and the value of the field being evaluated.");
    static final AllowableValue RECORD_PATH_VALUES = new AllowableValue("record-path-value", "Record Path Value", "The value entered for a Property (after Expression Language has been evaluated) is not the literal value to use but rather is a Record Path that should be evaluated against the Record, and the result of the RecordPath will be used to update the Record. Note that if this option is selected, and the Record Path results in multiple values for a given Record, the input FlowFile will be routed to the 'failure' Relationship.");
    static final PropertyDescriptor REPLACEMENT_VALUE_STRATEGY = new PropertyDescriptor.Builder().name("replacement-value-strategy").displayName("Replacement Value Strategy").description("Specifies how to interpret the configured replacement values").allowableValues(new AllowableValue[]{LITERAL_VALUES, RECORD_PATH_VALUES}).defaultValue(LITERAL_VALUES.getValue()).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).build();

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(REPLACEMENT_VALUE_STRATEGY);
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("Specifies the value to use to replace fields in the record that match the RecordPath: " + propertyDescriptorName).required(false).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)new RecordPathPropertyNameValidator()).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        boolean containsDynamic = validationContext.getProperties().keySet().stream().anyMatch(PropertyDescriptor::isDynamic);
        if (containsDynamic) {
            return Collections.emptyList();
        }
        return Collections.singleton(new ValidationResult.Builder().subject("User-defined Properties").valid(false).explanation("At least one RecordPath must be specified").build());
    }

    @OnScheduled
    public void createRecordPaths(ProcessContext context) {
        this.recordPathCache = new RecordPathCache(context.getProperties().size() * 2);
        ArrayList<String> recordPaths = new ArrayList<String>(context.getProperties().size() - 2);
        for (PropertyDescriptor property : context.getProperties().keySet()) {
            if (!property.isDynamic()) continue;
            recordPaths.add(property.getName());
        }
        this.recordPaths = recordPaths;
    }

    @Override
    protected Record process(Record record, FlowFile flowFile, ProcessContext context) {
        boolean evaluateValueAsRecordPath = context.getProperty(REPLACEMENT_VALUE_STRATEGY).getValue().equals(RECORD_PATH_VALUES.getValue());
        for (String recordPathText : this.recordPaths) {
            Object replacementValue;
            RecordPath recordPath = this.recordPathCache.getCompiled(recordPathText);
            RecordPathResult result = recordPath.evaluate(record);
            if (evaluateValueAsRecordPath) {
                replacementValue = context.getProperty(recordPathText).evaluateAttributeExpressions(flowFile).getValue();
                RecordPath replacementRecordPath = this.recordPathCache.getCompiled((String)replacementValue);
                if (replacementRecordPath.isAbsolute()) {
                    record = this.processAbsolutePath(replacementRecordPath, result.getSelectedFields(), record);
                    continue;
                }
                record = this.processRelativePath(replacementRecordPath, result.getSelectedFields(), record);
                continue;
            }
            replacementValue = context.getProperty(recordPathText);
            if (replacementValue.isExpressionLanguagePresent()) {
                HashMap fieldVariables = new HashMap();
                result.getSelectedFields().forEach(arg_0 -> UpdateRecord.lambda$process$0(fieldVariables, (PropertyValue)replacementValue, flowFile, arg_0));
                continue;
            }
            String evaluatedReplacementVal = replacementValue.evaluateAttributeExpressions(flowFile).getValue();
            result.getSelectedFields().forEach(fieldVal -> fieldVal.updateValue((Object)evaluatedReplacementVal, RecordFieldType.STRING.getDataType()));
        }
        record.incorporateInactiveFields();
        return record;
    }

    private Record processAbsolutePath(RecordPath replacementRecordPath, Stream<FieldValue> destinationFields, Record record) {
        RecordPathResult replacementResult = replacementRecordPath.evaluate(record);
        List<FieldValue> selectedFields = replacementResult.getSelectedFields().collect(Collectors.toList());
        List<FieldValue> destinationFieldValues = destinationFields.collect(Collectors.toList());
        return this.updateRecord(destinationFieldValues, selectedFields, record);
    }

    private Record processRelativePath(RecordPath replacementRecordPath, Stream<FieldValue> destinationFields, Record record) {
        List<FieldValue> destinationFieldValues = destinationFields.collect(Collectors.toList());
        for (FieldValue fieldVal : destinationFieldValues) {
            RecordPathResult replacementResult = replacementRecordPath.evaluate(record, fieldVal);
            List<FieldValue> selectedFields = replacementResult.getSelectedFields().collect(Collectors.toList());
            Object replacementObject = this.getReplacementObject(selectedFields);
            this.updateFieldValue(fieldVal, replacementObject);
            record = this.updateRecord(destinationFieldValues, selectedFields, record);
        }
        return record;
    }

    private Record updateRecord(List<FieldValue> destinationFields, List<FieldValue> selectedFields, Record record) {
        if (destinationFields.size() == 1 && !destinationFields.get(0).getParentRecord().isPresent()) {
            Object replacement = this.getReplacementObject(selectedFields);
            if (replacement == null) {
                return record;
            }
            if (replacement instanceof Record) {
                return (Record)replacement;
            }
            FieldValue replacementFieldValue = (FieldValue)replacement;
            if (replacementFieldValue.getValue() instanceof Record) {
                return (Record)replacementFieldValue.getValue();
            }
            List fields = selectedFields.stream().map(FieldValue::getField).collect(Collectors.toList());
            SimpleRecordSchema schema = new SimpleRecordSchema(fields);
            MapRecord mapRecord = new MapRecord((RecordSchema)schema, new HashMap());
            for (FieldValue selectedField : selectedFields) {
                mapRecord.setValue(selectedField.getField(), selectedField.getValue());
            }
            return mapRecord;
        }
        for (FieldValue fieldVal : destinationFields) {
            Object replacementObject = this.getReplacementObject(selectedFields);
            this.updateFieldValue(fieldVal, replacementObject);
        }
        return record;
    }

    private void updateFieldValue(FieldValue fieldValue, Object replacement) {
        if (replacement instanceof FieldValue) {
            FieldValue replacementFieldValue = (FieldValue)replacement;
            fieldValue.updateValue(replacementFieldValue.getValue(), replacementFieldValue.getField().getDataType());
        } else {
            fieldValue.updateValue(replacement);
        }
    }

    private Object getReplacementObject(List<FieldValue> selectedFields) {
        if (selectedFields.size() > 1) {
            List fields = selectedFields.stream().map(FieldValue::getField).collect(Collectors.toList());
            SimpleRecordSchema schema = new SimpleRecordSchema(fields);
            MapRecord record = new MapRecord((RecordSchema)schema, new HashMap());
            for (FieldValue fieldVal : selectedFields) {
                record.setValue(fieldVal.getField(), fieldVal.getValue());
            }
            return record;
        }
        if (selectedFields.isEmpty()) {
            return null;
        }
        return selectedFields.get(0);
    }

    private static /* synthetic */ void lambda$process$0(Map fieldVariables, PropertyValue replacementValue, FlowFile flowFile, FieldValue fieldVal) {
        fieldVariables.clear();
        fieldVariables.put(FIELD_NAME, fieldVal.getField().getFieldName());
        fieldVariables.put(FIELD_VALUE, DataTypeUtils.toString((Object)fieldVal.getValue(), (String)null));
        fieldVariables.put(FIELD_TYPE, fieldVal.getField().getDataType().getFieldType().name());
        String evaluatedReplacementVal = replacementValue.evaluateAttributeExpressions(flowFile, fieldVariables).getValue();
        fieldVal.updateValue((Object)evaluatedReplacementVal, RecordFieldType.STRING.getDataType());
    }
}

