/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.sql;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.AbstractQueryDatabaseTable;
import org.apache.nifi.processors.standard.sql.SqlWriter;
import org.apache.nifi.processors.standard.util.JdbcCommon;

public class DefaultAvroSqlWriter
implements SqlWriter {
    private final JdbcCommon.AvroConversionOptions options;
    private final Map<String, String> attributesToAdd = new HashMap<String, String>(){
        {
            this.put(CoreAttributes.MIME_TYPE.key(), "application/avro-binary");
        }
    };

    public DefaultAvroSqlWriter(JdbcCommon.AvroConversionOptions options) {
        this.options = options;
    }

    @Override
    public long writeResultSet(ResultSet resultSet, OutputStream outputStream, ComponentLog logger, AbstractQueryDatabaseTable.MaxValueResultSetRowCollector callback) throws Exception {
        try {
            return JdbcCommon.convertToAvroStream(resultSet, outputStream, this.options, callback);
        }
        catch (SQLException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    @Override
    public Map<String, String> getAttributesToAdd() {
        return this.attributesToAdd;
    }

    @Override
    public void writeEmptyResultSet(OutputStream outputStream, ComponentLog logger) throws IOException {
        JdbcCommon.createEmptyAvroStream(outputStream);
    }

    @Override
    public String getMimeType() {
        return "application/avro-binary";
    }
}

