/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@SideEffectFree
@SupportsBatching
@Tags(value={"json", "attributes", "flowfile"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Generates a JSON representation of the input FlowFile Attributes. The resulting JSON can be written to either a new Attribute 'JSONAttributes' or written to the FlowFile as content. Attributes  which contain nested JSON objects can either be handled as JSON or as escaped JSON depending on the strategy chosen.")
@WritesAttribute(attribute="JSONAttributes", description="JSON representation of Attributes")
public class AttributesToJSON
extends AbstractProcessor {
    public static final String JSON_ATTRIBUTE_NAME = "JSONAttributes";
    private static final String AT_LIST_SEPARATOR = ",";
    public static final String DESTINATION_ATTRIBUTE = "flowfile-attribute";
    public static final String DESTINATION_CONTENT = "flowfile-content";
    public static final String APPLICATION_JSON = "application/json";
    public static final PropertyDescriptor ATTRIBUTES_LIST = new PropertyDescriptor.Builder().name("Attributes List").description("Comma separated list of attributes to be included in the resulting JSON. If this value is left empty then all existing Attributes will be included. This list of attributes is case sensitive. If an attribute specified in the list is not found it will be be emitted to the resulting JSON with an empty string or NULL value.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor ATTRIBUTES_REGEX = new PropertyDescriptor.Builder().name("attributes-to-json-regex").displayName("Attributes Regular Expression").description("Regular expression that will be evaluated against the flow file attributes to select the matching attributes. This property can be used in combination with the attributes list property.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.createRegexValidator((int)0, (int)Integer.MAX_VALUE, (boolean)true)).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DESTINATION = new PropertyDescriptor.Builder().name("Destination").description("Control if JSON value is written as a new flowfile attribute 'JSONAttributes' or written in the flowfile content. Writing to flowfile content will overwrite any existing flowfile content.").required(true).allowableValues(new String[]{"flowfile-attribute", "flowfile-content"}).defaultValue("flowfile-attribute").build();
    public static final PropertyDescriptor INCLUDE_CORE_ATTRIBUTES = new PropertyDescriptor.Builder().name("Include Core Attributes").description("Determines if the FlowFile org.apache.nifi.flowfile.attributes.CoreAttributes which are contained in every FlowFile should be included in the final JSON value generated.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor NULL_VALUE_FOR_EMPTY_STRING = new PropertyDescriptor.Builder().name("Null Value").description("If true a non existing selected attribute will be NULL in the resulting JSON. If false an empty string will be placed in the JSON").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor JSON_HANDLING_STRATEGY = new PropertyDescriptor.Builder().name("JSON Handling Strategy").displayName("JSON Handling Strategy").description("Strategy to use for handling attributes which contain nested JSON.").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(JsonHandlingStrategy.class).defaultValue(JsonHandlingStrategy.ESCAPED.getValue()).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Successfully converted attributes to JSON").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Failed to convert attributes to JSON").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private volatile Set<String> attributesToRemove;
    private volatile Set<String> attributes;
    private volatile Boolean nullValueForEmptyString;
    private volatile boolean destinationContent;
    private volatile Pattern pattern;
    private volatile JsonHandlingStrategy jsonHandlingStrategy;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(ATTRIBUTES_LIST);
        properties.add(ATTRIBUTES_REGEX);
        properties.add(DESTINATION);
        properties.add(INCLUDE_CORE_ATTRIBUTES);
        properties.add(NULL_VALUE_FOR_EMPTY_STRING);
        properties.add(JSON_HANDLING_STRATEGY);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected Map<String, Object> buildAttributesMapForFlowFile(FlowFile ff, Set<String> attributes, Set<String> attributesToRemove, boolean nullValForEmptyString, Pattern attPattern) {
        LinkedHashMap<String, Object> result;
        block6: {
            block5: {
                if (attributes == null && attPattern == null) break block5;
                result = new LinkedHashMap<String, Object>();
                if (attributes != null) {
                    for (String string : attributes) {
                        String val = ff.getAttribute(string);
                        if (val != null || nullValForEmptyString) {
                            result.put(string, val);
                            continue;
                        }
                        result.put(string, "");
                    }
                }
                if (attPattern == null) break block6;
                for (Map.Entry entry : ff.getAttributes().entrySet()) {
                    if (!attPattern.matcher((CharSequence)entry.getKey()).matches()) continue;
                    result.put((String)entry.getKey(), entry.getValue());
                }
                break block6;
            }
            Map ffAttributes = ff.getAttributes();
            result = new LinkedHashMap(ffAttributes.size());
            for (Map.Entry e : ffAttributes.entrySet()) {
                if (attributesToRemove.contains(e.getKey())) continue;
                result.put((String)e.getKey(), e.getValue());
            }
        }
        return result;
    }

    private Set<String> buildAtrs(String atrList) {
        String[] ats;
        if (StringUtils.isNotBlank((CharSequence)atrList) && (ats = StringUtils.split((String)atrList, (String)AT_LIST_SEPARATOR)) != null) {
            HashSet<String> result = new HashSet<String>(ats.length);
            for (String str : ats) {
                result.add(str.trim());
            }
            return result;
        }
        return null;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.attributesToRemove = context.getProperty(INCLUDE_CORE_ATTRIBUTES).asBoolean() != false ? Collections.EMPTY_SET : Arrays.stream(CoreAttributes.values()).map(CoreAttributes::key).collect(Collectors.toSet());
        this.attributes = this.buildAtrs(context.getProperty(ATTRIBUTES_LIST).getValue());
        this.nullValueForEmptyString = context.getProperty(NULL_VALUE_FOR_EMPTY_STRING).asBoolean();
        this.destinationContent = DESTINATION_CONTENT.equals(context.getProperty(DESTINATION).getValue());
        this.jsonHandlingStrategy = JsonHandlingStrategy.valueOf(context.getProperty(JSON_HANDLING_STRATEGY).getValue());
        if (context.getProperty(ATTRIBUTES_REGEX).isSet()) {
            this.pattern = Pattern.compile(context.getProperty(ATTRIBUTES_REGEX).evaluateAttributeExpressions().getValue());
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile original = session.get();
        if (original == null) {
            return;
        }
        Map<String, Object> atrList = this.buildAttributesMapForFlowFile(original, this.attributes, this.attributesToRemove, this.nullValueForEmptyString, this.pattern);
        try {
            Map<String, Object> formattedAttributes = this.getFormattedAttributes(atrList);
            if (this.destinationContent) {
                FlowFile conFlowfile = session.write(original, (in, out) -> {
                    try (BufferedOutputStream outputStream = new BufferedOutputStream(out);){
                        ((OutputStream)outputStream).write(objectMapper.writeValueAsBytes((Object)formattedAttributes));
                    }
                });
                conFlowfile = session.putAttribute(conFlowfile, CoreAttributes.MIME_TYPE.key(), APPLICATION_JSON);
                session.transfer(conFlowfile, REL_SUCCESS);
            } else {
                FlowFile atFlowfile = session.putAttribute(original, JSON_ATTRIBUTE_NAME, objectMapper.writeValueAsString(formattedAttributes));
                session.transfer(atFlowfile, REL_SUCCESS);
            }
        }
        catch (JsonProcessingException e) {
            this.getLogger().error(e.getMessage());
            session.transfer(original, REL_FAILURE);
        }
    }

    private Map<String, Object> getFormattedAttributes(Map<String, Object> flowFileAttributes) throws JsonProcessingException {
        if (JsonHandlingStrategy.ESCAPED == this.jsonHandlingStrategy) {
            return flowFileAttributes;
        }
        LinkedHashMap<String, Object> formattedAttributes = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : flowFileAttributes.entrySet()) {
            String value = (String)entry.getValue();
            if (StringUtils.isNotBlank((CharSequence)value) && (this.isPossibleJsonArray(value) || this.isPossibleJsonObject(value))) {
                formattedAttributes.put(entry.getKey(), objectMapper.readTree(value));
                continue;
            }
            formattedAttributes.put(entry.getKey(), value);
        }
        return formattedAttributes;
    }

    private boolean isPossibleJsonArray(String value) {
        return value.startsWith("[") && value.endsWith("]");
    }

    private boolean isPossibleJsonObject(String value) {
        return value.startsWith("{") && value.endsWith("}");
    }

    public static enum JsonHandlingStrategy implements DescribedValue
    {
        ESCAPED("Escaped", "Escapes JSON attribute values to strings"),
        NESTED("Nested", "Handles JSON attribute values as nested structured objects or arrays");

        private final String displayName;
        private final String description;

        private JsonHandlingStrategy(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String getValue() {
            return this.name();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

