/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.annotation.documentation.UseCases;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.standard.AbstractRecordProcessor;
import org.apache.nifi.processors.standard.ConvertRecord;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.RecordPathResult;
import org.apache.nifi.record.path.util.RecordPathCache;
import org.apache.nifi.record.path.validation.RecordPathPropertyNameValidator;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"update", "record", "generic", "schema", "json", "csv", "avro", "log", "logs", "freeform", "text"})
@CapabilityDescription(value="Updates the contents of a FlowFile that contains Record-oriented data (i.e., data that can be read via a RecordReader and written by a RecordWriter). This Processor requires that at least one user-defined Property be added. The name of the Property should indicate a RecordPath that determines the field that should be updated. The value of the Property is either a replacement value (optionally making use of the Expression Language) or is itself a RecordPath that extracts a value from the Record. Whether the Property value is determined to be a RecordPath or a literal value depends on the configuration of the <Replacement Value Strategy> Property.")
@WritesAttributes(value={@WritesAttribute(attribute="record.index", description="This attribute provides the current row index and is only available inside the literal value expression."), @WritesAttribute(attribute="record.error.message", description="This attribute provides on failure the error message encountered by the Reader or Writer.")})
@DynamicProperty(name="A RecordPath.", value="The value to use to replace fields in the record that match the RecordPath", description="Allows users to specify values to use to replace fields in the record that match the RecordPath.", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES)
@SeeAlso(value={ConvertRecord.class})
@UseCases(value={@UseCase(description="Combine multiple fields into a single field.", keywords={"combine", "concatenate", "recordpath"}, configuration="\"Replacement Value Strategy\" = \"Record Path Value\"\n\nA single additional property is added to the Processor. The name of the property is a RecordPath identifying the field to place the result in.\nThe value of the property uses the CONCAT Record Path function to concatenate multiple values together, potentially using other string literal values.\nFor example, to combine the `title`, `firstName` and `lastName` fields into a single field named `fullName`, we add a property with the name `/fullName` and a value of `CONCAT(/title, ' ', /firstName, ' ', /lastName)`\n"), @UseCase(description="Change the value of a record field to an explicit value.", keywords={"change", "update", "replace", "transform"}, configuration="    \"Replacement Value Strategy\" = \"Literal Value\"\n\n    A single additional property is added to the Processor. The name of the property is a RecordPath identifying the field to place the result in.\n    The value of the property is the explicit value to set the field to. For example, we can set any field with a name of `txId`, regardless of its level in the data's hierarchy,     to `1111-1111` by adding a property with a name of `//txId` and a value of `1111-1111`\n"), @UseCase(description="Copy the value of one record field to another record field.", keywords={"change", "update", "copy", "recordpath", "hierarchy", "transform"}, configuration="    \"Replacement Value Strategy\" = \"Record Path Value\"\n\n    A single additional property is added to the Processor. The name of the property is a RecordPath identifying the field to update.\n    The value of the property is a RecordPath identifying the field to copy the value from.\n    For example, we can copy the value of `/identifiers/all/imei` to the `identifier` field at the root level, by adding a property named     `/identifier` with a value of `/identifiers/all/imei`.\n"), @UseCase(description="Enrich data by injecting the value of an attribute into each Record.", keywords={"enrich", "attribute", "change", "update", "replace", "insert", "transform"}, configuration="\"Replacement Value Strategy\" = \"Literal Value\"\n\nA single additional property is added to the Processor. The name of the property is a RecordPath identifying the field to place the result in.\nThe value of the property is an Expression Language expression that references the attribute of interest. We can, for example, insert a new field name `filename` into each record by adding a property named `/filename` with a value of `${filename}`\n"), @UseCase(description="Change the format of a record field.", keywords={"change", "update", "replace", "insert", "transform", "format", "date/time", "timezone", "expression language"}, configuration="\"Replacement Value Strategy\" = \"Literal Value\"\n\nA single additional property is added to the Processor. The name of the property is a RecordPath identifying the field to update.\nThe value is an Expression Language expression that references the `field.value` variable. For example, to change the date/time format of a field named `txDate` from `year-month-day` format to `month/day/year` format, we add a property named `/txDate` with a value of `${field.value:toDate('yyyy-MM-dd'):format('MM/dd/yyyy')}`. We could also change the timezone of a timestamp field (and insert the timezone for clarity) by using a value of `${field.value:toDate('yyyy-MM-dd HH:mm:ss', 'UTC-0400'):format('yyyy-MM-dd HH:mm:ss Z', 'UTC')}`.\n")})
public class UpdateRecord
extends AbstractRecordProcessor {
    private static final String FIELD_NAME = "field.name";
    private static final String FIELD_VALUE = "field.value";
    private static final String FIELD_TYPE = "field.type";
    private static final String RECORD_INDEX = "record.index";
    private volatile RecordPathCache recordPathCache;
    private volatile List<String> recordPaths;
    static final AllowableValue LITERAL_VALUES = new AllowableValue("literal-value", "Literal Value", "The value entered for a Property (after Expression Language has been evaluated) is the desired value to update the Record Fields with. Expression Language may reference variables 'field.name', 'field.type', and 'field.value' to access information about the field and the value of the field being evaluated.");
    static final AllowableValue RECORD_PATH_VALUES = new AllowableValue("record-path-value", "Record Path Value", "The value entered for a Property (after Expression Language has been evaluated) is not the literal value to use but rather is a Record Path that should be evaluated against the Record, and the result of the RecordPath will be used to update the Record. Note that if this option is selected, and the Record Path results in multiple values for a given Record, the input FlowFile will be routed to the 'failure' Relationship.");
    static final PropertyDescriptor REPLACEMENT_VALUE_STRATEGY = new PropertyDescriptor.Builder().name("Replacement Value Strategy").description("Specifies how to interpret the configured replacement values").allowableValues(new AllowableValue[]{LITERAL_VALUES, RECORD_PATH_VALUES}).defaultValue(LITERAL_VALUES.getValue()).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).build();

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(REPLACEMENT_VALUE_STRATEGY);
        return properties;
    }

    @Override
    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("replacement-value-strategy", REPLACEMENT_VALUE_STRATEGY.getName());
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("Specifies the value to use to replace fields in the record that match the RecordPath: " + propertyDescriptorName).required(false).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)new RecordPathPropertyNameValidator()).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        boolean containsDynamic = validationContext.getProperties().keySet().stream().anyMatch(PropertyDescriptor::isDynamic);
        if (containsDynamic) {
            return Collections.emptyList();
        }
        return Collections.singleton(new ValidationResult.Builder().subject("User-defined Properties").valid(false).explanation("At least one RecordPath must be specified").build());
    }

    @OnScheduled
    public void createRecordPaths(ProcessContext context) {
        this.recordPathCache = new RecordPathCache(context.getProperties().size() * 2);
        ArrayList<String> recordPaths = new ArrayList<String>(context.getProperties().size() - 2);
        for (PropertyDescriptor property : context.getProperties().keySet()) {
            if (!property.isDynamic()) continue;
            recordPaths.add(property.getName());
        }
        this.recordPaths = recordPaths;
    }

    @Override
    protected Record process(Record record, FlowFile flowFile, ProcessContext context, long count) {
        boolean evaluateValueAsRecordPath = context.getProperty(REPLACEMENT_VALUE_STRATEGY).getValue().equals(RECORD_PATH_VALUES.getValue());
        for (String recordPathText : this.recordPaths) {
            Object replacementValue;
            RecordPath recordPath = this.recordPathCache.getCompiled(recordPathText);
            RecordPathResult result = recordPath.evaluate(record);
            if (evaluateValueAsRecordPath) {
                replacementValue = context.getProperty(recordPathText).evaluateAttributeExpressions(flowFile).getValue();
                RecordPath replacementRecordPath = this.recordPathCache.getCompiled((String)replacementValue);
                if (replacementRecordPath.isAbsolute()) {
                    record = this.processAbsolutePath(replacementRecordPath, result.getSelectedFields(), record);
                    continue;
                }
                record = this.processRelativePath(replacementRecordPath, result.getSelectedFields(), record);
                continue;
            }
            replacementValue = context.getProperty(recordPathText);
            if (replacementValue.isExpressionLanguagePresent()) {
                HashMap fieldVariables = new HashMap();
                result.getSelectedFields().forEach(arg_0 -> UpdateRecord.lambda$process$0(fieldVariables, count, (PropertyValue)replacementValue, flowFile, arg_0));
                continue;
            }
            String evaluatedReplacementVal = replacementValue.evaluateAttributeExpressions(flowFile).getValue();
            result.getSelectedFields().forEach(fieldVal -> fieldVal.updateValue((Object)evaluatedReplacementVal, RecordFieldType.STRING.getDataType()));
        }
        record.incorporateInactiveFields();
        return record;
    }

    private Record processAbsolutePath(RecordPath replacementRecordPath, Stream<FieldValue> destinationFields, Record record) {
        List<FieldValue> selectedFields = this.getSelectedFields(replacementRecordPath, null, record);
        List<FieldValue> destinationFieldValues = destinationFields.collect(Collectors.toList());
        return this.updateRecord(destinationFieldValues, selectedFields, record);
    }

    private boolean isReplacingRoot(List<FieldValue> destinationFields) {
        return destinationFields.size() == 1 && !destinationFields.get(0).getParentRecord().isPresent();
    }

    private Record processRelativePath(RecordPath replacementRecordPath, Stream<FieldValue> destinationFields, Record record) {
        List<FieldValue> destinationFieldValues = destinationFields.collect(Collectors.toList());
        if (this.isReplacingRoot(destinationFieldValues)) {
            List<FieldValue> selectedFields = this.getSelectedFields(replacementRecordPath, destinationFieldValues.get(0), record);
            record = this.updateRecord(destinationFieldValues, selectedFields, record);
        } else {
            for (FieldValue fieldVal : destinationFieldValues) {
                List<FieldValue> selectedFields = this.getSelectedFields(replacementRecordPath, fieldVal, record);
                Object replacementObject = this.getReplacementObject(selectedFields);
                this.updateFieldValue(fieldVal, replacementObject);
            }
        }
        return record;
    }

    private Record updateRecord(List<FieldValue> destinationFields, List<FieldValue> selectedFields, Record record) {
        if (this.isReplacingRoot(destinationFields)) {
            Object replacement = this.getReplacementObject(selectedFields);
            if (replacement == null) {
                return record;
            }
            if (replacement instanceof Record) {
                return (Record)replacement;
            }
            FieldValue replacementFieldValue = (FieldValue)replacement;
            if (replacementFieldValue.getValue() instanceof Record) {
                return (Record)replacementFieldValue.getValue();
            }
            List fields = selectedFields.stream().map(FieldValue::getField).collect(Collectors.toList());
            SimpleRecordSchema schema = new SimpleRecordSchema(fields);
            MapRecord mapRecord = new MapRecord((RecordSchema)schema, new HashMap());
            for (FieldValue selectedField : selectedFields) {
                mapRecord.setValue(selectedField.getField(), selectedField.getValue());
            }
            return mapRecord;
        }
        for (FieldValue fieldVal : destinationFields) {
            Object replacementObject = this.getReplacementObject(selectedFields);
            this.updateFieldValue(fieldVal, replacementObject);
        }
        return record;
    }

    private void updateFieldValue(FieldValue fieldValue, Object replacement) {
        if (replacement instanceof FieldValue) {
            FieldValue replacementFieldValue = (FieldValue)replacement;
            fieldValue.updateValue(replacementFieldValue.getValue(), replacementFieldValue.getField().getDataType());
        } else {
            fieldValue.updateValue(replacement);
        }
    }

    private List<FieldValue> getSelectedFields(RecordPath replacementRecordPath, FieldValue fieldValue, Record record) {
        RecordPathResult replacementResult = replacementRecordPath.evaluate(record, fieldValue);
        return replacementResult.getSelectedFields().collect(Collectors.toList());
    }

    private Object getReplacementObject(List<FieldValue> selectedFields) {
        if (selectedFields.size() > 1) {
            List fields = selectedFields.stream().map(FieldValue::getField).collect(Collectors.toList());
            SimpleRecordSchema schema = new SimpleRecordSchema(fields);
            MapRecord record = new MapRecord((RecordSchema)schema, new HashMap());
            for (FieldValue fieldVal : selectedFields) {
                record.setValue(fieldVal.getField(), fieldVal.getValue());
            }
            return record;
        }
        if (selectedFields.isEmpty()) {
            return null;
        }
        return selectedFields.get(0);
    }

    private static /* synthetic */ void lambda$process$0(Map fieldVariables, long count, PropertyValue replacementValue, FlowFile flowFile, FieldValue fieldVal) {
        fieldVariables.clear();
        fieldVariables.put(FIELD_NAME, fieldVal.getField().getFieldName());
        fieldVariables.put(FIELD_VALUE, DataTypeUtils.toString((Object)fieldVal.getValue(), (String)null));
        fieldVariables.put(FIELD_TYPE, fieldVal.getField().getDataType().getFieldType().name());
        fieldVariables.put(RECORD_INDEX, String.valueOf(count));
        String evaluatedReplacementVal = replacementValue.evaluateAttributeExpressions(flowFile, fieldVariables).getValue();
        fieldVal.updateValue((Object)evaluatedReplacementVal, RecordFieldType.STRING.getDataType());
    }
}

