/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.calcite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.RecordPathResult;
import org.apache.nifi.record.path.StandardFieldValue;
import org.apache.nifi.record.path.util.RecordPathCache;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class RecordPathFunction {
    private static final RecordField ROOT_RECORD_FIELD = new RecordField("root", RecordFieldType.MAP.getMapDataType(RecordFieldType.STRING.getDataType()));
    private static final RecordSchema ROOT_RECORD_SCHEMA = new SimpleRecordSchema(Collections.singletonList(ROOT_RECORD_FIELD));
    private static final RecordField PARENT_RECORD_FIELD = new RecordField("root", RecordFieldType.RECORD.getRecordDataType(ROOT_RECORD_SCHEMA));
    protected static final RecordPathCache RECORD_PATH_CACHE = new RecordPathCache(100);

    protected <T> T eval(Object record, String recordPath, Function<Object, T> transform) {
        if (record == null) {
            return null;
        }
        try {
            if (record instanceof Record) {
                return this.eval((Record)record, recordPath, transform);
            }
            if (record instanceof Record[]) {
                return this.eval((Record[])record, recordPath, transform);
            }
            if (record instanceof Iterable) {
                return this.eval((Iterable)record, recordPath, transform);
            }
            if (record instanceof Map) {
                return this.eval((Map)record, recordPath, transform);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " against " + String.valueOf(record), e);
        }
        throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " against given argument because the argument is of type " + String.valueOf(record.getClass()) + " instead of Record");
    }

    private <T> T eval(Map<?, ?> map, String recordPath, Function<Object, T> transform) {
        RecordPath compiled = RECORD_PATH_CACHE.getCompiled(recordPath);
        MapRecord record = new MapRecord(ROOT_RECORD_SCHEMA, Collections.singletonMap("root", map));
        StandardFieldValue parentFieldValue = new StandardFieldValue((Object)record, PARENT_RECORD_FIELD, null);
        StandardFieldValue fieldValue = new StandardFieldValue(map, ROOT_RECORD_FIELD, (FieldValue)parentFieldValue);
        RecordPathResult result = compiled.evaluate((Record)record, (FieldValue)fieldValue);
        return this.evalResults(result.getSelectedFields(), transform, () -> "RecordPath " + recordPath + " resulted in more than one return value. The RecordPath must be further constrained.");
    }

    private <T> T eval(Record record, String recordPath, Function<Object, T> transform) {
        RecordPath compiled = RECORD_PATH_CACHE.getCompiled(recordPath);
        RecordPathResult result = compiled.evaluate(record);
        return this.evalResults(result.getSelectedFields(), transform, () -> "RecordPath " + recordPath + " evaluated against " + String.valueOf(record) + " resulted in more than one return value. The RecordPath must be further constrained.");
    }

    private <T> T eval(Record[] records, String recordPath, Function<Object, T> transform) {
        RecordPath compiled = RECORD_PATH_CACHE.getCompiled(recordPath);
        ArrayList selectedFields = new ArrayList();
        for (Record record : records) {
            RecordPathResult result = compiled.evaluate(record);
            result.getSelectedFields().forEach(selectedFields::add);
        }
        if (selectedFields.isEmpty()) {
            return null;
        }
        return this.evalResults(selectedFields.stream(), transform, () -> "RecordPath " + recordPath + " resulted in more than one return value. The RecordPath must be further constrained.");
    }

    private <T> T eval(Iterable<Record> records, String recordPath, Function<Object, T> transform) {
        RecordPath compiled = RECORD_PATH_CACHE.getCompiled(recordPath);
        ArrayList selectedFields = new ArrayList();
        for (Record record : records) {
            RecordPathResult result = compiled.evaluate(record);
            result.getSelectedFields().forEach(selectedFields::add);
        }
        if (selectedFields.isEmpty()) {
            return null;
        }
        return this.evalResults(selectedFields.stream(), transform, () -> "RecordPath " + recordPath + " resulted in more than one return value. The RecordPath must be further constrained.");
    }

    private <T> T evalResults(Stream<FieldValue> fields, Function<Object, T> transform, Supplier<String> multipleReturnValueErrorSupplier) {
        return fields.map(FieldValue::getValue).filter(Objects::nonNull).map(transform).reduce((a, b) -> {
            throw new RuntimeException((String)multipleReturnValueErrorSupplier.get());
        }).orElse(null);
    }
}

