/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.enrichment;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.standard.enrichment.RecordJoinInput;
import org.apache.nifi.processors.standard.enrichment.RecordJoinResult;
import org.apache.nifi.processors.standard.enrichment.RecordJoinStrategy;
import org.apache.nifi.processors.standard.enrichment.SqlJoinCache;
import org.apache.nifi.processors.standard.enrichment.SqlJoinCalciteParameters;
import org.apache.nifi.queryrecord.RecordDataSource;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.serialization.record.ResultSetRecordSet;
import org.apache.nifi.sql.NiFiTable;
import org.apache.nifi.sql.ResettableDataSource;

public class SqlJoinStrategy
implements RecordJoinStrategy {
    public static final String ENRICHMENT_TABLE_NAME = "ENRICHMENT";
    public static final String ORIGINAL_TABLE_NAME = "ORIGINAL";
    private final SqlJoinCache cache;
    private final ComponentLog logger;
    private final PropertyValue sqlPropertyValue;
    private final int defaultPrecision;
    private final int defaultScale;

    public SqlJoinStrategy(SqlJoinCache cache, PropertyValue sqlPropertyValue, ComponentLog logger, int defaultPrecision, int defaultScale) {
        this.cache = cache;
        this.sqlPropertyValue = sqlPropertyValue;
        this.logger = logger;
        this.defaultPrecision = defaultPrecision;
        this.defaultScale = defaultScale;
    }

    @Override
    public RecordJoinResult join(RecordJoinInput originalInput, RecordJoinInput enrichmentInput, Map<String, String> combinedAttributes, ProcessSession session, final RecordSchema outputSchema) throws SQLException {
        ResultSet rs;
        final String sql = this.sqlPropertyValue.evaluateAttributeExpressions(combinedAttributes).getValue();
        final SqlJoinCalciteParameters calciteParameters = this.cache.getCalciteParameters(sql, outputSchema, originalInput, enrichmentInput);
        final NiFiTable originalTable = calciteParameters.getDatabase().getTable(ORIGINAL_TABLE_NAME);
        originalTable.setDataSource((ResettableDataSource)new RecordDataSource(originalInput.getRecordSchema(), session, originalInput.getFlowFile(), originalInput.getRecordReaderFactory(), this.logger));
        final NiFiTable enrichmentTable = calciteParameters.getDatabase().getTable(ENRICHMENT_TABLE_NAME);
        enrichmentTable.setDataSource((ResettableDataSource)new RecordDataSource(enrichmentInput.getRecordSchema(), session, enrichmentInput.getFlowFile(), enrichmentInput.getRecordReaderFactory(), this.logger));
        PreparedStatement stmt = calciteParameters.getPreparedStatement();
        try {
            rs = stmt.executeQuery();
        }
        catch (Throwable t) {
            originalTable.close();
            enrichmentTable.close();
            throw t;
        }
        ResultSetRecordSet recordSet = new ResultSetRecordSet(rs, outputSchema, this.defaultPrecision, this.defaultScale, true);
        return new RecordJoinResult(){
            final /* synthetic */ RecordSet val$recordSet;
            {
                this.val$recordSet = recordSet;
            }

            @Override
            public void close() {
                SqlJoinStrategy.this.closeQuietly(new AutoCloseable[]{originalTable, enrichmentTable});
                SqlJoinStrategy.this.cache.returnCalciteParameters(sql, outputSchema, calciteParameters);
            }

            @Override
            public RecordSet getRecordSet() {
                return this.val$recordSet;
            }
        };
    }

    private void closeQuietly(AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            this.closeQuietly(closeable);
        }
    }

    private void closeQuietly(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close {}", new Object[]{closeable, e});
            }
        }
    }
}

