/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.servlets;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.ListenHTTP;
import org.apache.nifi.security.cert.StandardPrincipalFormatter;
import org.apache.nifi.util.FormatUtils;

@Path(value="/holds/*")
public class ContentAcknowledgmentServlet
extends HttpServlet {
    public static final String DEFAULT_FOUND_SUBJECT = "none";
    private static final long serialVersionUID = -2675148117984902978L;
    private Processor processor;
    private Pattern authorizedPattern;
    private ComponentLog logger;
    private ConcurrentMap<String, ListenHTTP.FlowFileEntryTimeWrapper> flowFileMap;
    private int port;

    public void init(ServletConfig config) throws ServletException {
        ServletContext context = config.getServletContext();
        this.processor = (Processor)context.getAttribute("processor");
        this.logger = (ComponentLog)context.getAttribute("logger");
        this.authorizedPattern = (Pattern)context.getAttribute("authorityPattern");
        this.flowFileMap = (ConcurrentMap)context.getAttribute("flowFileMap");
        this.port = (Integer)context.getAttribute("port");
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uuid;
        ListenHTTP.FlowFileEntryTimeWrapper timeWrapper;
        X509Certificate[] x509CertificateArray;
        int n;
        int n2;
        if (request.getLocalPort() != this.port) {
            super.doDelete(request, response);
            return;
        }
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        String foundSubject = DEFAULT_FOUND_SUBJECT;
        if (certs != null && (n2 = 0) < (n = (x509CertificateArray = certs).length)) {
            X509Certificate cert = x509CertificateArray[n2];
            foundSubject = StandardPrincipalFormatter.getInstance().getSubject(cert);
            if (!this.authorizedPattern.matcher(foundSubject).matches()) {
                this.logger.warn("rejecting transfer attempt from [{}] because the DN is not authorized", new Object[]{foundSubject});
                response.sendError(403, "not allowed based on dn");
                return;
            }
        }
        String uri = request.getRequestURI();
        int slashIndex = uri.lastIndexOf("/");
        int questionIndex = uri.indexOf("?");
        if (questionIndex < 0) {
            questionIndex = uri.length();
        }
        if ((timeWrapper = (ListenHTTP.FlowFileEntryTimeWrapper)this.flowFileMap.remove(uuid = uri.substring(slashIndex + 1, questionIndex))) == null) {
            this.logger.warn("received DELETE for HOLD with ID " + uuid + " from Remote Host: [" + request.getRemoteHost() + "] Port [" + request.getRemotePort() + "] SubjectDN [" + foundSubject + "], but no HOLD exists with that ID; sending response with Status Code 404");
            response.sendError(404);
            return;
        }
        try {
            Set<FlowFile> flowFiles = timeWrapper.getFlowFiles();
            long transferTime = System.currentTimeMillis() - timeWrapper.getEntryTime();
            long totalFlowFileSize = 0L;
            for (FlowFile flowFile : flowFiles) {
                totalFlowFileSize += flowFile.getSize();
            }
            double seconds = (double)transferTime / 1000.0;
            if (seconds <= 0.0) {
                seconds = 1.0E-8;
            }
            double bytesPerSecond = (double)totalFlowFileSize / seconds;
            String transferRate = FormatUtils.formatDataSize((double)bytesPerSecond) + "/sec";
            this.logger.info("received {} files/{} bytes from Remote Host: [{}] Port [{}] SubjectDN [{}] in {} milliseconds at a rate of {}; transferring to 'success': {}", new Object[]{flowFiles.size(), totalFlowFileSize, request.getRemoteHost(), request.getRemotePort(), foundSubject, transferTime, transferRate, flowFiles});
            String sendingSubject = foundSubject;
            ProcessSession session = timeWrapper.getSession();
            session.transfer(flowFiles, ListenHTTP.RELATIONSHIP_SUCCESS);
            session.commitAsync(() -> {
                try {
                    response.setStatus(200);
                    response.flushBuffer();
                }
                catch (Exception e) {
                    this.logger.error("Received DELETE for HOLD with ID {} from Remote Host: [{}] Port [{}] SubjectDN [{}]. FlowFiles were released but failed to acknowledge them.", new Object[]{uuid, request.getRemoteHost(), request.getRemotePort(), sendingSubject, e.toString()});
                }
            });
        }
        catch (Throwable t) {
            timeWrapper.getSession().rollback();
            this.logger.error("Received DELETE for HOLD with ID {} from Remote Host: [{}] Port [{}] SubjectDN [{}], but failed to process the request due to {}", new Object[]{uuid, request.getRemoteHost(), request.getRemotePort(), foundSubject, t.toString()});
            if (this.logger.isDebugEnabled()) {
                this.logger.error("", t);
            }
            response.sendError(404);
        }
    }
}

