/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ssh;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.schmizz.keepalive.KeepAlive;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.connection.ConnectionImpl;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.standard.ssh.SSHConfigProvider;
import org.apache.nifi.processors.standard.util.SFTPTransfer;

public class StandardSSHConfigProvider
implements SSHConfigProvider {
    private static final String COMMA_SEPARATOR = ",";
    private static final int KEEP_ALIVE_INTERVAL_SECONDS = 5;
    private static final KeepAliveProvider DISABLED_KEEP_ALIVE_PROVIDER = new DisabledKeepAliveProvider();

    @Override
    public Config getConfig(String identifier, PropertyContext context) {
        DefaultConfig config = new DefaultConfig();
        KeepAliveProvider keepAliveProvider = this.getKeepAliveProvider(identifier, context);
        config.setKeepAliveProvider(keepAliveProvider);
        this.getOptionalProperty(context, SFTPTransfer.CIPHERS_ALLOWED).ifPresent(property -> config.setCipherFactories(this.getFilteredValues((String)property, config.getCipherFactories())));
        this.getOptionalProperty(context, SFTPTransfer.KEY_ALGORITHMS_ALLOWED).ifPresent(property -> config.setKeyAlgorithms(this.getFilteredValues((String)property, config.getKeyAlgorithms())));
        this.getOptionalProperty(context, SFTPTransfer.KEY_EXCHANGE_ALGORITHMS_ALLOWED).ifPresent(property -> config.setKeyExchangeFactories(this.getFilteredValues((String)property, config.getKeyExchangeFactories())));
        this.getOptionalProperty(context, SFTPTransfer.MESSAGE_AUTHENTICATION_CODES_ALLOWED).ifPresent(property -> config.setMACFactories(this.getFilteredValues((String)property, config.getMACFactories())));
        String keyAlgorithmsAllowed = context.getProperty(SFTPTransfer.KEY_ALGORITHMS_ALLOWED).evaluateAttributeExpressions().getValue();
        if (keyAlgorithmsAllowed == null) {
            config.prioritizeSshRsaKeyAlgorithm();
        }
        return config;
    }

    private Optional<String> getOptionalProperty(PropertyContext context, PropertyDescriptor propertyDescriptor) {
        PropertyValue propertyValue = context.getProperty(propertyDescriptor);
        return propertyValue.isSet() ? Optional.of(propertyValue.evaluateAttributeExpressions().getValue()) : Optional.empty();
    }

    private <T> List<Factory.Named<T>> getFilteredValues(String propertyValue, List<Factory.Named<T>> supportedValues) {
        Set<String> configuredValues = this.getCommaSeparatedValues(propertyValue);
        return supportedValues.stream().filter(named -> configuredValues.contains(named.getName())).collect(Collectors.toList());
    }

    private Set<String> getCommaSeparatedValues(String propertyValue) {
        String[] values = propertyValue.split(COMMA_SEPARATOR);
        return Arrays.stream(values).map(String::trim).collect(Collectors.toSet());
    }

    private KeepAliveProvider getKeepAliveProvider(String identifier, PropertyContext context) {
        boolean keepAliveEnabled = context.getProperty(SFTPTransfer.USE_KEEPALIVE_ON_TIMEOUT).asBoolean();
        return keepAliveEnabled ? new EnabledKeepAliveProvider(identifier) : DISABLED_KEEP_ALIVE_PROVIDER;
    }

    private static class EnabledKeepAliveProvider
    extends KeepAliveProvider {
        private final String identifier;

        private EnabledKeepAliveProvider(String identifier) {
            this.identifier = identifier;
        }

        public KeepAlive provide(ConnectionImpl connection) {
            KeepAlive keepAlive = KeepAliveProvider.KEEP_ALIVE.provide(connection);
            keepAlive.setName(String.format("SSH-keep-alive-%s", this.identifier));
            keepAlive.setKeepAliveInterval(5);
            return keepAlive;
        }
    }

    private static class DisabledKeepAliveProvider
    extends KeepAliveProvider {
        private DisabledKeepAliveProvider() {
        }

        public KeepAlive provide(ConnectionImpl connection) {
            return new DisabledKeepAliveThread(connection);
        }
    }

    private static class DisabledKeepAliveThread
    extends KeepAlive {
        private DisabledKeepAliveThread(ConnectionImpl connection) {
            super(connection, "keep-alive-disabled");
        }

        public void run() {
        }

        protected void doKeepAlive() {
        }
    }
}

