/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.util.ArgumentUtils;
import org.apache.nifi.processors.standard.util.SoftLimitBoundedByteArrayOutputStream;
import org.apache.nifi.stream.io.StreamUtils;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"command execution", "command", "stream", "execute"})
@CapabilityDescription(value="The ExecuteStreamCommand processor provides a flexible way to integrate external commands and scripts into NiFi data flows. ExecuteStreamCommand can pass the incoming FlowFile's content to the command that it executes similarly how piping works.")
@SupportsSensitiveDynamicProperties
@DynamicProperties(value={@DynamicProperty(name="An environment variable name", value="An environment variable value", description="These environment variables are passed to the process spawned by this Processor"), @DynamicProperty(name="command.argument.<commandIndex>", value="Argument to be supplied to the command", description="These arguments are supplied to the process spawned by this Processor when using the Command Arguments Strategy : Dynamic Property Arguments. <commandIndex> is a number and it will determine the order.")})
@WritesAttributes(value={@WritesAttribute(attribute="execution.command", description="The name of the command executed"), @WritesAttribute(attribute="execution.command.args", description="The semi-colon delimited list of arguments. Sensitive properties will be masked"), @WritesAttribute(attribute="execution.status", description="The exit status code returned from executing the command"), @WritesAttribute(attribute="execution.error", description="Any error messages returned from executing the command"), @WritesAttribute(attribute="mime.type", description="Sets the MIME type of the output if the 'Output MIME Type' property is set and 'Output Destination Attribute' is not set")})
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.EXECUTE_CODE, explanation="Provides operator the ability to execute arbitrary code assuming all permissions that NiFi has.")})
public class ExecuteStreamCommand
extends AbstractProcessor {
    public static final Relationship ORIGINAL_RELATIONSHIP = new Relationship.Builder().name("original").description("The original FlowFile will be routed. It will have new attributes detailing the result of the script execution.").build();
    public static final Relationship OUTPUT_STREAM_RELATIONSHIP = new Relationship.Builder().name("output stream").description("The destination path for the flow file created from the command's output, if the returned status code is zero.").build();
    public static final Relationship NONZERO_STATUS_RELATIONSHIP = new Relationship.Builder().name("nonzero status").description("The destination path for the flow file created from the command's output, if the returned status code is non-zero. All flow files routed to this relationship will be penalized.").build();
    private final AtomicReference<Set<Relationship>> relationships = new AtomicReference();
    private static final Set<Relationship> OUTPUT_STREAM_RELATIONSHIP_SET;
    private static final Set<Relationship> ATTRIBUTE_RELATIONSHIP_SET;
    private static final Pattern COMMAND_ARGUMENT_PATTERN;
    static final AllowableValue COMMAND_ARGUMENTS_PROPERTY_STRATEGY;
    static final AllowableValue DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY;
    static final PropertyDescriptor WORKING_DIR;
    private static final Validator ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR;
    static final PropertyDescriptor EXECUTION_COMMAND;
    static final PropertyDescriptor ARGUMENTS_STRATEGY;
    static final PropertyDescriptor EXECUTION_ARGUMENTS;
    static final PropertyDescriptor ARG_DELIMITER;
    static final PropertyDescriptor IGNORE_STDIN;
    static final PropertyDescriptor PUT_OUTPUT_IN_ATTRIBUTE;
    static final PropertyDescriptor PUT_ATTRIBUTE_MAX_LENGTH;
    static final PropertyDescriptor MIME_TYPE;
    private static final List<PropertyDescriptor> PROPERTIES;
    private static final String MASKED_ARGUMENT = "********";
    private ComponentLog logger;

    public Set<Relationship> getRelationships() {
        return this.relationships.get();
    }

    protected void init(ProcessorInitializationContext context) {
        this.logger = this.getLogger();
        this.relationships.set(OUTPUT_STREAM_RELATIONSHIP_SET);
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.equals((Object)PUT_OUTPUT_IN_ATTRIBUTE)) {
            if (newValue != null) {
                this.relationships.set(ATTRIBUTE_RELATIONSHIP_SET);
            } else {
                this.relationships.set(OUTPUT_STREAM_RELATIONSHIP_SET);
            }
        }
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        Matcher matcher = COMMAND_ARGUMENT_PATTERN.matcher(propertyDescriptorName);
        if (matcher.matches()) {
            return new PropertyDescriptor.Builder().name(propertyDescriptorName).displayName(propertyDescriptorName).description("Argument passed to command").dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR).build();
        }
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("Sets the environment variable '" + propertyDescriptorName + "' for the process' environment").dynamic(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        Process process;
        File errorOut;
        void var16_23;
        File file;
        Object builder;
        String commandArguments;
        FlowFile inputFlowFile = session.get();
        if (null == inputFlowFile) {
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> argumentAttributeValue = new ArrayList<String>();
        boolean putToAttribute = context.getProperty(PUT_OUTPUT_IN_ATTRIBUTE).isSet();
        PropertyValue argumentsStrategyPropertyValue = context.getProperty(ARGUMENTS_STRATEGY);
        boolean useDynamicPropertyArguments = argumentsStrategyPropertyValue.isSet() && argumentsStrategyPropertyValue.getValue().equals(DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        Integer attributeSize = context.getProperty(PUT_ATTRIBUTE_MAX_LENGTH).asInteger();
        String attributeName = context.getProperty(PUT_OUTPUT_IN_ATTRIBUTE).getValue();
        String executeCommand = context.getProperty(EXECUTION_COMMAND).evaluateAttributeExpressions(inputFlowFile).getValue();
        args.add(executeCommand);
        boolean ignoreStdin = Boolean.parseBoolean(context.getProperty(IGNORE_STDIN).getValue());
        if (!useDynamicPropertyArguments) {
            commandArguments = context.getProperty(EXECUTION_ARGUMENTS).evaluateAttributeExpressions(inputFlowFile).getValue();
            if (!StringUtils.isBlank((CharSequence)commandArguments)) {
                args.addAll(ArgumentUtils.splitArgs(commandArguments, context.getProperty(ARG_DELIMITER).getValue().charAt(0)));
            }
        } else {
            ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
            for (Map.Entry entry : context.getProperties().entrySet()) {
                Matcher matcher = COMMAND_ARGUMENT_PATTERN.matcher(((PropertyDescriptor)entry.getKey()).getName());
                if (!matcher.matches()) continue;
                propertyDescriptors.add((PropertyDescriptor)entry.getKey());
            }
            propertyDescriptors.sort((p1, p2) -> {
                int index2;
                Matcher matcher = COMMAND_ARGUMENT_PATTERN.matcher(p1.getName());
                String indexString1 = null;
                while (matcher.find()) {
                    indexString1 = matcher.group("commandIndex");
                }
                matcher = COMMAND_ARGUMENT_PATTERN.matcher(p2.getName());
                String indexString2 = null;
                while (matcher.find()) {
                    indexString2 = matcher.group("commandIndex");
                }
                int index1 = Integer.parseInt(indexString1);
                if (index1 > (index2 = Integer.parseInt(indexString2))) {
                    return 1;
                }
                if (index1 < index2) {
                    return -1;
                }
                return 0;
            });
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                String argValue = context.getProperty(propertyDescriptor.getName()).evaluateAttributeExpressions(inputFlowFile).getValue();
                if (propertyDescriptor.isSensitive()) {
                    argumentAttributeValue.add(MASKED_ARGUMENT);
                } else {
                    argumentAttributeValue.add(argValue);
                }
                args.add(argValue);
            }
            if (argumentAttributeValue.size() > 0) {
                builder = new StringBuilder();
                for (String s : argumentAttributeValue) {
                    ((StringBuilder)builder).append(s).append("\t");
                }
                commandArguments = ((StringBuilder)builder).toString().trim();
            } else {
                commandArguments = "";
            }
        }
        String workingDir = context.getProperty(WORKING_DIR).evaluateAttributeExpressions(inputFlowFile).getValue();
        builder = new ProcessBuilder(new String[0]);
        this.logger.debug("Executing and waiting for command: {}", new Object[]{executeCommand});
        Object var16_21 = null;
        if (!(StringUtils.isBlank((CharSequence)workingDir) || (file = new File(workingDir)).exists() || file.mkdirs())) {
            this.logger.warn("Failed to create working directory {}, using current working directory {}", new Object[]{workingDir, System.getProperty("user.dir")});
        }
        HashMap<String, String> environment = new HashMap<String, String>();
        for (Map.Entry entry : context.getProperties().entrySet()) {
            if (!((PropertyDescriptor)entry.getKey()).isDynamic()) continue;
            environment.put(((PropertyDescriptor)entry.getKey()).getName(), (String)entry.getValue());
        }
        ((ProcessBuilder)builder).environment().putAll(environment);
        ((ProcessBuilder)builder).command(args);
        ((ProcessBuilder)builder).directory((File)var16_23);
        ((ProcessBuilder)builder).redirectInput(ProcessBuilder.Redirect.PIPE);
        ((ProcessBuilder)builder).redirectOutput(ProcessBuilder.Redirect.PIPE);
        try {
            errorOut = File.createTempFile("out", null);
            ((ProcessBuilder)builder).redirectError(errorOut);
        }
        catch (IOException e) {
            this.logger.error("Could not create temporary file for error logging", (Throwable)e);
            throw new ProcessException((Throwable)e);
        }
        try {
            process = ((ProcessBuilder)builder).start();
        }
        catch (IOException e) {
            try {
                if (!errorOut.delete()) {
                    this.logger.warn("Unable to delete file: " + errorOut.getAbsolutePath());
                }
            }
            catch (SecurityException se) {
                this.logger.warn("Unable to delete file: '" + errorOut.getAbsolutePath() + "' due to " + String.valueOf(se));
            }
            this.logger.error("Could not create external process to run command", (Throwable)e);
            throw new ProcessException((Throwable)e);
        }
        try (OutputStream pos = process.getOutputStream();
             InputStream pis = process.getInputStream();
             BufferedInputStream bis = new BufferedInputStream(pis);){
            Relationship outputFlowFileRelationship;
            BufferedOutputStream bos = new BufferedOutputStream(pos);
            FlowFile outputFlowFile = putToAttribute ? inputFlowFile : session.create(inputFlowFile);
            ProcessStreamWriterCallback callback = new ProcessStreamWriterCallback(ignoreStdin, bos, bis, this.logger, attributeName, session, outputFlowFile, process, putToAttribute, attributeSize);
            session.read(inputFlowFile, (InputStreamCallback)callback);
            outputFlowFile = callback.outputFlowFile;
            if (putToAttribute) {
                outputFlowFile = session.putAttribute(outputFlowFile, attributeName, new String(callback.outputBuffer, 0, callback.size));
            }
            int exitCode = callback.exitCode;
            this.logger.debug("Execution complete for command: {}.  Exited with code: {}", new Object[]{executeCommand, exitCode});
            HashMap<String, String> attributes = new HashMap<String, String>();
            StringBuilder strBldr = new StringBuilder();
            try (FileInputStream is = new FileInputStream(errorOut);){
                int c;
                while ((c = ((InputStream)is).read()) != -1) {
                    strBldr.append((char)c);
                }
            }
            catch (IOException e) {
                strBldr.append("Unknown...could not read Process's Std Error");
            }
            int length = Math.min(strBldr.length(), 4000);
            attributes.put("execution.error", strBldr.substring(0, length));
            Relationship relationship = putToAttribute ? ORIGINAL_RELATIONSHIP : (outputFlowFileRelationship = exitCode != 0 ? NONZERO_STATUS_RELATIONSHIP : OUTPUT_STREAM_RELATIONSHIP);
            if (exitCode == 0) {
                this.logger.info("Transferring {} to {}", new Object[]{outputFlowFile, outputFlowFileRelationship.getName()});
            } else {
                this.logger.error("Transferring {} to {}. Executable command {} ended in an error: {}", new Object[]{outputFlowFile, outputFlowFileRelationship.getName(), executeCommand, strBldr.toString()});
            }
            attributes.put("execution.status", Integer.toString(exitCode));
            attributes.put("execution.command", executeCommand);
            attributes.put("execution.command.args", commandArguments);
            if (context.getProperty(MIME_TYPE).isSet() && !putToAttribute) {
                attributes.put(CoreAttributes.MIME_TYPE.key(), context.getProperty(MIME_TYPE).getValue());
            }
            outputFlowFile = session.putAllAttributes(outputFlowFile, attributes);
            if (NONZERO_STATUS_RELATIONSHIP.equals((Object)outputFlowFileRelationship)) {
                outputFlowFile = session.penalize(outputFlowFile);
            }
            session.transfer(outputFlowFile, outputFlowFileRelationship);
            if (!putToAttribute) {
                this.logger.info("Transferring {} to original", new Object[]{inputFlowFile});
                inputFlowFile = session.putAllAttributes(inputFlowFile, attributes);
                session.transfer(inputFlowFile, ORIGINAL_RELATIONSHIP);
            }
        }
        catch (IOException e) {
            this.logger.warn("Problem terminating Process {}", new Object[]{process, e});
        }
        finally {
            FileUtils.deleteQuietly((File)errorOut);
            process.destroy();
        }
    }

    private static void readStdoutReadable(boolean ignoreStdin, OutputStream stdinWritable, ComponentLog logger, InputStream incomingFlowFileIS) {
        Thread writerThread = new Thread(() -> {
            if (!ignoreStdin) {
                try {
                    StreamUtils.copy((InputStream)incomingFlowFileIS, (OutputStream)stdinWritable);
                }
                catch (IOException e) {
                    logger.error("Failed to write FlowFile to Standard Input Stream", (Throwable)e);
                }
            }
            IOUtils.closeQuietly((OutputStream)stdinWritable);
        });
        writerThread.setDaemon(true);
        writerThread.start();
    }

    static {
        COMMAND_ARGUMENT_PATTERN = Pattern.compile("command\\.argument\\.(?<commandIndex>[0-9]+)$");
        COMMAND_ARGUMENTS_PROPERTY_STRATEGY = new AllowableValue("Command Arguments Property", "Command Arguments Property", "Arguments to be supplied to the executable are taken from the Command Arguments property");
        DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY = new AllowableValue("Dynamic Property Arguments", "Dynamic Property Arguments", "Arguments to be supplied to the executable are taken from dynamic properties with pattern of 'command.argument.<commandIndex>'");
        WORKING_DIR = new PropertyDescriptor.Builder().name("Working Directory").description("The directory to use as the current working directory when executing the command").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.createDirectoryExistsValidator((boolean)true, (boolean)true)).required(false).build();
        ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR = StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true);
        EXECUTION_COMMAND = new PropertyDescriptor.Builder().name("Command Path").description("Specifies the command to be executed; if just the name of an executable is provided, it must be in the user's environment PATH.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR).required(true).build();
        ARGUMENTS_STRATEGY = new PropertyDescriptor.Builder().name("argumentsStrategy").displayName("Command Arguments Strategy").description("Strategy for configuring arguments to be supplied to the command.").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).allowableValues(new DescribedValue[]{COMMAND_ARGUMENTS_PROPERTY_STRATEGY, DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY}).defaultValue(COMMAND_ARGUMENTS_PROPERTY_STRATEGY.getValue()).build();
        EXECUTION_ARGUMENTS = new PropertyDescriptor.Builder().name("Command Arguments").description("The arguments to supply to the executable delimited by the ';' character.").dependsOn(ARGUMENTS_STRATEGY, new AllowableValue[]{COMMAND_ARGUMENTS_PROPERTY_STRATEGY}).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((subject, input, context) -> {
            ValidationResult result = new ValidationResult.Builder().subject(subject).valid(true).input(input).build();
            List<String> args = ArgumentUtils.splitArgs(input, context.getProperty(ARG_DELIMITER).getValue().charAt(0));
            for (String arg : args) {
                ValidationResult valResult = ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR.validate(subject, arg, context);
                if (valResult.isValid()) continue;
                result = valResult;
                break;
            }
            return result;
        }).build();
        ARG_DELIMITER = new PropertyDescriptor.Builder().name("Argument Delimiter").description("Delimiter to use to separate arguments for a command [default: ;]. Must be a single character").dependsOn(ARGUMENTS_STRATEGY, new AllowableValue[]{COMMAND_ARGUMENTS_PROPERTY_STRATEGY}).addValidator(StandardValidators.SINGLE_CHAR_VALIDATOR).required(true).defaultValue(";").build();
        IGNORE_STDIN = new PropertyDescriptor.Builder().name("Ignore STDIN").description("If true, the contents of the incoming flowfile will not be passed to the executing command").addValidator(Validator.VALID).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
        PUT_OUTPUT_IN_ATTRIBUTE = new PropertyDescriptor.Builder().name("Output Destination Attribute").description("If set, the output of the stream command will be put into an attribute of the original FlowFile instead of a separate FlowFile. There will no longer be a relationship for 'output stream' or 'nonzero status'. The value of this property will be the key for the output attribute.").addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).build();
        PUT_ATTRIBUTE_MAX_LENGTH = new PropertyDescriptor.Builder().name("Max Attribute Length").description("If routing the output of the stream command to an attribute, the number of characters put to the attribute value will be at most this amount. This is important because attributes are held in memory and large attributes will quickly cause out of memory issues. If the output goes longer than this value, it will truncated to fit. Consider making this smaller if able.").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("256").build();
        MIME_TYPE = new PropertyDescriptor.Builder().name("Output MIME Type").displayName("Output MIME Type").description("Specifies the value to set for the \"mime.type\" attribute. This property is ignored if 'Output Destination Attribute' is set.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(WORKING_DIR);
        props.add(EXECUTION_COMMAND);
        props.add(ARGUMENTS_STRATEGY);
        props.add(EXECUTION_ARGUMENTS);
        props.add(ARG_DELIMITER);
        props.add(IGNORE_STDIN);
        props.add(PUT_OUTPUT_IN_ATTRIBUTE);
        props.add(PUT_ATTRIBUTE_MAX_LENGTH);
        props.add(MIME_TYPE);
        PROPERTIES = Collections.unmodifiableList(props);
        HashSet<Relationship> outputStreamRelationships = new HashSet<Relationship>();
        outputStreamRelationships.add(OUTPUT_STREAM_RELATIONSHIP);
        outputStreamRelationships.add(ORIGINAL_RELATIONSHIP);
        outputStreamRelationships.add(NONZERO_STATUS_RELATIONSHIP);
        OUTPUT_STREAM_RELATIONSHIP_SET = Collections.unmodifiableSet(outputStreamRelationships);
        HashSet<Relationship> attributeRelationships = new HashSet<Relationship>();
        attributeRelationships.add(ORIGINAL_RELATIONSHIP);
        ATTRIBUTE_RELATIONSHIP_SET = Collections.unmodifiableSet(attributeRelationships);
    }

    static class ProcessStreamWriterCallback
    implements InputStreamCallback {
        final boolean ignoreStdin;
        final OutputStream stdinWritable;
        final InputStream stdoutReadable;
        final ComponentLog logger;
        final ProcessSession session;
        final Process process;
        FlowFile outputFlowFile;
        int exitCode;
        final boolean putToAttribute;
        final int attributeSize;
        final String attributeName;
        byte[] outputBuffer;
        int size;

        public ProcessStreamWriterCallback(boolean ignoreStdin, OutputStream stdinWritable, InputStream stdoutReadable, ComponentLog logger, String attributeName, ProcessSession session, FlowFile outputFlowFile, Process process, boolean putToAttribute, int attributeSize) {
            this.ignoreStdin = ignoreStdin;
            this.stdinWritable = stdinWritable;
            this.stdoutReadable = stdoutReadable;
            this.logger = logger;
            this.session = session;
            this.outputFlowFile = outputFlowFile;
            this.process = process;
            this.putToAttribute = putToAttribute;
            this.attributeSize = attributeSize;
            this.attributeName = attributeName;
        }

        public void process(InputStream incomingFlowFileIS) throws IOException {
            if (this.putToAttribute) {
                try (SoftLimitBoundedByteArrayOutputStream softLimitBoundedBAOS = new SoftLimitBoundedByteArrayOutputStream(this.attributeSize);){
                    ExecuteStreamCommand.readStdoutReadable(this.ignoreStdin, this.stdinWritable, this.logger, incomingFlowFileIS);
                    long longSize = StreamUtils.copy((InputStream)this.stdoutReadable, (OutputStream)softLimitBoundedBAOS);
                    this.size = longSize > (long)this.attributeSize ? this.attributeSize : (int)longSize;
                    this.outputBuffer = softLimitBoundedBAOS.getBuffer();
                    this.stdoutReadable.close();
                    try {
                        this.exitCode = this.process.waitFor();
                    }
                    catch (InterruptedException e) {
                        this.logger.warn("Command Execution Process was interrupted", (Throwable)e);
                    }
                }
            } else {
                this.outputFlowFile = this.session.write(this.outputFlowFile, out -> {
                    ExecuteStreamCommand.readStdoutReadable(this.ignoreStdin, this.stdinWritable, this.logger, incomingFlowFileIS);
                    StreamUtils.copy((InputStream)this.stdoutReadable, (OutputStream)out);
                    try {
                        this.exitCode = this.process.waitFor();
                    }
                    catch (InterruptedException e) {
                        this.logger.warn("Command Execution Process was interrupted", (Throwable)e);
                    }
                });
            }
        }
    }
}

