/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.MultiProcessorUseCase;
import org.apache.nifi.annotation.documentation.ProcessorConfiguration;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.file.transfer.FetchFileTransfer;
import org.apache.nifi.processor.util.file.transfer.FileTransfer;
import org.apache.nifi.processors.standard.GetFTP;
import org.apache.nifi.processors.standard.GetSFTP;
import org.apache.nifi.processors.standard.ListFTP;
import org.apache.nifi.processors.standard.PutFTP;
import org.apache.nifi.processors.standard.PutSFTP;
import org.apache.nifi.processors.standard.util.FTPTransfer;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"ftp", "get", "retrieve", "files", "fetch", "remote", "ingest", "source", "input"})
@CapabilityDescription(value="Fetches the content of a file from a remote FTP server and overwrites the contents of an incoming FlowFile with the content of the remote file.")
@SeeAlso(value={GetSFTP.class, PutSFTP.class, GetFTP.class, PutFTP.class})
@WritesAttributes(value={@WritesAttribute(attribute="ftp.remote.host", description="The hostname or IP address from which the file was pulled"), @WritesAttribute(attribute="ftp.remote.port", description="The port that was used to communicate with the remote FTP server"), @WritesAttribute(attribute="ftp.remote.filename", description="The name of the remote file that was pulled"), @WritesAttribute(attribute="filename", description="The filename is updated to point to the filename fo the remote file"), @WritesAttribute(attribute="path", description="If the Remote File contains a directory name, that directory name will be added to the FlowFile using the 'path' attribute"), @WritesAttribute(attribute="fetch.failure.reason", description="The name of the failure relationship applied when routing to any failure relationship")})
@MultiProcessorUseCase(description="Retrieve all files in a directory of an FTP Server", keywords={"ftp", "file", "transform", "state", "retrieve", "fetch", "all", "stream"}, configurations={@ProcessorConfiguration(processorClass=ListFTP.class, configuration="The \"Hostname\" property should be set to the fully qualified hostname of the FTP Server. It's a good idea to parameterize     this property by setting it to something like `#{FTP_SERVER}`.\nThe \"Remote Path\" property must be set to the directory on the FTP Server where the files reside. If the flow being built is to be reused elsewhere,     it's a good idea to parameterize this property by setting it to something like `#{FTP_REMOTE_PATH}`.\nConfigure the \"Username\" property to the appropriate username for logging into the FTP Server. It's usually a good idea to parameterize this property     by setting it to something like `#{FTP_USERNAME}`.\nConfigure the \"Password\" property to the appropriate password for the provided username. It's usually a good idea to parameterize this property     by setting it to something like `#{FTP_PASSWORD}`.\n\nThe 'success' Relationship of this Processor is then connected to FetchFTP.\n"), @ProcessorConfiguration(processorClass=FetchFTP.class, configuration="\"Hostname\" = \"${ftp.remote.host}\"\n\"Remote File\" = \"${path}/${filename}\"\n\"Username\" = \"${ftp.listing.user}\"\n\"Password\" = \"#{FTP_PASSWORD}\"\n")})
public class FetchFTP
extends FetchFileTransfer {
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        PropertyDescriptor port = new PropertyDescriptor.Builder().fromPropertyDescriptor(UNDEFAULTED_PORT).defaultValue("21").build();
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(HOSTNAME);
        properties.add(port);
        properties.add(USERNAME);
        properties.add(FTPTransfer.PASSWORD);
        properties.add(REMOTE_FILENAME);
        properties.add(COMPLETION_STRATEGY);
        properties.add(MOVE_DESTINATION_DIR);
        properties.add(MOVE_CREATE_DIRECTORY);
        properties.add(FTPTransfer.CONNECTION_TIMEOUT);
        properties.add(FTPTransfer.DATA_TIMEOUT);
        properties.add(FTPTransfer.USE_COMPRESSION);
        properties.add(FTPTransfer.CONNECTION_MODE);
        properties.add(FTPTransfer.TRANSFER_MODE);
        properties.add(FTPTransfer.PROXY_CONFIGURATION_SERVICE);
        properties.add(FTPTransfer.PROXY_TYPE);
        properties.add(FTPTransfer.PROXY_HOST);
        properties.add(FTPTransfer.PROXY_PORT);
        properties.add(FTPTransfer.HTTP_PROXY_USERNAME);
        properties.add(FTPTransfer.HTTP_PROXY_PASSWORD);
        properties.add(FTPTransfer.BUFFER_SIZE);
        properties.add(FILE_NOT_FOUND_LOG_LEVEL);
        properties.add(FTPTransfer.UTF8_ENCODING);
        return properties;
    }

    protected FileTransfer createFileTransfer(ProcessContext context) {
        return new FTPTransfer(context, this.getLogger());
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        FTPTransfer.validateProxySpec(validationContext, results);
        return results;
    }
}

