/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.TriggerWhenEmpty;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.Validator;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.bin.Bin;
import org.apache.nifi.processor.util.bin.BinFiles;
import org.apache.nifi.processor.util.bin.BinManager;
import org.apache.nifi.processor.util.bin.BinProcessingResult;
import org.apache.nifi.processor.util.bin.EvictionReason;
import org.apache.nifi.processors.standard.ForkEnrichment;
import org.apache.nifi.processors.standard.enrichment.EnrichmentRole;
import org.apache.nifi.processors.standard.enrichment.InsertRecordFieldsJoinStrategy;
import org.apache.nifi.processors.standard.enrichment.RecordJoinInput;
import org.apache.nifi.processors.standard.enrichment.RecordJoinResult;
import org.apache.nifi.processors.standard.enrichment.RecordJoinStrategy;
import org.apache.nifi.processors.standard.enrichment.SqlJoinCache;
import org.apache.nifi.processors.standard.enrichment.SqlJoinStrategy;
import org.apache.nifi.processors.standard.enrichment.WrapperJoinStrategy;
import org.apache.nifi.record.path.validation.RecordPathValidator;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.util.db.JdbcProperties;

@TriggerWhenEmpty
@SideEffectFree
@Tags(value={"fork", "join", "enrichment", "record", "sql", "wrap", "recordpath", "merge", "combine", "streams"})
@CapabilityDescription(value="Joins together Records from two different FlowFiles where one FlowFile, the 'original' contains arbitrary records and the second FlowFile, the 'enrichment' contains additional data that should be used to enrich the first. See Additional Details for more information on how to configure this processor and the different use cases that it aims to accomplish.")
@SeeAlso(value={ForkEnrichment.class})
@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="Sets the mime.type attribute to the MIME Type specified by the Record Writer"), @WritesAttribute(attribute="record.count", description="The number of records in the FlowFile")})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@SystemResourceConsideration(resource=SystemResource.MEMORY, description="This Processor will load into heap all FlowFiles that are on its incoming queues. While it loads the FlowFiles themselves, and not their content, the FlowFile attributes can be very memory intensive. Additionally, if the Join Strategy is set to SQL, the SQL engine may require buffering the entire contents of the enrichment FlowFile for each concurrent task. See Processor's Additional Details for more details and for steps on how to mitigate these concerns.")
public class JoinEnrichment
extends BinFiles {
    static final String GROUP_ID_ATTRIBUTE = "enrichment.group.id";
    static final String ENRICHMENT_ROLE_ATTRIBUTE = "enrichment.role";
    static final String RECORD_COUNT_ATTRIBUTE = "record.count";
    static final AllowableValue JOIN_WRAPPER = new AllowableValue("Wrapper", "Wrapper", "The output is a Record that contains two fields: (1) 'original', containing the Record from the original FlowFile and (2) 'enrichment' containing the corresponding Record from the enrichment FlowFile. Records will be correlated based on their index in the FlowFile. If one FlowFile has more Records than the other, a null value will be used.");
    static final AllowableValue JOIN_SQL = new AllowableValue("SQL", "SQL", "The output is derived by evaluating a SQL SELECT statement that allows for two tables: 'original' and 'enrichment'. This allows for SQL JOIN statements to be used in order to correlate the Records of the two FlowFiles, so the index in which the Record is encountered in the FlowFile does not matter.");
    static final AllowableValue JOIN_INSERT_ENRICHMENT_FIELDS = new AllowableValue("Insert Enrichment Fields", "Insert Enrichment Fields", "The enrichment is joined together with the original FlowFile by placing all fields of the enrichment Record into the corresponding Record from the original FlowFile. Records will be correlated based on their index in the FlowFile.");
    static final PropertyDescriptor ORIGINAL_RECORD_READER = new PropertyDescriptor.Builder().name("Original Record Reader").displayName("Original Record Reader").description("The Record Reader for reading the 'original' FlowFile").required(true).identifiesControllerService(RecordReaderFactory.class).build();
    static final PropertyDescriptor ENRICHMENT_RECORD_READER = new PropertyDescriptor.Builder().name("Enrichment Record Reader").displayName("Enrichment Record Reader").description("The Record Reader for reading the 'enrichment' FlowFile").required(true).identifiesControllerService(RecordReaderFactory.class).build();
    static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("Record Writer").displayName("Record Writer").description("The Record Writer to use for writing the results. If the Record Writer is configured to inherit the schema from the Record, the schema that it will inherit will be the result of merging both the 'original' record schema and the 'enrichment' record schema.").required(true).identifiesControllerService(RecordSetWriterFactory.class).build();
    static final PropertyDescriptor JOIN_STRATEGY = new PropertyDescriptor.Builder().name("Join Strategy").displayName("Join Strategy").description("Specifies how to join the two FlowFiles into a single FlowFile").required(true).allowableValues(new DescribedValue[]{JOIN_WRAPPER, JOIN_SQL, JOIN_INSERT_ENRICHMENT_FIELDS}).defaultValue(JOIN_WRAPPER.getValue()).build();
    static final PropertyDescriptor SQL = new PropertyDescriptor.Builder().name("SQL").displayName("SQL").description("The SQL SELECT statement to evaluate. Expression Language may be provided, but doing so may result in poorer performance. Because this Processor is dealing with two FlowFiles at a time, it's also important to understand how attributes will be referenced. If both FlowFiles have an attribute with the same name but different values, the Expression Language will resolve to the value provided by the 'enrichment' FlowFile.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(JOIN_STRATEGY, new AllowableValue[]{JOIN_SQL}).defaultValue("SELECT original.*, enrichment.* \nFROM original \nLEFT OUTER JOIN enrichment \nON original.id = enrichment.id").build();
    static final PropertyDescriptor DEFAULT_PRECISION = new PropertyDescriptor.Builder().fromPropertyDescriptor(JdbcProperties.DEFAULT_PRECISION).required(false).dependsOn(JOIN_STRATEGY, new AllowableValue[]{JOIN_SQL}).build();
    static final PropertyDescriptor DEFAULT_SCALE = new PropertyDescriptor.Builder().fromPropertyDescriptor(JdbcProperties.DEFAULT_SCALE).required(false).dependsOn(JOIN_STRATEGY, new AllowableValue[]{JOIN_SQL}).build();
    static final PropertyDescriptor INSERTION_RECORD_PATH = new PropertyDescriptor.Builder().name("Insertion Record Path").displayName("Insertion Record Path").description("Specifies where in the 'original' Record the 'enrichment' Record's fields should be inserted. Note that if the RecordPath does not point to any existing field in the original Record, the enrichment will not be inserted.").required(true).addValidator((Validator)new RecordPathValidator()).defaultValue("/").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(JOIN_STRATEGY, new AllowableValue[]{JOIN_INSERT_ENRICHMENT_FIELDS}).build();
    static final PropertyDescriptor TIMEOUT = new PropertyDescriptor.Builder().name("Timeout").displayName("Timeout").description("Specifies the maximum amount of time to wait for the second FlowFile once the first arrives at the processor, after which point the first FlowFile will be routed to the 'timeout' relationship.").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("10 min").build();
    static final PropertyDescriptor MAX_BIN_COUNT = new PropertyDescriptor.Builder().fromPropertyDescriptor(BinFiles.MAX_BIN_COUNT).defaultValue("10000").build();
    private static final List<PropertyDescriptor> properties = Collections.unmodifiableList(Arrays.asList(ORIGINAL_RECORD_READER, ENRICHMENT_RECORD_READER, RECORD_WRITER, JOIN_STRATEGY, SQL, DEFAULT_PRECISION, DEFAULT_SCALE, INSERTION_RECORD_PATH, MAX_BIN_COUNT, TIMEOUT));
    static final Relationship REL_JOINED = new Relationship.Builder().name("joined").description("The resultant FlowFile with Records joined together from both the original and enrichment FlowFiles will be routed to this relationship").build();
    static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("Both of the incoming FlowFiles ('original' and 'enrichment') will be routed to this Relationship. I.e., this is the 'original' version of both of these FlowFiles.").autoTerminateDefault(true).build();
    static final Relationship REL_TIMEOUT = new Relationship.Builder().name("timeout").description("If one of the incoming FlowFiles (i.e., the 'original' FlowFile or the 'enrichment' FlowFile) arrives to this Processor but the other does not arrive within the configured Timeout period, the FlowFile that did arrive is routed to this relationship.").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If both the 'original' and 'enrichment' FlowFiles arrive at the processor but there was a failure in joining the records, both of those FlowFiles will be routed to this relationship.").build();
    private static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_JOINED, REL_ORIGINAL, REL_TIMEOUT, REL_FAILURE)));
    private final SqlJoinCache sqlJoinCache = new SqlJoinCache(this.getLogger());

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    @OnStopped
    public synchronized void cleanup() throws Exception {
        this.sqlJoinCache.close();
    }

    protected FlowFile preprocessFlowFile(ProcessContext context, ProcessSession session, FlowFile flowFile) {
        return flowFile;
    }

    protected String getGroupId(ProcessContext context, FlowFile flowFile, ProcessSession session) {
        return flowFile.getAttribute(GROUP_ID_ATTRIBUTE);
    }

    protected void setUpBinManager(BinManager binManager, ProcessContext context) {
    }

    protected int getMinEntries(PropertyContext context) {
        return 2;
    }

    protected int getMaxEntries(PropertyContext context) {
        return 2;
    }

    protected long getMinBytes(PropertyContext context) {
        return 0L;
    }

    protected long getMaxBytes(PropertyContext context) {
        return Long.MAX_VALUE;
    }

    protected int getMaxBinAgeSeconds(PropertyContext context) {
        return context.getProperty(TIMEOUT).asTimePeriod(TimeUnit.SECONDS).intValue();
    }

    protected BinProcessingResult processBin(Bin unmodifiableBin, ProcessContext context) throws ProcessException {
        String mimeType;
        WriteResult writeResult;
        FlowFile output;
        RecordSchema writerSchema;
        RecordSchema enrichmentSchema;
        RecordSchema originalSchema;
        ProcessSession session = unmodifiableBin.getSession();
        List flowFiles = unmodifiableBin.getContents();
        if (flowFiles.size() != 2) {
            if (unmodifiableBin.getEvictionReason() == EvictionReason.BIN_MANAGER_FULL) {
                session.transfer((Collection)flowFiles);
                session.commitAsync();
                return new BinProcessingResult(true);
            }
            session.transfer((Collection)flowFiles, REL_TIMEOUT);
            FlowFile flowFile = (FlowFile)flowFiles.get(0);
            EnrichmentRole role = this.getEnrichmentRole(flowFile);
            String missingType = role == null ? "other" : this.getOtherEnrichmentRole(role).name();
            this.getLogger().warn("Timed out waiting for the {} FlowFile to match {}; routing to {}", new Object[]{missingType, flowFiles.get(0), REL_TIMEOUT.getName()});
            session.commitAsync();
            return new BinProcessingResult(true);
        }
        FlowFile original = this.getFlowFileWithRole(flowFiles, EnrichmentRole.ORIGINAL);
        FlowFile enrichment = this.getFlowFileWithRole(flowFiles, EnrichmentRole.ENRICHMENT);
        if (original == null || enrichment == null) {
            this.getLogger().error("Received two FlowFiles {} but could not find both an 'original' and an 'enrichment' FlowFile. The FlowFiles do not appear to have the proper attributes necessary for use with this Processor. Routing to {}", new Object[]{flowFiles, REL_FAILURE});
            return this.transferFailure(flowFiles, session);
        }
        HashMap<String, String> combinedAttributes = new HashMap<String, String>(original.getAttributes());
        combinedAttributes.putAll(enrichment.getAttributes());
        RecordReaderFactory originalRecordReaderFactory = (RecordReaderFactory)context.getProperty(ORIGINAL_RECORD_READER).asControllerService(RecordReaderFactory.class);
        RecordReaderFactory enrichmentRecordReaderFactory = (RecordReaderFactory)context.getProperty(ENRICHMENT_RECORD_READER).asControllerService(RecordReaderFactory.class);
        RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
        try {
            originalSchema = this.getReaderSchema(originalRecordReaderFactory, original, session);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to determine Record Schema from 'original' FlowFile {}; routing to failure", new Object[]{original, e});
            return this.transferFailure(flowFiles, session);
        }
        try {
            enrichmentSchema = this.getReaderSchema(enrichmentRecordReaderFactory, enrichment, session);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to determine Record Schema from 'enrichment' FlowFile {}; routing to failure", new Object[]{original, e});
            return this.transferFailure(flowFiles, session);
        }
        RecordSchema combinedSchema = DataTypeUtils.merge((RecordSchema)originalSchema, (RecordSchema)enrichmentSchema);
        try {
            writerSchema = writerFactory.getSchema(combinedAttributes, combinedSchema);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to determine Record Schema for the Record Writer from 'original' FlowFile {} and 'enrichment' FLowFile {}; routing to failure", new Object[]{original, enrichment, e});
            return this.transferFailure(flowFiles, session);
        }
        RecordJoinInput originalInput = new RecordJoinInput(original, originalRecordReaderFactory, originalSchema);
        RecordJoinInput enrichmentInput = new RecordJoinInput(enrichment, enrichmentRecordReaderFactory, enrichmentSchema);
        RecordJoinStrategy joinStrategy = this.getJoinStrategy(context, combinedAttributes);
        try (RecordJoinResult result = joinStrategy.join(originalInput, enrichmentInput, combinedAttributes, session, writerSchema);){
            output = session.create((Collection)flowFiles);
            try (OutputStream out = session.write(output);){
                RecordSet resultRecordSet = result.getRecordSet();
                RecordSchema rsSchema = resultRecordSet.getSchema();
                try (RecordSetWriter writer = writerFactory.createWriter(this.getLogger(), rsSchema, out, combinedAttributes);){
                    writeResult = writer.write(resultRecordSet);
                    mimeType = writer.getMimeType();
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("Failed to join 'original' FlowFile {} and 'enrichment' FlowFile {}; routing to failure", new Object[]{original, enrichment, e});
            return this.transferFailure(flowFiles, session);
        }
        HashMap<String, String> writeAttributes = new HashMap<String, String>(writeResult.getAttributes());
        int joinedCount = writeResult.getRecordCount();
        writeAttributes.put(RECORD_COUNT_ATTRIBUTE, String.valueOf(joinedCount));
        writeAttributes.put(CoreAttributes.MIME_TYPE.key(), mimeType);
        session.putAllAttributes(output, writeAttributes);
        session.adjustCounter("Records Written", (long)joinedCount, false);
        session.transfer(output, REL_JOINED);
        return new BinProcessingResult(false);
    }

    private RecordSchema getReaderSchema(RecordReaderFactory recordReaderFactory, FlowFile flowFile, ProcessSession session) throws IOException, MalformedRecordException, SchemaNotFoundException {
        try (InputStream rawIn = session.read(flowFile);){
            RecordSchema schema;
            Map enrichmentAttributes = flowFile.getAttributes();
            RecordReader reader = recordReaderFactory.createRecordReader(enrichmentAttributes, rawIn, flowFile.getSize(), this.getLogger());
            RecordSchema recordSchema = schema = reader.getSchema();
            return recordSchema;
        }
    }

    private BinProcessingResult transferFailure(List<FlowFile> flowFiles, ProcessSession session) {
        session.transfer(flowFiles, REL_FAILURE);
        session.commitAsync();
        return new BinProcessingResult(true);
    }

    private RecordJoinStrategy getJoinStrategy(ProcessContext context, Map<String, String> attributes) {
        String strategyName = context.getProperty(JOIN_STRATEGY).getValue();
        if (strategyName.equalsIgnoreCase(JOIN_SQL.getValue())) {
            PropertyValue sqlPropertyValue = context.getProperty(SQL);
            int defaultPrecision = context.getProperty(DEFAULT_PRECISION).evaluateAttributeExpressions(attributes).asInteger();
            int defaultScale = context.getProperty(DEFAULT_SCALE).evaluateAttributeExpressions(attributes).asInteger();
            return new SqlJoinStrategy(this.sqlJoinCache, sqlPropertyValue, this.getLogger(), defaultPrecision, defaultScale);
        }
        if (strategyName.equalsIgnoreCase(JOIN_WRAPPER.getValue())) {
            return new WrapperJoinStrategy(this.getLogger());
        }
        if (strategyName.equalsIgnoreCase(JOIN_INSERT_ENRICHMENT_FIELDS.getValue())) {
            String recordPath = context.getProperty(INSERTION_RECORD_PATH).evaluateAttributeExpressions(attributes).getValue();
            return new InsertRecordFieldsJoinStrategy(this.getLogger(), recordPath);
        }
        throw new ProcessException("Invalid Join Strategy: " + strategyName);
    }

    private FlowFile getFlowFileWithRole(Collection<FlowFile> flowFiles, EnrichmentRole desiredRole) {
        for (FlowFile flowFile : flowFiles) {
            EnrichmentRole role = this.getEnrichmentRole(flowFile);
            if (role != desiredRole) continue;
            return flowFile;
        }
        return null;
    }

    private EnrichmentRole getEnrichmentRole(FlowFile flowFile) {
        String role = flowFile.getAttribute(ENRICHMENT_ROLE_ATTRIBUTE);
        if (role == null) {
            return EnrichmentRole.UNKNOWN;
        }
        try {
            return EnrichmentRole.valueOf(role);
        }
        catch (Exception e) {
            return EnrichmentRole.UNKNOWN;
        }
    }

    private EnrichmentRole getOtherEnrichmentRole(EnrichmentRole role) {
        if (role == null) {
            return null;
        }
        switch (role) {
            case ENRICHMENT: {
                return EnrichmentRole.ORIGINAL;
            }
            case ORIGINAL: {
                return EnrichmentRole.ENRICHMENT;
            }
            case UNKNOWN: {
                return EnrichmentRole.UNKNOWN;
            }
        }
        return null;
    }

    protected int processBins(ProcessContext context, ProcessSessionFactory sessionFactory) {
        Bin bin;
        Queue readyBins = this.getReadyBins();
        if (readyBins.size() <= 1) {
            return super.processBins(context, sessionFactory);
        }
        ComponentLog logger = this.getLogger();
        int binsProcessed = 0;
        long bytesProcessed = 0L;
        ProcessSession batchSession = sessionFactory.createSession();
        while (this.isScheduled() && (bin = (Bin)readyBins.poll()) != null) {
            BinProcessingResult binProcessingResult;
            long binBytes = 0L;
            for (FlowFile flowFile : bin.getContents()) {
                binBytes += flowFile.getSize();
            }
            try {
                binProcessingResult = this.processBin(bin, context);
            }
            catch (ProcessException e) {
                logger.error("Failed to process bundle of {} files due to {}", new Object[]{bin.getContents().size(), e});
                ProcessSession binSession = bin.getSession();
                for (FlowFile flowFile : bin.getContents()) {
                    binSession.transfer(flowFile, REL_FAILURE);
                }
                binSession.commitAsync();
                continue;
            }
            catch (Exception e) {
                logger.error("Failed to process bundle of {} files due to {}; rolling back sessions", new Object[]{bin.getContents().size(), e});
                bin.getSession().rollback();
                continue;
            }
            if (!binProcessingResult.isCommitted()) {
                ProcessSession binSession = bin.getSession();
                bin.getContents().forEach(ff -> binSession.putAllAttributes(ff, binProcessingResult.getAttributes()));
                binSession.transfer((Collection)bin.getContents(), REL_ORIGINAL);
                binSession.migrate(batchSession);
                binSession.commitAsync();
            }
            if (++binsProcessed % 100 != 0 && (bytesProcessed += binBytes) <= 5000000L) continue;
            batchSession.commitAsync();
            break;
        }
        batchSession.commitAsync();
        return binsProcessed;
    }
}

