/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.DynamicRelationship;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.annotation.documentation.UseCases;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stream.io.util.LineDemarcator;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"attributes", "routing", "text", "regexp", "regex", "Regular Expression", "Expression Language", "csv", "filter", "logs", "delimited", "find", "string", "search", "filter", "detect"})
@CapabilityDescription(value="Routes textual data based on a set of user-defined rules. Each line in an incoming FlowFile is compared against the values specified by user-defined Properties. The mechanism by which the text is compared to these user-defined properties is defined by the 'Matching Strategy'. The data is then routed according to these rules, routing each line of the text individually.")
@DynamicProperty(name="Relationship Name", value="value to match against", description="Routes data that matches the value specified in the Dynamic Property Value to the Relationship specified in the Dynamic Property Key.", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES)
@DynamicRelationship(name="Name from Dynamic Property", description="FlowFiles that match the Dynamic Property's value")
@WritesAttributes(value={@WritesAttribute(attribute="RouteText.Route", description="The name of the relationship to which the FlowFile was routed."), @WritesAttribute(attribute="RouteText.Group", description="The value captured by all capturing groups in the 'Grouping Regular Expression' property. If this property is not set or contains no capturing groups, this attribute will not be added.")})
@UseCases(value={@UseCase(description="Drop blank or empty lines from the FlowFile's content.", keywords={"filter", "drop", "empty", "blank", "remove", "delete", "strip out", "lines", "text"}, configuration="\"Routing Strategy\" = \"Route to each matching Property Name\"\n\"Matching Strategy\" = \"Matches Regular Expression\"\n\"Empty Line\" = \"^$\"\n\nAuto-terminate the \"Empty Line\" relationship.\nConnect the \"unmatched\" relationship to the next processor in your flow.\n"), @UseCase(description="Remove specific lines of text from a file, such as those containing a specific word or having a line length over some threshold.", keywords={"filter", "drop", "empty", "blank", "remove", "delete", "strip out", "lines", "text", "expression language"}, configuration="\"Routing Strategy\" = \"Route to each matching Property Name\"\n\"Matching Strategy\" = \"Satisfies Expression\"\n\nAn additional property should be added named \"Filter Out.\" The value should be a NiFi Expression Language Expression that can refer to two variables (in addition to FlowFile attributes): `line`, which is the line of text being evaluated; and `lineNo`, which is the line number in the file (starting with 1). The Expression should return `true` for any line that should be dropped.\n\nFor example, to remove any line that starts with a # symbol, we can set \"Filter Out\" to `${line:startsWith(\"#\")}`.\nWe could also remove the first 2 lines of text by setting \"Filter Out\" to `${lineNo:le(2)}`. Note that we use the `le` function because we want lines numbers less than or equal to `2`, since the line index is 1-based.\n\nAuto-terminate the \"Filter Out\" relationship.\nConnect the \"unmatched\" relationship to the next processor in your flow.\n")})
public class RouteText
extends AbstractProcessor {
    public static final String ROUTE_ATTRIBUTE_KEY = "RouteText.Route";
    public static final String GROUP_ATTRIBUTE_KEY = "RouteText.Group";
    private static final String routeAllMatchValue = "Route to 'matched' if line matches all conditions";
    private static final String routeAnyMatchValue = "Route to 'matched' if lines matches any condition";
    private static final String routePropertyNameValue = "Route to each matching Property Name";
    private static final String startsWithValue = "Starts With";
    private static final String endsWithValue = "Ends With";
    private static final String containsValue = "Contains";
    private static final String equalsValue = "Equals";
    private static final String matchesRegularExpressionValue = "Matches Regular Expression";
    private static final String containsRegularExpressionValue = "Contains Regular Expression";
    private static final String satisfiesExpression = "Satisfies Expression";
    public static final AllowableValue ROUTE_TO_MATCHING_PROPERTY_NAME = new AllowableValue("Route to each matching Property Name", "Route to each matching Property Name", "Lines will be routed to each relationship whose corresponding expression evaluates to 'true'");
    public static final AllowableValue ROUTE_TO_MATCHED_WHEN_ALL_PROPERTIES_MATCH = new AllowableValue("Route to 'matched' if line matches all conditions", "Route to 'matched' if line matches all conditions", "Requires that all user-defined expressions evaluate to 'true' for the line to be considered a match");
    public static final AllowableValue ROUTE_TO_MATCHED_WHEN_ANY_PROPERTY_MATCHES = new AllowableValue("Route to 'matched' if lines matches any condition", "Route to 'matched' if lines matches any condition", "Requires that at least one user-defined expression evaluate to 'true' for the line to be considered a match");
    public static final AllowableValue STARTS_WITH = new AllowableValue("Starts With", "Starts With", "Match lines based on whether the line starts with the property value");
    public static final AllowableValue ENDS_WITH = new AllowableValue("Ends With", "Ends With", "Match lines based on whether the line ends with the property value");
    public static final AllowableValue CONTAINS = new AllowableValue("Contains", "Contains", "Match lines based on whether the line contains the property value");
    public static final AllowableValue EQUALS = new AllowableValue("Equals", "Equals", "Match lines based on whether the line equals the property value");
    public static final AllowableValue MATCHES_REGULAR_EXPRESSION = new AllowableValue("Matches Regular Expression", "Matches Regular Expression", "Match lines based on whether the line exactly matches the Regular Expression that is provided as the Property value");
    public static final AllowableValue CONTAINS_REGULAR_EXPRESSION = new AllowableValue("Contains Regular Expression", "Contains Regular Expression", "Match lines based on whether the line contains some text that matches the Regular Expression that is provided as the Property value");
    public static final AllowableValue SATISFIES_EXPRESSION = new AllowableValue("Satisfies Expression", "Satisfies Expression", "Match lines based on whether or not the the text satisfies the given Expression Language expression. I.e., the line will match if the property value, evaluated as an Expression, returns true. The expression is able to reference FlowFile Attributes, as well as the variables 'line' (which is the text of the line to evaluate) and 'lineNo' (which is the line number being evaluated. This will be 1 for the first line, 2 for the second and so on).");
    public static final PropertyDescriptor ROUTE_STRATEGY = new PropertyDescriptor.Builder().name("Routing Strategy").description("Specifies how to determine which Relationship(s) to use when evaluating the lines of incoming text against the 'Matching Strategy' and user-defined properties.").required(true).allowableValues(new DescribedValue[]{ROUTE_TO_MATCHING_PROPERTY_NAME, ROUTE_TO_MATCHED_WHEN_ALL_PROPERTIES_MATCH, ROUTE_TO_MATCHED_WHEN_ANY_PROPERTY_MATCHES}).defaultValue(ROUTE_TO_MATCHING_PROPERTY_NAME.getValue()).dynamic(false).build();
    public static final PropertyDescriptor MATCH_STRATEGY = new PropertyDescriptor.Builder().name("Matching Strategy").description("Specifies how to evaluate each line of incoming text against the user-defined properties.").required(true).allowableValues(new DescribedValue[]{SATISFIES_EXPRESSION, STARTS_WITH, ENDS_WITH, CONTAINS, EQUALS, MATCHES_REGULAR_EXPRESSION, CONTAINS_REGULAR_EXPRESSION}).dynamic(false).build();
    public static final PropertyDescriptor TRIM_WHITESPACE = new PropertyDescriptor.Builder().name("Ignore Leading/Trailing Whitespace").description("Indicates whether or not the whitespace at the beginning and end of the lines should be ignored when evaluating the line.").required(true).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("true").dynamic(false).build();
    static final PropertyDescriptor IGNORE_CASE = new PropertyDescriptor.Builder().name("Ignore Case").description("If true, capitalization will not be taken into account when comparing values. E.g., matching against 'HELLO' or 'hello' will have the same result. This property is ignored if the 'Matching Strategy' is set to 'Satisfies Expression'.").expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    static final PropertyDescriptor GROUPING_REGEX = new PropertyDescriptor.Builder().name("Grouping Regular Expression").description("Specifies a Regular Expression to evaluate against each line to determine which Group the line should be placed in. The Regular Expression must have at least one Capturing Group that defines the line's Group. If multiple Capturing Groups exist in the Regular Expression, the values from all Capturing Groups will be concatenated together. Two lines will not be placed into the same FlowFile unless they both have the same value for the Group (or neither line matches the Regular Expression). For example, to group together all lines in a CSV File by the first column, we can set this value to \"(.*?),.*\". Two lines that have the same Group but different Relationships will never be placed into the same FlowFile.").addValidator(StandardValidators.createRegexValidator((int)1, (int)Integer.MAX_VALUE, (boolean)false)).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).build();
    public static final PropertyDescriptor CHARACTER_SET = new PropertyDescriptor.Builder().name("Character Set").description("The Character Set in which the incoming text is encoded").required(true).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue("UTF-8").build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The original input file will be routed to this destination when the lines have been successfully routed to 1 or more relationships").build();
    public static final Relationship REL_NO_MATCH = new Relationship.Builder().name("unmatched").description("Data that does not satisfy the required user-defined rules will be routed to this Relationship").build();
    public static final Relationship REL_MATCH = new Relationship.Builder().name("matched").description("Data that satisfies the required user-defined rules will be routed to this Relationship").build();
    private static Group EMPTY_GROUP = new Group(Collections.emptyList());
    private AtomicReference<Set<Relationship>> relationships = new AtomicReference();
    private List<PropertyDescriptor> properties;
    private volatile String configuredRouteStrategy = ROUTE_STRATEGY.getDefaultValue();
    private volatile Set<String> dynamicPropertyNames = new HashSet<String>();
    private volatile Map<Relationship, PropertyValue> propertyMap = new HashMap<Relationship, PropertyValue>();
    private volatile Pattern groupingRegex = null;
    static final int PATTERNS_CACHE_MAXIMUM_ENTRIES = 1024;
    final ConcurrentMap<String, Pattern> patternsCache = Caffeine.newBuilder().maximumSize(1024L).build().asMap();

    private Pattern cachedCompiledPattern(String regex, boolean ignoreCase) {
        return this.patternsCache.computeIfAbsent(regex, r -> ignoreCase ? Pattern.compile(r, 2) : Pattern.compile(r));
    }

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> set = new HashSet<Relationship>();
        set.add(REL_ORIGINAL);
        set.add(REL_NO_MATCH);
        this.relationships = new AtomicReference(set);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(ROUTE_STRATEGY);
        properties.add(MATCH_STRATEGY);
        properties.add(CHARACTER_SET);
        properties.add(TRIM_WHITESPACE);
        properties.add(IGNORE_CASE);
        properties.add(GROUPING_REGEX);
        this.properties = Collections.unmodifiableList(properties);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships.get();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().required(false).name(propertyDescriptorName).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dynamic(true).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.equals((Object)IGNORE_CASE) && !newValue.equals(oldValue)) {
            this.patternsCache.clear();
        }
        if (descriptor.equals((Object)ROUTE_STRATEGY)) {
            this.configuredRouteStrategy = newValue;
        } else {
            HashSet<String> newDynamicPropertyNames = new HashSet<String>(this.dynamicPropertyNames);
            if (newValue == null) {
                newDynamicPropertyNames.remove(descriptor.getName());
            } else if (oldValue == null && descriptor.isDynamic()) {
                newDynamicPropertyNames.add(descriptor.getName());
            }
            this.dynamicPropertyNames = Collections.unmodifiableSet(newDynamicPropertyNames);
        }
        Set<String> allDynamicProps = this.dynamicPropertyNames;
        HashSet<Relationship> newRelationships = new HashSet<Relationship>();
        String routeStrategy = this.configuredRouteStrategy;
        if (ROUTE_TO_MATCHING_PROPERTY_NAME.getValue().equals(routeStrategy)) {
            for (String propName : allDynamicProps) {
                newRelationships.add(new Relationship.Builder().name(propName).build());
            }
        } else {
            newRelationships.add(REL_MATCH);
        }
        newRelationships.add(REL_ORIGINAL);
        newRelationships.add(REL_NO_MATCH);
        this.relationships.set(newRelationships);
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        String regex = context.getProperty(GROUPING_REGEX).getValue();
        if (regex != null) {
            this.groupingRegex = Pattern.compile(regex);
        }
        HashMap<Relationship, PropertyValue> newPropertyMap = new HashMap<Relationship, PropertyValue>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (!descriptor.isDynamic()) continue;
            this.getLogger().debug("Adding new dynamic property: {}", new Object[]{descriptor});
            newPropertyMap.put(new Relationship.Builder().name(descriptor.getName()).build(), context.getProperty(descriptor));
        }
        this.propertyMap = newPropertyMap;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        boolean dynamicProperty = false;
        String matchStrategy = validationContext.getProperty(MATCH_STRATEGY).getValue();
        boolean compileRegex = matchStrategy.equals(matchesRegularExpressionValue) || matchStrategy.equals(containsRegularExpressionValue);
        boolean requiresExpression = matchStrategy.equalsIgnoreCase(satisfiesExpression);
        Validator validator = null;
        if (compileRegex) {
            validator = StandardValidators.createRegexValidator((int)0, (int)Integer.MAX_VALUE, (boolean)true);
        }
        Map allProperties = validationContext.getProperties();
        for (PropertyDescriptor descriptor : allProperties.keySet()) {
            if (!descriptor.isDynamic()) continue;
            dynamicProperty = true;
            String propValue = validationContext.getProperty(descriptor).getValue();
            if (compileRegex) {
                ValidationResult validationResult = validator.validate(descriptor.getName(), propValue, validationContext);
                if (validationResult == null) continue;
                results.add(validationResult);
                continue;
            }
            if (!requiresExpression) continue;
            try {
                AttributeExpression.ResultType resultType = validationContext.newExpressionLanguageCompiler().compile(propValue).getResultType();
                if (resultType == AttributeExpression.ResultType.BOOLEAN) continue;
                results.add(new ValidationResult.Builder().valid(false).input(propValue).subject(descriptor.getName()).explanation("expression returns type of " + resultType.name() + " but is required to return a Boolean value").build());
            }
            catch (IllegalArgumentException iae) {
                results.add(new ValidationResult.Builder().valid(false).input(propValue).subject(descriptor.getName()).explanation("input is not a valid Expression Language expression").build());
            }
        }
        if (!dynamicProperty) {
            results.add(new ValidationResult.Builder().subject("Dynamic Properties").explanation("In order to route text there must be dynamic properties to match against").valid(false).build());
        }
        return results;
    }

    public void onTrigger(ProcessContext context, final ProcessSession session) {
        Map<Relationship, PropertyValue> propValueMap;
        final FlowFile originalFlowFile = session.get();
        if (originalFlowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        final Charset charset = Charset.forName(context.getProperty(CHARACTER_SET).getValue());
        final boolean trim = context.getProperty(TRIM_WHITESPACE).asBoolean();
        final String routeStrategy = context.getProperty(ROUTE_STRATEGY).getValue();
        final String matchStrategy = context.getProperty(MATCH_STRATEGY).getValue();
        final boolean ignoreCase = context.getProperty(IGNORE_CASE).asBoolean();
        boolean compileRegex = matchStrategy.equals(matchesRegularExpressionValue) || matchStrategy.equals(containsRegularExpressionValue);
        boolean usePropValue = matchStrategy.equals(satisfiesExpression);
        Map<Relationship, PropertyValue> propMap = this.propertyMap;
        if (usePropValue) {
            propValueMap = propMap;
        } else {
            propValueMap = new HashMap<Relationship, PropertyValue>(propMap.size());
            for (Map.Entry<Relationship, PropertyValue> entry : propMap.entrySet()) {
                String value = entry.getValue().evaluateAttributeExpressions(originalFlowFile).getValue();
                propValueMap.put(entry.getKey(), (PropertyValue)(compileRegex ? this.cachedCompiledPattern(value, ignoreCase) : value));
            }
        }
        final HashMap flowFileMap = new HashMap();
        final Pattern groupPattern = this.groupingRegex;
        session.read(originalFlowFile, new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                try (LineDemarcator demarcator = new LineDemarcator(in, charset, Integer.MAX_VALUE, 8192);){
                    String line;
                    HashMap<String, String> variables = new HashMap<String, String>(2);
                    int lineCount = 0;
                    while ((line = demarcator.nextLine()) != null) {
                        Relationship relationship;
                        String matchLine;
                        if (trim) {
                            matchLine = line.trim();
                        } else {
                            int indexOfCR = line.indexOf("\r");
                            int indexOfNL = line.indexOf("\n");
                            String lineWithoutEndings = indexOfCR > 0 && indexOfNL > 0 ? line.substring(0, Math.min(indexOfCR, indexOfNL)) : (indexOfCR > 0 ? line.substring(0, indexOfCR) : (indexOfNL > 0 ? line.substring(0, indexOfNL) : line));
                            matchLine = lineWithoutEndings;
                        }
                        variables.put("line", line);
                        variables.put("lineNo", String.valueOf(++lineCount));
                        int propertiesThatMatchedLine = 0;
                        for (Map.Entry entry : propValueMap.entrySet()) {
                            boolean lineMatchesProperty = RouteText.lineMatches(matchLine, entry.getValue(), matchStrategy, ignoreCase, originalFlowFile, variables);
                            if (lineMatchesProperty) {
                                ++propertiesThatMatchedLine;
                            }
                            if (lineMatchesProperty && ROUTE_TO_MATCHING_PROPERTY_NAME.getValue().equals(routeStrategy)) {
                                Relationship relationship2 = (Relationship)entry.getKey();
                                Group group = RouteText.this.getGroup(matchLine, groupPattern);
                                RouteText.this.appendLine(session, flowFileMap, relationship2, originalFlowFile, line, charset, group);
                                continue;
                            }
                            if ((!lineMatchesProperty || !ROUTE_TO_MATCHED_WHEN_ANY_PROPERTY_MATCHES.getValue().equals(routeStrategy)) && (lineMatchesProperty || !ROUTE_TO_MATCHED_WHEN_ALL_PROPERTIES_MATCH.getValue().equals(routeStrategy))) continue;
                            break;
                        }
                        if ((relationship = ROUTE_TO_MATCHING_PROPERTY_NAME.getValue().equals(routeStrategy) && propertiesThatMatchedLine > 0 ? null : (ROUTE_TO_MATCHED_WHEN_ANY_PROPERTY_MATCHES.getValue().equals(routeStrategy) && propertiesThatMatchedLine > 0 ? REL_MATCH : (ROUTE_TO_MATCHED_WHEN_ALL_PROPERTIES_MATCH.getValue().equals(routeStrategy) && propertiesThatMatchedLine == propValueMap.size() ? REL_MATCH : REL_NO_MATCH))) == null) continue;
                        Group group = RouteText.this.getGroup(matchLine, groupPattern);
                        RouteText.this.appendLine(session, flowFileMap, relationship, originalFlowFile, line, charset, group);
                    }
                }
            }
        });
        for (Map.Entry entry : flowFileMap.entrySet()) {
            Relationship relationship = (Relationship)entry.getKey();
            Map groupToFlowFileMap = (Map)entry.getValue();
            for (Map.Entry flowFileEntry : groupToFlowFileMap.entrySet()) {
                Group group = (Group)flowFileEntry.getKey();
                FlowFile flowFile = (FlowFile)flowFileEntry.getValue();
                HashMap<String, String> attributes = new HashMap<String, String>(2);
                attributes.put(ROUTE_ATTRIBUTE_KEY, relationship.getName());
                attributes.put(GROUP_ATTRIBUTE_KEY, StringUtils.join(group.getCapturedValues(), (String)", "));
                logger.info("Created {} from {}; routing to relationship {}", new Object[]{flowFile, originalFlowFile, relationship.getName()});
                FlowFile updatedFlowFile = session.putAllAttributes(flowFile, attributes);
                session.getProvenanceReporter().route(updatedFlowFile, (Relationship)entry.getKey());
                session.transfer(updatedFlowFile, (Relationship)entry.getKey());
            }
        }
        FlowFile flowFile = originalFlowFile;
        logger.info("Routing {} to {}", new Object[]{flowFile, REL_ORIGINAL});
        session.getProvenanceReporter().route(originalFlowFile, REL_ORIGINAL);
        flowFile = session.putAttribute(flowFile, ROUTE_ATTRIBUTE_KEY, REL_ORIGINAL.getName());
        session.transfer(flowFile, REL_ORIGINAL);
    }

    private Group getGroup(String line, Pattern groupPattern) {
        if (groupPattern == null) {
            return EMPTY_GROUP;
        }
        Matcher matcher = groupPattern.matcher(line);
        if (matcher.matches()) {
            ArrayList<String> capturingGroupValues = new ArrayList<String>(matcher.groupCount());
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                capturingGroupValues.add(matcher.group(i));
            }
            return new Group(capturingGroupValues);
        }
        return EMPTY_GROUP;
    }

    private void appendLine(ProcessSession session, Map<Relationship, Map<Group, FlowFile>> flowFileMap, Relationship relationship, FlowFile original, final String line, final Charset charset, Group group) {
        Map groupToFlowFileMap = flowFileMap.computeIfAbsent(relationship, k -> new HashMap());
        FlowFile flowFile = (FlowFile)groupToFlowFileMap.get(group);
        if (flowFile == null) {
            flowFile = session.create(original);
        }
        flowFile = session.append(flowFile, new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                out.write(line.getBytes(charset));
            }
        });
        groupToFlowFileMap.put(group, flowFile);
    }

    protected static boolean lineMatches(String line, Object comparison, String matchingStrategy, boolean ignoreCase, FlowFile flowFile, Map<String, String> variables) {
        switch (matchingStrategy) {
            case "Starts With": {
                if (ignoreCase) {
                    return line.toLowerCase().startsWith(((String)comparison).toLowerCase());
                }
                return line.startsWith((String)comparison);
            }
            case "Ends With": {
                if (ignoreCase) {
                    return line.toLowerCase().endsWith(((String)comparison).toLowerCase());
                }
                return line.endsWith((String)comparison);
            }
            case "Contains": {
                if (ignoreCase) {
                    return line.toLowerCase().contains(((String)comparison).toLowerCase());
                }
                return line.contains((String)comparison);
            }
            case "Equals": {
                if (ignoreCase) {
                    return line.equalsIgnoreCase((String)comparison);
                }
                return line.equals(comparison);
            }
            case "Matches Regular Expression": {
                return ((Pattern)comparison).matcher(line).matches();
            }
            case "Contains Regular Expression": {
                return ((Pattern)comparison).matcher(line).find();
            }
            case "Satisfies Expression": {
                PropertyValue booleanProperty = (PropertyValue)comparison;
                return booleanProperty.evaluateAttributeExpressions(flowFile, variables).asBoolean();
            }
        }
        return false;
    }

    private static class Group {
        private final List<String> capturedValues;

        public Group(List<String> capturedValues) {
            this.capturedValues = capturedValues;
        }

        public List<String> getCapturedValues() {
            return this.capturedValues;
        }

        public String toString() {
            return "Group" + String.valueOf(this.capturedValues);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.capturedValues == null ? 0 : this.capturedValues.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Group other = (Group)obj;
            if (this.capturedValues == null) {
                return other.capturedValues == null;
            }
            return this.capturedValues.equals(other.capturedValues);
        }
    }
}

