/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.flowfile.attributes.FragmentAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.util.XmlElementNotifier;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.sax.StandardInputSourceParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

@SideEffectFree
@SupportsBatching
@Tags(value={"xml", "split"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Splits an XML File into multiple separate FlowFiles, each comprising a child or descendant of the original root element")
@WritesAttributes(value={@WritesAttribute(attribute="fragment.identifier", description="All split FlowFiles produced from the same parent FlowFile will have the same randomly generated UUID added for this attribute"), @WritesAttribute(attribute="fragment.index", description="A one-up number that indicates the ordering of the split FlowFiles that were created from a single parent FlowFile"), @WritesAttribute(attribute="fragment.count", description="The number of split FlowFiles generated from the parent FlowFile"), @WritesAttribute(attribute="segment.original.filename ", description="The filename of the parent FlowFile")})
@SystemResourceConsideration(resource=SystemResource.MEMORY, description="The entirety of the FlowFile's content (as a Document object) is read into memory, in addition to all of the generated FlowFiles representing the split XML. A Document object can take approximately 10 times as much memory as the size of the XML. For example, a 1 MB XML document may use 10 MB of memory. If many splits are generated due to the size of the XML, a two-phase approach may be necessary to avoid excessive use of memory.")
public class SplitXml
extends AbstractProcessor {
    public static final PropertyDescriptor SPLIT_DEPTH = new PropertyDescriptor.Builder().name("Split Depth").description("Indicates the XML-nesting depth to start splitting XML fragments. A depth of 1 means split the root's children, whereas a depth of 2 means split the root's children's children and so forth.").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("1").build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The original FlowFile that was split into segments. If the FlowFile fails processing, nothing will be sent to this relationship").build();
    public static final Relationship REL_SPLIT = new Relationship.Builder().name("split").description("All segments of the original FlowFile will be routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If a FlowFile fails processing for any reason (for example, the FlowFile is not valid XML), it will be routed to this relationship").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(SPLIT_DEPTH);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_ORIGINAL);
        relationships.add(REL_SPLIT);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile original = session.get();
        if (original == null) {
            return;
        }
        int depth = context.getProperty(SPLIT_DEPTH).asInteger();
        ComponentLog logger = this.getLogger();
        ArrayList splits = new ArrayList();
        String fragmentIdentifier = UUID.randomUUID().toString();
        AtomicInteger numberOfRecords = new AtomicInteger(0);
        XmlSplitterSaxParser parser = new XmlSplitterSaxParser(xmlTree -> {
            FlowFile split = session.create(original);
            split = session.write(split, out -> out.write(xmlTree.getBytes(StandardCharsets.UTF_8)));
            split = session.putAttribute(split, FragmentAttributes.FRAGMENT_ID.key(), fragmentIdentifier);
            split = session.putAttribute(split, FragmentAttributes.FRAGMENT_INDEX.key(), Integer.toString(numberOfRecords.getAndIncrement()));
            split = session.putAttribute(split, FragmentAttributes.SEGMENT_ORIGINAL_FILENAME.key(), split.getAttribute(CoreAttributes.FILENAME.key()));
            splits.add(split);
        }, depth);
        AtomicBoolean failed = new AtomicBoolean(false);
        session.read(original, rawIn -> {
            try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                try {
                    StandardInputSourceParser inputSourceParser = new StandardInputSourceParser();
                    inputSourceParser.setNamespaceAware(true);
                    inputSourceParser.parse(new InputSource(in), (ContentHandler)parser);
                }
                catch (ProcessingException e) {
                    logger.error("Parsing failed {}", new Object[]{original, e});
                    failed.set(true);
                }
            }
        });
        if (failed.get()) {
            session.transfer(original, REL_FAILURE);
            session.remove(splits);
        } else {
            splits.forEach(split -> {
                split = session.putAttribute(split, FragmentAttributes.FRAGMENT_COUNT.key(), Integer.toString(numberOfRecords.get()));
                session.transfer(split, REL_SPLIT);
            });
            FlowFile originalToTransfer = FragmentAttributes.copyAttributesToOriginal((ProcessSession)session, (FlowFile)original, (String)fragmentIdentifier, (int)numberOfRecords.get());
            session.transfer(originalToTransfer, REL_ORIGINAL);
            logger.info("Split {} into {} FlowFiles", new Object[]{originalToTransfer, splits.size()});
        }
    }

    private static class XmlSplitterSaxParser
    implements ContentHandler {
        private static final String XML_PROLOGUE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        private final XmlElementNotifier notifier;
        private final int splitDepth;
        private final StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        private int depth = 0;
        private final Map<String, String> prefixMap = new TreeMap<String, String>();

        public XmlSplitterSaxParser(XmlElementNotifier notifier, int splitDepth) {
            this.notifier = notifier;
            this.splitDepth = splitDepth;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.depth <= this.splitDepth) {
                return;
            }
            block7: for (int i = start; i < start + length; ++i) {
                char c = ch[i];
                switch (c) {
                    case '<': {
                        this.sb.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        this.sb.append("&gt;");
                        continue block7;
                    }
                    case '&': {
                        this.sb.append("&amp;");
                        continue block7;
                    }
                    case '\'': {
                        this.sb.append("&apos;");
                        continue block7;
                    }
                    case '\"': {
                        this.sb.append("&quot;");
                        continue block7;
                    }
                    default: {
                        this.sb.append(c);
                    }
                }
            }
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            int newDepth;
            if ((newDepth = --this.depth) >= this.splitDepth) {
                this.sb.append("</").append(qName).append(">");
            }
            if (newDepth == this.splitDepth) {
                String elementTree = this.sb.toString();
                this.notifier.onXmlElementFound(elementTree);
                this.sb.setLength(XML_PROLOGUE.length());
            }
        }

        @Override
        public void endPrefixMapping(String prefix) {
            this.prefixMap.remove(this.prefixToNamespace(prefix));
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        @Override
        public void processingInstruction(String target, String data) {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            int newDepth;
            if ((newDepth = ++this.depth) > this.splitDepth) {
                this.sb.append("<");
                this.sb.append(qName);
                HashSet<String> attributeNames = new HashSet<String>();
                int attCount = atts.getLength();
                for (int i = 0; i < attCount; ++i) {
                    String attName = atts.getQName(i);
                    attributeNames.add(attName);
                    String attValue = StringEscapeUtils.escapeXml10((String)atts.getValue(i));
                    this.sb.append(" ").append(attName).append("=").append("\"").append(attValue).append("\"");
                }
                if (this.splitDepth == newDepth - 1) {
                    for (Map.Entry<String, String> entry : this.prefixMap.entrySet()) {
                        if (attributeNames.contains(entry.getKey())) continue;
                        this.sb.append(" ");
                        this.sb.append(entry.getKey());
                        this.sb.append("=\"");
                        this.sb.append(entry.getValue());
                        this.sb.append("\"");
                    }
                }
                this.sb.append(">");
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            String ns = this.prefixToNamespace(prefix);
            this.prefixMap.put(ns, uri);
        }

        private String prefixToNamespace(String prefix) {
            Object ns = prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix;
            return ns;
        }
    }
}

