/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.flowfile.attributes.FragmentAttributes;
import org.apache.nifi.flowfile.attributes.StandardFlowFileMediaType;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.file.transfer.FileInfo;
import org.apache.nifi.processors.standard.MergeContent;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.FlowFileUnpackager;
import org.apache.nifi.util.FlowFileUnpackagerV1;
import org.apache.nifi.util.FlowFileUnpackagerV2;
import org.apache.nifi.util.FlowFileUnpackagerV3;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Unpack", "un-merge", "tar", "zip", "archive", "flowfile-stream", "flowfile-stream-v3"})
@CapabilityDescription(value="Unpacks the content of FlowFiles that have been packaged with one of several different Packaging Formats, emitting one to many FlowFiles for each input FlowFile. Supported formats are TAR, ZIP, and FlowFile Stream packages.")
@ReadsAttribute(attribute="mime.type", description="If the <Packaging Format> property is set to use mime.type attribute, this attribute is used to determine the FlowFile's MIME Type. In this case, if the attribute is set to application/tar, the TAR Packaging Format will be used. If the attribute is set to application/zip, the ZIP Packaging Format will be used. If the attribute is set to application/flowfile-v3 or application/flowfile-v2 or application/flowfile-v1, the appropriate FlowFile Packaging Format will be used. If this attribute is missing, the FlowFile will be routed to 'failure'. Otherwise, if the attribute's value is not one of those mentioned above, the FlowFile will be routed to 'success' without being unpacked. Use the File Filter property only extract files matching a specific regular expression.")
@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="If the FlowFile is successfully unpacked, its MIME Type is no longer known, so the mime.type attribute is set to application/octet-stream."), @WritesAttribute(attribute="fragment.identifier", description="All unpacked FlowFiles produced from the same parent FlowFile will have the same randomly generated UUID added for this attribute"), @WritesAttribute(attribute="fragment.index", description="A one-up number that indicates the ordering of the unpacked FlowFiles that were created from a single parent FlowFile"), @WritesAttribute(attribute="fragment.count", description="The number of unpacked FlowFiles generated from the parent FlowFile"), @WritesAttribute(attribute="segment.original.filename ", description="The filename of the parent FlowFile. Extensions of .tar, .zip or .pkg are removed because the MergeContent processor automatically adds those extensions if it is used to rebuild the original FlowFile"), @WritesAttribute(attribute="file.lastModifiedTime", description="The date and time that the unpacked file was last modified (tar only)."), @WritesAttribute(attribute="file.creationTime", description="The date and time that the file was created. This attribute holds always the same value as file.lastModifiedTime (tar only)."), @WritesAttribute(attribute="file.owner", description="The owner of the unpacked file (tar only)"), @WritesAttribute(attribute="file.group", description="The group owner of the unpacked file (tar only)"), @WritesAttribute(attribute="file.permissions", description="The read/write/execute permissions of the unpacked file (tar only)"), @WritesAttribute(attribute="file.encryptionMethod", description="The encryption method for entries in Zip archives")})
@SeeAlso(value={MergeContent.class})
public class UnpackContent
extends AbstractProcessor {
    public static final String FRAGMENT_ID = FragmentAttributes.FRAGMENT_ID.key();
    public static final String FRAGMENT_INDEX = FragmentAttributes.FRAGMENT_INDEX.key();
    public static final String FRAGMENT_COUNT = FragmentAttributes.FRAGMENT_COUNT.key();
    public static final String SEGMENT_ORIGINAL_FILENAME = FragmentAttributes.SEGMENT_ORIGINAL_FILENAME.key();
    public static final String AUTO_DETECT_FORMAT_NAME = "use mime.type attribute";
    public static final String TAR_FORMAT_NAME = "tar";
    public static final String ZIP_FORMAT_NAME = "zip";
    public static final String FLOWFILE_STREAM_FORMAT_V3_NAME = "flowfile-stream-v3";
    public static final String FLOWFILE_STREAM_FORMAT_V2_NAME = "flowfile-stream-v2";
    public static final String FLOWFILE_TAR_FORMAT_NAME = "flowfile-tar-v1";
    public static final String OCTET_STREAM = "application/octet-stream";
    public static final String FILE_LAST_MODIFIED_TIME_ATTRIBUTE = "file.lastModifiedTime";
    public static final String FILE_CREATION_TIME_ATTRIBUTE = "file.creationTime";
    public static final String FILE_OWNER_ATTRIBUTE = "file.owner";
    public static final String FILE_GROUP_ATTRIBUTE = "file.group";
    public static final String FILE_PERMISSIONS_ATTRIBUTE = "file.permissions";
    public static final String FILE_ENCRYPTION_METHOD_ATTRIBUTE = "file.encryptionMethod";
    public static final String FILE_MODIFIED_DATE_ATTR_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ").withZone(ZoneId.systemDefault());
    public static final PropertyDescriptor PACKAGING_FORMAT = new PropertyDescriptor.Builder().name("Packaging Format").description("The Packaging Format used to create the file").required(true).allowableValues(new String[]{PackageFormat.AUTO_DETECT_FORMAT.toString(), PackageFormat.TAR_FORMAT.toString(), PackageFormat.ZIP_FORMAT.toString(), PackageFormat.FLOWFILE_STREAM_FORMAT_V3.toString(), PackageFormat.FLOWFILE_STREAM_FORMAT_V2.toString(), PackageFormat.FLOWFILE_TAR_FORMAT.toString()}).defaultValue(PackageFormat.AUTO_DETECT_FORMAT.toString()).build();
    public static final PropertyDescriptor FILE_FILTER = new PropertyDescriptor.Builder().name("File Filter").description("Only files contained in the archive whose names match the given regular expression will be extracted (tar/zip only)").required(true).defaultValue(".*").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").displayName("Password").description("Password used for decrypting Zip archives encrypted with ZipCrypto or AES. Configuring a password disables support for alternative Zip compression algorithms.").required(false).sensitive(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor ALLOW_STORED_ENTRIES_WITH_DATA_DESCRIPTOR = new PropertyDescriptor.Builder().name("allow-stored-entries-wdd").displayName("Allow Stored Entries With Data Descriptor").description("Some zip archives contain stored entries with data descriptors which by spec should not happen.  If this property is true they will be read anyway.  If false and such an entry is discovered the zip will fail to process.").required(true).defaultValue("false").sensitive(false).allowableValues(new String[]{"true", "false"}).dependsOn(PACKAGING_FORMAT, PackageFormat.ZIP_FORMAT.toString(), new String[0]).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Unpacked FlowFiles are sent to this relationship").build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The original FlowFile is sent to this relationship after it has been successfully unpacked").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("The original FlowFile is sent to this relationship when it cannot be unpacked for some reason").build();
    private static final Set<Relationship> relationships = Set.of(REL_SUCCESS, REL_FAILURE, REL_ORIGINAL);
    private static final List<PropertyDescriptor> properties = List.of(PACKAGING_FORMAT, FILE_FILTER, PASSWORD, ALLOW_STORED_ENTRIES_WITH_DATA_DESCRIPTOR);
    private Pattern fileFilter;
    private Unpacker tarUnpacker;
    private Unpacker zipUnpacker;

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    @OnStopped
    public void onStopped() {
        this.fileFilter = null;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws ProcessException {
        if (this.fileFilter == null) {
            PropertyValue allowStoredEntriesWithDataDescriptorVal;
            this.fileFilter = Pattern.compile(context.getProperty(FILE_FILTER).getValue());
            this.tarUnpacker = new TarUnpacker(this.fileFilter);
            char[] password = null;
            PropertyValue passwordProperty = context.getProperty(PASSWORD);
            if (passwordProperty.isSet()) {
                password = passwordProperty.getValue().toCharArray();
            }
            boolean allowStoredEntriesWithDataDescriptor = (allowStoredEntriesWithDataDescriptorVal = context.getProperty(ALLOW_STORED_ENTRIES_WITH_DATA_DESCRIPTOR)).isSet() ? allowStoredEntriesWithDataDescriptorVal.asBoolean() : false;
            this.zipUnpacker = new ZipUnpacker(this.fileFilter, password, allowStoredEntriesWithDataDescriptor);
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        Unpacker unpacker;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        PackageFormat packagingFormat = PackageFormat.getFormat(context.getProperty(PACKAGING_FORMAT).getValue().toLowerCase());
        if (packagingFormat == PackageFormat.AUTO_DETECT_FORMAT) {
            packagingFormat = null;
            String mimeType = flowFile.getAttribute(CoreAttributes.MIME_TYPE.key());
            if (mimeType == null) {
                logger.error("No mime.type attribute set for {}; routing to failure", new Object[]{flowFile});
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            for (PackageFormat format : PackageFormat.values()) {
                if (!mimeType.toLowerCase().equals(format.getMimeType())) continue;
                packagingFormat = format;
            }
            if (packagingFormat == null) {
                logger.info("Cannot unpack {} because its mime.type attribute is set to '{}', which is not a format that can be unpacked; routing to 'success'", new Object[]{flowFile, mimeType});
                session.transfer(flowFile, REL_SUCCESS);
                return;
            }
        }
        boolean addFragmentAttrs = switch (packagingFormat.ordinal()) {
            case 1, 2 -> {
                unpacker = this.tarUnpacker;
                yield true;
            }
            case 3 -> {
                unpacker = this.zipUnpacker;
                yield true;
            }
            case 5 -> {
                unpacker = new FlowFileStreamUnpacker((FlowFileUnpackager)new FlowFileUnpackagerV2());
                yield false;
            }
            case 4 -> {
                unpacker = new FlowFileStreamUnpacker((FlowFileUnpackager)new FlowFileUnpackagerV3());
                yield false;
            }
            case 6 -> {
                unpacker = new FlowFileStreamUnpacker((FlowFileUnpackager)new FlowFileUnpackagerV1());
                yield false;
            }
            default -> throw new ProcessException(String.valueOf((Object)packagingFormat) + " is not a valid packaging format");
        };
        ArrayList<FlowFile> unpacked = new ArrayList<FlowFile>();
        try {
            unpacker.unpack(session, flowFile, unpacked);
            if (unpacked.isEmpty()) {
                logger.error("Unable to unpack {} because it does not appear to have any entries; routing to failure", new Object[]{flowFile});
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            if (addFragmentAttrs) {
                this.finishFragmentAttributes(session, flowFile, unpacked);
            }
            session.transfer(unpacked, REL_SUCCESS);
            String fragmentId = unpacked.size() > 0 ? ((FlowFile)unpacked.get(0)).getAttribute(FRAGMENT_ID) : null;
            flowFile = FragmentAttributes.copyAttributesToOriginal((ProcessSession)session, (FlowFile)flowFile, (String)fragmentId, (int)unpacked.size());
            session.transfer(flowFile, REL_ORIGINAL);
            session.getProvenanceReporter().fork(flowFile, unpacked);
            logger.info("Unpacked {} into {} and transferred to success", new Object[]{flowFile, unpacked});
        }
        catch (Exception e) {
            logger.error("Unable to unpack {}; routing to failure", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
            session.remove(unpacked);
        }
    }

    private void finishFragmentAttributes(ProcessSession session, FlowFile source, List<FlowFile> unpacked) {
        int fragmentCount = 0;
        for (FlowFile ff : unpacked) {
            String fragmentIndex = ff.getAttribute(FRAGMENT_INDEX);
            if (fragmentIndex != null) {
                ++fragmentCount;
                continue;
            }
            return;
        }
        String originalFilename = source.getAttribute(CoreAttributes.FILENAME.key());
        if (originalFilename.endsWith(".tar") || originalFilename.endsWith(".zip") || originalFilename.endsWith(".pkg")) {
            originalFilename = originalFilename.substring(0, originalFilename.length() - 4);
        }
        ArrayList<FlowFile> newList = new ArrayList<FlowFile>(unpacked);
        unpacked.clear();
        for (FlowFile ff : newList) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(FRAGMENT_COUNT, String.valueOf(fragmentCount));
            attributes.put(SEGMENT_ORIGINAL_FILENAME, originalFilename);
            FlowFile newFF = session.putAllAttributes(ff, attributes);
            unpacked.add(newFF);
        }
    }

    private static class TarUnpacker
    extends Unpacker {
        public TarUnpacker(Pattern fileFilter) {
            super(fileFilter);
        }

        @Override
        public void unpack(ProcessSession session, FlowFile source, List<FlowFile> unpacked) {
            String fragmentId = UUID.randomUUID().toString();
            session.read(source, inputStream -> {
                int fragmentCount = 0;
                try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new BufferedInputStream(inputStream));){
                    TarArchiveEntry tarEntry;
                    while ((tarEntry = tarIn.getNextTarEntry()) != null) {
                        if (tarEntry.isDirectory() || !this.fileMatches((ArchiveEntry)tarEntry)) continue;
                        File file = new File(tarEntry.getName());
                        Path filePath = file.toPath();
                        String filePathString = filePath.getParent() == null ? "/" : String.valueOf(filePath.getParent()) + "/";
                        FlowFile unpackedFile = session.create(source);
                        try {
                            HashMap<String, String> attributes = new HashMap<String, String>();
                            attributes.put(CoreAttributes.FILENAME.key(), file.getName());
                            attributes.put(CoreAttributes.PATH.key(), filePathString);
                            attributes.put(CoreAttributes.MIME_TYPE.key(), UnpackContent.OCTET_STREAM);
                            attributes.put(UnpackContent.FILE_PERMISSIONS_ATTRIBUTE, FileInfo.permissionToString((int)tarEntry.getMode()));
                            attributes.put(UnpackContent.FILE_OWNER_ATTRIBUTE, String.valueOf(tarEntry.getUserName()));
                            attributes.put(UnpackContent.FILE_GROUP_ATTRIBUTE, String.valueOf(tarEntry.getGroupName()));
                            String timeAsString = DATE_TIME_FORMATTER.format(tarEntry.getModTime().toInstant());
                            attributes.put(UnpackContent.FILE_LAST_MODIFIED_TIME_ATTRIBUTE, timeAsString);
                            attributes.put(UnpackContent.FILE_CREATION_TIME_ATTRIBUTE, timeAsString);
                            attributes.put(FRAGMENT_ID, fragmentId);
                            attributes.put(FRAGMENT_INDEX, String.valueOf(++fragmentCount));
                            unpackedFile = session.putAllAttributes(unpackedFile, attributes);
                            long fileSize = tarEntry.getSize();
                            unpackedFile = session.write(unpackedFile, outputStream -> StreamUtils.copy((InputStream)tarIn, (OutputStream)outputStream, (long)fileSize));
                        }
                        finally {
                            unpacked.add(unpackedFile);
                        }
                    }
                }
            });
        }
    }

    private static abstract class Unpacker {
        protected Pattern fileFilter = null;

        public Unpacker() {
        }

        public Unpacker(Pattern fileFilter) {
            this.fileFilter = fileFilter;
        }

        abstract void unpack(ProcessSession var1, FlowFile var2, List<FlowFile> var3);

        protected boolean fileMatches(ArchiveEntry entry) {
            return this.fileMatches(entry.getName());
        }

        protected boolean fileMatches(String entryName) {
            return this.fileFilter == null || this.fileFilter.matcher(entryName).find();
        }
    }

    private static class ZipUnpacker
    extends Unpacker {
        private final char[] password;
        private final boolean allowStoredEntriesWithDataDescriptor;

        public ZipUnpacker(Pattern fileFilter, char[] password, boolean allowStoredEntriesWithDataDescriptor) {
            super(fileFilter);
            this.password = password;
            this.allowStoredEntriesWithDataDescriptor = allowStoredEntriesWithDataDescriptor;
        }

        @Override
        public void unpack(ProcessSession session, FlowFile source, List<FlowFile> unpacked) {
            String fragmentId = UUID.randomUUID().toString();
            if (this.password == null) {
                session.read(source, (InputStreamCallback)new CompressedZipInputStreamCallback(this.fileFilter, session, source, unpacked, fragmentId, this.allowStoredEntriesWithDataDescriptor));
            } else {
                session.read(source, (InputStreamCallback)new EncryptedZipInputStreamCallback(this.fileFilter, session, source, unpacked, fragmentId, this.password));
            }
        }

        private static class CompressedZipInputStreamCallback
        extends ZipInputStreamCallback {
            private final boolean allowStoredEntriesWithDataDescriptor;

            private CompressedZipInputStreamCallback(Pattern fileFilter, ProcessSession session, FlowFile sourceFlowFile, List<FlowFile> unpacked, String fragmentId, boolean allowStoredEntriesWithDataDescriptor) {
                super(fileFilter, session, sourceFlowFile, unpacked, fragmentId);
                this.allowStoredEntriesWithDataDescriptor = allowStoredEntriesWithDataDescriptor;
            }

            public void process(InputStream inputStream) throws IOException {
                try (ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream((InputStream)new BufferedInputStream(inputStream), null, true, this.allowStoredEntriesWithDataDescriptor);){
                    ZipArchiveEntry zipEntry;
                    while ((zipEntry = zipInputStream.getNextZipEntry()) != null) {
                        this.processEntry((InputStream)zipInputStream, zipEntry.isDirectory(), zipEntry.getName(), EncryptionMethod.NONE);
                    }
                }
            }
        }

        private static class EncryptedZipInputStreamCallback
        extends ZipInputStreamCallback {
            private final char[] password;

            private EncryptedZipInputStreamCallback(Pattern fileFilter, ProcessSession session, FlowFile sourceFlowFile, List<FlowFile> unpacked, String fragmentId, char[] password) {
                super(fileFilter, session, sourceFlowFile, unpacked, fragmentId);
                this.password = password;
            }

            public void process(InputStream inputStream) throws IOException {
                try (ZipInputStream zipInputStream = new ZipInputStream((InputStream)new BufferedInputStream(inputStream), this.password);){
                    LocalFileHeader zipEntry;
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        this.processEntry((InputStream)zipInputStream, zipEntry.isDirectory(), zipEntry.getFileName(), zipEntry.getEncryptionMethod());
                    }
                }
            }
        }

        private static abstract class ZipInputStreamCallback
        implements InputStreamCallback {
            private static final String PATH_SEPARATOR = "/";
            private final Pattern fileFilter;
            private final ProcessSession session;
            private final FlowFile sourceFlowFile;
            private final List<FlowFile> unpacked;
            private final String fragmentId;
            private int fragmentIndex;

            private ZipInputStreamCallback(Pattern fileFilter, ProcessSession session, FlowFile sourceFlowFile, List<FlowFile> unpacked, String fragmentId) {
                this.fileFilter = fileFilter;
                this.session = session;
                this.sourceFlowFile = sourceFlowFile;
                this.unpacked = unpacked;
                this.fragmentId = fragmentId;
            }

            protected boolean isFileEntryMatched(boolean directory, String fileName) {
                return !directory && (this.fileFilter == null || this.fileFilter.matcher(fileName).find());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void processEntry(InputStream zipInputStream, boolean directory, String zipEntryName, EncryptionMethod encryptionMethod) {
                if (this.isFileEntryMatched(directory, zipEntryName)) {
                    File file = new File(zipEntryName);
                    String parentDirectory = file.getParent() == null ? PATH_SEPARATOR : file.getParent();
                    FlowFile unpackedFile = this.session.create(this.sourceFlowFile);
                    try {
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        attributes.put(CoreAttributes.FILENAME.key(), file.getName());
                        attributes.put(CoreAttributes.PATH.key(), parentDirectory);
                        attributes.put(CoreAttributes.MIME_TYPE.key(), UnpackContent.OCTET_STREAM);
                        attributes.put(UnpackContent.FILE_ENCRYPTION_METHOD_ATTRIBUTE, encryptionMethod.toString());
                        attributes.put(FRAGMENT_ID, this.fragmentId);
                        attributes.put(FRAGMENT_INDEX, String.valueOf(++this.fragmentIndex));
                        unpackedFile = this.session.putAllAttributes(unpackedFile, attributes);
                        unpackedFile = this.session.write(unpackedFile, outputStream -> StreamUtils.copy((InputStream)zipInputStream, (OutputStream)outputStream));
                    }
                    finally {
                        this.unpacked.add(unpackedFile);
                    }
                }
            }
        }
    }

    protected static enum PackageFormat {
        AUTO_DETECT_FORMAT("use mime.type attribute"),
        TAR_FORMAT("tar", "application/tar"),
        X_TAR_FORMAT("tar", "application/x-tar"),
        ZIP_FORMAT("zip", "application/zip"),
        FLOWFILE_STREAM_FORMAT_V3("flowfile-stream-v3", StandardFlowFileMediaType.VERSION_3.getMediaType()),
        FLOWFILE_STREAM_FORMAT_V2("flowfile-stream-v2", StandardFlowFileMediaType.VERSION_2.getMediaType()),
        FLOWFILE_TAR_FORMAT("flowfile-tar-v1", StandardFlowFileMediaType.VERSION_1.getMediaType());

        private final String textValue;
        private String mimeType;

        private PackageFormat(String textValue, String mimeType) {
            this.textValue = textValue;
            this.mimeType = mimeType;
        }

        private PackageFormat(String textValue) {
            this.textValue = textValue;
        }

        public String toString() {
            return this.textValue;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public static PackageFormat getFormat(String textValue) {
            return switch (textValue) {
                case UnpackContent.AUTO_DETECT_FORMAT_NAME -> AUTO_DETECT_FORMAT;
                case UnpackContent.TAR_FORMAT_NAME -> TAR_FORMAT;
                case UnpackContent.ZIP_FORMAT_NAME -> ZIP_FORMAT;
                case UnpackContent.FLOWFILE_STREAM_FORMAT_V3_NAME -> FLOWFILE_STREAM_FORMAT_V3;
                case UnpackContent.FLOWFILE_STREAM_FORMAT_V2_NAME -> FLOWFILE_STREAM_FORMAT_V2;
                case UnpackContent.FLOWFILE_TAR_FORMAT_NAME -> FLOWFILE_TAR_FORMAT;
                default -> null;
            };
        }
    }

    private static class FlowFileStreamUnpacker
    extends Unpacker {
        private final FlowFileUnpackager unpackager;

        public FlowFileStreamUnpacker(FlowFileUnpackager unpackager) {
            this.unpackager = unpackager;
        }

        @Override
        public void unpack(ProcessSession session, FlowFile source, List<FlowFile> unpacked) {
            session.read(source, inputStream -> {
                try (BufferedInputStream in = new BufferedInputStream(inputStream);){
                    while (this.unpackager.hasMoreData()) {
                        AtomicReference<Object> attributesRef = new AtomicReference<Object>(null);
                        FlowFile unpackedFile = session.create(source);
                        try {
                            unpackedFile = session.write(unpackedFile, outputStream -> {
                                try (BufferedOutputStream out = new BufferedOutputStream(outputStream);){
                                    Map attributes = this.unpackager.unpackageFlowFile(in, (OutputStream)out);
                                    if (attributes == null) {
                                        throw new IOException("Failed to unpack " + String.valueOf(source) + ": stream had no Attributes");
                                    }
                                    attributesRef.set(attributes);
                                }
                            });
                            Map attributes = attributesRef.get();
                            attributes.remove(CoreAttributes.UUID.key());
                            if (!attributes.containsKey(CoreAttributes.MIME_TYPE.key())) {
                                attributes.put(CoreAttributes.MIME_TYPE.key(), UnpackContent.OCTET_STREAM);
                            }
                            unpackedFile = session.putAllAttributes(unpackedFile, attributes);
                        }
                        finally {
                            unpacked.add(unpackedFile);
                        }
                    }
                }
            });
        }
    }
}

