/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.calcite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.processors.standard.calcite.RecordPathFunction;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.RecordPathResult;
import org.apache.nifi.record.path.StandardFieldValue;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.sql.CalciteDatabase;

public class RecordPathFunctions {
    public static void addToDatabase(CalciteDatabase database) {
        database.addUserDefinedFunction("RPATH", ObjectRecordPath.class, "eval");
        database.addUserDefinedFunction("RPATH_STRING", StringRecordPath.class, "eval");
        database.addUserDefinedFunction("RPATH_INT", IntegerRecordPath.class, "eval");
        database.addUserDefinedFunction("RPATH_LONG", LongRecordPath.class, "eval");
        database.addUserDefinedFunction("RPATH_DATE", DateRecordPath.class, "eval");
        database.addUserDefinedFunction("RPATH_DOUBLE", DoubleRecordPath.class, "eval");
        database.addUserDefinedFunction("RPATH_FLOAT", FloatRecordPath.class, "eval");
    }

    public static class ObjectRecordPath
    extends RecordPathFunction {
        private static final RecordField ROOT_RECORD_FIELD = new RecordField("root", RecordFieldType.MAP.getMapDataType(RecordFieldType.STRING.getDataType()));
        private static final RecordSchema ROOT_RECORD_SCHEMA = new SimpleRecordSchema(Collections.singletonList(ROOT_RECORD_FIELD));
        private static final RecordField PARENT_RECORD_FIELD = new RecordField("root", RecordFieldType.RECORD.getRecordDataType(ROOT_RECORD_SCHEMA));

        public Object eval(Object record, String recordPath) {
            if (record == null) {
                return null;
            }
            if (record instanceof Record) {
                return this.eval((Record)record, recordPath);
            }
            if (record instanceof Record[]) {
                return this.eval((Record[])record, recordPath);
            }
            if (record instanceof Iterable) {
                return this.eval((Iterable)record, recordPath);
            }
            if (record instanceof Map) {
                return this.eval((Map)record, recordPath);
            }
            throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " against given argument because the argument is of type " + String.valueOf(record.getClass()) + " instead of Record");
        }

        private Object eval(Map<?, ?> map, String recordPath) {
            RecordPath compiled = RECORD_PATH_CACHE.getCompiled(recordPath);
            MapRecord record = new MapRecord(ROOT_RECORD_SCHEMA, Collections.singletonMap("root", map));
            StandardFieldValue parentFieldValue = new StandardFieldValue((Object)record, PARENT_RECORD_FIELD, null);
            StandardFieldValue fieldValue = new StandardFieldValue(map, ROOT_RECORD_FIELD, (FieldValue)parentFieldValue);
            RecordPathResult result = compiled.evaluate((Record)record, (FieldValue)fieldValue);
            List<FieldValue> selectedFields = result.getSelectedFields().collect(Collectors.toList());
            return this.evalResults(selectedFields);
        }

        private Object eval(Record record, String recordPath) {
            RecordPath compiled = RECORD_PATH_CACHE.getCompiled(recordPath);
            RecordPathResult result = compiled.evaluate(record);
            List<FieldValue> selectedFields = result.getSelectedFields().collect(Collectors.toList());
            return this.evalResults(selectedFields);
        }

        private Object eval(Iterable<Record> records, String recordPath) {
            RecordPath compiled = RECORD_PATH_CACHE.getCompiled(recordPath);
            ArrayList<FieldValue> selectedFields = new ArrayList<FieldValue>();
            for (Record record : records) {
                RecordPathResult result = compiled.evaluate(record);
                result.getSelectedFields().forEach(selectedFields::add);
            }
            return this.evalResults(selectedFields);
        }

        private Object eval(Record[] records, String recordPath) {
            RecordPath compiled = RECORD_PATH_CACHE.getCompiled(recordPath);
            ArrayList<FieldValue> selectedFields = new ArrayList<FieldValue>();
            for (Record record : records) {
                RecordPathResult result = compiled.evaluate(record);
                result.getSelectedFields().forEach(selectedFields::add);
            }
            return this.evalResults(selectedFields);
        }

        private Object evalResults(List<FieldValue> selectedFields) {
            if (selectedFields.isEmpty()) {
                return null;
            }
            if (selectedFields.size() == 1) {
                return selectedFields.get(0).getValue();
            }
            return selectedFields.stream().map(FieldValue::getValue).toArray();
        }
    }

    public static class StringRecordPath
    extends RecordPathFunction {
        public String eval(Object record, String recordPath) {
            return this.eval(record, recordPath, Object::toString);
        }
    }

    public static class IntegerRecordPath
    extends RecordPathFunction {
        public Integer eval(Object record, String recordPath) {
            return this.eval(record, recordPath, val -> {
                if (val instanceof Number) {
                    return ((Number)val).intValue();
                }
                if (val instanceof String) {
                    return Integer.parseInt((String)val);
                }
                if (val instanceof Date) {
                    return (int)((Date)val).getTime();
                }
                throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " as Integer against " + String.valueOf(record) + " because the value returned is of type " + String.valueOf(val.getClass()));
            });
        }
    }

    public static class LongRecordPath
    extends RecordPathFunction {
        public Long eval(Object record, String recordPath) {
            return this.eval(record, recordPath, val -> {
                if (val instanceof Number) {
                    return ((Number)val).longValue();
                }
                if (val instanceof String) {
                    return Long.parseLong((String)val);
                }
                if (val instanceof Date) {
                    return ((Date)val).getTime();
                }
                throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " as Long against " + String.valueOf(record) + " because the value returned is of type " + String.valueOf(val.getClass()));
            });
        }
    }

    public static class DateRecordPath
    extends RecordPathFunction {
        public Long eval(Object record, String recordPath) {
            return this.eval(record, recordPath, val -> {
                if (val instanceof Number) {
                    return ((Number)val).longValue();
                }
                if (val instanceof String) {
                    throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " as Date against " + String.valueOf(record) + " because the value returned is of type String. To parse a String value as a Date, please use the toDate function. For example, SELECT RPATH_DATE( record, 'toDate( /event/timestamp, \"yyyy-MM-dd\" )' ) AS eventDate FROM FLOWFILE");
                }
                if (val instanceof Date) {
                    return ((Date)val).getTime();
                }
                throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " as Date against " + String.valueOf(record) + " because the value returned is of type " + String.valueOf(val.getClass()));
            });
        }
    }

    public static class DoubleRecordPath
    extends RecordPathFunction {
        public Double eval(Object record, String recordPath) {
            return this.eval(record, recordPath, val -> {
                if (val instanceof Number) {
                    return ((Number)val).doubleValue();
                }
                if (val instanceof String) {
                    return Double.parseDouble((String)val);
                }
                throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " as Double against " + String.valueOf(record) + " because the value returned is of type " + String.valueOf(val.getClass()));
            });
        }
    }

    public static class FloatRecordPath
    extends RecordPathFunction {
        public Float eval(Object record, String recordPath) {
            return this.eval(record, recordPath, val -> {
                if (val instanceof Number) {
                    return Float.valueOf(((Number)val).floatValue());
                }
                if (val instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)val));
                }
                throw new RuntimeException("Cannot evaluate RecordPath " + recordPath + " as Float against " + String.valueOf(record) + " because the value returned is of type " + String.valueOf(val.getClass()));
            });
        }
    }
}

